package software.amazon.awscdk.services.autoscaling;

/**
 * Basic properties of an AutoScalingGroup, except the exact machines to run and where they should run.
 * <p>
 * Constructs that want to create AutoScalingGroups can inherit
 * this interface and specialize the essential parts in various ways.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.sns.*;
 * BlockDeviceVolume blockDeviceVolume;
 * GroupMetrics groupMetrics;
 * HealthCheck healthCheck;
 * HealthChecks healthChecks;
 * KeyPair keyPair;
 * ScalingEvents scalingEvents;
 * Signals signals;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Topic topic;
 * UpdatePolicy updatePolicy;
 * CommonAutoScalingGroupProps commonAutoScalingGroupProps = CommonAutoScalingGroupProps.builder()
 *         .allowAllOutbound(false)
 *         .associatePublicIpAddress(false)
 *         .autoScalingGroupName("autoScalingGroupName")
 *         .azCapacityDistributionStrategy(CapacityDistributionStrategy.BALANCED_ONLY)
 *         .blockDevices(List.of(BlockDevice.builder()
 *                 .deviceName("deviceName")
 *                 .volume(blockDeviceVolume)
 *                 .build()))
 *         .capacityRebalance(false)
 *         .cooldown(Duration.minutes(30))
 *         .defaultInstanceWarmup(Duration.minutes(30))
 *         .desiredCapacity(123)
 *         .groupMetrics(List.of(groupMetrics))
 *         .healthCheck(healthCheck)
 *         .healthChecks(healthChecks)
 *         .ignoreUnmodifiedSizeProperties(false)
 *         .instanceMonitoring(Monitoring.BASIC)
 *         .keyName("keyName")
 *         .keyPair(keyPair)
 *         .maxCapacity(123)
 *         .maxInstanceLifetime(Duration.minutes(30))
 *         .minCapacity(123)
 *         .newInstancesProtectedFromScaleIn(false)
 *         .notifications(List.of(NotificationConfiguration.builder()
 *                 .topic(topic)
 *                 // the properties below are optional
 *                 .scalingEvents(scalingEvents)
 *                 .build()))
 *         .signals(signals)
 *         .spotPrice("spotPrice")
 *         .ssmSessionPermissions(false)
 *         .terminationPolicies(List.of(TerminationPolicy.ALLOCATION_STRATEGY))
 *         .terminationPolicyCustomLambdaFunctionArn("terminationPolicyCustomLambdaFunctionArn")
 *         .updatePolicy(updatePolicy)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:45.819Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CommonAutoScalingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CommonAutoScalingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonAutoScalingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the instances can initiate connections to anywhere by default.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
     * <p>
     * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
     * <p>
     * Default: - Use subnet setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * The name of the Auto Scaling group.
     * <p>
     * This name must be unique per Region per account.
     * <p>
     * Default: - Auto generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingGroupName() {
        return null;
    }

    /**
     * The strategy for distributing instances across Availability Zones.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.CapacityDistributionStrategy getAzCapacityDistributionStrategy() {
        return null;
    }

    /**
     * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * Indicates whether Capacity Rebalancing is enabled.
     * <p>
     * When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling
     * attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of
     * interruption. After launching a new instance, it then terminates an old instance.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-capacityrebalance">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-capacityrebalance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCapacityRebalance() {
        return null;
    }

    /**
     * Default scaling cooldown for this AutoScalingGroup.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getCooldown() {
        return null;
    }

    /**
     * The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics.
     * <p>
     * This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics,
     * resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource
     * consumption to become stable after an instance reaches the InService state.
     * <p>
     * To optimize the performance of scaling policies that scale continuously, such as target tracking and
     * step scaling policies, we strongly recommend that you enable the default instance warmup, even if its value is set to 0 seconds
     * <p>
     * Default instance warmup will not be added if no value is specified
     * <p>
     * Default: None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDefaultInstanceWarmup() {
        return null;
    }

    /**
     * Initial amount of instances in the fleet.
     * <p>
     * If this is set to a number, every deployment will reset the amount of
     * instances to this number. It is recommended to leave this value blank.
     * <p>
     * Default: minCapacity, and leave unchanged during deployment
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCapacity() {
        return null;
    }

    /**
     * Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
     * <p>
     * To report all group metrics use <code>GroupMetrics.all()</code>
     * Group metrics are reported in a granularity of 1 minute at no additional charge.
     * <p>
     * Default: - no group metrics will be reported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> getGroupMetrics() {
        return null;
    }

    /**
     * (deprecated) Configuration for health checks.
     * <p>
     * Default: - HealthCheck.ec2 with no grace period
     * <p>
     * @deprecated Use <code>healthChecks</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * Configuration for EC2 or additional health checks.
     * <p>
     * Even when using <code>HealthChecks.withAdditionalChecks()</code>, the EC2 type is implicitly included.
     * <p>
     * Default: - EC2 type with no grace period
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.HealthChecks getHealthChecks() {
        return null;
    }

    /**
     * If the ASG has scheduled actions, don't reset unchanged group sizes.
     * <p>
     * Only used if the ASG has scheduled actions (which may scale your ASG up
     * or down regardless of cdk deployments). If true, the size of the group
     * will only be reset if it has been changed in the CDK app. If false, the
     * sizes will always be changed back to what they were in the CDK app
     * on deployment.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreUnmodifiedSizeProperties() {
        return null;
    }

    /**
     * Controls whether instances in this group are launched with detailed or basic monitoring.
     * <p>
     * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
     * is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
     * <p>
     * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
     * <p>
     * Default: - Monitoring.DETAILED
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics">https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.Monitoring getInstanceMonitoring() {
        return null;
    }

    /**
     * (deprecated) Name of SSH keypair to grant access to instances.
     * <p>
     * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
     * <p>
     * You can either specify <code>keyPair</code> or <code>keyName</code>, not both.
     * <p>
     * Default: - No SSH access will be possible.
     * <p>
     * @deprecated <ul>
     * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The SSH keypair to grant access to the instance.
     * <p>
     * Feature flag <code>AUTOSCALING_GENERATE_LAUNCH_TEMPLATE</code> must be enabled to use this property.
     * <p>
     * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified.
     * <p>
     * You can either specify <code>keyPair</code> or <code>keyName</code>, not both.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
        return null;
    }

    /**
     * Maximum number of instances in the fleet.
     * <p>
     * Default: desiredCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * The maximum amount of time that an instance can be in service.
     * <p>
     * The maximum duration applies
     * to all current and future instances in the group. As an instance approaches its maximum duration,
     * it is terminated and replaced, and cannot be used again.
     * <p>
     * You must specify a value of at least 86,400 seconds (one day). To clear a previously set value,
     * leave this property undefined.
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxInstanceLifetime() {
        return null;
    }

    /**
     * Minimum number of instances in the fleet.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
        return null;
    }

    /**
     * Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
     * <p>
     * By default, Auto Scaling can terminate an instance at any time after launch
     * when scaling in an Auto Scaling Group, subject to the group's termination
     * policy. However, you may wish to protect newly-launched instances from
     * being scaled in if they are going to run critical applications that should
     * not be prematurely terminated.
     * <p>
     * This flag must be enabled if the Auto Scaling Group will be associated with
     * an ECS Capacity Provider with managed termination protection.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNewInstancesProtectedFromScaleIn() {
        return null;
    }

    /**
     * Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
     * <p>
     * Default: - No fleet change notifications will be sent.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> getNotifications() {
        return null;
    }

    /**
     * Configure waiting for signals during deployment.
     * <p>
     * Use this to pause the CloudFormation deployment to wait for the instances
     * in the AutoScalingGroup to report successful startup during
     * creation and updates. The UserData script needs to invoke <code>cfn-signal</code>
     * with a success or failure code after it is done setting up the instance.
     * <p>
     * Without waiting for signals, the CloudFormation deployment will proceed as
     * soon as the AutoScalingGroup has been created or updated but before the
     * instances in the group have been started.
     * <p>
     * For example, to have instances wait for an Elastic Load Balancing health check before
     * they signal success, add a health-check verification by using the
     * cfn-init helper script. For an example, see the verify_instance_health
     * command in the Auto Scaling rolling updates sample template:
     * <p>
     * https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
     * <p>
     * Default: - Do not wait for signals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.Signals getSignals() {
        return null;
    }

    /**
     * The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
     * <p>
     * Spot Instances are
     * launched when the price you specify exceeds the current Spot market price.
     * <p>
     * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
        return null;
    }

    /**
     * Add SSM session permissions to the instance role.
     * <p>
     * Setting this to <code>true</code> adds the necessary permissions to connect
     * to the instance using SSM Session Manager. You can do this
     * from the AWS Console.
     * <p>
     * NOTE: Setting this flag to <code>true</code> may not be enough by itself.
     * You must also use an AMI that comes with the SSM Agent, or install
     * the SSM Agent yourself. See
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html">Working with SSM Agent</a>
     * in the SSM Developer Guide.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSsmSessionPermissions() {
        return null;
    }

    /**
     * A policy or a list of policies that are used to select the instances to terminate.
     * <p>
     * The policies are executed in the order that you list them.
     * <p>
     * Default: - `TerminationPolicy.DEFAULT`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> getTerminationPolicies() {
        return null;
    }

    /**
     * A lambda function Arn that can be used as a custom termination policy to select the instances to terminate.
     * <p>
     * This property must be specified if the TerminationPolicy.CUSTOM_LAMBDA_FUNCTION
     * is used.
     * <p>
     * Default: - No lambda function Arn will be supplied
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lambda-custom-termination-policy.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/lambda-custom-termination-policy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTerminationPolicyCustomLambdaFunctionArn() {
        return null;
    }

    /**
     * What to do when an AutoScalingGroup's instance configuration is changed.
     * <p>
     * This is applied when any of the settings on the ASG are changed that
     * affect how the instances should be created (VPC, instance type, startup
     * scripts, etc.). It indicates how the existing instances should be
     * replaced with new instances matching the new config. By default, nothing
     * is done and only new instances are launched with the new config.
     * <p>
     * Default: - `UpdatePolicy.rollingUpdate()` if using `init`, `UpdatePolicy.none()` otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.UpdatePolicy getUpdatePolicy() {
        return null;
    }

    /**
     * Where to place instances within the VPC.
     * <p>
     * Default: - All Private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonAutoScalingGroupProps> {
        java.lang.Boolean allowAllOutbound;
        java.lang.Boolean associatePublicIpAddress;
        java.lang.String autoScalingGroupName;
        software.amazon.awscdk.services.autoscaling.CapacityDistributionStrategy azCapacityDistributionStrategy;
        java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        java.lang.Boolean capacityRebalance;
        software.amazon.awscdk.Duration cooldown;
        software.amazon.awscdk.Duration defaultInstanceWarmup;
        java.lang.Number desiredCapacity;
        java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        software.amazon.awscdk.services.autoscaling.HealthChecks healthChecks;
        java.lang.Boolean ignoreUnmodifiedSizeProperties;
        software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        java.lang.String keyName;
        software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        java.lang.Number maxCapacity;
        software.amazon.awscdk.Duration maxInstanceLifetime;
        java.lang.Number minCapacity;
        java.lang.Boolean newInstancesProtectedFromScaleIn;
        java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        software.amazon.awscdk.services.autoscaling.Signals signals;
        java.lang.String spotPrice;
        java.lang.Boolean ssmSessionPermissions;
        java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies;
        java.lang.String terminationPolicyCustomLambdaFunctionArn;
        software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether the instances can initiate connections to anywhere by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
         *                                 <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group.
         *                             This name must be unique per Region per account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAzCapacityDistributionStrategy}
         * @param azCapacityDistributionStrategy The strategy for distributing instances across Availability Zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azCapacityDistributionStrategy(software.amazon.awscdk.services.autoscaling.CapacityDistributionStrategy azCapacityDistributionStrategy) {
            this.azCapacityDistributionStrategy = azCapacityDistributionStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         *                     <p>
         *                     <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder blockDevices(java.util.List<? extends software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices) {
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice>)blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getCapacityRebalance}
         * @param capacityRebalance Indicates whether Capacity Rebalancing is enabled.
         *                          When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling
         *                          attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of
         *                          interruption. After launching a new instance, it then terminates an old instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityRebalance(java.lang.Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getCooldown}
         * @param cooldown Default scaling cooldown for this AutoScalingGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getDefaultInstanceWarmup}
         * @param defaultInstanceWarmup The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics.
         *                              This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics,
         *                              resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource
         *                              consumption to become stable after an instance reaches the InService state.
         *                              <p>
         *                              To optimize the performance of scaling policies that scale continuously, such as target tracking and
         *                              step scaling policies, we strongly recommend that you enable the default instance warmup, even if its value is set to 0 seconds
         *                              <p>
         *                              Default instance warmup will not be added if no value is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceWarmup(software.amazon.awscdk.Duration defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getDesiredCapacity}
         * @param desiredCapacity Initial amount of instances in the fleet.
         *                        If this is set to a number, every deployment will reset the amount of
         *                        instances to this number. It is recommended to leave this value blank.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(java.lang.Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getGroupMetrics}
         * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
         *                     To report all group metrics use <code>GroupMetrics.all()</code>
         *                     Group metrics are reported in a granularity of 1 minute at no additional charge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder groupMetrics(java.util.List<? extends software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics) {
            this.groupMetrics = (java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics>)groupMetrics;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getHealthCheck}
         * @param healthCheck Configuration for health checks.
         * @return {@code this}
         * @deprecated Use `healthChecks` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder healthCheck(software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getHealthChecks}
         * @param healthChecks Configuration for EC2 or additional health checks.
         *                     Even when using <code>HealthChecks.withAdditionalChecks()</code>, the EC2 type is implicitly included.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthChecks(software.amazon.awscdk.services.autoscaling.HealthChecks healthChecks) {
            this.healthChecks = healthChecks;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getIgnoreUnmodifiedSizeProperties}
         * @param ignoreUnmodifiedSizeProperties If the ASG has scheduled actions, don't reset unchanged group sizes.
         *                                       Only used if the ASG has scheduled actions (which may scale your ASG up
         *                                       or down regardless of cdk deployments). If true, the size of the group
         *                                       will only be reset if it has been changed in the CDK app. If false, the
         *                                       sizes will always be changed back to what they were in the CDK app
         *                                       on deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreUnmodifiedSizeProperties(java.lang.Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getInstanceMonitoring}
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed or basic monitoring.
         *                           When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
         *                           is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
         *                           <p>
         *                           <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instances.
         *                <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         *                <p>
         *                You can either specify <code>keyPair</code> or <code>keyName</code>, not both.
         * @return {@code this}
         * @deprecated - Use `keyPair` instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getKeyPair}
         * @param keyPair The SSH keypair to grant access to the instance.
         *                Feature flag <code>AUTOSCALING_GENERATE_LAUNCH_TEMPLATE</code> must be enabled to use this property.
         *                <p>
         *                <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified.
         *                <p>
         *                You can either specify <code>keyPair</code> or <code>keyName</code>, not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMaxCapacity}
         * @param maxCapacity Maximum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMaxInstanceLifetime}
         * @param maxInstanceLifetime The maximum amount of time that an instance can be in service.
         *                            The maximum duration applies
         *                            to all current and future instances in the group. As an instance approaches its maximum duration,
         *                            it is terminated and replaced, and cannot be used again.
         *                            <p>
         *                            You must specify a value of at least 86,400 seconds (one day). To clear a previously set value,
         *                            leave this property undefined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInstanceLifetime(software.amazon.awscdk.Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMinCapacity}
         * @param minCapacity Minimum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getNewInstancesProtectedFromScaleIn}
         * @param newInstancesProtectedFromScaleIn Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
         *                                         By default, Auto Scaling can terminate an instance at any time after launch
         *                                         when scaling in an Auto Scaling Group, subject to the group's termination
         *                                         policy. However, you may wish to protect newly-launched instances from
         *                                         being scaled in if they are going to run critical applications that should
         *                                         not be prematurely terminated.
         *                                         <p>
         *                                         This flag must be enabled if the Auto Scaling Group will be associated with
         *                                         an ECS Capacity Provider with managed termination protection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newInstancesProtectedFromScaleIn(java.lang.Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getNotifications}
         * @param notifications Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder notifications(java.util.List<? extends software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications) {
            this.notifications = (java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration>)notifications;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getSignals}
         * @param signals Configure waiting for signals during deployment.
         *                Use this to pause the CloudFormation deployment to wait for the instances
         *                in the AutoScalingGroup to report successful startup during
         *                creation and updates. The UserData script needs to invoke <code>cfn-signal</code>
         *                with a success or failure code after it is done setting up the instance.
         *                <p>
         *                Without waiting for signals, the CloudFormation deployment will proceed as
         *                soon as the AutoScalingGroup has been created or updated but before the
         *                instances in the group have been started.
         *                <p>
         *                For example, to have instances wait for an Elastic Load Balancing health check before
         *                they signal success, add a health-check verification by using the
         *                cfn-init helper script. For an example, see the verify_instance_health
         *                command in the Auto Scaling rolling updates sample template:
         *                <p>
         *                https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signals(software.amazon.awscdk.services.autoscaling.Signals signals) {
            this.signals = signals;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getSpotPrice}
         * @param spotPrice The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
         *                  Spot Instances are
         *                  launched when the price you specify exceeds the current Spot market price.
         *                  <p>
         *                  <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotPrice(java.lang.String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getSsmSessionPermissions}
         * @param ssmSessionPermissions Add SSM session permissions to the instance role.
         *                              Setting this to <code>true</code> adds the necessary permissions to connect
         *                              to the instance using SSM Session Manager. You can do this
         *                              from the AWS Console.
         *                              <p>
         *                              NOTE: Setting this flag to <code>true</code> may not be enough by itself.
         *                              You must also use an AMI that comes with the SSM Agent, or install
         *                              the SSM Agent yourself. See
         *                              <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html">Working with SSM Agent</a>
         *                              in the SSM Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmSessionPermissions(java.lang.Boolean ssmSessionPermissions) {
            this.ssmSessionPermissions = ssmSessionPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getTerminationPolicies}
         * @param terminationPolicies A policy or a list of policies that are used to select the instances to terminate.
         *                            The policies are executed in the order that you list them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder terminationPolicies(java.util.List<? extends software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies) {
            this.terminationPolicies = (java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy>)terminationPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getTerminationPolicyCustomLambdaFunctionArn}
         * @param terminationPolicyCustomLambdaFunctionArn A lambda function Arn that can be used as a custom termination policy to select the instances to terminate.
         *                                                 This property must be specified if the TerminationPolicy.CUSTOM_LAMBDA_FUNCTION
         *                                                 is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationPolicyCustomLambdaFunctionArn(java.lang.String terminationPolicyCustomLambdaFunctionArn) {
            this.terminationPolicyCustomLambdaFunctionArn = terminationPolicyCustomLambdaFunctionArn;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getUpdatePolicy}
         * @param updatePolicy What to do when an AutoScalingGroup's instance configuration is changed.
         *                     This is applied when any of the settings on the ASG are changed that
         *                     affect how the instances should be created (VPC, instance type, startup
         *                     scripts, etc.). It indicates how the existing instances should be
         *                     replaced with new instances matching the new config. By default, nothing
         *                     is done and only new instances are launched with the new config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatePolicy(software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getVpcSubnets}
         * @param vpcSubnets Where to place instances within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonAutoScalingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonAutoScalingGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonAutoScalingGroupProps {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean associatePublicIpAddress;
        private final java.lang.String autoScalingGroupName;
        private final software.amazon.awscdk.services.autoscaling.CapacityDistributionStrategy azCapacityDistributionStrategy;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        private final java.lang.Boolean capacityRebalance;
        private final software.amazon.awscdk.Duration cooldown;
        private final software.amazon.awscdk.Duration defaultInstanceWarmup;
        private final java.lang.Number desiredCapacity;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        private final software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        private final software.amazon.awscdk.services.autoscaling.HealthChecks healthChecks;
        private final java.lang.Boolean ignoreUnmodifiedSizeProperties;
        private final software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        private final java.lang.Number maxCapacity;
        private final software.amazon.awscdk.Duration maxInstanceLifetime;
        private final java.lang.Number minCapacity;
        private final java.lang.Boolean newInstancesProtectedFromScaleIn;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        private final software.amazon.awscdk.services.autoscaling.Signals signals;
        private final java.lang.String spotPrice;
        private final java.lang.Boolean ssmSessionPermissions;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies;
        private final java.lang.String terminationPolicyCustomLambdaFunctionArn;
        private final software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.azCapacityDistributionStrategy = software.amazon.jsii.Kernel.get(this, "azCapacityDistributionStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.CapacityDistributionStrategy.class));
            this.blockDevices = software.amazon.jsii.Kernel.get(this, "blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDevice.class)));
            this.capacityRebalance = software.amazon.jsii.Kernel.get(this, "capacityRebalance", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.defaultInstanceWarmup = software.amazon.jsii.Kernel.get(this, "defaultInstanceWarmup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.desiredCapacity = software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.groupMetrics = software.amazon.jsii.Kernel.get(this, "groupMetrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.GroupMetrics.class)));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.HealthCheck.class));
            this.healthChecks = software.amazon.jsii.Kernel.get(this, "healthChecks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.HealthChecks.class));
            this.ignoreUnmodifiedSizeProperties = software.amazon.jsii.Kernel.get(this, "ignoreUnmodifiedSizeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceMonitoring = software.amazon.jsii.Kernel.get(this, "instanceMonitoring", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Monitoring.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyPair = software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IKeyPair.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxInstanceLifetime = software.amazon.jsii.Kernel.get(this, "maxInstanceLifetime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.newInstancesProtectedFromScaleIn = software.amazon.jsii.Kernel.get(this, "newInstancesProtectedFromScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notifications = software.amazon.jsii.Kernel.get(this, "notifications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.NotificationConfiguration.class)));
            this.signals = software.amazon.jsii.Kernel.get(this, "signals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class));
            this.spotPrice = software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ssmSessionPermissions = software.amazon.jsii.Kernel.get(this, "ssmSessionPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.terminationPolicies = software.amazon.jsii.Kernel.get(this, "terminationPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TerminationPolicy.class)));
            this.terminationPolicyCustomLambdaFunctionArn = software.amazon.jsii.Kernel.get(this, "terminationPolicyCustomLambdaFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.updatePolicy = software.amazon.jsii.Kernel.get(this, "updatePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.UpdatePolicy.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = builder.allowAllOutbound;
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.autoScalingGroupName = builder.autoScalingGroupName;
            this.azCapacityDistributionStrategy = builder.azCapacityDistributionStrategy;
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice>)builder.blockDevices;
            this.capacityRebalance = builder.capacityRebalance;
            this.cooldown = builder.cooldown;
            this.defaultInstanceWarmup = builder.defaultInstanceWarmup;
            this.desiredCapacity = builder.desiredCapacity;
            this.groupMetrics = (java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics>)builder.groupMetrics;
            this.healthCheck = builder.healthCheck;
            this.healthChecks = builder.healthChecks;
            this.ignoreUnmodifiedSizeProperties = builder.ignoreUnmodifiedSizeProperties;
            this.instanceMonitoring = builder.instanceMonitoring;
            this.keyName = builder.keyName;
            this.keyPair = builder.keyPair;
            this.maxCapacity = builder.maxCapacity;
            this.maxInstanceLifetime = builder.maxInstanceLifetime;
            this.minCapacity = builder.minCapacity;
            this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
            this.notifications = (java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration>)builder.notifications;
            this.signals = builder.signals;
            this.spotPrice = builder.spotPrice;
            this.ssmSessionPermissions = builder.ssmSessionPermissions;
            this.terminationPolicies = (java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy>)builder.terminationPolicies;
            this.terminationPolicyCustomLambdaFunctionArn = builder.terminationPolicyCustomLambdaFunctionArn;
            this.updatePolicy = builder.updatePolicy;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.CapacityDistributionStrategy getAzCapacityDistributionStrategy() {
            return this.azCapacityDistributionStrategy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public final java.lang.Boolean getCapacityRebalance() {
            return this.capacityRebalance;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final software.amazon.awscdk.Duration getDefaultInstanceWarmup() {
            return this.defaultInstanceWarmup;
        }

        @Override
        public final java.lang.Number getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> getGroupMetrics() {
            return this.groupMetrics;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.HealthChecks getHealthChecks() {
            return this.healthChecks;
        }

        @Override
        public final java.lang.Boolean getIgnoreUnmodifiedSizeProperties() {
            return this.ignoreUnmodifiedSizeProperties;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Monitoring getInstanceMonitoring() {
            return this.instanceMonitoring;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxInstanceLifetime() {
            return this.maxInstanceLifetime;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.lang.Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> getNotifications() {
            return this.notifications;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Signals getSignals() {
            return this.signals;
        }

        @Override
        public final java.lang.String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final java.lang.Boolean getSsmSessionPermissions() {
            return this.ssmSessionPermissions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final java.lang.String getTerminationPolicyCustomLambdaFunctionArn() {
            return this.terminationPolicyCustomLambdaFunctionArn;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.UpdatePolicy getUpdatePolicy() {
            return this.updatePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getAutoScalingGroupName() != null) {
                data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            }
            if (this.getAzCapacityDistributionStrategy() != null) {
                data.set("azCapacityDistributionStrategy", om.valueToTree(this.getAzCapacityDistributionStrategy()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getCapacityRebalance() != null) {
                data.set("capacityRebalance", om.valueToTree(this.getCapacityRebalance()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDefaultInstanceWarmup() != null) {
                data.set("defaultInstanceWarmup", om.valueToTree(this.getDefaultInstanceWarmup()));
            }
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getGroupMetrics() != null) {
                data.set("groupMetrics", om.valueToTree(this.getGroupMetrics()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getHealthChecks() != null) {
                data.set("healthChecks", om.valueToTree(this.getHealthChecks()));
            }
            if (this.getIgnoreUnmodifiedSizeProperties() != null) {
                data.set("ignoreUnmodifiedSizeProperties", om.valueToTree(this.getIgnoreUnmodifiedSizeProperties()));
            }
            if (this.getInstanceMonitoring() != null) {
                data.set("instanceMonitoring", om.valueToTree(this.getInstanceMonitoring()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getKeyPair() != null) {
                data.set("keyPair", om.valueToTree(this.getKeyPair()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxInstanceLifetime() != null) {
                data.set("maxInstanceLifetime", om.valueToTree(this.getMaxInstanceLifetime()));
            }
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getNewInstancesProtectedFromScaleIn() != null) {
                data.set("newInstancesProtectedFromScaleIn", om.valueToTree(this.getNewInstancesProtectedFromScaleIn()));
            }
            if (this.getNotifications() != null) {
                data.set("notifications", om.valueToTree(this.getNotifications()));
            }
            if (this.getSignals() != null) {
                data.set("signals", om.valueToTree(this.getSignals()));
            }
            if (this.getSpotPrice() != null) {
                data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
            }
            if (this.getSsmSessionPermissions() != null) {
                data.set("ssmSessionPermissions", om.valueToTree(this.getSsmSessionPermissions()));
            }
            if (this.getTerminationPolicies() != null) {
                data.set("terminationPolicies", om.valueToTree(this.getTerminationPolicies()));
            }
            if (this.getTerminationPolicyCustomLambdaFunctionArn() != null) {
                data.set("terminationPolicyCustomLambdaFunctionArn", om.valueToTree(this.getTerminationPolicyCustomLambdaFunctionArn()));
            }
            if (this.getUpdatePolicy() != null) {
                data.set("updatePolicy", om.valueToTree(this.getUpdatePolicy()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CommonAutoScalingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonAutoScalingGroupProps.Jsii$Proxy that = (CommonAutoScalingGroupProps.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.autoScalingGroupName != null ? !this.autoScalingGroupName.equals(that.autoScalingGroupName) : that.autoScalingGroupName != null) return false;
            if (this.azCapacityDistributionStrategy != null ? !this.azCapacityDistributionStrategy.equals(that.azCapacityDistributionStrategy) : that.azCapacityDistributionStrategy != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.capacityRebalance != null ? !this.capacityRebalance.equals(that.capacityRebalance) : that.capacityRebalance != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.defaultInstanceWarmup != null ? !this.defaultInstanceWarmup.equals(that.defaultInstanceWarmup) : that.defaultInstanceWarmup != null) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.groupMetrics != null ? !this.groupMetrics.equals(that.groupMetrics) : that.groupMetrics != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.healthChecks != null ? !this.healthChecks.equals(that.healthChecks) : that.healthChecks != null) return false;
            if (this.ignoreUnmodifiedSizeProperties != null ? !this.ignoreUnmodifiedSizeProperties.equals(that.ignoreUnmodifiedSizeProperties) : that.ignoreUnmodifiedSizeProperties != null) return false;
            if (this.instanceMonitoring != null ? !this.instanceMonitoring.equals(that.instanceMonitoring) : that.instanceMonitoring != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.keyPair != null ? !this.keyPair.equals(that.keyPair) : that.keyPair != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxInstanceLifetime != null ? !this.maxInstanceLifetime.equals(that.maxInstanceLifetime) : that.maxInstanceLifetime != null) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            if (this.newInstancesProtectedFromScaleIn != null ? !this.newInstancesProtectedFromScaleIn.equals(that.newInstancesProtectedFromScaleIn) : that.newInstancesProtectedFromScaleIn != null) return false;
            if (this.notifications != null ? !this.notifications.equals(that.notifications) : that.notifications != null) return false;
            if (this.signals != null ? !this.signals.equals(that.signals) : that.signals != null) return false;
            if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
            if (this.ssmSessionPermissions != null ? !this.ssmSessionPermissions.equals(that.ssmSessionPermissions) : that.ssmSessionPermissions != null) return false;
            if (this.terminationPolicies != null ? !this.terminationPolicies.equals(that.terminationPolicies) : that.terminationPolicies != null) return false;
            if (this.terminationPolicyCustomLambdaFunctionArn != null ? !this.terminationPolicyCustomLambdaFunctionArn.equals(that.terminationPolicyCustomLambdaFunctionArn) : that.terminationPolicyCustomLambdaFunctionArn != null) return false;
            if (this.updatePolicy != null ? !this.updatePolicy.equals(that.updatePolicy) : that.updatePolicy != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.autoScalingGroupName != null ? this.autoScalingGroupName.hashCode() : 0);
            result = 31 * result + (this.azCapacityDistributionStrategy != null ? this.azCapacityDistributionStrategy.hashCode() : 0);
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.capacityRebalance != null ? this.capacityRebalance.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.defaultInstanceWarmup != null ? this.defaultInstanceWarmup.hashCode() : 0);
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.groupMetrics != null ? this.groupMetrics.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.healthChecks != null ? this.healthChecks.hashCode() : 0);
            result = 31 * result + (this.ignoreUnmodifiedSizeProperties != null ? this.ignoreUnmodifiedSizeProperties.hashCode() : 0);
            result = 31 * result + (this.instanceMonitoring != null ? this.instanceMonitoring.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.keyPair != null ? this.keyPair.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxInstanceLifetime != null ? this.maxInstanceLifetime.hashCode() : 0);
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.newInstancesProtectedFromScaleIn != null ? this.newInstancesProtectedFromScaleIn.hashCode() : 0);
            result = 31 * result + (this.notifications != null ? this.notifications.hashCode() : 0);
            result = 31 * result + (this.signals != null ? this.signals.hashCode() : 0);
            result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            result = 31 * result + (this.ssmSessionPermissions != null ? this.ssmSessionPermissions.hashCode() : 0);
            result = 31 * result + (this.terminationPolicies != null ? this.terminationPolicies.hashCode() : 0);
            result = 31 * result + (this.terminationPolicyCustomLambdaFunctionArn != null ? this.terminationPolicyCustomLambdaFunctionArn.hashCode() : 0);
            result = 31 * result + (this.updatePolicy != null ? this.updatePolicy.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
