package software.amazon.awscdk.services.batch;

/**
 * Properties for defining a <code>CfnServiceEnvironment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * CfnServiceEnvironmentProps cfnServiceEnvironmentProps = CfnServiceEnvironmentProps.builder()
 *         .capacityLimits(List.of(CapacityLimitProperty.builder()
 *                 .capacityUnit("capacityUnit")
 *                 .maxCapacity(123)
 *                 .build()))
 *         .serviceEnvironmentType("serviceEnvironmentType")
 *         // the properties below are optional
 *         .serviceEnvironmentName("serviceEnvironmentName")
 *         .state("state")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.126Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnServiceEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnServiceEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServiceEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The capacity limits for the service environment.
     * <p>
     * This defines the maximum resources that can be used by service jobs in this environment.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.batch.CfnServiceEnvironment.CapacityLimitProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-capacitylimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-capacitylimits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCapacityLimits();

    /**
     * The type of service environment.
     * <p>
     * For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-serviceenvironmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-serviceenvironmenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceEnvironmentType();

    /**
     * The name of the service environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-serviceenvironmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-serviceenvironmentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceEnvironmentName() {
        return null;
    }

    /**
     * The state of the service environment.
     * <p>
     * Valid values are <code>ENABLED</code> and <code>DISABLED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * The tags associated with the service environment.
     * <p>
     * Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your AWS Batch resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-serviceenvironment.html#cfn-batch-serviceenvironment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServiceEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServiceEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServiceEnvironmentProps> {
        java.lang.Object capacityLimits;
        java.lang.String serviceEnvironmentType;
        java.lang.String serviceEnvironmentName;
        java.lang.String state;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnServiceEnvironmentProps#getCapacityLimits}
         * @param capacityLimits The capacity limits for the service environment. This parameter is required.
         *                       This defines the maximum resources that can be used by service jobs in this environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityLimits(software.amazon.awscdk.IResolvable capacityLimits) {
            this.capacityLimits = capacityLimits;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceEnvironmentProps#getCapacityLimits}
         * @param capacityLimits The capacity limits for the service environment. This parameter is required.
         *                       This defines the maximum resources that can be used by service jobs in this environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityLimits(java.util.List<? extends java.lang.Object> capacityLimits) {
            this.capacityLimits = capacityLimits;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceEnvironmentProps#getServiceEnvironmentType}
         * @param serviceEnvironmentType The type of service environment. This parameter is required.
         *                               For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceEnvironmentType(java.lang.String serviceEnvironmentType) {
            this.serviceEnvironmentType = serviceEnvironmentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceEnvironmentProps#getServiceEnvironmentName}
         * @param serviceEnvironmentName The name of the service environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceEnvironmentName(java.lang.String serviceEnvironmentName) {
            this.serviceEnvironmentName = serviceEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceEnvironmentProps#getState}
         * @param state The state of the service environment.
         *              Valid values are <code>ENABLED</code> and <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceEnvironmentProps#getTags}
         * @param tags The tags associated with the service environment.
         *             Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your AWS Batch resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServiceEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServiceEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServiceEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServiceEnvironmentProps {
        private final java.lang.Object capacityLimits;
        private final java.lang.String serviceEnvironmentType;
        private final java.lang.String serviceEnvironmentName;
        private final java.lang.String state;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacityLimits = software.amazon.jsii.Kernel.get(this, "capacityLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceEnvironmentType = software.amazon.jsii.Kernel.get(this, "serviceEnvironmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceEnvironmentName = software.amazon.jsii.Kernel.get(this, "serviceEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacityLimits = java.util.Objects.requireNonNull(builder.capacityLimits, "capacityLimits is required");
            this.serviceEnvironmentType = java.util.Objects.requireNonNull(builder.serviceEnvironmentType, "serviceEnvironmentType is required");
            this.serviceEnvironmentName = builder.serviceEnvironmentName;
            this.state = builder.state;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getCapacityLimits() {
            return this.capacityLimits;
        }

        @Override
        public final java.lang.String getServiceEnvironmentType() {
            return this.serviceEnvironmentType;
        }

        @Override
        public final java.lang.String getServiceEnvironmentName() {
            return this.serviceEnvironmentName;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("capacityLimits", om.valueToTree(this.getCapacityLimits()));
            data.set("serviceEnvironmentType", om.valueToTree(this.getServiceEnvironmentType()));
            if (this.getServiceEnvironmentName() != null) {
                data.set("serviceEnvironmentName", om.valueToTree(this.getServiceEnvironmentName()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnServiceEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServiceEnvironmentProps.Jsii$Proxy that = (CfnServiceEnvironmentProps.Jsii$Proxy) o;

            if (!capacityLimits.equals(that.capacityLimits)) return false;
            if (!serviceEnvironmentType.equals(that.serviceEnvironmentType)) return false;
            if (this.serviceEnvironmentName != null ? !this.serviceEnvironmentName.equals(that.serviceEnvironmentName) : that.serviceEnvironmentName != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capacityLimits.hashCode();
            result = 31 * result + (this.serviceEnvironmentType.hashCode());
            result = 31 * result + (this.serviceEnvironmentName != null ? this.serviceEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
