package software.amazon.awscdk.services.batch;

/**
 * Batch default instances types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = new Vpc(this, "VPC");
 * ManagedEc2EcsComputeEnvironment.Builder.create(this, "myEc2ComputeEnv")
 *         .vpc(vpc)
 *         .defaultInstanceClasses(List.of(DefaultInstanceClass.ARM64))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/instance-type-compute-table.html">https://docs.aws.amazon.com/batch/latest/userguide/instance-type-compute-table.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.128Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.DefaultInstanceClass")
public enum DefaultInstanceClass {
    /**
     * x86 based instance types (from the m6i, c6i, r6i, and c7i instance families).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X86_64,
    /**
     * ARM64 based instance types (from the m6g, c6g, r6g, and c7g instance families).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM64,
}
