package software.amazon.awscdk.services.batch;

/**
 * A container orchestrated by ECS that uses EC2 resources.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.169Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.IEcsEc2ContainerDefinition")
@software.amazon.jsii.Jsii.Proxy(IEcsEc2ContainerDefinition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEcsEc2ContainerDefinition extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.IEcsContainerDefinition {

    /**
     * Limits to set for the user this docker container will run as.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Ulimit> getUlimits();

    /**
     * The number of physical GPUs to reserve for the container.
     * <p>
     * Make sure that the number of GPUs reserved for all containers in a job doesn't exceed
     * the number of available GPUs on the compute resource that the job is launched on.
     * <p>
     * Default: - no gpus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpu() {
        return null;
    }

    /**
     * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return null;
    }

    /**
     * Add a ulimit to this container.
     * <p>
     * @param ulimit This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addUlimit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Ulimit ulimit);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.batch.IEcsEc2ContainerDefinition.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The number of vCPUs reserved for the container.
         * <p>
         * Each vCPU is equivalent to 1,024 CPU shares.
         * For containers running on EC2 resources, you must specify at least one vCPU.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Number getCpu() {
            return software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * The image that this container will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
        }

        /**
         * The memory hard limit present to the container.
         * <p>
         * If your container attempts to exceed the memory specified, the container is terminated.
         * You must specify at least 4 MiB of memory for a job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size getMemory() {
            return software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The volumes to mount to this container.
         * <p>
         * Automatically added to the job definition.
         * <p>
         * Default: - no volumes
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsVolume.class))));
        }

        /**
         * The command that's passed to the container.
         * <p>
         * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * Whether to enable ecs exec for this container.
         * <p>
         * Default: undefined - AWS Batch default is false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableExecuteCommand() {
            return software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * Cannot start with <code>AWS_BATCH</code>.
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * <p>
         * Default: - no environment variables
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The role that the container can assume.
         * <p>
         * Default: - no jobRole
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
            return software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * <p>
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
            return software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LinuxParameters.class));
        }

        /**
         * The configuration of the log driver.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriverConfig getLogDriverConfig() {
            return software.amazon.jsii.Kernel.get(this, "logDriverConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class));
        }

        /**
         * Gives the container readonly access to its root filesystem.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
            return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * A map from environment variable names to the secrets for the container.
         * <p>
         * Allows your job definitions
         * to reference the secret by the environment variable name defined in this property.
         * <p>
         * Default: - no secrets
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The user name to use inside the container.
         * <p>
         * Default: - no user
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Limits to set for the user this docker container will run as.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Ulimit> getUlimits() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Ulimit.class))));
        }

        /**
         * The number of physical GPUs to reserve for the container.
         * <p>
         * Make sure that the number of GPUs reserved for all containers in a job doesn't exceed
         * the number of available GPUs on the compute resource that the job is launched on.
         * <p>
         * Default: - no gpus
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getGpu() {
            return software.amazon.jsii.Kernel.get(this, "gpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
            return software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Add a Volume to this container.
         * <p>
         * @param volume This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsVolume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }

        /**
         * Add a ulimit to this container.
         * <p>
         * @param ulimit This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addUlimit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Ulimit ulimit) {
            software.amazon.jsii.Kernel.call(this, "addUlimit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(ulimit, "ulimit is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEcsEc2ContainerDefinition}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEcsEc2ContainerDefinition, software.amazon.awscdk.services.batch.IEcsContainerDefinition.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The number of vCPUs reserved for the container.
         * <p>
         * Each vCPU is equivalent to 1,024 CPU shares.
         * For containers running on EC2 resources, you must specify at least one vCPU.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Number getCpu() {
            return software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * The image that this container will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
        }

        /**
         * The memory hard limit present to the container.
         * <p>
         * If your container attempts to exceed the memory specified, the container is terminated.
         * You must specify at least 4 MiB of memory for a job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size getMemory() {
            return software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The volumes to mount to this container.
         * <p>
         * Automatically added to the job definition.
         * <p>
         * Default: - no volumes
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsVolume.class))));
        }

        /**
         * The command that's passed to the container.
         * <p>
         * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * Whether to enable ecs exec for this container.
         * <p>
         * Default: undefined - AWS Batch default is false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableExecuteCommand() {
            return software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * Cannot start with <code>AWS_BATCH</code>.
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * <p>
         * Default: - no environment variables
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The role that the container can assume.
         * <p>
         * Default: - no jobRole
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
            return software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * <p>
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
            return software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LinuxParameters.class));
        }

        /**
         * The configuration of the log driver.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriverConfig getLogDriverConfig() {
            return software.amazon.jsii.Kernel.get(this, "logDriverConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class));
        }

        /**
         * Gives the container readonly access to its root filesystem.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
            return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * A map from environment variable names to the secrets for the container.
         * <p>
         * Allows your job definitions
         * to reference the secret by the environment variable name defined in this property.
         * <p>
         * Default: - no secrets
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The user name to use inside the container.
         * <p>
         * Default: - no user
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Limits to set for the user this docker container will run as.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Ulimit> getUlimits() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Ulimit.class))));
        }

        /**
         * The number of physical GPUs to reserve for the container.
         * <p>
         * Make sure that the number of GPUs reserved for all containers in a job doesn't exceed
         * the number of available GPUs on the compute resource that the job is launched on.
         * <p>
         * Default: - no gpus
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGpu() {
            return software.amazon.jsii.Kernel.get(this, "gpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
            return software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Add a Volume to this container.
         * <p>
         * @param volume This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsVolume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }

        /**
         * Add a ulimit to this container.
         * <p>
         * @param ulimit This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addUlimit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Ulimit ulimit) {
            software.amazon.jsii.Kernel.call(this, "addUlimit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(ulimit, "ulimit is required") });
        }
    }
}
