package software.amazon.awscdk.services.bedrock;

/**
 * Creates a version of the flow that you can deploy.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html">Deploy a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnFlowVersion cfnFlowVersion = CfnFlowVersion.Builder.create(this, "MyCfnFlowVersion")
 *         .flowArn("flowArn")
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flowversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flowversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.392Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion")
public class CfnFlowVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.bedrock.IFlowVersionRef {

    protected CfnFlowVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnFlowVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Bedrock::FlowVersion</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlowVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnFlowVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time at the version was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the KMS key that the flow version is encrypted with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCustomerEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCustomerEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Flow definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDefinition() {
        return software.amazon.jsii.Kernel.get(this, "attrDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the service role with permissions to create a flow.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service row for flows</a> in the Amazon Bedrock User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFlowId() {
        return software.amazon.jsii.Kernel.get(this, "attrFlowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a FlowVersion resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.bedrock.FlowVersionReference getFlowVersionRef() {
        return software.amazon.jsii.Kernel.get(this, "flowVersionRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.bedrock.FlowVersionReference.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow that the version belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow that the version belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flowArn", java.util.Objects.requireNonNull(value, "flowArn is required"));
    }

    /**
     * The description of the flow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the flow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * Defines an agent node in your flow.
     * <p>
     * You specify the agent to invoke at this point in the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AgentFlowNodeConfigurationProperty agentFlowNodeConfigurationProperty = AgentFlowNodeConfigurationProperty.builder()
     *         .agentAliasArn("agentAliasArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-agentflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-agentflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.AgentFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the alias of the agent to invoke.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-agentflownodeconfiguration.html#cfn-bedrock-flowversion-agentflownodeconfiguration-agentaliasarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-agentflownodeconfiguration.html#cfn-bedrock-flowversion-agentflownodeconfiguration-agentaliasarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAgentAliasArn();

        /**
         * @return a {@link Builder} of {@link AgentFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentFlowNodeConfigurationProperty> {
            java.lang.String agentAliasArn;

            /**
             * Sets the value of {@link AgentFlowNodeConfigurationProperty#getAgentAliasArn}
             * @param agentAliasArn The Amazon Resource Name (ARN) of the alias of the agent to invoke. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentAliasArn(java.lang.String agentAliasArn) {
                this.agentAliasArn = agentAliasArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentFlowNodeConfigurationProperty {
            private final java.lang.String agentAliasArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentAliasArn = software.amazon.jsii.Kernel.get(this, "agentAliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentAliasArn = java.util.Objects.requireNonNull(builder.agentAliasArn, "agentAliasArn is required");
            }

            @Override
            public final java.lang.String getAgentAliasArn() {
                return this.agentAliasArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("agentAliasArn", om.valueToTree(this.getAgentAliasArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.AgentFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentFlowNodeConfigurationProperty.Jsii$Proxy that = (AgentFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.agentAliasArn.equals(that.agentAliasArn);
            }

            @Override
            public final int hashCode() {
                int result = this.agentAliasArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines a condition node in your flow.
     * <p>
     * You can specify conditions that determine which node comes next in the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ConditionFlowNodeConfigurationProperty conditionFlowNodeConfigurationProperty = ConditionFlowNodeConfigurationProperty.builder()
     *         .conditions(List.of(FlowConditionProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .expression("expression")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-conditionflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-conditionflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.ConditionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of conditions.
         * <p>
         * Each member contains the name of a condition and an expression that defines the condition.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConditionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-conditionflownodeconfiguration.html#cfn-bedrock-flowversion-conditionflownodeconfiguration-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-conditionflownodeconfiguration.html#cfn-bedrock-flowversion-conditionflownodeconfiguration-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

        /**
         * @return a {@link Builder} of {@link ConditionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionFlowNodeConfigurationProperty> {
            java.lang.Object conditions;

            /**
             * Sets the value of {@link ConditionFlowNodeConfigurationProperty#getConditions}
             * @param conditions An array of conditions. This parameter is required.
             *                   Each member contains the name of a condition and an expression that defines the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link ConditionFlowNodeConfigurationProperty#getConditions}
             * @param conditions An array of conditions. This parameter is required.
             *                   Each member contains the name of a condition and an expression that defines the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionFlowNodeConfigurationProperty {
            private final java.lang.Object conditions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conditions", om.valueToTree(this.getConditions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.ConditionFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionFlowNodeConfigurationProperty.Jsii$Proxy that = (ConditionFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.conditions.equals(that.conditions);
            }

            @Override
            public final int hashCode() {
                int result = this.conditions.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a field to be used during the reranking process in a Knowledge Base vector search.
     * <p>
     * This structure identifies metadata fields that should be considered when reordering search results to improve relevance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FieldForRerankingProperty fieldForRerankingProperty = FieldForRerankingProperty.builder()
     *         .fieldName("fieldName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-fieldforreranking.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-fieldforreranking.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FieldForRerankingProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldForRerankingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldForRerankingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metadata field to be used during the reranking process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-fieldforreranking.html#cfn-bedrock-flowversion-fieldforreranking-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-fieldforreranking.html#cfn-bedrock-flowversion-fieldforreranking-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

        /**
         * @return a {@link Builder} of {@link FieldForRerankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldForRerankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldForRerankingProperty> {
            java.lang.String fieldName;

            /**
             * Sets the value of {@link FieldForRerankingProperty#getFieldName}
             * @param fieldName The name of the metadata field to be used during the reranking process. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldForRerankingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldForRerankingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldForRerankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldForRerankingProperty {
            private final java.lang.String fieldName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldName", om.valueToTree(this.getFieldName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FieldForRerankingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldForRerankingProperty.Jsii$Proxy that = (FieldForRerankingProperty.Jsii$Proxy) o;

                return this.fieldName.equals(that.fieldName);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines a condition in the condition node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConditionProperty flowConditionProperty = FlowConditionProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the condition that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowcondition.html#cfn-bedrock-flowversion-flowcondition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowcondition.html#cfn-bedrock-flowversion-flowcondition-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Defines the condition.
         * <p>
         * You must refer to at least one of the inputs in the condition. For more information, expand the Condition node section in <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html#flows-nodes">Node types in prompt flows</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowcondition.html#cfn-bedrock-flowversion-flowcondition-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowcondition.html#cfn-bedrock-flowversion-flowcondition-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConditionProperty> {
            java.lang.String name;
            java.lang.String expression;

            /**
             * Sets the value of {@link FlowConditionProperty#getName}
             * @param name A name for the condition that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowConditionProperty#getExpression}
             * @param expression Defines the condition.
             *                   You must refer to at least one of the inputs in the condition. For more information, expand the Condition node section in <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html#flows-nodes">Node types in prompt flows</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConditionProperty {
            private final java.lang.String name;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.expression = builder.expression;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConditionProperty.Jsii$Proxy that = (FlowConditionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.expression != null ? this.expression.equals(that.expression) : that.expression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a connection between a condition node and another node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConditionalConnectionConfigurationProperty flowConditionalConnectionConfigurationProperty = FlowConditionalConnectionConfigurationProperty.builder()
     *         .condition("condition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconditionalconnectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconditionalconnectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConditionalConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConditionalConnectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConditionalConnectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition that triggers this connection.
         * <p>
         * For more information about how to write conditions, see the <em>Condition</em> node type in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the Amazon Bedrock User Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconditionalconnectionconfiguration.html#cfn-bedrock-flowversion-flowconditionalconnectionconfiguration-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconditionalconnectionconfiguration.html#cfn-bedrock-flowversion-flowconditionalconnectionconfiguration-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * @return a {@link Builder} of {@link FlowConditionalConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConditionalConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConditionalConnectionConfigurationProperty> {
            java.lang.String condition;

            /**
             * Sets the value of {@link FlowConditionalConnectionConfigurationProperty#getCondition}
             * @param condition The condition that triggers this connection. This parameter is required.
             *                  For more information about how to write conditions, see the <em>Condition</em> node type in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the Amazon Bedrock User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConditionalConnectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConditionalConnectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConditionalConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConditionalConnectionConfigurationProperty {
            private final java.lang.String condition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConditionalConnectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConditionalConnectionConfigurationProperty.Jsii$Proxy that = (FlowConditionalConnectionConfigurationProperty.Jsii$Proxy) o;

                return this.condition.equals(that.condition);
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration of the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConnectionConfigurationProperty flowConnectionConfigurationProperty = FlowConnectionConfigurationProperty.builder()
     *         .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                 .condition("condition")
     *                 .build())
     *         .data(FlowDataConnectionConfigurationProperty.builder()
     *                 .sourceOutput("sourceOutput")
     *                 .targetInput("targetInput")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConnectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConnectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of a connection originating from a Condition node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConditionalConnectionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnectionconfiguration.html#cfn-bedrock-flowversion-flowconnectionconfiguration-conditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnectionconfiguration.html#cfn-bedrock-flowversion-flowconnectionconfiguration-conditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditional() {
            return null;
        }

        /**
         * The configuration of a connection originating from a node that isn't a Condition node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowDataConnectionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnectionconfiguration.html#cfn-bedrock-flowversion-flowconnectionconfiguration-data">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnectionconfiguration.html#cfn-bedrock-flowversion-flowconnectionconfiguration-data</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConnectionConfigurationProperty> {
            java.lang.Object conditional;
            java.lang.Object data;

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getConditional}
             * @param conditional The configuration of a connection originating from a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.IResolvable conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getConditional}
             * @param conditional The configuration of a connection originating from a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConditionalConnectionConfigurationProperty conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getData}
             * @param data The configuration of a connection originating from a node that isn't a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder data(software.amazon.awscdk.IResolvable data) {
                this.data = data;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getData}
             * @param data The configuration of a connection originating from a node that isn't a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder data(software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowDataConnectionConfigurationProperty data) {
                this.data = data;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConnectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConnectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConnectionConfigurationProperty {
            private final java.lang.Object conditional;
            private final java.lang.Object data;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditional = software.amazon.jsii.Kernel.get(this, "conditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.data = software.amazon.jsii.Kernel.get(this, "data", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditional = builder.conditional;
                this.data = builder.data;
            }

            @Override
            public final java.lang.Object getConditional() {
                return this.conditional;
            }

            @Override
            public final java.lang.Object getData() {
                return this.data;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditional() != null) {
                    data.set("conditional", om.valueToTree(this.getConditional()));
                }
                if (this.getData() != null) {
                    data.set("data", om.valueToTree(this.getData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConnectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConnectionConfigurationProperty.Jsii$Proxy that = (FlowConnectionConfigurationProperty.Jsii$Proxy) o;

                if (this.conditional != null ? !this.conditional.equals(that.conditional) : that.conditional != null) return false;
                return this.data != null ? this.data.equals(that.data) : that.data == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditional != null ? this.conditional.hashCode() : 0;
                result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a connection between two nodes in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConnectionProperty flowConnectionProperty = FlowConnectionProperty.builder()
     *         .name("name")
     *         .source("source")
     *         .target("target")
     *         .type("type")
     *         // the properties below are optional
     *         .configuration(FlowConnectionConfigurationProperty.builder()
     *                 .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                         .condition("condition")
     *                         .build())
     *                 .data(FlowDataConnectionConfigurationProperty.builder()
     *                         .sourceOutput("sourceOutput")
     *                         .targetInput("targetInput")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConnectionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConnectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConnectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the connection that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The node that the connection starts at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The node that the connection ends at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * Whether the source node that the connection begins from is a condition node ( <code>Conditional</code> ) or not ( <code>Data</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The configuration of the connection.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConnectionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowconnection.html#cfn-bedrock-flowversion-flowconnection-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowConnectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConnectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConnectionProperty> {
            java.lang.String name;
            java.lang.String source;
            java.lang.String target;
            java.lang.String type;
            java.lang.Object configuration;

            /**
             * Sets the value of {@link FlowConnectionProperty#getName}
             * @param name A name for the connection that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getSource}
             * @param source The node that the connection starts at. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getTarget}
             * @param target The node that the connection ends at. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getType}
             * @param type Whether the source node that the connection begins from is a condition node ( <code>Conditional</code> ) or not ( <code>Data</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getConfiguration}
             * @param configuration The configuration of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getConfiguration}
             * @param configuration The configuration of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConnectionConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConnectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConnectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConnectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConnectionProperty {
            private final java.lang.String name;
            private final java.lang.String source;
            private final java.lang.String target;
            private final java.lang.String type;
            private final java.lang.Object configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.configuration = builder.configuration;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("source", om.valueToTree(this.getSource()));
                data.set("target", om.valueToTree(this.getTarget()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConnectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConnectionProperty.Jsii$Proxy that = (FlowConnectionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!source.equals(that.source)) return false;
                if (!target.equals(that.target)) return false;
                if (!type.equals(that.type)) return false;
                return this.configuration != null ? this.configuration.equals(that.configuration) : that.configuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a connection originating from a node that isn't a Condition node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowDataConnectionConfigurationProperty flowDataConnectionConfigurationProperty = FlowDataConnectionConfigurationProperty.builder()
     *         .sourceOutput("sourceOutput")
     *         .targetInput("targetInput")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdataconnectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdataconnectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowDataConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowDataConnectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowDataConnectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the output in the source node that the connection begins from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdataconnectionconfiguration.html#cfn-bedrock-flowversion-flowdataconnectionconfiguration-sourceoutput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdataconnectionconfiguration.html#cfn-bedrock-flowversion-flowdataconnectionconfiguration-sourceoutput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceOutput();

        /**
         * The name of the input in the target node that the connection ends at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdataconnectionconfiguration.html#cfn-bedrock-flowversion-flowdataconnectionconfiguration-targetinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdataconnectionconfiguration.html#cfn-bedrock-flowversion-flowdataconnectionconfiguration-targetinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetInput();

        /**
         * @return a {@link Builder} of {@link FlowDataConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowDataConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowDataConnectionConfigurationProperty> {
            java.lang.String sourceOutput;
            java.lang.String targetInput;

            /**
             * Sets the value of {@link FlowDataConnectionConfigurationProperty#getSourceOutput}
             * @param sourceOutput The name of the output in the source node that the connection begins from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceOutput(java.lang.String sourceOutput) {
                this.sourceOutput = sourceOutput;
                return this;
            }

            /**
             * Sets the value of {@link FlowDataConnectionConfigurationProperty#getTargetInput}
             * @param targetInput The name of the input in the target node that the connection ends at. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetInput(java.lang.String targetInput) {
                this.targetInput = targetInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowDataConnectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowDataConnectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowDataConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowDataConnectionConfigurationProperty {
            private final java.lang.String sourceOutput;
            private final java.lang.String targetInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceOutput = software.amazon.jsii.Kernel.get(this, "sourceOutput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetInput = software.amazon.jsii.Kernel.get(this, "targetInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceOutput = java.util.Objects.requireNonNull(builder.sourceOutput, "sourceOutput is required");
                this.targetInput = java.util.Objects.requireNonNull(builder.targetInput, "targetInput is required");
            }

            @Override
            public final java.lang.String getSourceOutput() {
                return this.sourceOutput;
            }

            @Override
            public final java.lang.String getTargetInput() {
                return this.targetInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceOutput", om.valueToTree(this.getSourceOutput()));
                data.set("targetInput", om.valueToTree(this.getTargetInput()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowDataConnectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowDataConnectionConfigurationProperty.Jsii$Proxy that = (FlowDataConnectionConfigurationProperty.Jsii$Proxy) o;

                if (!sourceOutput.equals(that.sourceOutput)) return false;
                return this.targetInput.equals(that.targetInput);
            }

            @Override
            public final int hashCode() {
                int result = this.sourceOutput.hashCode();
                result = 31 * result + (this.targetInput.hashCode());
                return result;
            }
        }
    }
    /**
     * The definition of the nodes and connections between nodes in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * Object collector;
     * FlowDefinitionProperty flowDefinitionProperty_;
     * Object input;
     * Object iterator;
     * Object loopInput;
     * Object output;
     * FlowDefinitionProperty flowDefinitionProperty = FlowDefinitionProperty.builder()
     *         .connections(List.of(FlowConnectionProperty.builder()
     *                 .name("name")
     *                 .source("source")
     *                 .target("target")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .configuration(FlowConnectionConfigurationProperty.builder()
     *                         .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                                 .condition("condition")
     *                                 .build())
     *                         .data(FlowDataConnectionConfigurationProperty.builder()
     *                                 .sourceOutput("sourceOutput")
     *                                 .targetInput("targetInput")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .nodes(List.of(FlowNodeProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .configuration(FlowNodeConfigurationProperty.builder()
     *                         .agent(AgentFlowNodeConfigurationProperty.builder()
     *                                 .agentAliasArn("agentAliasArn")
     *                                 .build())
     *                         .collector(collector)
     *                         .condition(ConditionFlowNodeConfigurationProperty.builder()
     *                                 .conditions(List.of(FlowConditionProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .expression("expression")
     *                                         .build()))
     *                                 .build())
     *                         .inlineCode(InlineCodeFlowNodeConfigurationProperty.builder()
     *                                 .code("code")
     *                                 .language("language")
     *                                 .build())
     *                         .input(input)
     *                         .iterator(iterator)
     *                         .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *                                 .knowledgeBaseId("knowledgeBaseId")
     *                                 // the properties below are optional
     *                                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                         .guardrailIdentifier("guardrailIdentifier")
     *                                         .guardrailVersion("guardrailVersion")
     *                                         .build())
     *                                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                 .maxTokens(123)
     *                                                 .stopSequences(List.of("stopSequences"))
     *                                                 .temperature(123)
     *                                                 .topP(123)
     *                                                 .build())
     *                                         .build())
     *                                 .modelId("modelId")
     *                                 .numberOfResults(123)
     *                                 .orchestrationConfiguration(KnowledgeBaseOrchestrationConfigurationProperty.builder()
     *                                         .additionalModelRequestFields(additionalModelRequestFields)
     *                                         .inferenceConfig(PromptInferenceConfigurationProperty.builder()
     *                                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                         .maxTokens(123)
     *                                                         .stopSequences(List.of("stopSequences"))
     *                                                         .temperature(123)
     *                                                         .topP(123)
     *                                                         .build())
     *                                                 .build())
     *                                         .performanceConfig(PerformanceConfigurationProperty.builder()
     *                                                 .latency("latency")
     *                                                 .build())
     *                                         .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                                                 .textPromptTemplate("textPromptTemplate")
     *                                                 .build())
     *                                         .build())
     *                                 .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                                         .textPromptTemplate("textPromptTemplate")
     *                                         .build())
     *                                 .rerankingConfiguration(VectorSearchRerankingConfigurationProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfigurationProperty.builder()
     *                                                 .modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *                                                         .modelArn("modelArn")
     *                                                         // the properties below are optional
     *                                                         .additionalModelRequestFields(additionalModelRequestFields)
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .metadataConfiguration(MetadataConfigurationForRerankingProperty.builder()
     *                                                         .selectionMode("selectionMode")
     *                                                         // the properties below are optional
     *                                                         .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                                                                 .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                                                                         .fieldName("fieldName")
     *                                                                         .build()))
     *                                                                 .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                                                                         .fieldName("fieldName")
     *                                                                         .build()))
     *                                                                 .build())
     *                                                         .build())
     *                                                 .numberOfRerankedResults(123)
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
     *                                 .lambdaArn("lambdaArn")
     *                                 .build())
     *                         .lex(LexFlowNodeConfigurationProperty.builder()
     *                                 .botAliasArn("botAliasArn")
     *                                 .localeId("localeId")
     *                                 .build())
     *                         .loop(LoopFlowNodeConfigurationProperty.builder()
     *                                 .definition(flowDefinitionProperty_)
     *                                 .build())
     *                         .loopController(LoopControllerFlowNodeConfigurationProperty.builder()
     *                                 .continueCondition(FlowConditionProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .expression("expression")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .maxIterations(123)
     *                                 .build())
     *                         .loopInput(loopInput)
     *                         .output(output)
     *                         .prompt(PromptFlowNodeConfigurationProperty.builder()
     *                                 .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                                         .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                                                 .modelId("modelId")
     *                                                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                                         .text(TextPromptTemplateConfigurationProperty.builder()
     *                                                                 .text("text")
     *                                                                 // the properties below are optional
     *                                                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                                         .name("name")
     *                                                                         .build()))
     *                                                                 .build())
     *                                                         .build())
     *                                                 .templateType("templateType")
     *                                                 // the properties below are optional
     *                                                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                                 .maxTokens(123)
     *                                                                 .stopSequences(List.of("stopSequences"))
     *                                                                 .temperature(123)
     *                                                                 .topP(123)
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                                                 .promptArn("promptArn")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                         .guardrailIdentifier("guardrailIdentifier")
     *                                         .guardrailVersion("guardrailVersion")
     *                                         .build())
     *                                 .build())
     *                         .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
     *                                 .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                                         .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                                                 .bucketName("bucketName")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .storage(StorageFlowNodeConfigurationProperty.builder()
     *                                 .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                                         .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                                                 .bucketName("bucketName")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .inputs(List.of(FlowNodeInputProperty.builder()
     *                         .expression("expression")
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .outputs(List.of(FlowNodeOutputProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of connection definitions in the flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConnectionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdefinition.html#cfn-bedrock-flowversion-flowdefinition-connections">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdefinition.html#cfn-bedrock-flowversion-flowdefinition-connections</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnections() {
            return null;
        }

        /**
         * An array of node definitions in the flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowNodeProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdefinition.html#cfn-bedrock-flowversion-flowdefinition-nodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flowdefinition.html#cfn-bedrock-flowversion-flowdefinition-nodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNodes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowDefinitionProperty> {
            java.lang.Object connections;
            java.lang.Object nodes;

            /**
             * Sets the value of {@link FlowDefinitionProperty#getConnections}
             * @param connections An array of connection definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connections(software.amazon.awscdk.IResolvable connections) {
                this.connections = connections;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getConnections}
             * @param connections An array of connection definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connections(java.util.List<? extends java.lang.Object> connections) {
                this.connections = connections;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getNodes}
             * @param nodes An array of node definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodes(software.amazon.awscdk.IResolvable nodes) {
                this.nodes = nodes;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getNodes}
             * @param nodes An array of node definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodes(java.util.List<? extends java.lang.Object> nodes) {
                this.nodes = nodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowDefinitionProperty {
            private final java.lang.Object connections;
            private final java.lang.Object nodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connections = software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nodes = software.amazon.jsii.Kernel.get(this, "nodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connections = builder.connections;
                this.nodes = builder.nodes;
            }

            @Override
            public final java.lang.Object getConnections() {
                return this.connections;
            }

            @Override
            public final java.lang.Object getNodes() {
                return this.nodes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnections() != null) {
                    data.set("connections", om.valueToTree(this.getConnections()));
                }
                if (this.getNodes() != null) {
                    data.set("nodes", om.valueToTree(this.getNodes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowDefinitionProperty.Jsii$Proxy that = (FlowDefinitionProperty.Jsii$Proxy) o;

                if (this.connections != null ? !this.connections.equals(that.connections) : that.connections != null) return false;
                return this.nodes != null ? this.nodes.equals(that.nodes) : that.nodes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connections != null ? this.connections.hashCode() : 0;
                result = 31 * result + (this.nodes != null ? this.nodes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a node in your flow.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * Object collector;
     * FlowNodeConfigurationProperty flowNodeConfigurationProperty_;
     * Object input;
     * Object iterator;
     * Object loopInput;
     * Object output;
     * FlowNodeConfigurationProperty flowNodeConfigurationProperty = FlowNodeConfigurationProperty.builder()
     *         .agent(AgentFlowNodeConfigurationProperty.builder()
     *                 .agentAliasArn("agentAliasArn")
     *                 .build())
     *         .collector(collector)
     *         .condition(ConditionFlowNodeConfigurationProperty.builder()
     *                 .conditions(List.of(FlowConditionProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .expression("expression")
     *                         .build()))
     *                 .build())
     *         .inlineCode(InlineCodeFlowNodeConfigurationProperty.builder()
     *                 .code("code")
     *                 .language("language")
     *                 .build())
     *         .input(input)
     *         .iterator(iterator)
     *         .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *                 .knowledgeBaseId("knowledgeBaseId")
     *                 // the properties below are optional
     *                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                         .guardrailIdentifier("guardrailIdentifier")
     *                         .guardrailVersion("guardrailVersion")
     *                         .build())
     *                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                 .maxTokens(123)
     *                                 .stopSequences(List.of("stopSequences"))
     *                                 .temperature(123)
     *                                 .topP(123)
     *                                 .build())
     *                         .build())
     *                 .modelId("modelId")
     *                 .numberOfResults(123)
     *                 .orchestrationConfiguration(KnowledgeBaseOrchestrationConfigurationProperty.builder()
     *                         .additionalModelRequestFields(additionalModelRequestFields)
     *                         .inferenceConfig(PromptInferenceConfigurationProperty.builder()
     *                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                         .maxTokens(123)
     *                                         .stopSequences(List.of("stopSequences"))
     *                                         .temperature(123)
     *                                         .topP(123)
     *                                         .build())
     *                                 .build())
     *                         .performanceConfig(PerformanceConfigurationProperty.builder()
     *                                 .latency("latency")
     *                                 .build())
     *                         .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                                 .textPromptTemplate("textPromptTemplate")
     *                                 .build())
     *                         .build())
     *                 .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                         .textPromptTemplate("textPromptTemplate")
     *                         .build())
     *                 .rerankingConfiguration(VectorSearchRerankingConfigurationProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfigurationProperty.builder()
     *                                 .modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *                                         .modelArn("modelArn")
     *                                         // the properties below are optional
     *                                         .additionalModelRequestFields(additionalModelRequestFields)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .metadataConfiguration(MetadataConfigurationForRerankingProperty.builder()
     *                                         .selectionMode("selectionMode")
     *                                         // the properties below are optional
     *                                         .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                                                 .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                                                         .fieldName("fieldName")
     *                                                         .build()))
     *                                                 .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                                                         .fieldName("fieldName")
     *                                                         .build()))
     *                                                 .build())
     *                                         .build())
     *                                 .numberOfRerankedResults(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .build())
     *         .lex(LexFlowNodeConfigurationProperty.builder()
     *                 .botAliasArn("botAliasArn")
     *                 .localeId("localeId")
     *                 .build())
     *         .loop(LoopFlowNodeConfigurationProperty.builder()
     *                 .definition(FlowDefinitionProperty.builder()
     *                         .connections(List.of(FlowConnectionProperty.builder()
     *                                 .name("name")
     *                                 .source("source")
     *                                 .target("target")
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .configuration(FlowConnectionConfigurationProperty.builder()
     *                                         .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                                                 .condition("condition")
     *                                                 .build())
     *                                         .data(FlowDataConnectionConfigurationProperty.builder()
     *                                                 .sourceOutput("sourceOutput")
     *                                                 .targetInput("targetInput")
     *                                                 .build())
     *                                         .build())
     *                                 .build()))
     *                         .nodes(List.of(FlowNodeProperty.builder()
     *                                 .name("name")
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .configuration(flowNodeConfigurationProperty_)
     *                                 .inputs(List.of(FlowNodeInputProperty.builder()
     *                                         .expression("expression")
     *                                         .name("name")
     *                                         .type("type")
     *                                         .build()))
     *                                 .outputs(List.of(FlowNodeOutputProperty.builder()
     *                                         .name("name")
     *                                         .type("type")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .loopController(LoopControllerFlowNodeConfigurationProperty.builder()
     *                 .continueCondition(FlowConditionProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .expression("expression")
     *                         .build())
     *                 // the properties below are optional
     *                 .maxIterations(123)
     *                 .build())
     *         .loopInput(loopInput)
     *         .output(output)
     *         .prompt(PromptFlowNodeConfigurationProperty.builder()
     *                 .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                         .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                                 .modelId("modelId")
     *                                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                         .text(TextPromptTemplateConfigurationProperty.builder()
     *                                                 .text("text")
     *                                                 // the properties below are optional
     *                                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                         .name("name")
     *                                                         .build()))
     *                                                 .build())
     *                                         .build())
     *                                 .templateType("templateType")
     *                                 // the properties below are optional
     *                                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                 .maxTokens(123)
     *                                                 .stopSequences(List.of("stopSequences"))
     *                                                 .temperature(123)
     *                                                 .topP(123)
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                                 .promptArn("promptArn")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                         .guardrailIdentifier("guardrailIdentifier")
     *                         .guardrailVersion("guardrailVersion")
     *                         .build())
     *                 .build())
     *         .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
     *                 .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                         .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .storage(StorageFlowNodeConfigurationProperty.builder()
     *                 .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                         .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for an agent node in your flow.
         * <p>
         * Invokes an alias of an agent and returns the response.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.AgentFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-agent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-agent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgent() {
            return null;
        }

        /**
         * Contains configurations for a collector node in your flow.
         * <p>
         * Collects an iteration of inputs and consolidates them into an array of outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-collector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-collector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCollector() {
            return null;
        }

        /**
         * Contains configurations for a condition node in your flow.
         * <p>
         * Defines conditions that lead to different branches of the flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.ConditionFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCondition() {
            return null;
        }

        /**
         * Contains configurations for an inline code node in your flow.
         * <p>
         * Inline code nodes let you write and execute code directly within your flow, enabling data transformations, custom logic, and integrations without needing an external Lambda function.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.InlineCodeFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-inlinecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-inlinecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInlineCode() {
            return null;
        }

        /**
         * Contains configurations for an input flow node in your flow.
         * <p>
         * The first node in the flow. <code>inputs</code> can't be specified for this node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInput() {
            return null;
        }

        /**
         * Contains configurations for an iterator node in your flow.
         * <p>
         * Takes an input that is an array and iteratively sends each item of the array as an output to the following node. The size of the array is also returned in the output.
         * <p>
         * The output flow node at the end of the flow iteration will return a response for each member of the array. To return only one response, you can include a collector node downstream from the iterator node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-iterator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-iterator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIterator() {
            return null;
        }

        /**
         * Contains configurations for a knowledge base node in your flow.
         * <p>
         * Queries a knowledge base and returns the retrieved results or generated response.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBaseFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-knowledgebase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-knowledgebase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKnowledgeBase() {
            return null;
        }

        /**
         * Contains configurations for a Lambda function node in your flow.
         * <p>
         * Invokes an AWS Lambda function.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.LambdaFunctionFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-lambdafunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-lambdafunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunction() {
            return null;
        }

        /**
         * Contains configurations for a Lex node in your flow.
         * <p>
         * Invokes an Amazon Lex bot to identify the intent of the input and return the intent as the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.LexFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-lex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-lex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLex() {
            return null;
        }

        /**
         * Contains configurations for a DoWhile loop in your flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.LoopFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-loop">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-loop</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoop() {
            return null;
        }

        /**
         * Contains controller node configurations for a DoWhile loop in your flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.LoopControllerFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-loopcontroller">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-loopcontroller</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoopController() {
            return null;
        }

        /**
         * Contains input node configurations for a DoWhile loop in your flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-loopinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-loopinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoopInput() {
            return null;
        }

        /**
         * Contains configurations for an output flow node in your flow.
         * <p>
         * The last node in the flow. <code>outputs</code> can't be specified for this node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutput() {
            return null;
        }

        /**
         * Contains configurations for a prompt node in your flow.
         * <p>
         * Runs a prompt and generates the model response as the output. You can use a prompt from Prompt management or you can configure one in this node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-prompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-prompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrompt() {
            return null;
        }

        /**
         * Contains configurations for a retrieval node in your flow.
         * <p>
         * Retrieves data from an Amazon S3 location and returns it as the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.RetrievalFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-retrieval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-retrieval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetrieval() {
            return null;
        }

        /**
         * Contains configurations for a storage node in your flow.
         * <p>
         * Stores an input in an Amazon S3 location.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.StorageFlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-storage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeconfiguration.html#cfn-bedrock-flowversion-flownodeconfiguration-storage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStorage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeConfigurationProperty> {
            java.lang.Object agent;
            java.lang.Object collector;
            java.lang.Object condition;
            java.lang.Object inlineCode;
            java.lang.Object input;
            java.lang.Object iterator;
            java.lang.Object knowledgeBase;
            java.lang.Object lambdaFunction;
            java.lang.Object lex;
            java.lang.Object loop;
            java.lang.Object loopController;
            java.lang.Object loopInput;
            java.lang.Object output;
            java.lang.Object prompt;
            java.lang.Object retrieval;
            java.lang.Object storage;

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getAgent}
             * @param agent Contains configurations for an agent node in your flow.
             *              Invokes an alias of an agent and returns the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agent(software.amazon.awscdk.IResolvable agent) {
                this.agent = agent;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getAgent}
             * @param agent Contains configurations for an agent node in your flow.
             *              Invokes an alias of an agent and returns the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agent(software.amazon.awscdk.services.bedrock.CfnFlowVersion.AgentFlowNodeConfigurationProperty agent) {
                this.agent = agent;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getCollector}
             * @param collector Contains configurations for a collector node in your flow.
             *                  Collects an iteration of inputs and consolidates them into an array of outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collector(java.lang.Object collector) {
                this.collector = collector;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getCondition}
             * @param condition Contains configurations for a condition node in your flow.
             *                  Defines conditions that lead to different branches of the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.IResolvable condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getCondition}
             * @param condition Contains configurations for a condition node in your flow.
             *                  Defines conditions that lead to different branches of the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.services.bedrock.CfnFlowVersion.ConditionFlowNodeConfigurationProperty condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getInlineCode}
             * @param inlineCode Contains configurations for an inline code node in your flow.
             *                   Inline code nodes let you write and execute code directly within your flow, enabling data transformations, custom logic, and integrations without needing an external Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineCode(software.amazon.awscdk.IResolvable inlineCode) {
                this.inlineCode = inlineCode;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getInlineCode}
             * @param inlineCode Contains configurations for an inline code node in your flow.
             *                   Inline code nodes let you write and execute code directly within your flow, enabling data transformations, custom logic, and integrations without needing an external Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineCode(software.amazon.awscdk.services.bedrock.CfnFlowVersion.InlineCodeFlowNodeConfigurationProperty inlineCode) {
                this.inlineCode = inlineCode;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getInput}
             * @param input Contains configurations for an input flow node in your flow.
             *              The first node in the flow. <code>inputs</code> can't be specified for this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.Object input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getIterator}
             * @param iterator Contains configurations for an iterator node in your flow.
             *                 Takes an input that is an array and iteratively sends each item of the array as an output to the following node. The size of the array is also returned in the output.
             *                 <p>
             *                 The output flow node at the end of the flow iteration will return a response for each member of the array. To return only one response, you can include a collector node downstream from the iterator node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iterator(java.lang.Object iterator) {
                this.iterator = iterator;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getKnowledgeBase}
             * @param knowledgeBase Contains configurations for a knowledge base node in your flow.
             *                      Queries a knowledge base and returns the retrieved results or generated response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBase(software.amazon.awscdk.IResolvable knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getKnowledgeBase}
             * @param knowledgeBase Contains configurations for a knowledge base node in your flow.
             *                      Queries a knowledge base and returns the retrieved results or generated response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBase(software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBaseFlowNodeConfigurationProperty knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLambdaFunction}
             * @param lambdaFunction Contains configurations for a Lambda function node in your flow.
             *                       Invokes an AWS Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunction(software.amazon.awscdk.IResolvable lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLambdaFunction}
             * @param lambdaFunction Contains configurations for a Lambda function node in your flow.
             *                       Invokes an AWS Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunction(software.amazon.awscdk.services.bedrock.CfnFlowVersion.LambdaFunctionFlowNodeConfigurationProperty lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLex}
             * @param lex Contains configurations for a Lex node in your flow.
             *            Invokes an Amazon Lex bot to identify the intent of the input and return the intent as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lex(software.amazon.awscdk.IResolvable lex) {
                this.lex = lex;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLex}
             * @param lex Contains configurations for a Lex node in your flow.
             *            Invokes an Amazon Lex bot to identify the intent of the input and return the intent as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lex(software.amazon.awscdk.services.bedrock.CfnFlowVersion.LexFlowNodeConfigurationProperty lex) {
                this.lex = lex;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLoop}
             * @param loop Contains configurations for a DoWhile loop in your flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loop(software.amazon.awscdk.IResolvable loop) {
                this.loop = loop;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLoop}
             * @param loop Contains configurations for a DoWhile loop in your flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loop(software.amazon.awscdk.services.bedrock.CfnFlowVersion.LoopFlowNodeConfigurationProperty loop) {
                this.loop = loop;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLoopController}
             * @param loopController Contains controller node configurations for a DoWhile loop in your flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loopController(software.amazon.awscdk.IResolvable loopController) {
                this.loopController = loopController;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLoopController}
             * @param loopController Contains controller node configurations for a DoWhile loop in your flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loopController(software.amazon.awscdk.services.bedrock.CfnFlowVersion.LoopControllerFlowNodeConfigurationProperty loopController) {
                this.loopController = loopController;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLoopInput}
             * @param loopInput Contains input node configurations for a DoWhile loop in your flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loopInput(java.lang.Object loopInput) {
                this.loopInput = loopInput;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getOutput}
             * @param output Contains configurations for an output flow node in your flow.
             *               The last node in the flow. <code>outputs</code> can't be specified for this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder output(java.lang.Object output) {
                this.output = output;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getPrompt}
             * @param prompt Contains configurations for a prompt node in your flow.
             *               Runs a prompt and generates the model response as the output. You can use a prompt from Prompt management or you can configure one in this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prompt(software.amazon.awscdk.IResolvable prompt) {
                this.prompt = prompt;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getPrompt}
             * @param prompt Contains configurations for a prompt node in your flow.
             *               Runs a prompt and generates the model response as the output. You can use a prompt from Prompt management or you can configure one in this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prompt(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeConfigurationProperty prompt) {
                this.prompt = prompt;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getRetrieval}
             * @param retrieval Contains configurations for a retrieval node in your flow.
             *                  Retrieves data from an Amazon S3 location and returns it as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retrieval(software.amazon.awscdk.IResolvable retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getRetrieval}
             * @param retrieval Contains configurations for a retrieval node in your flow.
             *                  Retrieves data from an Amazon S3 location and returns it as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retrieval(software.amazon.awscdk.services.bedrock.CfnFlowVersion.RetrievalFlowNodeConfigurationProperty retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getStorage}
             * @param storage Contains configurations for a storage node in your flow.
             *                Stores an input in an Amazon S3 location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storage(software.amazon.awscdk.IResolvable storage) {
                this.storage = storage;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getStorage}
             * @param storage Contains configurations for a storage node in your flow.
             *                Stores an input in an Amazon S3 location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storage(software.amazon.awscdk.services.bedrock.CfnFlowVersion.StorageFlowNodeConfigurationProperty storage) {
                this.storage = storage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeConfigurationProperty {
            private final java.lang.Object agent;
            private final java.lang.Object collector;
            private final java.lang.Object condition;
            private final java.lang.Object inlineCode;
            private final java.lang.Object input;
            private final java.lang.Object iterator;
            private final java.lang.Object knowledgeBase;
            private final java.lang.Object lambdaFunction;
            private final java.lang.Object lex;
            private final java.lang.Object loop;
            private final java.lang.Object loopController;
            private final java.lang.Object loopInput;
            private final java.lang.Object output;
            private final java.lang.Object prompt;
            private final java.lang.Object retrieval;
            private final java.lang.Object storage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agent = software.amazon.jsii.Kernel.get(this, "agent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.collector = software.amazon.jsii.Kernel.get(this, "collector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inlineCode = software.amazon.jsii.Kernel.get(this, "inlineCode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iterator = software.amazon.jsii.Kernel.get(this, "iterator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.knowledgeBase = software.amazon.jsii.Kernel.get(this, "knowledgeBase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lex = software.amazon.jsii.Kernel.get(this, "lex", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loop = software.amazon.jsii.Kernel.get(this, "loop", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loopController = software.amazon.jsii.Kernel.get(this, "loopController", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loopInput = software.amazon.jsii.Kernel.get(this, "loopInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prompt = software.amazon.jsii.Kernel.get(this, "prompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retrieval = software.amazon.jsii.Kernel.get(this, "retrieval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storage = software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agent = builder.agent;
                this.collector = builder.collector;
                this.condition = builder.condition;
                this.inlineCode = builder.inlineCode;
                this.input = builder.input;
                this.iterator = builder.iterator;
                this.knowledgeBase = builder.knowledgeBase;
                this.lambdaFunction = builder.lambdaFunction;
                this.lex = builder.lex;
                this.loop = builder.loop;
                this.loopController = builder.loopController;
                this.loopInput = builder.loopInput;
                this.output = builder.output;
                this.prompt = builder.prompt;
                this.retrieval = builder.retrieval;
                this.storage = builder.storage;
            }

            @Override
            public final java.lang.Object getAgent() {
                return this.agent;
            }

            @Override
            public final java.lang.Object getCollector() {
                return this.collector;
            }

            @Override
            public final java.lang.Object getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.Object getInlineCode() {
                return this.inlineCode;
            }

            @Override
            public final java.lang.Object getInput() {
                return this.input;
            }

            @Override
            public final java.lang.Object getIterator() {
                return this.iterator;
            }

            @Override
            public final java.lang.Object getKnowledgeBase() {
                return this.knowledgeBase;
            }

            @Override
            public final java.lang.Object getLambdaFunction() {
                return this.lambdaFunction;
            }

            @Override
            public final java.lang.Object getLex() {
                return this.lex;
            }

            @Override
            public final java.lang.Object getLoop() {
                return this.loop;
            }

            @Override
            public final java.lang.Object getLoopController() {
                return this.loopController;
            }

            @Override
            public final java.lang.Object getLoopInput() {
                return this.loopInput;
            }

            @Override
            public final java.lang.Object getOutput() {
                return this.output;
            }

            @Override
            public final java.lang.Object getPrompt() {
                return this.prompt;
            }

            @Override
            public final java.lang.Object getRetrieval() {
                return this.retrieval;
            }

            @Override
            public final java.lang.Object getStorage() {
                return this.storage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgent() != null) {
                    data.set("agent", om.valueToTree(this.getAgent()));
                }
                if (this.getCollector() != null) {
                    data.set("collector", om.valueToTree(this.getCollector()));
                }
                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }
                if (this.getInlineCode() != null) {
                    data.set("inlineCode", om.valueToTree(this.getInlineCode()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getIterator() != null) {
                    data.set("iterator", om.valueToTree(this.getIterator()));
                }
                if (this.getKnowledgeBase() != null) {
                    data.set("knowledgeBase", om.valueToTree(this.getKnowledgeBase()));
                }
                if (this.getLambdaFunction() != null) {
                    data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
                }
                if (this.getLex() != null) {
                    data.set("lex", om.valueToTree(this.getLex()));
                }
                if (this.getLoop() != null) {
                    data.set("loop", om.valueToTree(this.getLoop()));
                }
                if (this.getLoopController() != null) {
                    data.set("loopController", om.valueToTree(this.getLoopController()));
                }
                if (this.getLoopInput() != null) {
                    data.set("loopInput", om.valueToTree(this.getLoopInput()));
                }
                if (this.getOutput() != null) {
                    data.set("output", om.valueToTree(this.getOutput()));
                }
                if (this.getPrompt() != null) {
                    data.set("prompt", om.valueToTree(this.getPrompt()));
                }
                if (this.getRetrieval() != null) {
                    data.set("retrieval", om.valueToTree(this.getRetrieval()));
                }
                if (this.getStorage() != null) {
                    data.set("storage", om.valueToTree(this.getStorage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeConfigurationProperty.Jsii$Proxy that = (FlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (this.agent != null ? !this.agent.equals(that.agent) : that.agent != null) return false;
                if (this.collector != null ? !this.collector.equals(that.collector) : that.collector != null) return false;
                if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
                if (this.inlineCode != null ? !this.inlineCode.equals(that.inlineCode) : that.inlineCode != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                if (this.iterator != null ? !this.iterator.equals(that.iterator) : that.iterator != null) return false;
                if (this.knowledgeBase != null ? !this.knowledgeBase.equals(that.knowledgeBase) : that.knowledgeBase != null) return false;
                if (this.lambdaFunction != null ? !this.lambdaFunction.equals(that.lambdaFunction) : that.lambdaFunction != null) return false;
                if (this.lex != null ? !this.lex.equals(that.lex) : that.lex != null) return false;
                if (this.loop != null ? !this.loop.equals(that.loop) : that.loop != null) return false;
                if (this.loopController != null ? !this.loopController.equals(that.loopController) : that.loopController != null) return false;
                if (this.loopInput != null ? !this.loopInput.equals(that.loopInput) : that.loopInput != null) return false;
                if (this.output != null ? !this.output.equals(that.output) : that.output != null) return false;
                if (this.prompt != null ? !this.prompt.equals(that.prompt) : that.prompt != null) return false;
                if (this.retrieval != null ? !this.retrieval.equals(that.retrieval) : that.retrieval != null) return false;
                return this.storage != null ? this.storage.equals(that.storage) : that.storage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agent != null ? this.agent.hashCode() : 0;
                result = 31 * result + (this.collector != null ? this.collector.hashCode() : 0);
                result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
                result = 31 * result + (this.inlineCode != null ? this.inlineCode.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.iterator != null ? this.iterator.hashCode() : 0);
                result = 31 * result + (this.knowledgeBase != null ? this.knowledgeBase.hashCode() : 0);
                result = 31 * result + (this.lambdaFunction != null ? this.lambdaFunction.hashCode() : 0);
                result = 31 * result + (this.lex != null ? this.lex.hashCode() : 0);
                result = 31 * result + (this.loop != null ? this.loop.hashCode() : 0);
                result = 31 * result + (this.loopController != null ? this.loopController.hashCode() : 0);
                result = 31 * result + (this.loopInput != null ? this.loopInput.hashCode() : 0);
                result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
                result = 31 * result + (this.prompt != null ? this.prompt.hashCode() : 0);
                result = 31 * result + (this.retrieval != null ? this.retrieval.hashCode() : 0);
                result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for an input in an Amazon Bedrock Flows node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowNodeInputProperty flowNodeInputProperty = FlowNodeInputProperty.builder()
     *         .expression("expression")
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeInputProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that formats the input for the node.
         * <p>
         * For an explanation of how to create expressions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in Prompt flows in Amazon Bedrock</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html#cfn-bedrock-flowversion-flownodeinput-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html#cfn-bedrock-flowversion-flownodeinput-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * Specifies a name for the input that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html#cfn-bedrock-flowversion-flownodeinput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html#cfn-bedrock-flowversion-flownodeinput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specifies the data type of the input.
         * <p>
         * If the input doesn't match this type at runtime, a validation error will be thrown.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html#cfn-bedrock-flowversion-flownodeinput-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeinput.html#cfn-bedrock-flowversion-flownodeinput-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link FlowNodeInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeInputProperty> {
            java.lang.String expression;
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link FlowNodeInputProperty#getExpression}
             * @param expression An expression that formats the input for the node. This parameter is required.
             *                   For an explanation of how to create expressions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in Prompt flows in Amazon Bedrock</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeInputProperty#getName}
             * @param name Specifies a name for the input that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeInputProperty#getType}
             * @param type Specifies the data type of the input. This parameter is required.
             *             If the input doesn't match this type at runtime, a validation error will be thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeInputProperty {
            private final java.lang.String expression;
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeInputProperty.Jsii$Proxy that = (FlowNodeInputProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations for an output from a node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowNodeOutputProperty flowNodeOutputProperty = FlowNodeOutputProperty.builder()
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the output that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeoutput.html#cfn-bedrock-flowversion-flownodeoutput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeoutput.html#cfn-bedrock-flowversion-flownodeoutput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The data type of the output.
         * <p>
         * If the output doesn't match this type at runtime, a validation error will be thrown.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeoutput.html#cfn-bedrock-flowversion-flownodeoutput-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownodeoutput.html#cfn-bedrock-flowversion-flownodeoutput-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link FlowNodeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeOutputProperty> {
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link FlowNodeOutputProperty#getName}
             * @param name A name for the output that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeOutputProperty#getType}
             * @param type The data type of the output. This parameter is required.
             *             If the output doesn't match this type at runtime, a validation error will be thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeOutputProperty {
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeOutputProperty.Jsii$Proxy that = (FlowNodeOutputProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations about a node in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * Object collector;
     * FlowNodeProperty flowNodeProperty_;
     * Object input;
     * Object iterator;
     * Object loopInput;
     * Object output;
     * FlowNodeProperty flowNodeProperty = FlowNodeProperty.builder()
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .configuration(FlowNodeConfigurationProperty.builder()
     *                 .agent(AgentFlowNodeConfigurationProperty.builder()
     *                         .agentAliasArn("agentAliasArn")
     *                         .build())
     *                 .collector(collector)
     *                 .condition(ConditionFlowNodeConfigurationProperty.builder()
     *                         .conditions(List.of(FlowConditionProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .expression("expression")
     *                                 .build()))
     *                         .build())
     *                 .inlineCode(InlineCodeFlowNodeConfigurationProperty.builder()
     *                         .code("code")
     *                         .language("language")
     *                         .build())
     *                 .input(input)
     *                 .iterator(iterator)
     *                 .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *                         .knowledgeBaseId("knowledgeBaseId")
     *                         // the properties below are optional
     *                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                 .guardrailIdentifier("guardrailIdentifier")
     *                                 .guardrailVersion("guardrailVersion")
     *                                 .build())
     *                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                         .maxTokens(123)
     *                                         .stopSequences(List.of("stopSequences"))
     *                                         .temperature(123)
     *                                         .topP(123)
     *                                         .build())
     *                                 .build())
     *                         .modelId("modelId")
     *                         .numberOfResults(123)
     *                         .orchestrationConfiguration(KnowledgeBaseOrchestrationConfigurationProperty.builder()
     *                                 .additionalModelRequestFields(additionalModelRequestFields)
     *                                 .inferenceConfig(PromptInferenceConfigurationProperty.builder()
     *                                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                 .maxTokens(123)
     *                                                 .stopSequences(List.of("stopSequences"))
     *                                                 .temperature(123)
     *                                                 .topP(123)
     *                                                 .build())
     *                                         .build())
     *                                 .performanceConfig(PerformanceConfigurationProperty.builder()
     *                                         .latency("latency")
     *                                         .build())
     *                                 .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                                         .textPromptTemplate("textPromptTemplate")
     *                                         .build())
     *                                 .build())
     *                         .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                                 .textPromptTemplate("textPromptTemplate")
     *                                 .build())
     *                         .rerankingConfiguration(VectorSearchRerankingConfigurationProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfigurationProperty.builder()
     *                                         .modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *                                                 .modelArn("modelArn")
     *                                                 // the properties below are optional
     *                                                 .additionalModelRequestFields(additionalModelRequestFields)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .metadataConfiguration(MetadataConfigurationForRerankingProperty.builder()
     *                                                 .selectionMode("selectionMode")
     *                                                 // the properties below are optional
     *                                                 .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                                                         .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                                                                 .fieldName("fieldName")
     *                                                                 .build()))
     *                                                         .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                                                                 .fieldName("fieldName")
     *                                                                 .build()))
     *                                                         .build())
     *                                                 .build())
     *                                         .numberOfRerankedResults(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
     *                         .lambdaArn("lambdaArn")
     *                         .build())
     *                 .lex(LexFlowNodeConfigurationProperty.builder()
     *                         .botAliasArn("botAliasArn")
     *                         .localeId("localeId")
     *                         .build())
     *                 .loop(LoopFlowNodeConfigurationProperty.builder()
     *                         .definition(FlowDefinitionProperty.builder()
     *                                 .connections(List.of(FlowConnectionProperty.builder()
     *                                         .name("name")
     *                                         .source("source")
     *                                         .target("target")
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .configuration(FlowConnectionConfigurationProperty.builder()
     *                                                 .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                                                         .condition("condition")
     *                                                         .build())
     *                                                 .data(FlowDataConnectionConfigurationProperty.builder()
     *                                                         .sourceOutput("sourceOutput")
     *                                                         .targetInput("targetInput")
     *                                                         .build())
     *                                                 .build())
     *                                         .build()))
     *                                 .nodes(List.of(flowNodeProperty_))
     *                                 .build())
     *                         .build())
     *                 .loopController(LoopControllerFlowNodeConfigurationProperty.builder()
     *                         .continueCondition(FlowConditionProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .expression("expression")
     *                                 .build())
     *                         // the properties below are optional
     *                         .maxIterations(123)
     *                         .build())
     *                 .loopInput(loopInput)
     *                 .output(output)
     *                 .prompt(PromptFlowNodeConfigurationProperty.builder()
     *                         .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                                 .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                                         .modelId("modelId")
     *                                         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                                                         .text("text")
     *                                                         // the properties below are optional
     *                                                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build()))
     *                                                         .build())
     *                                                 .build())
     *                                         .templateType("templateType")
     *                                         // the properties below are optional
     *                                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                         .maxTokens(123)
     *                                                         .stopSequences(List.of("stopSequences"))
     *                                                         .temperature(123)
     *                                                         .topP(123)
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                                         .promptArn("promptArn")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                 .guardrailIdentifier("guardrailIdentifier")
     *                                 .guardrailVersion("guardrailVersion")
     *                                 .build())
     *                         .build())
     *                 .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
     *                         .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                                 .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                                         .bucketName("bucketName")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .storage(StorageFlowNodeConfigurationProperty.builder()
     *                         .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                                 .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                                         .bucketName("bucketName")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .inputs(List.of(FlowNodeInputProperty.builder()
     *                 .expression("expression")
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .outputs(List.of(FlowNodeOutputProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of node.
         * <p>
         * This value must match the name of the key that you provide in the configuration you provide in the <code>FlowNodeConfiguration</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Contains configurations for the node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowNodeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * An array of objects, each of which contains information about an input into the node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowNodeInputProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-inputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-inputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputs() {
            return null;
        }

        /**
         * A list of objects, each of which contains information about an output from the node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowNodeOutputProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-flownode.html#cfn-bedrock-flowversion-flownode-outputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeProperty> {
            java.lang.String name;
            java.lang.String type;
            java.lang.Object configuration;
            java.lang.Object inputs;
            java.lang.Object outputs;

            /**
             * Sets the value of {@link FlowNodeProperty#getName}
             * @param name A name for the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getType}
             * @param type The type of node. This parameter is required.
             *             This value must match the name of the key that you provide in the configuration you provide in the <code>FlowNodeConfiguration</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getConfiguration}
             * @param configuration Contains configurations for the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getConfiguration}
             * @param configuration Contains configurations for the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowNodeConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getInputs}
             * @param inputs An array of objects, each of which contains information about an input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputs(software.amazon.awscdk.IResolvable inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getInputs}
             * @param inputs An array of objects, each of which contains information about an input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputs(java.util.List<? extends java.lang.Object> inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getOutputs}
             * @param outputs A list of objects, each of which contains information about an output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(software.amazon.awscdk.IResolvable outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getOutputs}
             * @param outputs A list of objects, each of which contains information about an output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(java.util.List<? extends java.lang.Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.Object configuration;
            private final java.lang.Object inputs;
            private final java.lang.Object outputs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputs = software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.configuration = builder.configuration;
                this.inputs = builder.inputs;
                this.outputs = builder.outputs;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.Object getInputs() {
                return this.inputs;
            }

            @Override
            public final java.lang.Object getOutputs() {
                return this.outputs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getInputs() != null) {
                    data.set("inputs", om.valueToTree(this.getInputs()));
                }
                if (this.getOutputs() != null) {
                    data.set("outputs", om.valueToTree(this.getOutputs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeProperty.Jsii$Proxy that = (FlowNodeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) return false;
                return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                result = 31 * result + (this.inputs != null ? this.inputs.hashCode() : 0);
                result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration information for a guardrail that you use with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * GuardrailConfigurationProperty guardrailConfigurationProperty = GuardrailConfigurationProperty.builder()
     *         .guardrailIdentifier("guardrailIdentifier")
     *         .guardrailVersion("guardrailVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-guardrailconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-guardrailconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.GuardrailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-guardrailconfiguration.html#cfn-bedrock-flowversion-guardrailconfiguration-guardrailidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-guardrailconfiguration.html#cfn-bedrock-flowversion-guardrailconfiguration-guardrailidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuardrailIdentifier() {
            return null;
        }

        /**
         * The version of the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-guardrailconfiguration.html#cfn-bedrock-flowversion-guardrailconfiguration-guardrailversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-guardrailconfiguration.html#cfn-bedrock-flowversion-guardrailconfiguration-guardrailversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuardrailVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailConfigurationProperty> {
            java.lang.String guardrailIdentifier;
            java.lang.String guardrailVersion;

            /**
             * Sets the value of {@link GuardrailConfigurationProperty#getGuardrailIdentifier}
             * @param guardrailIdentifier The identifier for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailIdentifier(java.lang.String guardrailIdentifier) {
                this.guardrailIdentifier = guardrailIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailConfigurationProperty#getGuardrailVersion}
             * @param guardrailVersion The version of the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailVersion(java.lang.String guardrailVersion) {
                this.guardrailVersion = guardrailVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailConfigurationProperty {
            private final java.lang.String guardrailIdentifier;
            private final java.lang.String guardrailVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.guardrailIdentifier = software.amazon.jsii.Kernel.get(this, "guardrailIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.guardrailVersion = software.amazon.jsii.Kernel.get(this, "guardrailVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.guardrailIdentifier = builder.guardrailIdentifier;
                this.guardrailVersion = builder.guardrailVersion;
            }

            @Override
            public final java.lang.String getGuardrailIdentifier() {
                return this.guardrailIdentifier;
            }

            @Override
            public final java.lang.String getGuardrailVersion() {
                return this.guardrailVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGuardrailIdentifier() != null) {
                    data.set("guardrailIdentifier", om.valueToTree(this.getGuardrailIdentifier()));
                }
                if (this.getGuardrailVersion() != null) {
                    data.set("guardrailVersion", om.valueToTree(this.getGuardrailVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.GuardrailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailConfigurationProperty.Jsii$Proxy that = (GuardrailConfigurationProperty.Jsii$Proxy) o;

                if (this.guardrailIdentifier != null ? !this.guardrailIdentifier.equals(that.guardrailIdentifier) : that.guardrailIdentifier != null) return false;
                return this.guardrailVersion != null ? this.guardrailVersion.equals(that.guardrailVersion) : that.guardrailVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.guardrailIdentifier != null ? this.guardrailIdentifier.hashCode() : 0;
                result = 31 * result + (this.guardrailVersion != null ? this.guardrailVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for an inline code node in your flow.
     * <p>
     * Inline code nodes let you write and execute code directly within your flow, enabling data transformations, custom logic, and integrations without needing an external Lambda function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * InlineCodeFlowNodeConfigurationProperty inlineCodeFlowNodeConfigurationProperty = InlineCodeFlowNodeConfigurationProperty.builder()
     *         .code("code")
     *         .language("language")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-inlinecodeflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-inlinecodeflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.InlineCodeFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InlineCodeFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InlineCodeFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The code that's executed in your inline code node.
         * <p>
         * The code can access input data from previous nodes in the flow, perform operations on that data, and produce output that can be used by other nodes in your flow.
         * <p>
         * The code must be valid in the programming <code>language</code> that you specify.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-inlinecodeflownodeconfiguration.html#cfn-bedrock-flowversion-inlinecodeflownodeconfiguration-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-inlinecodeflownodeconfiguration.html#cfn-bedrock-flowversion-inlinecodeflownodeconfiguration-code</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCode();

        /**
         * The programming language used by your inline code node.
         * <p>
         * The code must be valid in the programming <code>language</code> that you specify. Currently, only Python 3 ( <code>Python_3</code> ) is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-inlinecodeflownodeconfiguration.html#cfn-bedrock-flowversion-inlinecodeflownodeconfiguration-language">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-inlinecodeflownodeconfiguration.html#cfn-bedrock-flowversion-inlinecodeflownodeconfiguration-language</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLanguage();

        /**
         * @return a {@link Builder} of {@link InlineCodeFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InlineCodeFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InlineCodeFlowNodeConfigurationProperty> {
            java.lang.String code;
            java.lang.String language;

            /**
             * Sets the value of {@link InlineCodeFlowNodeConfigurationProperty#getCode}
             * @param code The code that's executed in your inline code node. This parameter is required.
             *             The code can access input data from previous nodes in the flow, perform operations on that data, and produce output that can be used by other nodes in your flow.
             *             <p>
             *             The code must be valid in the programming <code>language</code> that you specify.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder code(java.lang.String code) {
                this.code = code;
                return this;
            }

            /**
             * Sets the value of {@link InlineCodeFlowNodeConfigurationProperty#getLanguage}
             * @param language The programming language used by your inline code node. This parameter is required.
             *                 The code must be valid in the programming <code>language</code> that you specify. Currently, only Python 3 ( <code>Python_3</code> ) is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder language(java.lang.String language) {
                this.language = language;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InlineCodeFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InlineCodeFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InlineCodeFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InlineCodeFlowNodeConfigurationProperty {
            private final java.lang.String code;
            private final java.lang.String language;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.language = software.amazon.jsii.Kernel.get(this, "language", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.code = java.util.Objects.requireNonNull(builder.code, "code is required");
                this.language = java.util.Objects.requireNonNull(builder.language, "language is required");
            }

            @Override
            public final java.lang.String getCode() {
                return this.code;
            }

            @Override
            public final java.lang.String getLanguage() {
                return this.language;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("code", om.valueToTree(this.getCode()));
                data.set("language", om.valueToTree(this.getLanguage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.InlineCodeFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InlineCodeFlowNodeConfigurationProperty.Jsii$Proxy that = (InlineCodeFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!code.equals(that.code)) return false;
                return this.language.equals(that.language);
            }

            @Override
            public final int hashCode() {
                int result = this.code.hashCode();
                result = 31 * result + (this.language.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations for a knowledge base node in a flow.
     * <p>
     * This node takes a query as the input and returns, as the output, the retrieved responses directly (as an array) or a response generated based on the retrieved responses. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * KnowledgeBaseFlowNodeConfigurationProperty knowledgeBaseFlowNodeConfigurationProperty = KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *         .knowledgeBaseId("knowledgeBaseId")
     *         // the properties below are optional
     *         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                 .guardrailIdentifier("guardrailIdentifier")
     *                 .guardrailVersion("guardrailVersion")
     *                 .build())
     *         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .stopSequences(List.of("stopSequences"))
     *                         .temperature(123)
     *                         .topP(123)
     *                         .build())
     *                 .build())
     *         .modelId("modelId")
     *         .numberOfResults(123)
     *         .orchestrationConfiguration(KnowledgeBaseOrchestrationConfigurationProperty.builder()
     *                 .additionalModelRequestFields(additionalModelRequestFields)
     *                 .inferenceConfig(PromptInferenceConfigurationProperty.builder()
     *                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                 .maxTokens(123)
     *                                 .stopSequences(List.of("stopSequences"))
     *                                 .temperature(123)
     *                                 .topP(123)
     *                                 .build())
     *                         .build())
     *                 .performanceConfig(PerformanceConfigurationProperty.builder()
     *                         .latency("latency")
     *                         .build())
     *                 .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                         .textPromptTemplate("textPromptTemplate")
     *                         .build())
     *                 .build())
     *         .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                 .textPromptTemplate("textPromptTemplate")
     *                 .build())
     *         .rerankingConfiguration(VectorSearchRerankingConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfigurationProperty.builder()
     *                         .modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *                                 .modelArn("modelArn")
     *                                 // the properties below are optional
     *                                 .additionalModelRequestFields(additionalModelRequestFields)
     *                                 .build())
     *                         // the properties below are optional
     *                         .metadataConfiguration(MetadataConfigurationForRerankingProperty.builder()
     *                                 .selectionMode("selectionMode")
     *                                 // the properties below are optional
     *                                 .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                                         .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                                                 .fieldName("fieldName")
     *                                                 .build()))
     *                                         .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                                                 .fieldName("fieldName")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .numberOfRerankedResults(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBaseFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KnowledgeBaseFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KnowledgeBaseFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the knowledge base to query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-knowledgebaseid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-knowledgebaseid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseId();

        /**
         * Contains configurations for a guardrail to apply during query and response generation for the knowledge base in this configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.GuardrailConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-guardrailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-guardrailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGuardrailConfiguration() {
            return null;
        }

        /**
         * Contains inference configurations for the prompt.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-inferenceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-inferenceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceConfiguration() {
            return null;
        }

        /**
         * The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to use to generate a response from the query results. Omit this field if you want to return the retrieved results as an array.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModelId() {
            return null;
        }

        /**
         * The number of results to retrieve from the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-numberofresults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-numberofresults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfResults() {
            return null;
        }

        /**
         * The configuration for orchestrating the retrieval and generation process in the knowledge base node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBaseOrchestrationConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-orchestrationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-orchestrationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrchestrationConfiguration() {
            return null;
        }

        /**
         * A custom prompt template to use with the knowledge base for generating responses.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBasePromptTemplateProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-prompttemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-prompttemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPromptTemplate() {
            return null;
        }

        /**
         * The configuration for reranking the retrieved results from the knowledge base to improve relevance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.VectorSearchRerankingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-rerankingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flowversion-knowledgebaseflownodeconfiguration-rerankingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRerankingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KnowledgeBaseFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KnowledgeBaseFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBaseFlowNodeConfigurationProperty> {
            java.lang.String knowledgeBaseId;
            java.lang.Object guardrailConfiguration;
            java.lang.Object inferenceConfiguration;
            java.lang.String modelId;
            java.lang.Number numberOfResults;
            java.lang.Object orchestrationConfiguration;
            java.lang.Object promptTemplate;
            java.lang.Object rerankingConfiguration;

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getKnowledgeBaseId}
             * @param knowledgeBaseId The unique identifier of the knowledge base to query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBaseId(java.lang.String knowledgeBaseId) {
                this.knowledgeBaseId = knowledgeBaseId;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply during query and response generation for the knowledge base in this configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply during query and response generation for the knowledge base in this configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getModelId}
             * @param modelId The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to use to generate a response from the query results. Omit this field if you want to return the retrieved results as an array.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getNumberOfResults}
             * @param numberOfResults The number of results to retrieve from the knowledge base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfResults(java.lang.Number numberOfResults) {
                this.numberOfResults = numberOfResults;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getOrchestrationConfiguration}
             * @param orchestrationConfiguration The configuration for orchestrating the retrieval and generation process in the knowledge base node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orchestrationConfiguration(software.amazon.awscdk.IResolvable orchestrationConfiguration) {
                this.orchestrationConfiguration = orchestrationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getOrchestrationConfiguration}
             * @param orchestrationConfiguration The configuration for orchestrating the retrieval and generation process in the knowledge base node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orchestrationConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBaseOrchestrationConfigurationProperty orchestrationConfiguration) {
                this.orchestrationConfiguration = orchestrationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getPromptTemplate}
             * @param promptTemplate A custom prompt template to use with the knowledge base for generating responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptTemplate(software.amazon.awscdk.IResolvable promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getPromptTemplate}
             * @param promptTemplate A custom prompt template to use with the knowledge base for generating responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptTemplate(software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBasePromptTemplateProperty promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getRerankingConfiguration}
             * @param rerankingConfiguration The configuration for reranking the retrieved results from the knowledge base to improve relevance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rerankingConfiguration(software.amazon.awscdk.IResolvable rerankingConfiguration) {
                this.rerankingConfiguration = rerankingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getRerankingConfiguration}
             * @param rerankingConfiguration The configuration for reranking the retrieved results from the knowledge base to improve relevance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rerankingConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.VectorSearchRerankingConfigurationProperty rerankingConfiguration) {
                this.rerankingConfiguration = rerankingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KnowledgeBaseFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KnowledgeBaseFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KnowledgeBaseFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBaseFlowNodeConfigurationProperty {
            private final java.lang.String knowledgeBaseId;
            private final java.lang.Object guardrailConfiguration;
            private final java.lang.Object inferenceConfiguration;
            private final java.lang.String modelId;
            private final java.lang.Number numberOfResults;
            private final java.lang.Object orchestrationConfiguration;
            private final java.lang.Object promptTemplate;
            private final java.lang.Object rerankingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.knowledgeBaseId = software.amazon.jsii.Kernel.get(this, "knowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.guardrailConfiguration = software.amazon.jsii.Kernel.get(this, "guardrailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inferenceConfiguration = software.amazon.jsii.Kernel.get(this, "inferenceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberOfResults = software.amazon.jsii.Kernel.get(this, "numberOfResults", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.orchestrationConfiguration = software.amazon.jsii.Kernel.get(this, "orchestrationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.promptTemplate = software.amazon.jsii.Kernel.get(this, "promptTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rerankingConfiguration = software.amazon.jsii.Kernel.get(this, "rerankingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.knowledgeBaseId = java.util.Objects.requireNonNull(builder.knowledgeBaseId, "knowledgeBaseId is required");
                this.guardrailConfiguration = builder.guardrailConfiguration;
                this.inferenceConfiguration = builder.inferenceConfiguration;
                this.modelId = builder.modelId;
                this.numberOfResults = builder.numberOfResults;
                this.orchestrationConfiguration = builder.orchestrationConfiguration;
                this.promptTemplate = builder.promptTemplate;
                this.rerankingConfiguration = builder.rerankingConfiguration;
            }

            @Override
            public final java.lang.String getKnowledgeBaseId() {
                return this.knowledgeBaseId;
            }

            @Override
            public final java.lang.Object getGuardrailConfiguration() {
                return this.guardrailConfiguration;
            }

            @Override
            public final java.lang.Object getInferenceConfiguration() {
                return this.inferenceConfiguration;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            public final java.lang.Number getNumberOfResults() {
                return this.numberOfResults;
            }

            @Override
            public final java.lang.Object getOrchestrationConfiguration() {
                return this.orchestrationConfiguration;
            }

            @Override
            public final java.lang.Object getPromptTemplate() {
                return this.promptTemplate;
            }

            @Override
            public final java.lang.Object getRerankingConfiguration() {
                return this.rerankingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("knowledgeBaseId", om.valueToTree(this.getKnowledgeBaseId()));
                if (this.getGuardrailConfiguration() != null) {
                    data.set("guardrailConfiguration", om.valueToTree(this.getGuardrailConfiguration()));
                }
                if (this.getInferenceConfiguration() != null) {
                    data.set("inferenceConfiguration", om.valueToTree(this.getInferenceConfiguration()));
                }
                if (this.getModelId() != null) {
                    data.set("modelId", om.valueToTree(this.getModelId()));
                }
                if (this.getNumberOfResults() != null) {
                    data.set("numberOfResults", om.valueToTree(this.getNumberOfResults()));
                }
                if (this.getOrchestrationConfiguration() != null) {
                    data.set("orchestrationConfiguration", om.valueToTree(this.getOrchestrationConfiguration()));
                }
                if (this.getPromptTemplate() != null) {
                    data.set("promptTemplate", om.valueToTree(this.getPromptTemplate()));
                }
                if (this.getRerankingConfiguration() != null) {
                    data.set("rerankingConfiguration", om.valueToTree(this.getRerankingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBaseFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KnowledgeBaseFlowNodeConfigurationProperty.Jsii$Proxy that = (KnowledgeBaseFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!knowledgeBaseId.equals(that.knowledgeBaseId)) return false;
                if (this.guardrailConfiguration != null ? !this.guardrailConfiguration.equals(that.guardrailConfiguration) : that.guardrailConfiguration != null) return false;
                if (this.inferenceConfiguration != null ? !this.inferenceConfiguration.equals(that.inferenceConfiguration) : that.inferenceConfiguration != null) return false;
                if (this.modelId != null ? !this.modelId.equals(that.modelId) : that.modelId != null) return false;
                if (this.numberOfResults != null ? !this.numberOfResults.equals(that.numberOfResults) : that.numberOfResults != null) return false;
                if (this.orchestrationConfiguration != null ? !this.orchestrationConfiguration.equals(that.orchestrationConfiguration) : that.orchestrationConfiguration != null) return false;
                if (this.promptTemplate != null ? !this.promptTemplate.equals(that.promptTemplate) : that.promptTemplate != null) return false;
                return this.rerankingConfiguration != null ? this.rerankingConfiguration.equals(that.rerankingConfiguration) : that.rerankingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.knowledgeBaseId.hashCode();
                result = 31 * result + (this.guardrailConfiguration != null ? this.guardrailConfiguration.hashCode() : 0);
                result = 31 * result + (this.inferenceConfiguration != null ? this.inferenceConfiguration.hashCode() : 0);
                result = 31 * result + (this.modelId != null ? this.modelId.hashCode() : 0);
                result = 31 * result + (this.numberOfResults != null ? this.numberOfResults.hashCode() : 0);
                result = 31 * result + (this.orchestrationConfiguration != null ? this.orchestrationConfiguration.hashCode() : 0);
                result = 31 * result + (this.promptTemplate != null ? this.promptTemplate.hashCode() : 0);
                result = 31 * result + (this.rerankingConfiguration != null ? this.rerankingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures how the knowledge base orchestrates the retrieval and generation process, allowing for customization of prompts, inference parameters, and performance settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * KnowledgeBaseOrchestrationConfigurationProperty knowledgeBaseOrchestrationConfigurationProperty = KnowledgeBaseOrchestrationConfigurationProperty.builder()
     *         .additionalModelRequestFields(additionalModelRequestFields)
     *         .inferenceConfig(PromptInferenceConfigurationProperty.builder()
     *                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .stopSequences(List.of("stopSequences"))
     *                         .temperature(123)
     *                         .topP(123)
     *                         .build())
     *                 .build())
     *         .performanceConfig(PerformanceConfigurationProperty.builder()
     *                 .latency("latency")
     *                 .build())
     *         .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                 .textPromptTemplate("textPromptTemplate")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBaseOrchestrationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KnowledgeBaseOrchestrationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KnowledgeBaseOrchestrationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The additional model-specific request parameters as key-value pairs to be included in the request to the foundation model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-additionalmodelrequestfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-additionalmodelrequestfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalModelRequestFields() {
            return null;
        }

        /**
         * Contains inference configurations for the prompt.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-inferenceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-inferenceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceConfig() {
            return null;
        }

        /**
         * The performance configuration options for the knowledge base retrieval and generation process.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PerformanceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-performanceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-performanceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPerformanceConfig() {
            return null;
        }

        /**
         * A custom prompt template for orchestrating the retrieval and generation process.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBasePromptTemplateProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-prompttemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseorchestrationconfiguration.html#cfn-bedrock-flowversion-knowledgebaseorchestrationconfiguration-prompttemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPromptTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KnowledgeBaseOrchestrationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KnowledgeBaseOrchestrationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBaseOrchestrationConfigurationProperty> {
            java.lang.Object additionalModelRequestFields;
            java.lang.Object inferenceConfig;
            java.lang.Object performanceConfig;
            java.lang.Object promptTemplate;

            /**
             * Sets the value of {@link KnowledgeBaseOrchestrationConfigurationProperty#getAdditionalModelRequestFields}
             * @param additionalModelRequestFields The additional model-specific request parameters as key-value pairs to be included in the request to the foundation model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalModelRequestFields(java.lang.Object additionalModelRequestFields) {
                this.additionalModelRequestFields = additionalModelRequestFields;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseOrchestrationConfigurationProperty#getInferenceConfig}
             * @param inferenceConfig Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfig(software.amazon.awscdk.IResolvable inferenceConfig) {
                this.inferenceConfig = inferenceConfig;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseOrchestrationConfigurationProperty#getInferenceConfig}
             * @param inferenceConfig Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfig(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty inferenceConfig) {
                this.inferenceConfig = inferenceConfig;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseOrchestrationConfigurationProperty#getPerformanceConfig}
             * @param performanceConfig The performance configuration options for the knowledge base retrieval and generation process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder performanceConfig(software.amazon.awscdk.IResolvable performanceConfig) {
                this.performanceConfig = performanceConfig;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseOrchestrationConfigurationProperty#getPerformanceConfig}
             * @param performanceConfig The performance configuration options for the knowledge base retrieval and generation process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder performanceConfig(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PerformanceConfigurationProperty performanceConfig) {
                this.performanceConfig = performanceConfig;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseOrchestrationConfigurationProperty#getPromptTemplate}
             * @param promptTemplate A custom prompt template for orchestrating the retrieval and generation process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptTemplate(software.amazon.awscdk.IResolvable promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseOrchestrationConfigurationProperty#getPromptTemplate}
             * @param promptTemplate A custom prompt template for orchestrating the retrieval and generation process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptTemplate(software.amazon.awscdk.services.bedrock.CfnFlowVersion.KnowledgeBasePromptTemplateProperty promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KnowledgeBaseOrchestrationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KnowledgeBaseOrchestrationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KnowledgeBaseOrchestrationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBaseOrchestrationConfigurationProperty {
            private final java.lang.Object additionalModelRequestFields;
            private final java.lang.Object inferenceConfig;
            private final java.lang.Object performanceConfig;
            private final java.lang.Object promptTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalModelRequestFields = software.amazon.jsii.Kernel.get(this, "additionalModelRequestFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inferenceConfig = software.amazon.jsii.Kernel.get(this, "inferenceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.performanceConfig = software.amazon.jsii.Kernel.get(this, "performanceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.promptTemplate = software.amazon.jsii.Kernel.get(this, "promptTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalModelRequestFields = builder.additionalModelRequestFields;
                this.inferenceConfig = builder.inferenceConfig;
                this.performanceConfig = builder.performanceConfig;
                this.promptTemplate = builder.promptTemplate;
            }

            @Override
            public final java.lang.Object getAdditionalModelRequestFields() {
                return this.additionalModelRequestFields;
            }

            @Override
            public final java.lang.Object getInferenceConfig() {
                return this.inferenceConfig;
            }

            @Override
            public final java.lang.Object getPerformanceConfig() {
                return this.performanceConfig;
            }

            @Override
            public final java.lang.Object getPromptTemplate() {
                return this.promptTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalModelRequestFields() != null) {
                    data.set("additionalModelRequestFields", om.valueToTree(this.getAdditionalModelRequestFields()));
                }
                if (this.getInferenceConfig() != null) {
                    data.set("inferenceConfig", om.valueToTree(this.getInferenceConfig()));
                }
                if (this.getPerformanceConfig() != null) {
                    data.set("performanceConfig", om.valueToTree(this.getPerformanceConfig()));
                }
                if (this.getPromptTemplate() != null) {
                    data.set("promptTemplate", om.valueToTree(this.getPromptTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBaseOrchestrationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KnowledgeBaseOrchestrationConfigurationProperty.Jsii$Proxy that = (KnowledgeBaseOrchestrationConfigurationProperty.Jsii$Proxy) o;

                if (this.additionalModelRequestFields != null ? !this.additionalModelRequestFields.equals(that.additionalModelRequestFields) : that.additionalModelRequestFields != null) return false;
                if (this.inferenceConfig != null ? !this.inferenceConfig.equals(that.inferenceConfig) : that.inferenceConfig != null) return false;
                if (this.performanceConfig != null ? !this.performanceConfig.equals(that.performanceConfig) : that.performanceConfig != null) return false;
                return this.promptTemplate != null ? this.promptTemplate.equals(that.promptTemplate) : that.promptTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalModelRequestFields != null ? this.additionalModelRequestFields.hashCode() : 0;
                result = 31 * result + (this.inferenceConfig != null ? this.inferenceConfig.hashCode() : 0);
                result = 31 * result + (this.performanceConfig != null ? this.performanceConfig.hashCode() : 0);
                result = 31 * result + (this.promptTemplate != null ? this.promptTemplate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a custom prompt template for orchestrating the retrieval and generation process.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * KnowledgeBasePromptTemplateProperty knowledgeBasePromptTemplateProperty = KnowledgeBasePromptTemplateProperty.builder()
     *         .textPromptTemplate("textPromptTemplate")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseprompttemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseprompttemplate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBasePromptTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(KnowledgeBasePromptTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KnowledgeBasePromptTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text of the prompt template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseprompttemplate.html#cfn-bedrock-flowversion-knowledgebaseprompttemplate-textprompttemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-knowledgebaseprompttemplate.html#cfn-bedrock-flowversion-knowledgebaseprompttemplate-textprompttemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextPromptTemplate();

        /**
         * @return a {@link Builder} of {@link KnowledgeBasePromptTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KnowledgeBasePromptTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBasePromptTemplateProperty> {
            java.lang.String textPromptTemplate;

            /**
             * Sets the value of {@link KnowledgeBasePromptTemplateProperty#getTextPromptTemplate}
             * @param textPromptTemplate The text of the prompt template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textPromptTemplate(java.lang.String textPromptTemplate) {
                this.textPromptTemplate = textPromptTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KnowledgeBasePromptTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KnowledgeBasePromptTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KnowledgeBasePromptTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBasePromptTemplateProperty {
            private final java.lang.String textPromptTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.textPromptTemplate = software.amazon.jsii.Kernel.get(this, "textPromptTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.textPromptTemplate = java.util.Objects.requireNonNull(builder.textPromptTemplate, "textPromptTemplate is required");
            }

            @Override
            public final java.lang.String getTextPromptTemplate() {
                return this.textPromptTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("textPromptTemplate", om.valueToTree(this.getTextPromptTemplate()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBasePromptTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KnowledgeBasePromptTemplateProperty.Jsii$Proxy that = (KnowledgeBasePromptTemplateProperty.Jsii$Proxy) o;

                return this.textPromptTemplate.equals(that.textPromptTemplate);
            }

            @Override
            public final int hashCode() {
                int result = this.textPromptTemplate.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Lambda function node in the flow.
     * <p>
     * You specify the Lambda function to invoke and the inputs into the function. The output is the response that is defined in the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * LambdaFunctionFlowNodeConfigurationProperty lambdaFunctionFlowNodeConfigurationProperty = LambdaFunctionFlowNodeConfigurationProperty.builder()
     *         .lambdaArn("lambdaArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lambdafunctionflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lambdafunctionflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.LambdaFunctionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaFunctionFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaFunctionFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Lambda function to invoke.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lambdafunctionflownodeconfiguration.html#cfn-bedrock-flowversion-lambdafunctionflownodeconfiguration-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lambdafunctionflownodeconfiguration.html#cfn-bedrock-flowversion-lambdafunctionflownodeconfiguration-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * @return a {@link Builder} of {@link LambdaFunctionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaFunctionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionFlowNodeConfigurationProperty> {
            java.lang.String lambdaArn;

            /**
             * Sets the value of {@link LambdaFunctionFlowNodeConfigurationProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of the Lambda function to invoke. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaFunctionFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaFunctionFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaFunctionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionFlowNodeConfigurationProperty {
            private final java.lang.String lambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.LambdaFunctionFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaFunctionFlowNodeConfigurationProperty.Jsii$Proxy that = (LambdaFunctionFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.lambdaArn.equals(that.lambdaArn);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Lex node in the flow.
     * <p>
     * You specify a Amazon Lex bot to invoke. This node takes an utterance as the input and returns as the output the intent identified by the Amazon Lex bot. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * LexFlowNodeConfigurationProperty lexFlowNodeConfigurationProperty = LexFlowNodeConfigurationProperty.builder()
     *         .botAliasArn("botAliasArn")
     *         .localeId("localeId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lexflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lexflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.LexFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LexFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LexFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lexflownodeconfiguration.html#cfn-bedrock-flowversion-lexflownodeconfiguration-botaliasarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lexflownodeconfiguration.html#cfn-bedrock-flowversion-lexflownodeconfiguration-botaliasarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBotAliasArn();

        /**
         * The Region to invoke the Amazon Lex bot in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lexflownodeconfiguration.html#cfn-bedrock-flowversion-lexflownodeconfiguration-localeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-lexflownodeconfiguration.html#cfn-bedrock-flowversion-lexflownodeconfiguration-localeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocaleId();

        /**
         * @return a {@link Builder} of {@link LexFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LexFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LexFlowNodeConfigurationProperty> {
            java.lang.String botAliasArn;
            java.lang.String localeId;

            /**
             * Sets the value of {@link LexFlowNodeConfigurationProperty#getBotAliasArn}
             * @param botAliasArn The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasArn(java.lang.String botAliasArn) {
                this.botAliasArn = botAliasArn;
                return this;
            }

            /**
             * Sets the value of {@link LexFlowNodeConfigurationProperty#getLocaleId}
             * @param localeId The Region to invoke the Amazon Lex bot in. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeId(java.lang.String localeId) {
                this.localeId = localeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LexFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LexFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LexFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LexFlowNodeConfigurationProperty {
            private final java.lang.String botAliasArn;
            private final java.lang.String localeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.botAliasArn = software.amazon.jsii.Kernel.get(this, "botAliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localeId = software.amazon.jsii.Kernel.get(this, "localeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.botAliasArn = java.util.Objects.requireNonNull(builder.botAliasArn, "botAliasArn is required");
                this.localeId = java.util.Objects.requireNonNull(builder.localeId, "localeId is required");
            }

            @Override
            public final java.lang.String getBotAliasArn() {
                return this.botAliasArn;
            }

            @Override
            public final java.lang.String getLocaleId() {
                return this.localeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("botAliasArn", om.valueToTree(this.getBotAliasArn()));
                data.set("localeId", om.valueToTree(this.getLocaleId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.LexFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LexFlowNodeConfigurationProperty.Jsii$Proxy that = (LexFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!botAliasArn.equals(that.botAliasArn)) return false;
                return this.localeId.equals(that.localeId);
            }

            @Override
            public final int hashCode() {
                int result = this.botAliasArn.hashCode();
                result = 31 * result + (this.localeId.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations for the controller node of a DoWhile loop in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * LoopControllerFlowNodeConfigurationProperty loopControllerFlowNodeConfigurationProperty = LoopControllerFlowNodeConfigurationProperty.builder()
     *         .continueCondition(FlowConditionProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .expression("expression")
     *                 .build())
     *         // the properties below are optional
     *         .maxIterations(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopcontrollerflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopcontrollerflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.LoopControllerFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoopControllerFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoopControllerFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the condition that determines when the flow exits the DoWhile loop.
         * <p>
         * The loop executes until this condition evaluates to true.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopcontrollerflownodeconfiguration.html#cfn-bedrock-flowversion-loopcontrollerflownodeconfiguration-continuecondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopcontrollerflownodeconfiguration.html#cfn-bedrock-flowversion-loopcontrollerflownodeconfiguration-continuecondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContinueCondition();

        /**
         * Specifies the maximum number of times the DoWhile loop can iterate before the flow exits the loop.
         * <p>
         * Default: - 10
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopcontrollerflownodeconfiguration.html#cfn-bedrock-flowversion-loopcontrollerflownodeconfiguration-maxiterations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopcontrollerflownodeconfiguration.html#cfn-bedrock-flowversion-loopcontrollerflownodeconfiguration-maxiterations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxIterations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoopControllerFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoopControllerFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoopControllerFlowNodeConfigurationProperty> {
            java.lang.Object continueCondition;
            java.lang.Number maxIterations;

            /**
             * Sets the value of {@link LoopControllerFlowNodeConfigurationProperty#getContinueCondition}
             * @param continueCondition Specifies the condition that determines when the flow exits the DoWhile loop. This parameter is required.
             *                          The loop executes until this condition evaluates to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continueCondition(software.amazon.awscdk.IResolvable continueCondition) {
                this.continueCondition = continueCondition;
                return this;
            }

            /**
             * Sets the value of {@link LoopControllerFlowNodeConfigurationProperty#getContinueCondition}
             * @param continueCondition Specifies the condition that determines when the flow exits the DoWhile loop. This parameter is required.
             *                          The loop executes until this condition evaluates to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continueCondition(software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowConditionProperty continueCondition) {
                this.continueCondition = continueCondition;
                return this;
            }

            /**
             * Sets the value of {@link LoopControllerFlowNodeConfigurationProperty#getMaxIterations}
             * @param maxIterations Specifies the maximum number of times the DoWhile loop can iterate before the flow exits the loop.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxIterations(java.lang.Number maxIterations) {
                this.maxIterations = maxIterations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoopControllerFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoopControllerFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoopControllerFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoopControllerFlowNodeConfigurationProperty {
            private final java.lang.Object continueCondition;
            private final java.lang.Number maxIterations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.continueCondition = software.amazon.jsii.Kernel.get(this, "continueCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxIterations = software.amazon.jsii.Kernel.get(this, "maxIterations", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.continueCondition = java.util.Objects.requireNonNull(builder.continueCondition, "continueCondition is required");
                this.maxIterations = builder.maxIterations;
            }

            @Override
            public final java.lang.Object getContinueCondition() {
                return this.continueCondition;
            }

            @Override
            public final java.lang.Number getMaxIterations() {
                return this.maxIterations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("continueCondition", om.valueToTree(this.getContinueCondition()));
                if (this.getMaxIterations() != null) {
                    data.set("maxIterations", om.valueToTree(this.getMaxIterations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.LoopControllerFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoopControllerFlowNodeConfigurationProperty.Jsii$Proxy that = (LoopControllerFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!continueCondition.equals(that.continueCondition)) return false;
                return this.maxIterations != null ? this.maxIterations.equals(that.maxIterations) : that.maxIterations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.continueCondition.hashCode();
                result = 31 * result + (this.maxIterations != null ? this.maxIterations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for the nodes of a DoWhile loop in your flow.
     * <p>
     * A DoWhile loop is made up of the following nodes:
     * <p>
     * <ul>
     * <li><code>Loop</code> - The container node that holds the loop's flow definition. This node encompasses the entire loop structure.</li>
     * <li><code>LoopInput</code> - The entry point node for the loop. This node receives inputs from nodes outside the loop and from previous loop iterations.</li>
     * <li>Body nodes - The processing nodes that execute within each loop iteration. These can be nodes for handling data in your flow, such as a prompt or Lambda function nodes. Some node types aren't supported inside a DoWhile loop body. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_LoopIncompatibleNodeTypeFlowValidationDetails.html">LoopIncompatibleNodeTypeFlowValidationDetails</a> .</li>
     * <li><code>LoopController</code> - The node that evaluates whether the loop should continue or exit based on a condition.</li>
     * </ul>
     * <p>
     * These nodes work together to create a loop that runs at least once and continues until a specified condition is met or a maximum number of iterations is reached.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * Object collector;
     * Object input;
     * Object iterator;
     * LoopFlowNodeConfigurationProperty loopFlowNodeConfigurationProperty_;
     * Object loopInput;
     * Object output;
     * LoopFlowNodeConfigurationProperty loopFlowNodeConfigurationProperty = LoopFlowNodeConfigurationProperty.builder()
     *         .definition(FlowDefinitionProperty.builder()
     *                 .connections(List.of(FlowConnectionProperty.builder()
     *                         .name("name")
     *                         .source("source")
     *                         .target("target")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .configuration(FlowConnectionConfigurationProperty.builder()
     *                                 .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                                         .condition("condition")
     *                                         .build())
     *                                 .data(FlowDataConnectionConfigurationProperty.builder()
     *                                         .sourceOutput("sourceOutput")
     *                                         .targetInput("targetInput")
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *                 .nodes(List.of(FlowNodeProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .configuration(FlowNodeConfigurationProperty.builder()
     *                                 .agent(AgentFlowNodeConfigurationProperty.builder()
     *                                         .agentAliasArn("agentAliasArn")
     *                                         .build())
     *                                 .collector(collector)
     *                                 .condition(ConditionFlowNodeConfigurationProperty.builder()
     *                                         .conditions(List.of(FlowConditionProperty.builder()
     *                                                 .name("name")
     *                                                 // the properties below are optional
     *                                                 .expression("expression")
     *                                                 .build()))
     *                                         .build())
     *                                 .inlineCode(InlineCodeFlowNodeConfigurationProperty.builder()
     *                                         .code("code")
     *                                         .language("language")
     *                                         .build())
     *                                 .input(input)
     *                                 .iterator(iterator)
     *                                 .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *                                         .knowledgeBaseId("knowledgeBaseId")
     *                                         // the properties below are optional
     *                                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                                 .guardrailIdentifier("guardrailIdentifier")
     *                                                 .guardrailVersion("guardrailVersion")
     *                                                 .build())
     *                                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                         .maxTokens(123)
     *                                                         .stopSequences(List.of("stopSequences"))
     *                                                         .temperature(123)
     *                                                         .topP(123)
     *                                                         .build())
     *                                                 .build())
     *                                         .modelId("modelId")
     *                                         .numberOfResults(123)
     *                                         .orchestrationConfiguration(KnowledgeBaseOrchestrationConfigurationProperty.builder()
     *                                                 .additionalModelRequestFields(additionalModelRequestFields)
     *                                                 .inferenceConfig(PromptInferenceConfigurationProperty.builder()
     *                                                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                                 .maxTokens(123)
     *                                                                 .stopSequences(List.of("stopSequences"))
     *                                                                 .temperature(123)
     *                                                                 .topP(123)
     *                                                                 .build())
     *                                                         .build())
     *                                                 .performanceConfig(PerformanceConfigurationProperty.builder()
     *                                                         .latency("latency")
     *                                                         .build())
     *                                                 .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                                                         .textPromptTemplate("textPromptTemplate")
     *                                                         .build())
     *                                                 .build())
     *                                         .promptTemplate(KnowledgeBasePromptTemplateProperty.builder()
     *                                                 .textPromptTemplate("textPromptTemplate")
     *                                                 .build())
     *                                         .rerankingConfiguration(VectorSearchRerankingConfigurationProperty.builder()
     *                                                 .type("type")
     *                                                 // the properties below are optional
     *                                                 .bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfigurationProperty.builder()
     *                                                         .modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *                                                                 .modelArn("modelArn")
     *                                                                 // the properties below are optional
     *                                                                 .additionalModelRequestFields(additionalModelRequestFields)
     *                                                                 .build())
     *                                                         // the properties below are optional
     *                                                         .metadataConfiguration(MetadataConfigurationForRerankingProperty.builder()
     *                                                                 .selectionMode("selectionMode")
     *                                                                 // the properties below are optional
     *                                                                 .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                                                                         .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                                                                                 .fieldName("fieldName")
     *                                                                                 .build()))
     *                                                                         .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                                                                                 .fieldName("fieldName")
     *                                                                                 .build()))
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .numberOfRerankedResults(123)
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
     *                                         .lambdaArn("lambdaArn")
     *                                         .build())
     *                                 .lex(LexFlowNodeConfigurationProperty.builder()
     *                                         .botAliasArn("botAliasArn")
     *                                         .localeId("localeId")
     *                                         .build())
     *                                 .loop(loopFlowNodeConfigurationProperty_)
     *                                 .loopController(LoopControllerFlowNodeConfigurationProperty.builder()
     *                                         .continueCondition(FlowConditionProperty.builder()
     *                                                 .name("name")
     *                                                 // the properties below are optional
     *                                                 .expression("expression")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .maxIterations(123)
     *                                         .build())
     *                                 .loopInput(loopInput)
     *                                 .output(output)
     *                                 .prompt(PromptFlowNodeConfigurationProperty.builder()
     *                                         .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                                                 .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                                                         .modelId("modelId")
     *                                                         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                                                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                                                                         .text("text")
     *                                                                         // the properties below are optional
     *                                                                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                                                 .name("name")
     *                                                                                 .build()))
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .templateType("templateType")
     *                                                         // the properties below are optional
     *                                                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                                         .maxTokens(123)
     *                                                                         .stopSequences(List.of("stopSequences"))
     *                                                                         .temperature(123)
     *                                                                         .topP(123)
     *                                                                         .build())
     *                                                                 .build())
     *                                                         .build())
     *                                                 .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                                                         .promptArn("promptArn")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                                 .guardrailIdentifier("guardrailIdentifier")
     *                                                 .guardrailVersion("guardrailVersion")
     *                                                 .build())
     *                                         .build())
     *                                 .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
     *                                         .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                                                 .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                                                         .bucketName("bucketName")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .storage(StorageFlowNodeConfigurationProperty.builder()
     *                                         .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                                                 .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                                                         .bucketName("bucketName")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .inputs(List.of(FlowNodeInputProperty.builder()
     *                                 .expression("expression")
     *                                 .name("name")
     *                                 .type("type")
     *                                 .build()))
     *                         .outputs(List.of(FlowNodeOutputProperty.builder()
     *                                 .name("name")
     *                                 .type("type")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.LoopFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoopFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoopFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The definition of the DoWhile loop nodes and connections between nodes in the flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopflownodeconfiguration.html#cfn-bedrock-flowversion-loopflownodeconfiguration-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-loopflownodeconfiguration.html#cfn-bedrock-flowversion-loopflownodeconfiguration-definition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefinition();

        /**
         * @return a {@link Builder} of {@link LoopFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoopFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoopFlowNodeConfigurationProperty> {
            java.lang.Object definition;

            /**
             * Sets the value of {@link LoopFlowNodeConfigurationProperty#getDefinition}
             * @param definition The definition of the DoWhile loop nodes and connections between nodes in the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(software.amazon.awscdk.IResolvable definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Sets the value of {@link LoopFlowNodeConfigurationProperty#getDefinition}
             * @param definition The definition of the DoWhile loop nodes and connections between nodes in the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(software.amazon.awscdk.services.bedrock.CfnFlowVersion.FlowDefinitionProperty definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoopFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoopFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoopFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoopFlowNodeConfigurationProperty {
            private final java.lang.Object definition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.definition = java.util.Objects.requireNonNull(builder.definition, "definition is required");
            }

            @Override
            public final java.lang.Object getDefinition() {
                return this.definition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("definition", om.valueToTree(this.getDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.LoopFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoopFlowNodeConfigurationProperty.Jsii$Proxy that = (LoopFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.definition.equals(that.definition);
            }

            @Override
            public final int hashCode() {
                int result = this.definition.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration for how metadata should be used during the reranking process in Knowledge Base vector searches.
     * <p>
     * This determines which metadata fields are included or excluded when reordering search results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * MetadataConfigurationForRerankingProperty metadataConfigurationForRerankingProperty = MetadataConfigurationForRerankingProperty.builder()
     *         .selectionMode("selectionMode")
     *         // the properties below are optional
     *         .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                 .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                         .fieldName("fieldName")
     *                         .build()))
     *                 .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                         .fieldName("fieldName")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-metadataconfigurationforreranking.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-metadataconfigurationforreranking.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.MetadataConfigurationForRerankingProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataConfigurationForRerankingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataConfigurationForRerankingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The mode for selecting which metadata fields to include in the reranking process.
         * <p>
         * Valid values are ALL (use all available metadata fields) or SELECTIVE (use only specified fields).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-metadataconfigurationforreranking.html#cfn-bedrock-flowversion-metadataconfigurationforreranking-selectionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-metadataconfigurationforreranking.html#cfn-bedrock-flowversion-metadataconfigurationforreranking-selectionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSelectionMode();

        /**
         * Configuration for selective mode, which allows you to explicitly include or exclude specific metadata fields during reranking.
         * <p>
         * This is only used when selectionMode is set to SELECTIVE.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.RerankingMetadataSelectiveModeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-metadataconfigurationforreranking.html#cfn-bedrock-flowversion-metadataconfigurationforreranking-selectivemodeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-metadataconfigurationforreranking.html#cfn-bedrock-flowversion-metadataconfigurationforreranking-selectivemodeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectiveModeConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataConfigurationForRerankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataConfigurationForRerankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataConfigurationForRerankingProperty> {
            java.lang.String selectionMode;
            java.lang.Object selectiveModeConfiguration;

            /**
             * Sets the value of {@link MetadataConfigurationForRerankingProperty#getSelectionMode}
             * @param selectionMode The mode for selecting which metadata fields to include in the reranking process. This parameter is required.
             *                      Valid values are ALL (use all available metadata fields) or SELECTIVE (use only specified fields).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionMode(java.lang.String selectionMode) {
                this.selectionMode = selectionMode;
                return this;
            }

            /**
             * Sets the value of {@link MetadataConfigurationForRerankingProperty#getSelectiveModeConfiguration}
             * @param selectiveModeConfiguration Configuration for selective mode, which allows you to explicitly include or exclude specific metadata fields during reranking.
             *                                   This is only used when selectionMode is set to SELECTIVE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectiveModeConfiguration(software.amazon.awscdk.IResolvable selectiveModeConfiguration) {
                this.selectiveModeConfiguration = selectiveModeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MetadataConfigurationForRerankingProperty#getSelectiveModeConfiguration}
             * @param selectiveModeConfiguration Configuration for selective mode, which allows you to explicitly include or exclude specific metadata fields during reranking.
             *                                   This is only used when selectionMode is set to SELECTIVE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectiveModeConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.RerankingMetadataSelectiveModeConfigurationProperty selectiveModeConfiguration) {
                this.selectiveModeConfiguration = selectiveModeConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataConfigurationForRerankingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataConfigurationForRerankingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataConfigurationForRerankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataConfigurationForRerankingProperty {
            private final java.lang.String selectionMode;
            private final java.lang.Object selectiveModeConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.selectionMode = software.amazon.jsii.Kernel.get(this, "selectionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectiveModeConfiguration = software.amazon.jsii.Kernel.get(this, "selectiveModeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.selectionMode = java.util.Objects.requireNonNull(builder.selectionMode, "selectionMode is required");
                this.selectiveModeConfiguration = builder.selectiveModeConfiguration;
            }

            @Override
            public final java.lang.String getSelectionMode() {
                return this.selectionMode;
            }

            @Override
            public final java.lang.Object getSelectiveModeConfiguration() {
                return this.selectiveModeConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("selectionMode", om.valueToTree(this.getSelectionMode()));
                if (this.getSelectiveModeConfiguration() != null) {
                    data.set("selectiveModeConfiguration", om.valueToTree(this.getSelectiveModeConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.MetadataConfigurationForRerankingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataConfigurationForRerankingProperty.Jsii$Proxy that = (MetadataConfigurationForRerankingProperty.Jsii$Proxy) o;

                if (!selectionMode.equals(that.selectionMode)) return false;
                return this.selectiveModeConfiguration != null ? this.selectiveModeConfiguration.equals(that.selectiveModeConfiguration) : that.selectiveModeConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.selectionMode.hashCode();
                result = 31 * result + (this.selectiveModeConfiguration != null ? this.selectiveModeConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Performance settings for a model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PerformanceConfigurationProperty performanceConfigurationProperty = PerformanceConfigurationProperty.builder()
     *         .latency("latency")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-performanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-performanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PerformanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PerformanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PerformanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To use a latency-optimized version of the model, set to <code>optimized</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-performanceconfiguration.html#cfn-bedrock-flowversion-performanceconfiguration-latency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-performanceconfiguration.html#cfn-bedrock-flowversion-performanceconfiguration-latency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLatency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PerformanceConfigurationProperty> {
            java.lang.String latency;

            /**
             * Sets the value of {@link PerformanceConfigurationProperty#getLatency}
             * @param latency To use a latency-optimized version of the model, set to <code>optimized</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder latency(java.lang.String latency) {
                this.latency = latency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PerformanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PerformanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PerformanceConfigurationProperty {
            private final java.lang.String latency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.latency = software.amazon.jsii.Kernel.get(this, "latency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.latency = builder.latency;
            }

            @Override
            public final java.lang.String getLatency() {
                return this.latency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLatency() != null) {
                    data.set("latency", om.valueToTree(this.getLatency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PerformanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PerformanceConfigurationProperty.Jsii$Proxy that = (PerformanceConfigurationProperty.Jsii$Proxy) o;

                return this.latency != null ? this.latency.equals(that.latency) : that.latency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.latency != null ? this.latency.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt node in the flow.
     * <p>
     * You can use a prompt from Prompt management or you can define one in this node. If the prompt contains variables, the inputs into this node will fill in the variables. The output from this node is the response generated by the model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeConfigurationProperty promptFlowNodeConfigurationProperty = PromptFlowNodeConfigurationProperty.builder()
     *         .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                 .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                         .modelId("modelId")
     *                         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                                         .text("text")
     *                                         // the properties below are optional
     *                                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                 .name("name")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .templateType("templateType")
     *                         // the properties below are optional
     *                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                         .maxTokens(123)
     *                                         .stopSequences(List.of("stopSequences"))
     *                                         .temperature(123)
     *                                         .topP(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                         .promptArn("promptArn")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                 .guardrailIdentifier("guardrailIdentifier")
     *                 .guardrailVersion("guardrailVersion")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the prompt is from Prompt management or defined inline.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeSourceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeconfiguration.html#cfn-bedrock-flowversion-promptflownodeconfiguration-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeconfiguration.html#cfn-bedrock-flowversion-promptflownodeconfiguration-sourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration();

        /**
         * Contains configurations for a guardrail to apply to the prompt in this node and the response generated from it.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.GuardrailConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeconfiguration.html#cfn-bedrock-flowversion-promptflownodeconfiguration-guardrailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeconfiguration.html#cfn-bedrock-flowversion-promptflownodeconfiguration-guardrailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGuardrailConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeConfigurationProperty> {
            java.lang.Object sourceConfiguration;
            java.lang.Object guardrailConfiguration;

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration Specifies whether the prompt is from Prompt management or defined inline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration Specifies whether the prompt is from Prompt management or defined inline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply to the prompt in this node and the response generated from it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply to the prompt in this node and the response generated from it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeConfigurationProperty {
            private final java.lang.Object sourceConfiguration;
            private final java.lang.Object guardrailConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.guardrailConfiguration = software.amazon.jsii.Kernel.get(this, "guardrailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceConfiguration = java.util.Objects.requireNonNull(builder.sourceConfiguration, "sourceConfiguration is required");
                this.guardrailConfiguration = builder.guardrailConfiguration;
            }

            @Override
            public final java.lang.Object getSourceConfiguration() {
                return this.sourceConfiguration;
            }

            @Override
            public final java.lang.Object getGuardrailConfiguration() {
                return this.guardrailConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
                if (this.getGuardrailConfiguration() != null) {
                    data.set("guardrailConfiguration", om.valueToTree(this.getGuardrailConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!sourceConfiguration.equals(that.sourceConfiguration)) return false;
                return this.guardrailConfiguration != null ? this.guardrailConfiguration.equals(that.guardrailConfiguration) : that.guardrailConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceConfiguration.hashCode();
                result = 31 * result + (this.guardrailConfiguration != null ? this.guardrailConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt defined inline in the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeInlineConfigurationProperty promptFlowNodeInlineConfigurationProperty = PromptFlowNodeInlineConfigurationProperty.builder()
     *         .modelId("modelId")
     *         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                         .text("text")
     *                         // the properties below are optional
     *                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .templateType("templateType")
     *         // the properties below are optional
     *         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .stopSequences(List.of("stopSequences"))
     *                         .temperature(123)
     *                         .topP(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeInlineConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeInlineConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeInlineConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to run inference with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelId();

        /**
         * Contains a prompt and variables in the prompt that can be replaced with values at runtime.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptTemplateConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-templateconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-templateconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTemplateConfiguration();

        /**
         * The type of prompt template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-templatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-templatetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTemplateType();

        /**
         * Contains inference configurations for the prompt.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-inferenceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodeinlineconfiguration.html#cfn-bedrock-flowversion-promptflownodeinlineconfiguration-inferenceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeInlineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeInlineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeInlineConfigurationProperty> {
            java.lang.String modelId;
            java.lang.Object templateConfiguration;
            java.lang.String templateType;
            java.lang.Object inferenceConfiguration;

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getModelId}
             * @param modelId The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to run inference with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getTemplateConfiguration}
             * @param templateConfiguration Contains a prompt and variables in the prompt that can be replaced with values at runtime. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.IResolvable templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getTemplateConfiguration}
             * @param templateConfiguration Contains a prompt and variables in the prompt that can be replaced with values at runtime. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptTemplateConfigurationProperty templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getTemplateType}
             * @param templateType The type of prompt template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateType(java.lang.String templateType) {
                this.templateType = templateType;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeInlineConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeInlineConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeInlineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeInlineConfigurationProperty {
            private final java.lang.String modelId;
            private final java.lang.Object templateConfiguration;
            private final java.lang.String templateType;
            private final java.lang.Object inferenceConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateConfiguration = software.amazon.jsii.Kernel.get(this, "templateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.templateType = software.amazon.jsii.Kernel.get(this, "templateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceConfiguration = software.amazon.jsii.Kernel.get(this, "inferenceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
                this.templateConfiguration = java.util.Objects.requireNonNull(builder.templateConfiguration, "templateConfiguration is required");
                this.templateType = java.util.Objects.requireNonNull(builder.templateType, "templateType is required");
                this.inferenceConfiguration = builder.inferenceConfiguration;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            public final java.lang.Object getTemplateConfiguration() {
                return this.templateConfiguration;
            }

            @Override
            public final java.lang.String getTemplateType() {
                return this.templateType;
            }

            @Override
            public final java.lang.Object getInferenceConfiguration() {
                return this.inferenceConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("modelId", om.valueToTree(this.getModelId()));
                data.set("templateConfiguration", om.valueToTree(this.getTemplateConfiguration()));
                data.set("templateType", om.valueToTree(this.getTemplateType()));
                if (this.getInferenceConfiguration() != null) {
                    data.set("inferenceConfiguration", om.valueToTree(this.getInferenceConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeInlineConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeInlineConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeInlineConfigurationProperty.Jsii$Proxy) o;

                if (!modelId.equals(that.modelId)) return false;
                if (!templateConfiguration.equals(that.templateConfiguration)) return false;
                if (!templateType.equals(that.templateType)) return false;
                return this.inferenceConfiguration != null ? this.inferenceConfiguration.equals(that.inferenceConfiguration) : that.inferenceConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelId.hashCode();
                result = 31 * result + (this.templateConfiguration.hashCode());
                result = 31 * result + (this.templateType.hashCode());
                result = 31 * result + (this.inferenceConfiguration != null ? this.inferenceConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt from Prompt management to use in a node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeResourceConfigurationProperty promptFlowNodeResourceConfigurationProperty = PromptFlowNodeResourceConfigurationProperty.builder()
     *         .promptArn("promptArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownoderesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownoderesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeResourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeResourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeResourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the prompt from Prompt management.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownoderesourceconfiguration.html#cfn-bedrock-flowversion-promptflownoderesourceconfiguration-promptarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownoderesourceconfiguration.html#cfn-bedrock-flowversion-promptflownoderesourceconfiguration-promptarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPromptArn();

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeResourceConfigurationProperty> {
            java.lang.String promptArn;

            /**
             * Sets the value of {@link PromptFlowNodeResourceConfigurationProperty#getPromptArn}
             * @param promptArn The Amazon Resource Name (ARN) of the prompt from Prompt management. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptArn(java.lang.String promptArn) {
                this.promptArn = promptArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeResourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeResourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeResourceConfigurationProperty {
            private final java.lang.String promptArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.promptArn = software.amazon.jsii.Kernel.get(this, "promptArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.promptArn = java.util.Objects.requireNonNull(builder.promptArn, "promptArn is required");
            }

            @Override
            public final java.lang.String getPromptArn() {
                return this.promptArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("promptArn", om.valueToTree(this.getPromptArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeResourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeResourceConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeResourceConfigurationProperty.Jsii$Proxy) o;

                return this.promptArn.equals(that.promptArn);
            }

            @Override
            public final int hashCode() {
                int result = this.promptArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt and whether it is from Prompt management or defined inline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeSourceConfigurationProperty promptFlowNodeSourceConfigurationProperty = PromptFlowNodeSourceConfigurationProperty.builder()
     *         .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                 .modelId("modelId")
     *                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                         .text(TextPromptTemplateConfigurationProperty.builder()
     *                                 .text("text")
     *                                 // the properties below are optional
     *                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .templateType("templateType")
     *                 // the properties below are optional
     *                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                 .maxTokens(123)
     *                                 .stopSequences(List.of("stopSequences"))
     *                                 .temperature(123)
     *                                 .topP(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                 .promptArn("promptArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for a prompt that is defined inline.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeInlineConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodesourceconfiguration.html#cfn-bedrock-flowversion-promptflownodesourceconfiguration-inline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodesourceconfiguration.html#cfn-bedrock-flowversion-promptflownodesourceconfiguration-inline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInline() {
            return null;
        }

        /**
         * Contains configurations for a prompt from Prompt management.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeResourceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodesourceconfiguration.html#cfn-bedrock-flowversion-promptflownodesourceconfiguration-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptflownodesourceconfiguration.html#cfn-bedrock-flowversion-promptflownodesourceconfiguration-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeSourceConfigurationProperty> {
            java.lang.Object inline;
            java.lang.Object resource;

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getInline}
             * @param inline Contains configurations for a prompt that is defined inline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(software.amazon.awscdk.IResolvable inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getInline}
             * @param inline Contains configurations for a prompt that is defined inline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeInlineConfigurationProperty inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getResource}
             * @param resource Contains configurations for a prompt from Prompt management.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(software.amazon.awscdk.IResolvable resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getResource}
             * @param resource Contains configurations for a prompt from Prompt management.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptFlowNodeResourceConfigurationProperty resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeSourceConfigurationProperty {
            private final java.lang.Object inline;
            private final java.lang.Object resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inline = software.amazon.jsii.Kernel.get(this, "inline", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inline = builder.inline;
                this.resource = builder.resource;
            }

            @Override
            public final java.lang.Object getInline() {
                return this.inline;
            }

            @Override
            public final java.lang.Object getResource() {
                return this.resource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInline() != null) {
                    data.set("inline", om.valueToTree(this.getInline()));
                }
                if (this.getResource() != null) {
                    data.set("resource", om.valueToTree(this.getResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeSourceConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeSourceConfigurationProperty.Jsii$Proxy) o;

                if (this.inline != null ? !this.inline.equals(that.inline) : that.inline != null) return false;
                return this.resource != null ? this.resource.equals(that.resource) : that.resource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inline != null ? this.inline.hashCode() : 0;
                result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains inference configurations for the prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptInferenceConfigurationProperty promptInferenceConfigurationProperty = PromptInferenceConfigurationProperty.builder()
     *         .text(PromptModelInferenceConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .stopSequences(List.of("stopSequences"))
     *                 .temperature(123)
     *                 .topP(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinferenceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinferenceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptInferenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptInferenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains inference configurations for a text prompt.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptModelInferenceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinferenceconfiguration.html#cfn-bedrock-flowversion-promptinferenceconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinferenceconfiguration.html#cfn-bedrock-flowversion-promptinferenceconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getText();

        /**
         * @return a {@link Builder} of {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptInferenceConfigurationProperty> {
            java.lang.Object text;

            /**
             * Sets the value of {@link PromptInferenceConfigurationProperty#getText}
             * @param text Contains inference configurations for a text prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.IResolvable text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link PromptInferenceConfigurationProperty#getText}
             * @param text Contains inference configurations for a text prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptModelInferenceConfigurationProperty text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptInferenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptInferenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptInferenceConfigurationProperty {
            private final java.lang.Object text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.Object getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptInferenceConfigurationProperty.Jsii$Proxy that = (PromptInferenceConfigurationProperty.Jsii$Proxy) o;

                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about a variable in the prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptInputVariableProperty promptInputVariableProperty = PromptInputVariableProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinputvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinputvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptInputVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptInputVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptInputVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinputvariable.html#cfn-bedrock-flowversion-promptinputvariable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptinputvariable.html#cfn-bedrock-flowversion-promptinputvariable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptInputVariableProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link PromptInputVariableProperty#getName}
             * @param name The name of the variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptInputVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptInputVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptInputVariableProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptInputVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptInputVariableProperty.Jsii$Proxy that = (PromptInputVariableProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains inference configurations related to model inference for a prompt.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/inference-parameters.html">Inference parameters</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptModelInferenceConfigurationProperty promptModelInferenceConfigurationProperty = PromptModelInferenceConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .stopSequences(List.of("stopSequences"))
     *         .temperature(123)
     *         .topP(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptModelInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptModelInferenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptModelInferenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens to return in the response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTokens() {
            return null;
        }

        /**
         * A list of strings that define sequences after which the model will stop generating.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-stopsequences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-stopsequences</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStopSequences() {
            return null;
        }

        /**
         * Controls the randomness of the response.
         * <p>
         * Choose a lower value for more predictable outputs and a higher value for more surprising outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-temperature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-temperature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTemperature() {
            return null;
        }

        /**
         * The percentage of most-likely candidates that the model considers for the next token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-topp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-promptmodelinferenceconfiguration.html#cfn-bedrock-flowversion-promptmodelinferenceconfiguration-topp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTopP() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptModelInferenceConfigurationProperty> {
            java.lang.Number maxTokens;
            java.util.List<java.lang.String> stopSequences;
            java.lang.Number temperature;
            java.lang.Number topP;

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens to return in the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getStopSequences}
             * @param stopSequences A list of strings that define sequences after which the model will stop generating.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopSequences(java.util.List<java.lang.String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getTemperature}
             * @param temperature Controls the randomness of the response.
             *                    Choose a lower value for more predictable outputs and a higher value for more surprising outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temperature(java.lang.Number temperature) {
                this.temperature = temperature;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getTopP}
             * @param topP The percentage of most-likely candidates that the model considers for the next token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topP(java.lang.Number topP) {
                this.topP = topP;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptModelInferenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptModelInferenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptModelInferenceConfigurationProperty {
            private final java.lang.Number maxTokens;
            private final java.util.List<java.lang.String> stopSequences;
            private final java.lang.Number temperature;
            private final java.lang.Number topP;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stopSequences = software.amazon.jsii.Kernel.get(this, "stopSequences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.temperature = software.amazon.jsii.Kernel.get(this, "temperature", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.topP = software.amazon.jsii.Kernel.get(this, "topP", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = builder.maxTokens;
                this.stopSequences = builder.stopSequences;
                this.temperature = builder.temperature;
                this.topP = builder.topP;
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            public final java.util.List<java.lang.String> getStopSequences() {
                return this.stopSequences;
            }

            @Override
            public final java.lang.Number getTemperature() {
                return this.temperature;
            }

            @Override
            public final java.lang.Number getTopP() {
                return this.topP;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxTokens() != null) {
                    data.set("maxTokens", om.valueToTree(this.getMaxTokens()));
                }
                if (this.getStopSequences() != null) {
                    data.set("stopSequences", om.valueToTree(this.getStopSequences()));
                }
                if (this.getTemperature() != null) {
                    data.set("temperature", om.valueToTree(this.getTemperature()));
                }
                if (this.getTopP() != null) {
                    data.set("topP", om.valueToTree(this.getTopP()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptModelInferenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptModelInferenceConfigurationProperty.Jsii$Proxy that = (PromptModelInferenceConfigurationProperty.Jsii$Proxy) o;

                if (this.maxTokens != null ? !this.maxTokens.equals(that.maxTokens) : that.maxTokens != null) return false;
                if (this.stopSequences != null ? !this.stopSequences.equals(that.stopSequences) : that.stopSequences != null) return false;
                if (this.temperature != null ? !this.temperature.equals(that.temperature) : that.temperature != null) return false;
                return this.topP != null ? this.topP.equals(that.topP) : that.topP == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens != null ? this.maxTokens.hashCode() : 0;
                result = 31 * result + (this.stopSequences != null ? this.stopSequences.hashCode() : 0);
                result = 31 * result + (this.temperature != null ? this.temperature.hashCode() : 0);
                result = 31 * result + (this.topP != null ? this.topP.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the message for a prompt.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Construct and store reusable prompts with Prompt management in Amazon Bedrock</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptTemplateConfigurationProperty promptTemplateConfigurationProperty = PromptTemplateConfigurationProperty.builder()
     *         .text(TextPromptTemplateConfigurationProperty.builder()
     *                 .text("text")
     *                 // the properties below are optional
     *                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-prompttemplateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-prompttemplateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptTemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptTemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the text in a message for a prompt.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.TextPromptTemplateConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-prompttemplateconfiguration.html#cfn-bedrock-flowversion-prompttemplateconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-prompttemplateconfiguration.html#cfn-bedrock-flowversion-prompttemplateconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getText();

        /**
         * @return a {@link Builder} of {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptTemplateConfigurationProperty> {
            java.lang.Object text;

            /**
             * Sets the value of {@link PromptTemplateConfigurationProperty#getText}
             * @param text Contains configurations for the text in a message for a prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.IResolvable text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link PromptTemplateConfigurationProperty#getText}
             * @param text Contains configurations for the text in a message for a prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.services.bedrock.CfnFlowVersion.TextPromptTemplateConfigurationProperty text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptTemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptTemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptTemplateConfigurationProperty {
            private final java.lang.Object text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.Object getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptTemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptTemplateConfigurationProperty.Jsii$Proxy that = (PromptTemplateConfigurationProperty.Jsii$Proxy) o;

                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration for selectively including or excluding metadata fields during the reranking process.
     * <p>
     * This allows you to control which metadata attributes are considered when reordering search results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RerankingMetadataSelectiveModeConfigurationProperty rerankingMetadataSelectiveModeConfigurationProperty = RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *         .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                 .fieldName("fieldName")
     *                 .build()))
     *         .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                 .fieldName("fieldName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.RerankingMetadataSelectiveModeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RerankingMetadataSelectiveModeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RerankingMetadataSelectiveModeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of metadata field names to explicitly exclude from the reranking process.
         * <p>
         * All metadata fields except these will be considered when reordering search results. This parameter cannot be used together with fieldsToInclude.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FieldForRerankingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration.html#cfn-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration-fieldstoexclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration.html#cfn-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration-fieldstoexclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldsToExclude() {
            return null;
        }

        /**
         * A list of metadata field names to explicitly include in the reranking process.
         * <p>
         * Only these fields will be considered when reordering search results. This parameter cannot be used together with fieldsToExclude.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.FieldForRerankingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration.html#cfn-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration-fieldstoinclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration.html#cfn-bedrock-flowversion-rerankingmetadataselectivemodeconfiguration-fieldstoinclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldsToInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RerankingMetadataSelectiveModeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RerankingMetadataSelectiveModeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RerankingMetadataSelectiveModeConfigurationProperty> {
            java.lang.Object fieldsToExclude;
            java.lang.Object fieldsToInclude;

            /**
             * Sets the value of {@link RerankingMetadataSelectiveModeConfigurationProperty#getFieldsToExclude}
             * @param fieldsToExclude A list of metadata field names to explicitly exclude from the reranking process.
             *                        All metadata fields except these will be considered when reordering search results. This parameter cannot be used together with fieldsToInclude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldsToExclude(software.amazon.awscdk.IResolvable fieldsToExclude) {
                this.fieldsToExclude = fieldsToExclude;
                return this;
            }

            /**
             * Sets the value of {@link RerankingMetadataSelectiveModeConfigurationProperty#getFieldsToExclude}
             * @param fieldsToExclude A list of metadata field names to explicitly exclude from the reranking process.
             *                        All metadata fields except these will be considered when reordering search results. This parameter cannot be used together with fieldsToInclude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldsToExclude(java.util.List<? extends java.lang.Object> fieldsToExclude) {
                this.fieldsToExclude = fieldsToExclude;
                return this;
            }

            /**
             * Sets the value of {@link RerankingMetadataSelectiveModeConfigurationProperty#getFieldsToInclude}
             * @param fieldsToInclude A list of metadata field names to explicitly include in the reranking process.
             *                        Only these fields will be considered when reordering search results. This parameter cannot be used together with fieldsToExclude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldsToInclude(software.amazon.awscdk.IResolvable fieldsToInclude) {
                this.fieldsToInclude = fieldsToInclude;
                return this;
            }

            /**
             * Sets the value of {@link RerankingMetadataSelectiveModeConfigurationProperty#getFieldsToInclude}
             * @param fieldsToInclude A list of metadata field names to explicitly include in the reranking process.
             *                        Only these fields will be considered when reordering search results. This parameter cannot be used together with fieldsToExclude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldsToInclude(java.util.List<? extends java.lang.Object> fieldsToInclude) {
                this.fieldsToInclude = fieldsToInclude;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RerankingMetadataSelectiveModeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RerankingMetadataSelectiveModeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RerankingMetadataSelectiveModeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RerankingMetadataSelectiveModeConfigurationProperty {
            private final java.lang.Object fieldsToExclude;
            private final java.lang.Object fieldsToInclude;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldsToExclude = software.amazon.jsii.Kernel.get(this, "fieldsToExclude", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldsToInclude = software.amazon.jsii.Kernel.get(this, "fieldsToInclude", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldsToExclude = builder.fieldsToExclude;
                this.fieldsToInclude = builder.fieldsToInclude;
            }

            @Override
            public final java.lang.Object getFieldsToExclude() {
                return this.fieldsToExclude;
            }

            @Override
            public final java.lang.Object getFieldsToInclude() {
                return this.fieldsToInclude;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFieldsToExclude() != null) {
                    data.set("fieldsToExclude", om.valueToTree(this.getFieldsToExclude()));
                }
                if (this.getFieldsToInclude() != null) {
                    data.set("fieldsToInclude", om.valueToTree(this.getFieldsToInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.RerankingMetadataSelectiveModeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RerankingMetadataSelectiveModeConfigurationProperty.Jsii$Proxy that = (RerankingMetadataSelectiveModeConfigurationProperty.Jsii$Proxy) o;

                if (this.fieldsToExclude != null ? !this.fieldsToExclude.equals(that.fieldsToExclude) : that.fieldsToExclude != null) return false;
                return this.fieldsToInclude != null ? this.fieldsToInclude.equals(that.fieldsToInclude) : that.fieldsToInclude == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldsToExclude != null ? this.fieldsToExclude.hashCode() : 0;
                result = 31 * result + (this.fieldsToInclude != null ? this.fieldsToInclude.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Retrieval node in a flow.
     * <p>
     * This node retrieves data from the Amazon S3 location that you specify and returns it as the output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RetrievalFlowNodeConfigurationProperty retrievalFlowNodeConfigurationProperty = RetrievalFlowNodeConfigurationProperty.builder()
     *         .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                 .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                         .bucketName("bucketName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetrievalFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetrievalFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the service to use for retrieving data to return as the output from the node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.RetrievalFlowNodeServiceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeconfiguration.html#cfn-bedrock-flowversion-retrievalflownodeconfiguration-serviceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeconfiguration.html#cfn-bedrock-flowversion-retrievalflownodeconfiguration-serviceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServiceConfiguration();

        /**
         * @return a {@link Builder} of {@link RetrievalFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetrievalFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetrievalFlowNodeConfigurationProperty> {
            java.lang.Object serviceConfiguration;

            /**
             * Sets the value of {@link RetrievalFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for retrieving data to return as the output from the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RetrievalFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for retrieving data to return as the output from the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.RetrievalFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetrievalFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetrievalFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetrievalFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetrievalFlowNodeConfigurationProperty {
            private final java.lang.Object serviceConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceConfiguration = software.amazon.jsii.Kernel.get(this, "serviceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceConfiguration = java.util.Objects.requireNonNull(builder.serviceConfiguration, "serviceConfiguration is required");
            }

            @Override
            public final java.lang.Object getServiceConfiguration() {
                return this.serviceConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("serviceConfiguration", om.valueToTree(this.getServiceConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetrievalFlowNodeConfigurationProperty.Jsii$Proxy that = (RetrievalFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.serviceConfiguration.equals(that.serviceConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.serviceConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RetrievalFlowNodeS3ConfigurationProperty retrievalFlowNodeS3ConfigurationProperty = RetrievalFlowNodeS3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodes3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodes3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetrievalFlowNodeS3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetrievalFlowNodeS3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket from which to retrieve data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodes3configuration.html#cfn-bedrock-flowversion-retrievalflownodes3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodes3configuration.html#cfn-bedrock-flowversion-retrievalflownodes3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link RetrievalFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetrievalFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetrievalFlowNodeS3ConfigurationProperty> {
            java.lang.String bucketName;

            /**
             * Sets the value of {@link RetrievalFlowNodeS3ConfigurationProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket from which to retrieve data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetrievalFlowNodeS3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetrievalFlowNodeS3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetrievalFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetrievalFlowNodeS3ConfigurationProperty {
            private final java.lang.String bucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeS3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetrievalFlowNodeS3ConfigurationProperty.Jsii$Proxy that = (RetrievalFlowNodeS3ConfigurationProperty.Jsii$Proxy) o;

                return this.bucketName.equals(that.bucketName);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the service to use for retrieving data to return as the output from the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RetrievalFlowNodeServiceConfigurationProperty retrievalFlowNodeServiceConfigurationProperty = RetrievalFlowNodeServiceConfigurationProperty.builder()
     *         .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeserviceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeserviceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetrievalFlowNodeServiceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetrievalFlowNodeServiceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.RetrievalFlowNodeS3ConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeserviceconfiguration.html#cfn-bedrock-flowversion-retrievalflownodeserviceconfiguration-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-retrievalflownodeserviceconfiguration.html#cfn-bedrock-flowversion-retrievalflownodeserviceconfiguration-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetrievalFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetrievalFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetrievalFlowNodeServiceConfigurationProperty> {
            java.lang.Object s3;

            /**
             * Sets the value of {@link RetrievalFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link RetrievalFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.bedrock.CfnFlowVersion.RetrievalFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetrievalFlowNodeServiceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetrievalFlowNodeServiceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetrievalFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetrievalFlowNodeServiceConfigurationProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeServiceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetrievalFlowNodeServiceConfigurationProperty.Jsii$Proxy that = (RetrievalFlowNodeServiceConfigurationProperty.Jsii$Proxy) o;

                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3 != null ? this.s3.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Storage node in a flow.
     * <p>
     * This node stores the input in an Amazon S3 location that you specify.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageFlowNodeConfigurationProperty storageFlowNodeConfigurationProperty = StorageFlowNodeConfigurationProperty.builder()
     *         .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                 .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                         .bucketName("bucketName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the service to use for storing the input into the node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.StorageFlowNodeServiceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeconfiguration.html#cfn-bedrock-flowversion-storageflownodeconfiguration-serviceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeconfiguration.html#cfn-bedrock-flowversion-storageflownodeconfiguration-serviceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServiceConfiguration();

        /**
         * @return a {@link Builder} of {@link StorageFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageFlowNodeConfigurationProperty> {
            java.lang.Object serviceConfiguration;

            /**
             * Sets the value of {@link StorageFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for storing the input into the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for storing the input into the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.StorageFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageFlowNodeConfigurationProperty {
            private final java.lang.Object serviceConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceConfiguration = software.amazon.jsii.Kernel.get(this, "serviceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceConfiguration = java.util.Objects.requireNonNull(builder.serviceConfiguration, "serviceConfiguration is required");
            }

            @Override
            public final java.lang.Object getServiceConfiguration() {
                return this.serviceConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("serviceConfiguration", om.valueToTree(this.getServiceConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageFlowNodeConfigurationProperty.Jsii$Proxy that = (StorageFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.serviceConfiguration.equals(that.serviceConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.serviceConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the Amazon S3 location in which to store the input into the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageFlowNodeS3ConfigurationProperty storageFlowNodeS3ConfigurationProperty = StorageFlowNodeS3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodes3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodes3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageFlowNodeS3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageFlowNodeS3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket in which to store the input into the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodes3configuration.html#cfn-bedrock-flowversion-storageflownodes3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodes3configuration.html#cfn-bedrock-flowversion-storageflownodes3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link StorageFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageFlowNodeS3ConfigurationProperty> {
            java.lang.String bucketName;

            /**
             * Sets the value of {@link StorageFlowNodeS3ConfigurationProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket in which to store the input into the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageFlowNodeS3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageFlowNodeS3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageFlowNodeS3ConfigurationProperty {
            private final java.lang.String bucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeS3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageFlowNodeS3ConfigurationProperty.Jsii$Proxy that = (StorageFlowNodeS3ConfigurationProperty.Jsii$Proxy) o;

                return this.bucketName.equals(that.bucketName);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the service to use for storing the input into the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageFlowNodeServiceConfigurationProperty storageFlowNodeServiceConfigurationProperty = StorageFlowNodeServiceConfigurationProperty.builder()
     *         .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeserviceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeserviceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageFlowNodeServiceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageFlowNodeServiceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the Amazon S3 location in which to store the input into the node.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.StorageFlowNodeS3ConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeserviceconfiguration.html#cfn-bedrock-flowversion-storageflownodeserviceconfiguration-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-storageflownodeserviceconfiguration.html#cfn-bedrock-flowversion-storageflownodeserviceconfiguration-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageFlowNodeServiceConfigurationProperty> {
            java.lang.Object s3;

            /**
             * Sets the value of {@link StorageFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location in which to store the input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link StorageFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location in which to store the input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.bedrock.CfnFlowVersion.StorageFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageFlowNodeServiceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageFlowNodeServiceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageFlowNodeServiceConfigurationProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeServiceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageFlowNodeServiceConfigurationProperty.Jsii$Proxy that = (StorageFlowNodeServiceConfigurationProperty.Jsii$Proxy) o;

                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3 != null ? this.s3.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains configurations for a text prompt template.
     * <p>
     * To include a variable, enclose a word in double curly braces as in <code>{{variable}}</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TextPromptTemplateConfigurationProperty textPromptTemplateConfigurationProperty = TextPromptTemplateConfigurationProperty.builder()
     *         .text("text")
     *         // the properties below are optional
     *         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-textprompttemplateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-textprompttemplateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.TextPromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TextPromptTemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextPromptTemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message for the prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-textprompttemplateconfiguration.html#cfn-bedrock-flowversion-textprompttemplateconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-textprompttemplateconfiguration.html#cfn-bedrock-flowversion-textprompttemplateconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * An array of the variables in the prompt template.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.PromptInputVariableProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-textprompttemplateconfiguration.html#cfn-bedrock-flowversion-textprompttemplateconfiguration-inputvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-textprompttemplateconfiguration.html#cfn-bedrock-flowversion-textprompttemplateconfiguration-inputvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextPromptTemplateConfigurationProperty> {
            java.lang.String text;
            java.lang.Object inputVariables;

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getText}
             * @param text The message for the prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getInputVariables}
             * @param inputVariables An array of the variables in the prompt template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputVariables(software.amazon.awscdk.IResolvable inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getInputVariables}
             * @param inputVariables An array of the variables in the prompt template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputVariables(java.util.List<? extends java.lang.Object> inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextPromptTemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextPromptTemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextPromptTemplateConfigurationProperty {
            private final java.lang.String text;
            private final java.lang.Object inputVariables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputVariables = software.amazon.jsii.Kernel.get(this, "inputVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.inputVariables = builder.inputVariables;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.Object getInputVariables() {
                return this.inputVariables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));
                if (this.getInputVariables() != null) {
                    data.set("inputVariables", om.valueToTree(this.getInputVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.TextPromptTemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextPromptTemplateConfigurationProperty.Jsii$Proxy that = (TextPromptTemplateConfigurationProperty.Jsii$Proxy) o;

                if (!text.equals(that.text)) return false;
                return this.inputVariables != null ? this.inputVariables.equals(that.inputVariables) : that.inputVariables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                result = 31 * result + (this.inputVariables != null ? this.inputVariables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for using Amazon Bedrock foundation models to rerank Knowledge Base vector search results.
     * <p>
     * This enables more sophisticated relevance ranking using large language models.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * VectorSearchBedrockRerankingConfigurationProperty vectorSearchBedrockRerankingConfigurationProperty = VectorSearchBedrockRerankingConfigurationProperty.builder()
     *         .modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *                 .modelArn("modelArn")
     *                 // the properties below are optional
     *                 .additionalModelRequestFields(additionalModelRequestFields)
     *                 .build())
     *         // the properties below are optional
     *         .metadataConfiguration(MetadataConfigurationForRerankingProperty.builder()
     *                 .selectionMode("selectionMode")
     *                 // the properties below are optional
     *                 .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                         .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                                 .fieldName("fieldName")
     *                                 .build()))
     *                         .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                                 .fieldName("fieldName")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .numberOfRerankedResults(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchBedrockRerankingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorSearchBedrockRerankingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorSearchBedrockRerankingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration for the Amazon Bedrock foundation model used for reranking.
         * <p>
         * This includes the model ARN and any additional request fields required by the model.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.VectorSearchBedrockRerankingModelConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration-modelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration-modelconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getModelConfiguration();

        /**
         * Configuration for how document metadata should be used during the reranking process.
         * <p>
         * This determines which metadata fields are included when reordering search results.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.MetadataConfigurationForRerankingProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration-metadataconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration-metadataconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataConfiguration() {
            return null;
        }

        /**
         * The maximum number of results to rerank.
         * <p>
         * This limits how many of the initial vector search results will be processed by the reranking model. A smaller number improves performance but may exclude potentially relevant results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration-numberofrerankedresults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingconfiguration-numberofrerankedresults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfRerankedResults() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorSearchBedrockRerankingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorSearchBedrockRerankingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorSearchBedrockRerankingConfigurationProperty> {
            java.lang.Object modelConfiguration;
            java.lang.Object metadataConfiguration;
            java.lang.Number numberOfRerankedResults;

            /**
             * Sets the value of {@link VectorSearchBedrockRerankingConfigurationProperty#getModelConfiguration}
             * @param modelConfiguration Configuration for the Amazon Bedrock foundation model used for reranking. This parameter is required.
             *                           This includes the model ARN and any additional request fields required by the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelConfiguration(software.amazon.awscdk.IResolvable modelConfiguration) {
                this.modelConfiguration = modelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorSearchBedrockRerankingConfigurationProperty#getModelConfiguration}
             * @param modelConfiguration Configuration for the Amazon Bedrock foundation model used for reranking. This parameter is required.
             *                           This includes the model ARN and any additional request fields required by the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.VectorSearchBedrockRerankingModelConfigurationProperty modelConfiguration) {
                this.modelConfiguration = modelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorSearchBedrockRerankingConfigurationProperty#getMetadataConfiguration}
             * @param metadataConfiguration Configuration for how document metadata should be used during the reranking process.
             *                              This determines which metadata fields are included when reordering search results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataConfiguration(software.amazon.awscdk.IResolvable metadataConfiguration) {
                this.metadataConfiguration = metadataConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorSearchBedrockRerankingConfigurationProperty#getMetadataConfiguration}
             * @param metadataConfiguration Configuration for how document metadata should be used during the reranking process.
             *                              This determines which metadata fields are included when reordering search results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.MetadataConfigurationForRerankingProperty metadataConfiguration) {
                this.metadataConfiguration = metadataConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorSearchBedrockRerankingConfigurationProperty#getNumberOfRerankedResults}
             * @param numberOfRerankedResults The maximum number of results to rerank.
             *                                This limits how many of the initial vector search results will be processed by the reranking model. A smaller number improves performance but may exclude potentially relevant results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfRerankedResults(java.lang.Number numberOfRerankedResults) {
                this.numberOfRerankedResults = numberOfRerankedResults;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorSearchBedrockRerankingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorSearchBedrockRerankingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorSearchBedrockRerankingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorSearchBedrockRerankingConfigurationProperty {
            private final java.lang.Object modelConfiguration;
            private final java.lang.Object metadataConfiguration;
            private final java.lang.Number numberOfRerankedResults;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelConfiguration = software.amazon.jsii.Kernel.get(this, "modelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metadataConfiguration = software.amazon.jsii.Kernel.get(this, "metadataConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numberOfRerankedResults = software.amazon.jsii.Kernel.get(this, "numberOfRerankedResults", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelConfiguration = java.util.Objects.requireNonNull(builder.modelConfiguration, "modelConfiguration is required");
                this.metadataConfiguration = builder.metadataConfiguration;
                this.numberOfRerankedResults = builder.numberOfRerankedResults;
            }

            @Override
            public final java.lang.Object getModelConfiguration() {
                return this.modelConfiguration;
            }

            @Override
            public final java.lang.Object getMetadataConfiguration() {
                return this.metadataConfiguration;
            }

            @Override
            public final java.lang.Number getNumberOfRerankedResults() {
                return this.numberOfRerankedResults;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("modelConfiguration", om.valueToTree(this.getModelConfiguration()));
                if (this.getMetadataConfiguration() != null) {
                    data.set("metadataConfiguration", om.valueToTree(this.getMetadataConfiguration()));
                }
                if (this.getNumberOfRerankedResults() != null) {
                    data.set("numberOfRerankedResults", om.valueToTree(this.getNumberOfRerankedResults()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchBedrockRerankingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorSearchBedrockRerankingConfigurationProperty.Jsii$Proxy that = (VectorSearchBedrockRerankingConfigurationProperty.Jsii$Proxy) o;

                if (!modelConfiguration.equals(that.modelConfiguration)) return false;
                if (this.metadataConfiguration != null ? !this.metadataConfiguration.equals(that.metadataConfiguration) : that.metadataConfiguration != null) return false;
                return this.numberOfRerankedResults != null ? this.numberOfRerankedResults.equals(that.numberOfRerankedResults) : that.numberOfRerankedResults == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelConfiguration.hashCode();
                result = 31 * result + (this.metadataConfiguration != null ? this.metadataConfiguration.hashCode() : 0);
                result = 31 * result + (this.numberOfRerankedResults != null ? this.numberOfRerankedResults.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for the Amazon Bedrock foundation model used for reranking vector search results.
     * <p>
     * This specifies which model to use and any additional parameters required by the model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * VectorSearchBedrockRerankingModelConfigurationProperty vectorSearchBedrockRerankingModelConfigurationProperty = VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *         .modelArn("modelArn")
     *         // the properties below are optional
     *         .additionalModelRequestFields(additionalModelRequestFields)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchBedrockRerankingModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorSearchBedrockRerankingModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorSearchBedrockRerankingModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the foundation model to use for reranking.
         * <p>
         * This model processes the query and search results to determine a more relevant ordering.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration-modelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration-modelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelArn();

        /**
         * A list of additional fields to include in the model request during reranking.
         * <p>
         * These fields provide extra context or configuration options specific to the selected foundation model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration-additionalmodelrequestfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration.html#cfn-bedrock-flowversion-vectorsearchbedrockrerankingmodelconfiguration-additionalmodelrequestfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalModelRequestFields() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorSearchBedrockRerankingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorSearchBedrockRerankingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorSearchBedrockRerankingModelConfigurationProperty> {
            java.lang.String modelArn;
            java.lang.Object additionalModelRequestFields;

            /**
             * Sets the value of {@link VectorSearchBedrockRerankingModelConfigurationProperty#getModelArn}
             * @param modelArn The Amazon Resource Name (ARN) of the foundation model to use for reranking. This parameter is required.
             *                 This model processes the query and search results to determine a more relevant ordering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelArn(java.lang.String modelArn) {
                this.modelArn = modelArn;
                return this;
            }

            /**
             * Sets the value of {@link VectorSearchBedrockRerankingModelConfigurationProperty#getAdditionalModelRequestFields}
             * @param additionalModelRequestFields A list of additional fields to include in the model request during reranking.
             *                                     These fields provide extra context or configuration options specific to the selected foundation model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalModelRequestFields(java.lang.Object additionalModelRequestFields) {
                this.additionalModelRequestFields = additionalModelRequestFields;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorSearchBedrockRerankingModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorSearchBedrockRerankingModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorSearchBedrockRerankingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorSearchBedrockRerankingModelConfigurationProperty {
            private final java.lang.String modelArn;
            private final java.lang.Object additionalModelRequestFields;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelArn = software.amazon.jsii.Kernel.get(this, "modelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.additionalModelRequestFields = software.amazon.jsii.Kernel.get(this, "additionalModelRequestFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelArn = java.util.Objects.requireNonNull(builder.modelArn, "modelArn is required");
                this.additionalModelRequestFields = builder.additionalModelRequestFields;
            }

            @Override
            public final java.lang.String getModelArn() {
                return this.modelArn;
            }

            @Override
            public final java.lang.Object getAdditionalModelRequestFields() {
                return this.additionalModelRequestFields;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("modelArn", om.valueToTree(this.getModelArn()));
                if (this.getAdditionalModelRequestFields() != null) {
                    data.set("additionalModelRequestFields", om.valueToTree(this.getAdditionalModelRequestFields()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchBedrockRerankingModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorSearchBedrockRerankingModelConfigurationProperty.Jsii$Proxy that = (VectorSearchBedrockRerankingModelConfigurationProperty.Jsii$Proxy) o;

                if (!modelArn.equals(that.modelArn)) return false;
                return this.additionalModelRequestFields != null ? this.additionalModelRequestFields.equals(that.additionalModelRequestFields) : that.additionalModelRequestFields == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelArn.hashCode();
                result = 31 * result + (this.additionalModelRequestFields != null ? this.additionalModelRequestFields.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for reranking vector search results to improve relevance.
     * <p>
     * Reranking applies additional relevance models to reorder the initial vector search results based on more sophisticated criteria.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object additionalModelRequestFields;
     * VectorSearchRerankingConfigurationProperty vectorSearchRerankingConfigurationProperty = VectorSearchRerankingConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfigurationProperty.builder()
     *                 .modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty.builder()
     *                         .modelArn("modelArn")
     *                         // the properties below are optional
     *                         .additionalModelRequestFields(additionalModelRequestFields)
     *                         .build())
     *                 // the properties below are optional
     *                 .metadataConfiguration(MetadataConfigurationForRerankingProperty.builder()
     *                         .selectionMode("selectionMode")
     *                         // the properties below are optional
     *                         .selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty.builder()
     *                                 .fieldsToExclude(List.of(FieldForRerankingProperty.builder()
     *                                         .fieldName("fieldName")
     *                                         .build()))
     *                                 .fieldsToInclude(List.of(FieldForRerankingProperty.builder()
     *                                         .fieldName("fieldName")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .numberOfRerankedResults(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchrerankingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchrerankingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchRerankingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorSearchRerankingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorSearchRerankingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of reranking to apply to vector search results.
         * <p>
         * Currently, the only supported value is BEDROCK, which uses Amazon Bedrock foundation models for reranking.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchrerankingconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchrerankingconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Configuration for using Amazon Bedrock foundation models to rerank search results.
         * <p>
         * This is required when the reranking type is set to BEDROCK.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion.VectorSearchBedrockRerankingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchrerankingconfiguration-bedrockrerankingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flowversion-vectorsearchrerankingconfiguration.html#cfn-bedrock-flowversion-vectorsearchrerankingconfiguration-bedrockrerankingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBedrockRerankingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorSearchRerankingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorSearchRerankingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorSearchRerankingConfigurationProperty> {
            java.lang.String type;
            java.lang.Object bedrockRerankingConfiguration;

            /**
             * Sets the value of {@link VectorSearchRerankingConfigurationProperty#getType}
             * @param type The type of reranking to apply to vector search results. This parameter is required.
             *             Currently, the only supported value is BEDROCK, which uses Amazon Bedrock foundation models for reranking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link VectorSearchRerankingConfigurationProperty#getBedrockRerankingConfiguration}
             * @param bedrockRerankingConfiguration Configuration for using Amazon Bedrock foundation models to rerank search results.
             *                                      This is required when the reranking type is set to BEDROCK.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockRerankingConfiguration(software.amazon.awscdk.IResolvable bedrockRerankingConfiguration) {
                this.bedrockRerankingConfiguration = bedrockRerankingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorSearchRerankingConfigurationProperty#getBedrockRerankingConfiguration}
             * @param bedrockRerankingConfiguration Configuration for using Amazon Bedrock foundation models to rerank search results.
             *                                      This is required when the reranking type is set to BEDROCK.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockRerankingConfiguration(software.amazon.awscdk.services.bedrock.CfnFlowVersion.VectorSearchBedrockRerankingConfigurationProperty bedrockRerankingConfiguration) {
                this.bedrockRerankingConfiguration = bedrockRerankingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorSearchRerankingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorSearchRerankingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorSearchRerankingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorSearchRerankingConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object bedrockRerankingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bedrockRerankingConfiguration = software.amazon.jsii.Kernel.get(this, "bedrockRerankingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.bedrockRerankingConfiguration = builder.bedrockRerankingConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getBedrockRerankingConfiguration() {
                return this.bedrockRerankingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getBedrockRerankingConfiguration() != null) {
                    data.set("bedrockRerankingConfiguration", om.valueToTree(this.getBedrockRerankingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchRerankingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorSearchRerankingConfigurationProperty.Jsii$Proxy that = (VectorSearchRerankingConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.bedrockRerankingConfiguration != null ? this.bedrockRerankingConfiguration.equals(that.bedrockRerankingConfiguration) : that.bedrockRerankingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.bedrockRerankingConfiguration != null ? this.bedrockRerankingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnFlowVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnFlowVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnFlowVersionProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the flow that the version belongs to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flowversion.html#cfn-bedrock-flowversion-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flowversion.html#cfn-bedrock-flowversion-flowarn</a>
         * @param flowArn The Amazon Resource Name (ARN) of the flow that the version belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(final java.lang.String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        /**
         * The description of the flow version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flowversion.html#cfn-bedrock-flowversion-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flowversion.html#cfn-bedrock-flowversion-description</a>
         * @param description The description of the flow version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnFlowVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnFlowVersion build() {
            return new software.amazon.awscdk.services.bedrock.CfnFlowVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
