package software.amazon.awscdk.services.bedrockagentcore;

/**
 * Properties for defining a <code>CfnGatewayTarget</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrockagentcore.*;
 * SchemaDefinitionProperty schemaDefinitionProperty_;
 * CfnGatewayTargetProps cfnGatewayTargetProps = CfnGatewayTargetProps.builder()
 *         .credentialProviderConfigurations(List.of(CredentialProviderConfigurationProperty.builder()
 *                 .credentialProviderType("credentialProviderType")
 *                 // the properties below are optional
 *                 .credentialProvider(CredentialProviderProperty.builder()
 *                         .apiKeyCredentialProvider(ApiKeyCredentialProviderProperty.builder()
 *                                 .providerArn("providerArn")
 *                                 // the properties below are optional
 *                                 .credentialLocation("credentialLocation")
 *                                 .credentialParameterName("credentialParameterName")
 *                                 .credentialPrefix("credentialPrefix")
 *                                 .build())
 *                         .oauthCredentialProvider(OAuthCredentialProviderProperty.builder()
 *                                 .providerArn("providerArn")
 *                                 .scopes(List.of("scopes"))
 *                                 // the properties below are optional
 *                                 .customParameters(Map.of(
 *                                         "customParametersKey", "customParameters"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .name("name")
 *         .targetConfiguration(TargetConfigurationProperty.builder()
 *                 .mcp(McpTargetConfigurationProperty.builder()
 *                         .lambda(McpLambdaTargetConfigurationProperty.builder()
 *                                 .lambdaArn("lambdaArn")
 *                                 .toolSchema(ToolSchemaProperty.builder()
 *                                         .inlinePayload(List.of(ToolDefinitionProperty.builder()
 *                                                 .description("description")
 *                                                 .inputSchema(SchemaDefinitionProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .description("description")
 *                                                         .items(schemaDefinitionProperty_)
 *                                                         .properties(Map.of(
 *                                                                 "propertiesKey", schemaDefinitionProperty_))
 *                                                         .required(List.of("required"))
 *                                                         .build())
 *                                                 .name("name")
 *                                                 // the properties below are optional
 *                                                 .outputSchema(SchemaDefinitionProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .description("description")
 *                                                         .items(schemaDefinitionProperty_)
 *                                                         .properties(Map.of(
 *                                                                 "propertiesKey", schemaDefinitionProperty_))
 *                                                         .required(List.of("required"))
 *                                                         .build())
 *                                                 .build()))
 *                                         .s3(S3ConfigurationProperty.builder()
 *                                                 .bucketOwnerAccountId("bucketOwnerAccountId")
 *                                                 .uri("uri")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .mcpServer(McpServerTargetConfigurationProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .build())
 *                         .openApiSchema(ApiSchemaConfigurationProperty.builder()
 *                                 .inlinePayload("inlinePayload")
 *                                 .s3(S3ConfigurationProperty.builder()
 *                                         .bucketOwnerAccountId("bucketOwnerAccountId")
 *                                         .uri("uri")
 *                                         .build())
 *                                 .build())
 *                         .smithyModel(ApiSchemaConfigurationProperty.builder()
 *                                 .inlinePayload("inlinePayload")
 *                                 .s3(S3ConfigurationProperty.builder()
 *                                         .bucketOwnerAccountId("bucketOwnerAccountId")
 *                                         .uri("uri")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .gatewayIdentifier("gatewayIdentifier")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.564Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTargetProps")
@software.amazon.jsii.Jsii.Proxy(CfnGatewayTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGatewayTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The OAuth credential provider configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.CredentialProviderConfigurationProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCredentialProviderConfigurations();

    /**
     * The name for the gateway target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The target configuration for the Smithy model target.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.TargetConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTargetConfiguration();

    /**
     * The description for the gateway target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The gateway ID for the gateway target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-gatewayidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-gatewayidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGatewayIdentifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGatewayTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGatewayTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGatewayTargetProps> {
        java.lang.Object credentialProviderConfigurations;
        java.lang.String name;
        java.lang.Object targetConfiguration;
        java.lang.String description;
        java.lang.String gatewayIdentifier;

        /**
         * Sets the value of {@link CfnGatewayTargetProps#getCredentialProviderConfigurations}
         * @param credentialProviderConfigurations The OAuth credential provider configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialProviderConfigurations(software.amazon.awscdk.IResolvable credentialProviderConfigurations) {
            this.credentialProviderConfigurations = credentialProviderConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayTargetProps#getCredentialProviderConfigurations}
         * @param credentialProviderConfigurations The OAuth credential provider configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialProviderConfigurations(java.util.List<? extends java.lang.Object> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = credentialProviderConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayTargetProps#getName}
         * @param name The name for the gateway target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayTargetProps#getTargetConfiguration}
         * @param targetConfiguration The target configuration for the Smithy model target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(software.amazon.awscdk.IResolvable targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayTargetProps#getTargetConfiguration}
         * @param targetConfiguration The target configuration for the Smithy model target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.TargetConfigurationProperty targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayTargetProps#getDescription}
         * @param description The description for the gateway target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayTargetProps#getGatewayIdentifier}
         * @param gatewayIdentifier The gateway ID for the gateway target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayIdentifier(java.lang.String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGatewayTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGatewayTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGatewayTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGatewayTargetProps {
        private final java.lang.Object credentialProviderConfigurations;
        private final java.lang.String name;
        private final java.lang.Object targetConfiguration;
        private final java.lang.String description;
        private final java.lang.String gatewayIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.credentialProviderConfigurations = software.amazon.jsii.Kernel.get(this, "credentialProviderConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetConfiguration = software.amazon.jsii.Kernel.get(this, "targetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gatewayIdentifier = software.amazon.jsii.Kernel.get(this, "gatewayIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.credentialProviderConfigurations = java.util.Objects.requireNonNull(builder.credentialProviderConfigurations, "credentialProviderConfigurations is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.targetConfiguration = java.util.Objects.requireNonNull(builder.targetConfiguration, "targetConfiguration is required");
            this.description = builder.description;
            this.gatewayIdentifier = builder.gatewayIdentifier;
        }

        @Override
        public final java.lang.Object getCredentialProviderConfigurations() {
            return this.credentialProviderConfigurations;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getTargetConfiguration() {
            return this.targetConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGatewayIdentifier() {
            return this.gatewayIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("credentialProviderConfigurations", om.valueToTree(this.getCredentialProviderConfigurations()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("targetConfiguration", om.valueToTree(this.getTargetConfiguration()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGatewayIdentifier() != null) {
                data.set("gatewayIdentifier", om.valueToTree(this.getGatewayIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGatewayTargetProps.Jsii$Proxy that = (CfnGatewayTargetProps.Jsii$Proxy) o;

            if (!credentialProviderConfigurations.equals(that.credentialProviderConfigurations)) return false;
            if (!name.equals(that.name)) return false;
            if (!targetConfiguration.equals(that.targetConfiguration)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.gatewayIdentifier != null ? this.gatewayIdentifier.equals(that.gatewayIdentifier) : that.gatewayIdentifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.credentialProviderConfigurations.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.targetConfiguration.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.gatewayIdentifier != null ? this.gatewayIdentifier.hashCode() : 0);
            return result;
        }
    }
}
