package software.amazon.awscdk.services.bedrockagentcore;

/**
 * Memory allows AI agents to maintain both immediate and long-term knowledge, enabling context-aware and personalized interactions.
 * <p>
 * For more information about using Memory in Amazon Bedrock AgentCore, see <a href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/memory-getting-started.html">Host agent or tools with Amazon Bedrock AgentCore Memory</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrockagentcore.*;
 * CfnMemory cfnMemory = CfnMemory.Builder.create(this, "MyCfnMemory")
 *         .eventExpiryDuration(123)
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .encryptionKeyArn("encryptionKeyArn")
 *         .memoryExecutionRoleArn("memoryExecutionRoleArn")
 *         .memoryStrategies(List.of(MemoryStrategyProperty.builder()
 *                 .customMemoryStrategy(CustomMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .configuration(CustomConfigurationInputProperty.builder()
 *                                 .selfManagedConfiguration(SelfManagedConfigurationProperty.builder()
 *                                         .historicalContextWindowSize(123)
 *                                         .invocationConfiguration(InvocationConfigurationInputProperty.builder()
 *                                                 .payloadDeliveryBucketName("payloadDeliveryBucketName")
 *                                                 .topicArn("topicArn")
 *                                                 .build())
 *                                         .triggerConditions(List.of(TriggerConditionInputProperty.builder()
 *                                                 .messageBasedTrigger(MessageBasedTriggerInputProperty.builder()
 *                                                         .messageCount(123)
 *                                                         .build())
 *                                                 .timeBasedTrigger(TimeBasedTriggerInputProperty.builder()
 *                                                         .idleSessionTimeout(123)
 *                                                         .build())
 *                                                 .tokenBasedTrigger(TokenBasedTriggerInputProperty.builder()
 *                                                         .tokenCount(123)
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .semanticOverride(SemanticOverrideProperty.builder()
 *                                         .consolidation(SemanticOverrideConsolidationConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .extraction(SemanticOverrideExtractionConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .build())
 *                                 .summaryOverride(SummaryOverrideProperty.builder()
 *                                         .consolidation(SummaryOverrideConsolidationConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .build())
 *                                 .userPreferenceOverride(UserPreferenceOverrideProperty.builder()
 *                                         .consolidation(UserPreferenceOverrideConsolidationConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .extraction(UserPreferenceOverrideExtractionConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .semanticMemoryStrategy(SemanticMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .summaryMemoryStrategy(SummaryMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.565Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory")
public class CfnMemory extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.bedrockagentcore.IMemoryRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnMemory(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMemory(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::BedrockAgentCore::Memory</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMemory(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrockagentcore.CfnMemoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The timestamp when the memory record was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFailureReason() {
        return software.amazon.jsii.Kernel.get(this, "attrFailureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ARN of the Memory resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMemoryArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMemoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The memory ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMemoryId() {
        return software.amazon.jsii.Kernel.get(this, "attrMemoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The memory status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Memory resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.bedrockagentcore.MemoryReference getMemoryRef() {
        return software.amazon.jsii.Kernel.get(this, "memoryRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.bedrockagentcore.MemoryReference.class));
    }

    /**
     * The event expiry configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getEventExpiryDuration() {
        return software.amazon.jsii.Kernel.get(this, "eventExpiryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The event expiry configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventExpiryDuration(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "eventExpiryDuration", java.util.Objects.requireNonNull(value, "eventExpiryDuration is required"));
    }

    /**
     * The memory name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The memory name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Description of the Memory resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Description of the Memory resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The memory encryption key Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The memory encryption key Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "encryptionKeyArn", value);
    }

    /**
     * The memory role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMemoryExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "memoryExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The memory role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemoryExecutionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "memoryExecutionRoleArn", value);
    }

    /**
     * The memory strategies.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.MemoryStrategyProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMemoryStrategies() {
        return software.amazon.jsii.Kernel.get(this, "memoryStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The memory strategies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemoryStrategies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "memoryStrategies", value);
    }

    /**
     * The memory strategies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemoryStrategies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.bedrockagentcore.CfnMemory.MemoryStrategyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrockagentcore.CfnMemory.MemoryStrategyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "memoryStrategies", value);
    }

    /**
     * The tags for the resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags for the resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The memory configuration input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * CustomConfigurationInputProperty customConfigurationInputProperty = CustomConfigurationInputProperty.builder()
     *         .selfManagedConfiguration(SelfManagedConfigurationProperty.builder()
     *                 .historicalContextWindowSize(123)
     *                 .invocationConfiguration(InvocationConfigurationInputProperty.builder()
     *                         .payloadDeliveryBucketName("payloadDeliveryBucketName")
     *                         .topicArn("topicArn")
     *                         .build())
     *                 .triggerConditions(List.of(TriggerConditionInputProperty.builder()
     *                         .messageBasedTrigger(MessageBasedTriggerInputProperty.builder()
     *                                 .messageCount(123)
     *                                 .build())
     *                         .timeBasedTrigger(TimeBasedTriggerInputProperty.builder()
     *                                 .idleSessionTimeout(123)
     *                                 .build())
     *                         .tokenBasedTrigger(TokenBasedTriggerInputProperty.builder()
     *                                 .tokenCount(123)
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .semanticOverride(SemanticOverrideProperty.builder()
     *                 .consolidation(SemanticOverrideConsolidationConfigurationInputProperty.builder()
     *                         .appendToPrompt("appendToPrompt")
     *                         .modelId("modelId")
     *                         .build())
     *                 .extraction(SemanticOverrideExtractionConfigurationInputProperty.builder()
     *                         .appendToPrompt("appendToPrompt")
     *                         .modelId("modelId")
     *                         .build())
     *                 .build())
     *         .summaryOverride(SummaryOverrideProperty.builder()
     *                 .consolidation(SummaryOverrideConsolidationConfigurationInputProperty.builder()
     *                         .appendToPrompt("appendToPrompt")
     *                         .modelId("modelId")
     *                         .build())
     *                 .build())
     *         .userPreferenceOverride(UserPreferenceOverrideProperty.builder()
     *                 .consolidation(UserPreferenceOverrideConsolidationConfigurationInputProperty.builder()
     *                         .appendToPrompt("appendToPrompt")
     *                         .modelId("modelId")
     *                         .build())
     *                 .extraction(UserPreferenceOverrideExtractionConfigurationInputProperty.builder()
     *                         .appendToPrompt("appendToPrompt")
     *                         .modelId("modelId")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.CustomConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom configuration input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SelfManagedConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-selfmanagedconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-selfmanagedconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedConfiguration() {
            return null;
        }

        /**
         * The memory override configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticOverrideProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-semanticoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-semanticoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSemanticOverride() {
            return null;
        }

        /**
         * The memory configuration override.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SummaryOverrideProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-summaryoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-summaryoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSummaryOverride() {
            return null;
        }

        /**
         * The memory user preference override.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceOverrideProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-userpreferenceoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-customconfigurationinput.html#cfn-bedrockagentcore-memory-customconfigurationinput-userpreferenceoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserPreferenceOverride() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomConfigurationInputProperty> {
            java.lang.Object selfManagedConfiguration;
            java.lang.Object semanticOverride;
            java.lang.Object summaryOverride;
            java.lang.Object userPreferenceOverride;

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getSelfManagedConfiguration}
             * @param selfManagedConfiguration The custom configuration input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedConfiguration(software.amazon.awscdk.IResolvable selfManagedConfiguration) {
                this.selfManagedConfiguration = selfManagedConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getSelfManagedConfiguration}
             * @param selfManagedConfiguration The custom configuration input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SelfManagedConfigurationProperty selfManagedConfiguration) {
                this.selfManagedConfiguration = selfManagedConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getSemanticOverride}
             * @param semanticOverride The memory override configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticOverride(software.amazon.awscdk.IResolvable semanticOverride) {
                this.semanticOverride = semanticOverride;
                return this;
            }

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getSemanticOverride}
             * @param semanticOverride The memory override configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticOverride(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticOverrideProperty semanticOverride) {
                this.semanticOverride = semanticOverride;
                return this;
            }

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getSummaryOverride}
             * @param summaryOverride The memory configuration override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder summaryOverride(software.amazon.awscdk.IResolvable summaryOverride) {
                this.summaryOverride = summaryOverride;
                return this;
            }

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getSummaryOverride}
             * @param summaryOverride The memory configuration override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder summaryOverride(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SummaryOverrideProperty summaryOverride) {
                this.summaryOverride = summaryOverride;
                return this;
            }

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getUserPreferenceOverride}
             * @param userPreferenceOverride The memory user preference override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPreferenceOverride(software.amazon.awscdk.IResolvable userPreferenceOverride) {
                this.userPreferenceOverride = userPreferenceOverride;
                return this;
            }

            /**
             * Sets the value of {@link CustomConfigurationInputProperty#getUserPreferenceOverride}
             * @param userPreferenceOverride The memory user preference override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPreferenceOverride(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceOverrideProperty userPreferenceOverride) {
                this.userPreferenceOverride = userPreferenceOverride;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomConfigurationInputProperty {
            private final java.lang.Object selfManagedConfiguration;
            private final java.lang.Object semanticOverride;
            private final java.lang.Object summaryOverride;
            private final java.lang.Object userPreferenceOverride;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.selfManagedConfiguration = software.amazon.jsii.Kernel.get(this, "selfManagedConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.semanticOverride = software.amazon.jsii.Kernel.get(this, "semanticOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.summaryOverride = software.amazon.jsii.Kernel.get(this, "summaryOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userPreferenceOverride = software.amazon.jsii.Kernel.get(this, "userPreferenceOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.selfManagedConfiguration = builder.selfManagedConfiguration;
                this.semanticOverride = builder.semanticOverride;
                this.summaryOverride = builder.summaryOverride;
                this.userPreferenceOverride = builder.userPreferenceOverride;
            }

            @Override
            public final java.lang.Object getSelfManagedConfiguration() {
                return this.selfManagedConfiguration;
            }

            @Override
            public final java.lang.Object getSemanticOverride() {
                return this.semanticOverride;
            }

            @Override
            public final java.lang.Object getSummaryOverride() {
                return this.summaryOverride;
            }

            @Override
            public final java.lang.Object getUserPreferenceOverride() {
                return this.userPreferenceOverride;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSelfManagedConfiguration() != null) {
                    data.set("selfManagedConfiguration", om.valueToTree(this.getSelfManagedConfiguration()));
                }
                if (this.getSemanticOverride() != null) {
                    data.set("semanticOverride", om.valueToTree(this.getSemanticOverride()));
                }
                if (this.getSummaryOverride() != null) {
                    data.set("summaryOverride", om.valueToTree(this.getSummaryOverride()));
                }
                if (this.getUserPreferenceOverride() != null) {
                    data.set("userPreferenceOverride", om.valueToTree(this.getUserPreferenceOverride()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.CustomConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomConfigurationInputProperty.Jsii$Proxy that = (CustomConfigurationInputProperty.Jsii$Proxy) o;

                if (this.selfManagedConfiguration != null ? !this.selfManagedConfiguration.equals(that.selfManagedConfiguration) : that.selfManagedConfiguration != null) return false;
                if (this.semanticOverride != null ? !this.semanticOverride.equals(that.semanticOverride) : that.semanticOverride != null) return false;
                if (this.summaryOverride != null ? !this.summaryOverride.equals(that.summaryOverride) : that.summaryOverride != null) return false;
                return this.userPreferenceOverride != null ? this.userPreferenceOverride.equals(that.userPreferenceOverride) : that.userPreferenceOverride == null;
            }

            @Override
            public final int hashCode() {
                int result = this.selfManagedConfiguration != null ? this.selfManagedConfiguration.hashCode() : 0;
                result = 31 * result + (this.semanticOverride != null ? this.semanticOverride.hashCode() : 0);
                result = 31 * result + (this.summaryOverride != null ? this.summaryOverride.hashCode() : 0);
                result = 31 * result + (this.userPreferenceOverride != null ? this.userPreferenceOverride.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The memory strategy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * CustomMemoryStrategyProperty customMemoryStrategyProperty = CustomMemoryStrategyProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .configuration(CustomConfigurationInputProperty.builder()
     *                 .selfManagedConfiguration(SelfManagedConfigurationProperty.builder()
     *                         .historicalContextWindowSize(123)
     *                         .invocationConfiguration(InvocationConfigurationInputProperty.builder()
     *                                 .payloadDeliveryBucketName("payloadDeliveryBucketName")
     *                                 .topicArn("topicArn")
     *                                 .build())
     *                         .triggerConditions(List.of(TriggerConditionInputProperty.builder()
     *                                 .messageBasedTrigger(MessageBasedTriggerInputProperty.builder()
     *                                         .messageCount(123)
     *                                         .build())
     *                                 .timeBasedTrigger(TimeBasedTriggerInputProperty.builder()
     *                                         .idleSessionTimeout(123)
     *                                         .build())
     *                                 .tokenBasedTrigger(TokenBasedTriggerInputProperty.builder()
     *                                         .tokenCount(123)
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .semanticOverride(SemanticOverrideProperty.builder()
     *                         .consolidation(SemanticOverrideConsolidationConfigurationInputProperty.builder()
     *                                 .appendToPrompt("appendToPrompt")
     *                                 .modelId("modelId")
     *                                 .build())
     *                         .extraction(SemanticOverrideExtractionConfigurationInputProperty.builder()
     *                                 .appendToPrompt("appendToPrompt")
     *                                 .modelId("modelId")
     *                                 .build())
     *                         .build())
     *                 .summaryOverride(SummaryOverrideProperty.builder()
     *                         .consolidation(SummaryOverrideConsolidationConfigurationInputProperty.builder()
     *                                 .appendToPrompt("appendToPrompt")
     *                                 .modelId("modelId")
     *                                 .build())
     *                         .build())
     *                 .userPreferenceOverride(UserPreferenceOverrideProperty.builder()
     *                         .consolidation(UserPreferenceOverrideConsolidationConfigurationInputProperty.builder()
     *                                 .appendToPrompt("appendToPrompt")
     *                                 .modelId("modelId")
     *                                 .build())
     *                         .extraction(UserPreferenceOverrideExtractionConfigurationInputProperty.builder()
     *                                 .appendToPrompt("appendToPrompt")
     *                                 .modelId("modelId")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .createdAt("createdAt")
     *         .description("description")
     *         .namespaces(List.of("namespaces"))
     *         .status("status")
     *         .strategyId("strategyId")
     *         .type("type")
     *         .updatedAt("updatedAt")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.CustomMemoryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomMemoryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomMemoryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory strategy name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The memory strategy configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.CustomConfigurationInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * Creation timestamp of the memory strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-createdat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedAt() {
            return null;
        }

        /**
         * The memory strategy description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The memory strategy namespaces.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-namespaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-namespaces</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNamespaces() {
            return null;
        }

        /**
         * The memory strategy status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The memory strategy ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-strategyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-strategyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStrategyId() {
            return null;
        }

        /**
         * The memory strategy type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The memory strategy update date and time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-updatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-custommemorystrategy.html#cfn-bedrockagentcore-memory-custommemorystrategy-updatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdatedAt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomMemoryStrategyProperty> {
            java.lang.String name;
            java.lang.Object configuration;
            java.lang.String createdAt;
            java.lang.String description;
            java.util.List<java.lang.String> namespaces;
            java.lang.String status;
            java.lang.String strategyId;
            java.lang.String type;
            java.lang.String updatedAt;

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getName}
             * @param name The memory strategy name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getConfiguration}
             * @param configuration The memory strategy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getConfiguration}
             * @param configuration The memory strategy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.CustomConfigurationInputProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getCreatedAt}
             * @param createdAt Creation timestamp of the memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.lang.String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getDescription}
             * @param description The memory strategy description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getNamespaces}
             * @param namespaces The memory strategy namespaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaces(java.util.List<java.lang.String> namespaces) {
                this.namespaces = namespaces;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getStatus}
             * @param status The memory strategy status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getStrategyId}
             * @param strategyId The memory strategy ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strategyId(java.lang.String strategyId) {
                this.strategyId = strategyId;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getType}
             * @param type The memory strategy type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link CustomMemoryStrategyProperty#getUpdatedAt}
             * @param updatedAt The memory strategy update date and time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(java.lang.String updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomMemoryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomMemoryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomMemoryStrategyProperty {
            private final java.lang.String name;
            private final java.lang.Object configuration;
            private final java.lang.String createdAt;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> namespaces;
            private final java.lang.String status;
            private final java.lang.String strategyId;
            private final java.lang.String type;
            private final java.lang.String updatedAt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaces = software.amazon.jsii.Kernel.get(this, "namespaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.strategyId = software.amazon.jsii.Kernel.get(this, "strategyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updatedAt = software.amazon.jsii.Kernel.get(this, "updatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.configuration = builder.configuration;
                this.createdAt = builder.createdAt;
                this.description = builder.description;
                this.namespaces = builder.namespaces;
                this.status = builder.status;
                this.strategyId = builder.strategyId;
                this.type = builder.type;
                this.updatedAt = builder.updatedAt;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.String getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getNamespaces() {
                return this.namespaces;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getStrategyId() {
                return this.strategyId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUpdatedAt() {
                return this.updatedAt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getNamespaces() != null) {
                    data.set("namespaces", om.valueToTree(this.getNamespaces()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getStrategyId() != null) {
                    data.set("strategyId", om.valueToTree(this.getStrategyId()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUpdatedAt() != null) {
                    data.set("updatedAt", om.valueToTree(this.getUpdatedAt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.CustomMemoryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomMemoryStrategyProperty.Jsii$Proxy that = (CustomMemoryStrategyProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.strategyId != null ? !this.strategyId.equals(that.strategyId) : that.strategyId != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.updatedAt != null ? this.updatedAt.equals(that.updatedAt) : that.updatedAt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.namespaces != null ? this.namespaces.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.strategyId != null ? this.strategyId.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The memory invocation configuration input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * InvocationConfigurationInputProperty invocationConfigurationInputProperty = InvocationConfigurationInputProperty.builder()
     *         .payloadDeliveryBucketName("payloadDeliveryBucketName")
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-invocationconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-invocationconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.InvocationConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(InvocationConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InvocationConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message invocation configuration information for the bucket name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-invocationconfigurationinput.html#cfn-bedrockagentcore-memory-invocationconfigurationinput-payloaddeliverybucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-invocationconfigurationinput.html#cfn-bedrockagentcore-memory-invocationconfigurationinput-payloaddeliverybucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadDeliveryBucketName() {
            return null;
        }

        /**
         * The memory trigger condition topic Amazon Resource Name (ARN).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-invocationconfigurationinput.html#cfn-bedrockagentcore-memory-invocationconfigurationinput-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-invocationconfigurationinput.html#cfn-bedrockagentcore-memory-invocationconfigurationinput-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InvocationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InvocationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InvocationConfigurationInputProperty> {
            java.lang.String payloadDeliveryBucketName;
            java.lang.String topicArn;

            /**
             * Sets the value of {@link InvocationConfigurationInputProperty#getPayloadDeliveryBucketName}
             * @param payloadDeliveryBucketName The message invocation configuration information for the bucket name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadDeliveryBucketName(java.lang.String payloadDeliveryBucketName) {
                this.payloadDeliveryBucketName = payloadDeliveryBucketName;
                return this;
            }

            /**
             * Sets the value of {@link InvocationConfigurationInputProperty#getTopicArn}
             * @param topicArn The memory trigger condition topic Amazon Resource Name (ARN).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InvocationConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InvocationConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InvocationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InvocationConfigurationInputProperty {
            private final java.lang.String payloadDeliveryBucketName;
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.payloadDeliveryBucketName = software.amazon.jsii.Kernel.get(this, "payloadDeliveryBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.payloadDeliveryBucketName = builder.payloadDeliveryBucketName;
                this.topicArn = builder.topicArn;
            }

            @Override
            public final java.lang.String getPayloadDeliveryBucketName() {
                return this.payloadDeliveryBucketName;
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPayloadDeliveryBucketName() != null) {
                    data.set("payloadDeliveryBucketName", om.valueToTree(this.getPayloadDeliveryBucketName()));
                }
                if (this.getTopicArn() != null) {
                    data.set("topicArn", om.valueToTree(this.getTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.InvocationConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InvocationConfigurationInputProperty.Jsii$Proxy that = (InvocationConfigurationInputProperty.Jsii$Proxy) o;

                if (this.payloadDeliveryBucketName != null ? !this.payloadDeliveryBucketName.equals(that.payloadDeliveryBucketName) : that.payloadDeliveryBucketName != null) return false;
                return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.payloadDeliveryBucketName != null ? this.payloadDeliveryBucketName.hashCode() : 0;
                result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The memory strategy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * MemoryStrategyProperty memoryStrategyProperty = MemoryStrategyProperty.builder()
     *         .customMemoryStrategy(CustomMemoryStrategyProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .configuration(CustomConfigurationInputProperty.builder()
     *                         .selfManagedConfiguration(SelfManagedConfigurationProperty.builder()
     *                                 .historicalContextWindowSize(123)
     *                                 .invocationConfiguration(InvocationConfigurationInputProperty.builder()
     *                                         .payloadDeliveryBucketName("payloadDeliveryBucketName")
     *                                         .topicArn("topicArn")
     *                                         .build())
     *                                 .triggerConditions(List.of(TriggerConditionInputProperty.builder()
     *                                         .messageBasedTrigger(MessageBasedTriggerInputProperty.builder()
     *                                                 .messageCount(123)
     *                                                 .build())
     *                                         .timeBasedTrigger(TimeBasedTriggerInputProperty.builder()
     *                                                 .idleSessionTimeout(123)
     *                                                 .build())
     *                                         .tokenBasedTrigger(TokenBasedTriggerInputProperty.builder()
     *                                                 .tokenCount(123)
     *                                                 .build())
     *                                         .build()))
     *                                 .build())
     *                         .semanticOverride(SemanticOverrideProperty.builder()
     *                                 .consolidation(SemanticOverrideConsolidationConfigurationInputProperty.builder()
     *                                         .appendToPrompt("appendToPrompt")
     *                                         .modelId("modelId")
     *                                         .build())
     *                                 .extraction(SemanticOverrideExtractionConfigurationInputProperty.builder()
     *                                         .appendToPrompt("appendToPrompt")
     *                                         .modelId("modelId")
     *                                         .build())
     *                                 .build())
     *                         .summaryOverride(SummaryOverrideProperty.builder()
     *                                 .consolidation(SummaryOverrideConsolidationConfigurationInputProperty.builder()
     *                                         .appendToPrompt("appendToPrompt")
     *                                         .modelId("modelId")
     *                                         .build())
     *                                 .build())
     *                         .userPreferenceOverride(UserPreferenceOverrideProperty.builder()
     *                                 .consolidation(UserPreferenceOverrideConsolidationConfigurationInputProperty.builder()
     *                                         .appendToPrompt("appendToPrompt")
     *                                         .modelId("modelId")
     *                                         .build())
     *                                 .extraction(UserPreferenceOverrideExtractionConfigurationInputProperty.builder()
     *                                         .appendToPrompt("appendToPrompt")
     *                                         .modelId("modelId")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .createdAt("createdAt")
     *                 .description("description")
     *                 .namespaces(List.of("namespaces"))
     *                 .status("status")
     *                 .strategyId("strategyId")
     *                 .type("type")
     *                 .updatedAt("updatedAt")
     *                 .build())
     *         .semanticMemoryStrategy(SemanticMemoryStrategyProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .createdAt("createdAt")
     *                 .description("description")
     *                 .namespaces(List.of("namespaces"))
     *                 .status("status")
     *                 .strategyId("strategyId")
     *                 .type("type")
     *                 .updatedAt("updatedAt")
     *                 .build())
     *         .summaryMemoryStrategy(SummaryMemoryStrategyProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .createdAt("createdAt")
     *                 .description("description")
     *                 .namespaces(List.of("namespaces"))
     *                 .status("status")
     *                 .strategyId("strategyId")
     *                 .type("type")
     *                 .updatedAt("updatedAt")
     *                 .build())
     *         .userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .createdAt("createdAt")
     *                 .description("description")
     *                 .namespaces(List.of("namespaces"))
     *                 .status("status")
     *                 .strategyId("strategyId")
     *                 .type("type")
     *                 .updatedAt("updatedAt")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.MemoryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory strategy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.CustomMemoryStrategyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-custommemorystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-custommemorystrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomMemoryStrategy() {
            return null;
        }

        /**
         * The memory strategy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticMemoryStrategyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-semanticmemorystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-semanticmemorystrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSemanticMemoryStrategy() {
            return null;
        }

        /**
         * The memory strategy summary.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SummaryMemoryStrategyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-summarymemorystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-summarymemorystrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSummaryMemoryStrategy() {
            return null;
        }

        /**
         * The memory strategy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceMemoryStrategyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-userpreferencememorystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-memorystrategy.html#cfn-bedrockagentcore-memory-memorystrategy-userpreferencememorystrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserPreferenceMemoryStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryStrategyProperty> {
            java.lang.Object customMemoryStrategy;
            java.lang.Object semanticMemoryStrategy;
            java.lang.Object summaryMemoryStrategy;
            java.lang.Object userPreferenceMemoryStrategy;

            /**
             * Sets the value of {@link MemoryStrategyProperty#getCustomMemoryStrategy}
             * @param customMemoryStrategy The memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customMemoryStrategy(software.amazon.awscdk.IResolvable customMemoryStrategy) {
                this.customMemoryStrategy = customMemoryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link MemoryStrategyProperty#getCustomMemoryStrategy}
             * @param customMemoryStrategy The memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customMemoryStrategy(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.CustomMemoryStrategyProperty customMemoryStrategy) {
                this.customMemoryStrategy = customMemoryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link MemoryStrategyProperty#getSemanticMemoryStrategy}
             * @param semanticMemoryStrategy The memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticMemoryStrategy(software.amazon.awscdk.IResolvable semanticMemoryStrategy) {
                this.semanticMemoryStrategy = semanticMemoryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link MemoryStrategyProperty#getSemanticMemoryStrategy}
             * @param semanticMemoryStrategy The memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticMemoryStrategy(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticMemoryStrategyProperty semanticMemoryStrategy) {
                this.semanticMemoryStrategy = semanticMemoryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link MemoryStrategyProperty#getSummaryMemoryStrategy}
             * @param summaryMemoryStrategy The memory strategy summary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder summaryMemoryStrategy(software.amazon.awscdk.IResolvable summaryMemoryStrategy) {
                this.summaryMemoryStrategy = summaryMemoryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link MemoryStrategyProperty#getSummaryMemoryStrategy}
             * @param summaryMemoryStrategy The memory strategy summary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder summaryMemoryStrategy(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SummaryMemoryStrategyProperty summaryMemoryStrategy) {
                this.summaryMemoryStrategy = summaryMemoryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link MemoryStrategyProperty#getUserPreferenceMemoryStrategy}
             * @param userPreferenceMemoryStrategy The memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPreferenceMemoryStrategy(software.amazon.awscdk.IResolvable userPreferenceMemoryStrategy) {
                this.userPreferenceMemoryStrategy = userPreferenceMemoryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link MemoryStrategyProperty#getUserPreferenceMemoryStrategy}
             * @param userPreferenceMemoryStrategy The memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPreferenceMemoryStrategy(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceMemoryStrategyProperty userPreferenceMemoryStrategy) {
                this.userPreferenceMemoryStrategy = userPreferenceMemoryStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryStrategyProperty {
            private final java.lang.Object customMemoryStrategy;
            private final java.lang.Object semanticMemoryStrategy;
            private final java.lang.Object summaryMemoryStrategy;
            private final java.lang.Object userPreferenceMemoryStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customMemoryStrategy = software.amazon.jsii.Kernel.get(this, "customMemoryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.semanticMemoryStrategy = software.amazon.jsii.Kernel.get(this, "semanticMemoryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.summaryMemoryStrategy = software.amazon.jsii.Kernel.get(this, "summaryMemoryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userPreferenceMemoryStrategy = software.amazon.jsii.Kernel.get(this, "userPreferenceMemoryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customMemoryStrategy = builder.customMemoryStrategy;
                this.semanticMemoryStrategy = builder.semanticMemoryStrategy;
                this.summaryMemoryStrategy = builder.summaryMemoryStrategy;
                this.userPreferenceMemoryStrategy = builder.userPreferenceMemoryStrategy;
            }

            @Override
            public final java.lang.Object getCustomMemoryStrategy() {
                return this.customMemoryStrategy;
            }

            @Override
            public final java.lang.Object getSemanticMemoryStrategy() {
                return this.semanticMemoryStrategy;
            }

            @Override
            public final java.lang.Object getSummaryMemoryStrategy() {
                return this.summaryMemoryStrategy;
            }

            @Override
            public final java.lang.Object getUserPreferenceMemoryStrategy() {
                return this.userPreferenceMemoryStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomMemoryStrategy() != null) {
                    data.set("customMemoryStrategy", om.valueToTree(this.getCustomMemoryStrategy()));
                }
                if (this.getSemanticMemoryStrategy() != null) {
                    data.set("semanticMemoryStrategy", om.valueToTree(this.getSemanticMemoryStrategy()));
                }
                if (this.getSummaryMemoryStrategy() != null) {
                    data.set("summaryMemoryStrategy", om.valueToTree(this.getSummaryMemoryStrategy()));
                }
                if (this.getUserPreferenceMemoryStrategy() != null) {
                    data.set("userPreferenceMemoryStrategy", om.valueToTree(this.getUserPreferenceMemoryStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.MemoryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryStrategyProperty.Jsii$Proxy that = (MemoryStrategyProperty.Jsii$Proxy) o;

                if (this.customMemoryStrategy != null ? !this.customMemoryStrategy.equals(that.customMemoryStrategy) : that.customMemoryStrategy != null) return false;
                if (this.semanticMemoryStrategy != null ? !this.semanticMemoryStrategy.equals(that.semanticMemoryStrategy) : that.semanticMemoryStrategy != null) return false;
                if (this.summaryMemoryStrategy != null ? !this.summaryMemoryStrategy.equals(that.summaryMemoryStrategy) : that.summaryMemoryStrategy != null) return false;
                return this.userPreferenceMemoryStrategy != null ? this.userPreferenceMemoryStrategy.equals(that.userPreferenceMemoryStrategy) : that.userPreferenceMemoryStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customMemoryStrategy != null ? this.customMemoryStrategy.hashCode() : 0;
                result = 31 * result + (this.semanticMemoryStrategy != null ? this.semanticMemoryStrategy.hashCode() : 0);
                result = 31 * result + (this.summaryMemoryStrategy != null ? this.summaryMemoryStrategy.hashCode() : 0);
                result = 31 * result + (this.userPreferenceMemoryStrategy != null ? this.userPreferenceMemoryStrategy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The message based trigger input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * MessageBasedTriggerInputProperty messageBasedTriggerInputProperty = MessageBasedTriggerInputProperty.builder()
     *         .messageCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-messagebasedtriggerinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-messagebasedtriggerinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.MessageBasedTriggerInputProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageBasedTriggerInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageBasedTriggerInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory trigger condition input for the message based trigger message count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-messagebasedtriggerinput.html#cfn-bedrockagentcore-memory-messagebasedtriggerinput-messagecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-messagebasedtriggerinput.html#cfn-bedrockagentcore-memory-messagebasedtriggerinput-messagecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMessageCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageBasedTriggerInputProperty> {
            java.lang.Number messageCount;

            /**
             * Sets the value of {@link MessageBasedTriggerInputProperty#getMessageCount}
             * @param messageCount The memory trigger condition input for the message based trigger message count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageCount(java.lang.Number messageCount) {
                this.messageCount = messageCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageBasedTriggerInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageBasedTriggerInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageBasedTriggerInputProperty {
            private final java.lang.Number messageCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.messageCount = software.amazon.jsii.Kernel.get(this, "messageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.messageCount = builder.messageCount;
            }

            @Override
            public final java.lang.Number getMessageCount() {
                return this.messageCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessageCount() != null) {
                    data.set("messageCount", om.valueToTree(this.getMessageCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.MessageBasedTriggerInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageBasedTriggerInputProperty.Jsii$Proxy that = (MessageBasedTriggerInputProperty.Jsii$Proxy) o;

                return this.messageCount != null ? this.messageCount.equals(that.messageCount) : that.messageCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.messageCount != null ? this.messageCount.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The self managed configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SelfManagedConfigurationProperty selfManagedConfigurationProperty = SelfManagedConfigurationProperty.builder()
     *         .historicalContextWindowSize(123)
     *         .invocationConfiguration(InvocationConfigurationInputProperty.builder()
     *                 .payloadDeliveryBucketName("payloadDeliveryBucketName")
     *                 .topicArn("topicArn")
     *                 .build())
     *         .triggerConditions(List.of(TriggerConditionInputProperty.builder()
     *                 .messageBasedTrigger(MessageBasedTriggerInputProperty.builder()
     *                         .messageCount(123)
     *                         .build())
     *                 .timeBasedTrigger(TimeBasedTriggerInputProperty.builder()
     *                         .idleSessionTimeout(123)
     *                         .build())
     *                 .tokenBasedTrigger(TokenBasedTriggerInputProperty.builder()
     *                         .tokenCount(123)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SelfManagedConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SelfManagedConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelfManagedConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory configuration for self managed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html#cfn-bedrockagentcore-memory-selfmanagedconfiguration-historicalcontextwindowsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html#cfn-bedrockagentcore-memory-selfmanagedconfiguration-historicalcontextwindowsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHistoricalContextWindowSize() {
            return null;
        }

        /**
         * The self managed configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.InvocationConfigurationInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html#cfn-bedrockagentcore-memory-selfmanagedconfiguration-invocationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html#cfn-bedrockagentcore-memory-selfmanagedconfiguration-invocationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvocationConfiguration() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.TriggerConditionInputProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html#cfn-bedrockagentcore-memory-selfmanagedconfiguration-triggerconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-selfmanagedconfiguration.html#cfn-bedrockagentcore-memory-selfmanagedconfiguration-triggerconditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTriggerConditions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelfManagedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelfManagedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelfManagedConfigurationProperty> {
            java.lang.Number historicalContextWindowSize;
            java.lang.Object invocationConfiguration;
            java.lang.Object triggerConditions;

            /**
             * Sets the value of {@link SelfManagedConfigurationProperty#getHistoricalContextWindowSize}
             * @param historicalContextWindowSize The memory configuration for self managed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder historicalContextWindowSize(java.lang.Number historicalContextWindowSize) {
                this.historicalContextWindowSize = historicalContextWindowSize;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedConfigurationProperty#getInvocationConfiguration}
             * @param invocationConfiguration The self managed configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationConfiguration(software.amazon.awscdk.IResolvable invocationConfiguration) {
                this.invocationConfiguration = invocationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedConfigurationProperty#getInvocationConfiguration}
             * @param invocationConfiguration The self managed configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.InvocationConfigurationInputProperty invocationConfiguration) {
                this.invocationConfiguration = invocationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedConfigurationProperty#getTriggerConditions}
             * @param triggerConditions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerConditions(software.amazon.awscdk.IResolvable triggerConditions) {
                this.triggerConditions = triggerConditions;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedConfigurationProperty#getTriggerConditions}
             * @param triggerConditions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerConditions(java.util.List<? extends java.lang.Object> triggerConditions) {
                this.triggerConditions = triggerConditions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelfManagedConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelfManagedConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelfManagedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfManagedConfigurationProperty {
            private final java.lang.Number historicalContextWindowSize;
            private final java.lang.Object invocationConfiguration;
            private final java.lang.Object triggerConditions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.historicalContextWindowSize = software.amazon.jsii.Kernel.get(this, "historicalContextWindowSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.invocationConfiguration = software.amazon.jsii.Kernel.get(this, "invocationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.triggerConditions = software.amazon.jsii.Kernel.get(this, "triggerConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.historicalContextWindowSize = builder.historicalContextWindowSize;
                this.invocationConfiguration = builder.invocationConfiguration;
                this.triggerConditions = builder.triggerConditions;
            }

            @Override
            public final java.lang.Number getHistoricalContextWindowSize() {
                return this.historicalContextWindowSize;
            }

            @Override
            public final java.lang.Object getInvocationConfiguration() {
                return this.invocationConfiguration;
            }

            @Override
            public final java.lang.Object getTriggerConditions() {
                return this.triggerConditions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHistoricalContextWindowSize() != null) {
                    data.set("historicalContextWindowSize", om.valueToTree(this.getHistoricalContextWindowSize()));
                }
                if (this.getInvocationConfiguration() != null) {
                    data.set("invocationConfiguration", om.valueToTree(this.getInvocationConfiguration()));
                }
                if (this.getTriggerConditions() != null) {
                    data.set("triggerConditions", om.valueToTree(this.getTriggerConditions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SelfManagedConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelfManagedConfigurationProperty.Jsii$Proxy that = (SelfManagedConfigurationProperty.Jsii$Proxy) o;

                if (this.historicalContextWindowSize != null ? !this.historicalContextWindowSize.equals(that.historicalContextWindowSize) : that.historicalContextWindowSize != null) return false;
                if (this.invocationConfiguration != null ? !this.invocationConfiguration.equals(that.invocationConfiguration) : that.invocationConfiguration != null) return false;
                return this.triggerConditions != null ? this.triggerConditions.equals(that.triggerConditions) : that.triggerConditions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.historicalContextWindowSize != null ? this.historicalContextWindowSize.hashCode() : 0;
                result = 31 * result + (this.invocationConfiguration != null ? this.invocationConfiguration.hashCode() : 0);
                result = 31 * result + (this.triggerConditions != null ? this.triggerConditions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The memory strategy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SemanticMemoryStrategyProperty semanticMemoryStrategyProperty = SemanticMemoryStrategyProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .createdAt("createdAt")
     *         .description("description")
     *         .namespaces(List.of("namespaces"))
     *         .status("status")
     *         .strategyId("strategyId")
     *         .type("type")
     *         .updatedAt("updatedAt")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticMemoryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticMemoryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticMemoryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory strategy name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Creation timestamp of the memory strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-createdat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedAt() {
            return null;
        }

        /**
         * The memory strategy description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The memory strategy namespaces.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-namespaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-namespaces</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNamespaces() {
            return null;
        }

        /**
         * Status of the memory strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The memory strategy ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-strategyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-strategyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStrategyId() {
            return null;
        }

        /**
         * The memory strategy type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * Last update timestamp of the memory strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-updatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticmemorystrategy.html#cfn-bedrockagentcore-memory-semanticmemorystrategy-updatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdatedAt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SemanticMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticMemoryStrategyProperty> {
            java.lang.String name;
            java.lang.String createdAt;
            java.lang.String description;
            java.util.List<java.lang.String> namespaces;
            java.lang.String status;
            java.lang.String strategyId;
            java.lang.String type;
            java.lang.String updatedAt;

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getName}
             * @param name The memory strategy name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getCreatedAt}
             * @param createdAt Creation timestamp of the memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.lang.String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getDescription}
             * @param description The memory strategy description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getNamespaces}
             * @param namespaces The memory strategy namespaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaces(java.util.List<java.lang.String> namespaces) {
                this.namespaces = namespaces;
                return this;
            }

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getStatus}
             * @param status Status of the memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getStrategyId}
             * @param strategyId The memory strategy ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strategyId(java.lang.String strategyId) {
                this.strategyId = strategyId;
                return this;
            }

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getType}
             * @param type The memory strategy type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SemanticMemoryStrategyProperty#getUpdatedAt}
             * @param updatedAt Last update timestamp of the memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(java.lang.String updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticMemoryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticMemoryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticMemoryStrategyProperty {
            private final java.lang.String name;
            private final java.lang.String createdAt;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> namespaces;
            private final java.lang.String status;
            private final java.lang.String strategyId;
            private final java.lang.String type;
            private final java.lang.String updatedAt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaces = software.amazon.jsii.Kernel.get(this, "namespaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.strategyId = software.amazon.jsii.Kernel.get(this, "strategyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updatedAt = software.amazon.jsii.Kernel.get(this, "updatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.createdAt = builder.createdAt;
                this.description = builder.description;
                this.namespaces = builder.namespaces;
                this.status = builder.status;
                this.strategyId = builder.strategyId;
                this.type = builder.type;
                this.updatedAt = builder.updatedAt;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getNamespaces() {
                return this.namespaces;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getStrategyId() {
                return this.strategyId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUpdatedAt() {
                return this.updatedAt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getNamespaces() != null) {
                    data.set("namespaces", om.valueToTree(this.getNamespaces()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getStrategyId() != null) {
                    data.set("strategyId", om.valueToTree(this.getStrategyId()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUpdatedAt() != null) {
                    data.set("updatedAt", om.valueToTree(this.getUpdatedAt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticMemoryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticMemoryStrategyProperty.Jsii$Proxy that = (SemanticMemoryStrategyProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.strategyId != null ? !this.strategyId.equals(that.strategyId) : that.strategyId != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.updatedAt != null ? this.updatedAt.equals(that.updatedAt) : that.updatedAt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.namespaces != null ? this.namespaces.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.strategyId != null ? this.strategyId.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The memory override configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SemanticOverrideConsolidationConfigurationInputProperty semanticOverrideConsolidationConfigurationInputProperty = SemanticOverrideConsolidationConfigurationInputProperty.builder()
     *         .appendToPrompt("appendToPrompt")
     *         .modelId("modelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticOverrideConsolidationConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticOverrideConsolidationConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticOverrideConsolidationConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The override configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput-appendtoprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput-appendtoprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppendToPrompt();

        /**
         * The memory override model ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideconsolidationconfigurationinput-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelId();

        /**
         * @return a {@link Builder} of {@link SemanticOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticOverrideConsolidationConfigurationInputProperty> {
            java.lang.String appendToPrompt;
            java.lang.String modelId;

            /**
             * Sets the value of {@link SemanticOverrideConsolidationConfigurationInputProperty#getAppendToPrompt}
             * @param appendToPrompt The override configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendToPrompt(java.lang.String appendToPrompt) {
                this.appendToPrompt = appendToPrompt;
                return this;
            }

            /**
             * Sets the value of {@link SemanticOverrideConsolidationConfigurationInputProperty#getModelId}
             * @param modelId The memory override model ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticOverrideConsolidationConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticOverrideConsolidationConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticOverrideConsolidationConfigurationInputProperty {
            private final java.lang.String appendToPrompt;
            private final java.lang.String modelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appendToPrompt = software.amazon.jsii.Kernel.get(this, "appendToPrompt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appendToPrompt = java.util.Objects.requireNonNull(builder.appendToPrompt, "appendToPrompt is required");
                this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
            }

            @Override
            public final java.lang.String getAppendToPrompt() {
                return this.appendToPrompt;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appendToPrompt", om.valueToTree(this.getAppendToPrompt()));
                data.set("modelId", om.valueToTree(this.getModelId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticOverrideConsolidationConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticOverrideConsolidationConfigurationInputProperty.Jsii$Proxy that = (SemanticOverrideConsolidationConfigurationInputProperty.Jsii$Proxy) o;

                if (!appendToPrompt.equals(that.appendToPrompt)) return false;
                return this.modelId.equals(that.modelId);
            }

            @Override
            public final int hashCode() {
                int result = this.appendToPrompt.hashCode();
                result = 31 * result + (this.modelId.hashCode());
                return result;
            }
        }
    }
    /**
     * The memory override configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SemanticOverrideExtractionConfigurationInputProperty semanticOverrideExtractionConfigurationInputProperty = SemanticOverrideExtractionConfigurationInputProperty.builder()
     *         .appendToPrompt("appendToPrompt")
     *         .modelId("modelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticOverrideExtractionConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticOverrideExtractionConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticOverrideExtractionConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The extraction configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput-appendtoprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput-appendtoprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppendToPrompt();

        /**
         * The memory override configuration model ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-semanticoverrideextractionconfigurationinput-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelId();

        /**
         * @return a {@link Builder} of {@link SemanticOverrideExtractionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticOverrideExtractionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticOverrideExtractionConfigurationInputProperty> {
            java.lang.String appendToPrompt;
            java.lang.String modelId;

            /**
             * Sets the value of {@link SemanticOverrideExtractionConfigurationInputProperty#getAppendToPrompt}
             * @param appendToPrompt The extraction configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendToPrompt(java.lang.String appendToPrompt) {
                this.appendToPrompt = appendToPrompt;
                return this;
            }

            /**
             * Sets the value of {@link SemanticOverrideExtractionConfigurationInputProperty#getModelId}
             * @param modelId The memory override configuration model ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticOverrideExtractionConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticOverrideExtractionConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticOverrideExtractionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticOverrideExtractionConfigurationInputProperty {
            private final java.lang.String appendToPrompt;
            private final java.lang.String modelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appendToPrompt = software.amazon.jsii.Kernel.get(this, "appendToPrompt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appendToPrompt = java.util.Objects.requireNonNull(builder.appendToPrompt, "appendToPrompt is required");
                this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
            }

            @Override
            public final java.lang.String getAppendToPrompt() {
                return this.appendToPrompt;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appendToPrompt", om.valueToTree(this.getAppendToPrompt()));
                data.set("modelId", om.valueToTree(this.getModelId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticOverrideExtractionConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticOverrideExtractionConfigurationInputProperty.Jsii$Proxy that = (SemanticOverrideExtractionConfigurationInputProperty.Jsii$Proxy) o;

                if (!appendToPrompt.equals(that.appendToPrompt)) return false;
                return this.modelId.equals(that.modelId);
            }

            @Override
            public final int hashCode() {
                int result = this.appendToPrompt.hashCode();
                result = 31 * result + (this.modelId.hashCode());
                return result;
            }
        }
    }
    /**
     * The memory override.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SemanticOverrideProperty semanticOverrideProperty = SemanticOverrideProperty.builder()
     *         .consolidation(SemanticOverrideConsolidationConfigurationInputProperty.builder()
     *                 .appendToPrompt("appendToPrompt")
     *                 .modelId("modelId")
     *                 .build())
     *         .extraction(SemanticOverrideExtractionConfigurationInputProperty.builder()
     *                 .appendToPrompt("appendToPrompt")
     *                 .modelId("modelId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory override consolidation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticOverrideConsolidationConfigurationInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverride.html#cfn-bedrockagentcore-memory-semanticoverride-consolidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverride.html#cfn-bedrockagentcore-memory-semanticoverride-consolidation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConsolidation() {
            return null;
        }

        /**
         * The memory override extraction.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticOverrideExtractionConfigurationInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverride.html#cfn-bedrockagentcore-memory-semanticoverride-extraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-semanticoverride.html#cfn-bedrockagentcore-memory-semanticoverride-extraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SemanticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticOverrideProperty> {
            java.lang.Object consolidation;
            java.lang.Object extraction;

            /**
             * Sets the value of {@link SemanticOverrideProperty#getConsolidation}
             * @param consolidation The memory override consolidation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.IResolvable consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Sets the value of {@link SemanticOverrideProperty#getConsolidation}
             * @param consolidation The memory override consolidation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticOverrideConsolidationConfigurationInputProperty consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Sets the value of {@link SemanticOverrideProperty#getExtraction}
             * @param extraction The memory override extraction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.IResolvable extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link SemanticOverrideProperty#getExtraction}
             * @param extraction The memory override extraction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SemanticOverrideExtractionConfigurationInputProperty extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticOverrideProperty {
            private final java.lang.Object consolidation;
            private final java.lang.Object extraction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.consolidation = software.amazon.jsii.Kernel.get(this, "consolidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extraction = software.amazon.jsii.Kernel.get(this, "extraction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.consolidation = builder.consolidation;
                this.extraction = builder.extraction;
            }

            @Override
            public final java.lang.Object getConsolidation() {
                return this.consolidation;
            }

            @Override
            public final java.lang.Object getExtraction() {
                return this.extraction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConsolidation() != null) {
                    data.set("consolidation", om.valueToTree(this.getConsolidation()));
                }
                if (this.getExtraction() != null) {
                    data.set("extraction", om.valueToTree(this.getExtraction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SemanticOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticOverrideProperty.Jsii$Proxy that = (SemanticOverrideProperty.Jsii$Proxy) o;

                if (this.consolidation != null ? !this.consolidation.equals(that.consolidation) : that.consolidation != null) return false;
                return this.extraction != null ? this.extraction.equals(that.extraction) : that.extraction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.consolidation != null ? this.consolidation.hashCode() : 0;
                result = 31 * result + (this.extraction != null ? this.extraction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The memory strategy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SummaryMemoryStrategyProperty summaryMemoryStrategyProperty = SummaryMemoryStrategyProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .createdAt("createdAt")
     *         .description("description")
     *         .namespaces(List.of("namespaces"))
     *         .status("status")
     *         .strategyId("strategyId")
     *         .type("type")
     *         .updatedAt("updatedAt")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SummaryMemoryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(SummaryMemoryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SummaryMemoryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory strategy name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Creation timestamp of the memory strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-createdat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedAt() {
            return null;
        }

        /**
         * The memory strategy description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The summary memory strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-namespaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-namespaces</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNamespaces() {
            return null;
        }

        /**
         * The memory strategy status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The memory strategy ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-strategyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-strategyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStrategyId() {
            return null;
        }

        /**
         * The memory strategy type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The memory strategy update date and time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-updatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summarymemorystrategy.html#cfn-bedrockagentcore-memory-summarymemorystrategy-updatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdatedAt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SummaryMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SummaryMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SummaryMemoryStrategyProperty> {
            java.lang.String name;
            java.lang.String createdAt;
            java.lang.String description;
            java.util.List<java.lang.String> namespaces;
            java.lang.String status;
            java.lang.String strategyId;
            java.lang.String type;
            java.lang.String updatedAt;

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getName}
             * @param name The memory strategy name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getCreatedAt}
             * @param createdAt Creation timestamp of the memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.lang.String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getDescription}
             * @param description The memory strategy description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getNamespaces}
             * @param namespaces The summary memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaces(java.util.List<java.lang.String> namespaces) {
                this.namespaces = namespaces;
                return this;
            }

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getStatus}
             * @param status The memory strategy status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getStrategyId}
             * @param strategyId The memory strategy ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strategyId(java.lang.String strategyId) {
                this.strategyId = strategyId;
                return this;
            }

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getType}
             * @param type The memory strategy type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SummaryMemoryStrategyProperty#getUpdatedAt}
             * @param updatedAt The memory strategy update date and time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(java.lang.String updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SummaryMemoryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SummaryMemoryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SummaryMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SummaryMemoryStrategyProperty {
            private final java.lang.String name;
            private final java.lang.String createdAt;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> namespaces;
            private final java.lang.String status;
            private final java.lang.String strategyId;
            private final java.lang.String type;
            private final java.lang.String updatedAt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaces = software.amazon.jsii.Kernel.get(this, "namespaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.strategyId = software.amazon.jsii.Kernel.get(this, "strategyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updatedAt = software.amazon.jsii.Kernel.get(this, "updatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.createdAt = builder.createdAt;
                this.description = builder.description;
                this.namespaces = builder.namespaces;
                this.status = builder.status;
                this.strategyId = builder.strategyId;
                this.type = builder.type;
                this.updatedAt = builder.updatedAt;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getNamespaces() {
                return this.namespaces;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getStrategyId() {
                return this.strategyId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUpdatedAt() {
                return this.updatedAt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getNamespaces() != null) {
                    data.set("namespaces", om.valueToTree(this.getNamespaces()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getStrategyId() != null) {
                    data.set("strategyId", om.valueToTree(this.getStrategyId()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUpdatedAt() != null) {
                    data.set("updatedAt", om.valueToTree(this.getUpdatedAt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SummaryMemoryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SummaryMemoryStrategyProperty.Jsii$Proxy that = (SummaryMemoryStrategyProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.strategyId != null ? !this.strategyId.equals(that.strategyId) : that.strategyId != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.updatedAt != null ? this.updatedAt.equals(that.updatedAt) : that.updatedAt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.namespaces != null ? this.namespaces.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.strategyId != null ? this.strategyId.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The consolidation configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SummaryOverrideConsolidationConfigurationInputProperty summaryOverrideConsolidationConfigurationInputProperty = SummaryOverrideConsolidationConfigurationInputProperty.builder()
     *         .appendToPrompt("appendToPrompt")
     *         .modelId("modelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SummaryOverrideConsolidationConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(SummaryOverrideConsolidationConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SummaryOverrideConsolidationConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory override configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput-appendtoprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput-appendtoprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppendToPrompt();

        /**
         * The memory override configuration model ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-summaryoverrideconsolidationconfigurationinput-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelId();

        /**
         * @return a {@link Builder} of {@link SummaryOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SummaryOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SummaryOverrideConsolidationConfigurationInputProperty> {
            java.lang.String appendToPrompt;
            java.lang.String modelId;

            /**
             * Sets the value of {@link SummaryOverrideConsolidationConfigurationInputProperty#getAppendToPrompt}
             * @param appendToPrompt The memory override configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendToPrompt(java.lang.String appendToPrompt) {
                this.appendToPrompt = appendToPrompt;
                return this;
            }

            /**
             * Sets the value of {@link SummaryOverrideConsolidationConfigurationInputProperty#getModelId}
             * @param modelId The memory override configuration model ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SummaryOverrideConsolidationConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SummaryOverrideConsolidationConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SummaryOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SummaryOverrideConsolidationConfigurationInputProperty {
            private final java.lang.String appendToPrompt;
            private final java.lang.String modelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appendToPrompt = software.amazon.jsii.Kernel.get(this, "appendToPrompt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appendToPrompt = java.util.Objects.requireNonNull(builder.appendToPrompt, "appendToPrompt is required");
                this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
            }

            @Override
            public final java.lang.String getAppendToPrompt() {
                return this.appendToPrompt;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appendToPrompt", om.valueToTree(this.getAppendToPrompt()));
                data.set("modelId", om.valueToTree(this.getModelId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SummaryOverrideConsolidationConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SummaryOverrideConsolidationConfigurationInputProperty.Jsii$Proxy that = (SummaryOverrideConsolidationConfigurationInputProperty.Jsii$Proxy) o;

                if (!appendToPrompt.equals(that.appendToPrompt)) return false;
                return this.modelId.equals(that.modelId);
            }

            @Override
            public final int hashCode() {
                int result = this.appendToPrompt.hashCode();
                result = 31 * result + (this.modelId.hashCode());
                return result;
            }
        }
    }
    /**
     * The memory summary override.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SummaryOverrideProperty summaryOverrideProperty = SummaryOverrideProperty.builder()
     *         .consolidation(SummaryOverrideConsolidationConfigurationInputProperty.builder()
     *                 .appendToPrompt("appendToPrompt")
     *                 .modelId("modelId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SummaryOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(SummaryOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SummaryOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory override consolidation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SummaryOverrideConsolidationConfigurationInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverride.html#cfn-bedrockagentcore-memory-summaryoverride-consolidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-summaryoverride.html#cfn-bedrockagentcore-memory-summaryoverride-consolidation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConsolidation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SummaryOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SummaryOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SummaryOverrideProperty> {
            java.lang.Object consolidation;

            /**
             * Sets the value of {@link SummaryOverrideProperty#getConsolidation}
             * @param consolidation The memory override consolidation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.IResolvable consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Sets the value of {@link SummaryOverrideProperty#getConsolidation}
             * @param consolidation The memory override consolidation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.SummaryOverrideConsolidationConfigurationInputProperty consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SummaryOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SummaryOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SummaryOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SummaryOverrideProperty {
            private final java.lang.Object consolidation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.consolidation = software.amazon.jsii.Kernel.get(this, "consolidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.consolidation = builder.consolidation;
            }

            @Override
            public final java.lang.Object getConsolidation() {
                return this.consolidation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConsolidation() != null) {
                    data.set("consolidation", om.valueToTree(this.getConsolidation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.SummaryOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SummaryOverrideProperty.Jsii$Proxy that = (SummaryOverrideProperty.Jsii$Proxy) o;

                return this.consolidation != null ? this.consolidation.equals(that.consolidation) : that.consolidation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.consolidation != null ? this.consolidation.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The memory trigger condition input for the time based trigger.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * TimeBasedTriggerInputProperty timeBasedTriggerInputProperty = TimeBasedTriggerInputProperty.builder()
     *         .idleSessionTimeout(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-timebasedtriggerinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-timebasedtriggerinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.TimeBasedTriggerInputProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeBasedTriggerInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeBasedTriggerInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory trigger condition input for the session timeout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-timebasedtriggerinput.html#cfn-bedrockagentcore-memory-timebasedtriggerinput-idlesessiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-timebasedtriggerinput.html#cfn-bedrockagentcore-memory-timebasedtriggerinput-idlesessiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIdleSessionTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeBasedTriggerInputProperty> {
            java.lang.Number idleSessionTimeout;

            /**
             * Sets the value of {@link TimeBasedTriggerInputProperty#getIdleSessionTimeout}
             * @param idleSessionTimeout The memory trigger condition input for the session timeout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleSessionTimeout(java.lang.Number idleSessionTimeout) {
                this.idleSessionTimeout = idleSessionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeBasedTriggerInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeBasedTriggerInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeBasedTriggerInputProperty {
            private final java.lang.Number idleSessionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleSessionTimeout = software.amazon.jsii.Kernel.get(this, "idleSessionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleSessionTimeout = builder.idleSessionTimeout;
            }

            @Override
            public final java.lang.Number getIdleSessionTimeout() {
                return this.idleSessionTimeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdleSessionTimeout() != null) {
                    data.set("idleSessionTimeout", om.valueToTree(this.getIdleSessionTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.TimeBasedTriggerInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeBasedTriggerInputProperty.Jsii$Proxy that = (TimeBasedTriggerInputProperty.Jsii$Proxy) o;

                return this.idleSessionTimeout != null ? this.idleSessionTimeout.equals(that.idleSessionTimeout) : that.idleSessionTimeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idleSessionTimeout != null ? this.idleSessionTimeout.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The token based trigger input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * TokenBasedTriggerInputProperty tokenBasedTriggerInputProperty = TokenBasedTriggerInputProperty.builder()
     *         .tokenCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-tokenbasedtriggerinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-tokenbasedtriggerinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.TokenBasedTriggerInputProperty")
    @software.amazon.jsii.Jsii.Proxy(TokenBasedTriggerInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TokenBasedTriggerInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The token based trigger token count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-tokenbasedtriggerinput.html#cfn-bedrockagentcore-memory-tokenbasedtriggerinput-tokencount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-tokenbasedtriggerinput.html#cfn-bedrockagentcore-memory-tokenbasedtriggerinput-tokencount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTokenCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TokenBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TokenBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TokenBasedTriggerInputProperty> {
            java.lang.Number tokenCount;

            /**
             * Sets the value of {@link TokenBasedTriggerInputProperty#getTokenCount}
             * @param tokenCount The token based trigger token count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenCount(java.lang.Number tokenCount) {
                this.tokenCount = tokenCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TokenBasedTriggerInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TokenBasedTriggerInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TokenBasedTriggerInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TokenBasedTriggerInputProperty {
            private final java.lang.Number tokenCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tokenCount = software.amazon.jsii.Kernel.get(this, "tokenCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tokenCount = builder.tokenCount;
            }

            @Override
            public final java.lang.Number getTokenCount() {
                return this.tokenCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTokenCount() != null) {
                    data.set("tokenCount", om.valueToTree(this.getTokenCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.TokenBasedTriggerInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TokenBasedTriggerInputProperty.Jsii$Proxy that = (TokenBasedTriggerInputProperty.Jsii$Proxy) o;

                return this.tokenCount != null ? this.tokenCount.equals(that.tokenCount) : that.tokenCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tokenCount != null ? this.tokenCount.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The memory trigger condition input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * TriggerConditionInputProperty triggerConditionInputProperty = TriggerConditionInputProperty.builder()
     *         .messageBasedTrigger(MessageBasedTriggerInputProperty.builder()
     *                 .messageCount(123)
     *                 .build())
     *         .timeBasedTrigger(TimeBasedTriggerInputProperty.builder()
     *                 .idleSessionTimeout(123)
     *                 .build())
     *         .tokenBasedTrigger(TokenBasedTriggerInputProperty.builder()
     *                 .tokenCount(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.TriggerConditionInputProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerConditionInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerConditionInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory trigger condition input for the message based trigger.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.MessageBasedTriggerInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html#cfn-bedrockagentcore-memory-triggerconditioninput-messagebasedtrigger">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html#cfn-bedrockagentcore-memory-triggerconditioninput-messagebasedtrigger</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMessageBasedTrigger() {
            return null;
        }

        /**
         * The memory trigger condition input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.TimeBasedTriggerInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html#cfn-bedrockagentcore-memory-triggerconditioninput-timebasedtrigger">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html#cfn-bedrockagentcore-memory-triggerconditioninput-timebasedtrigger</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeBasedTrigger() {
            return null;
        }

        /**
         * The trigger condition information for a token based trigger.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.TokenBasedTriggerInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html#cfn-bedrockagentcore-memory-triggerconditioninput-tokenbasedtrigger">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-triggerconditioninput.html#cfn-bedrockagentcore-memory-triggerconditioninput-tokenbasedtrigger</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTokenBasedTrigger() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerConditionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerConditionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerConditionInputProperty> {
            java.lang.Object messageBasedTrigger;
            java.lang.Object timeBasedTrigger;
            java.lang.Object tokenBasedTrigger;

            /**
             * Sets the value of {@link TriggerConditionInputProperty#getMessageBasedTrigger}
             * @param messageBasedTrigger The memory trigger condition input for the message based trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageBasedTrigger(software.amazon.awscdk.IResolvable messageBasedTrigger) {
                this.messageBasedTrigger = messageBasedTrigger;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConditionInputProperty#getMessageBasedTrigger}
             * @param messageBasedTrigger The memory trigger condition input for the message based trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageBasedTrigger(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.MessageBasedTriggerInputProperty messageBasedTrigger) {
                this.messageBasedTrigger = messageBasedTrigger;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConditionInputProperty#getTimeBasedTrigger}
             * @param timeBasedTrigger The memory trigger condition input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedTrigger(software.amazon.awscdk.IResolvable timeBasedTrigger) {
                this.timeBasedTrigger = timeBasedTrigger;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConditionInputProperty#getTimeBasedTrigger}
             * @param timeBasedTrigger The memory trigger condition input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedTrigger(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.TimeBasedTriggerInputProperty timeBasedTrigger) {
                this.timeBasedTrigger = timeBasedTrigger;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConditionInputProperty#getTokenBasedTrigger}
             * @param tokenBasedTrigger The trigger condition information for a token based trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenBasedTrigger(software.amazon.awscdk.IResolvable tokenBasedTrigger) {
                this.tokenBasedTrigger = tokenBasedTrigger;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConditionInputProperty#getTokenBasedTrigger}
             * @param tokenBasedTrigger The trigger condition information for a token based trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenBasedTrigger(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.TokenBasedTriggerInputProperty tokenBasedTrigger) {
                this.tokenBasedTrigger = tokenBasedTrigger;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConditionInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerConditionInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerConditionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerConditionInputProperty {
            private final java.lang.Object messageBasedTrigger;
            private final java.lang.Object timeBasedTrigger;
            private final java.lang.Object tokenBasedTrigger;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.messageBasedTrigger = software.amazon.jsii.Kernel.get(this, "messageBasedTrigger", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeBasedTrigger = software.amazon.jsii.Kernel.get(this, "timeBasedTrigger", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tokenBasedTrigger = software.amazon.jsii.Kernel.get(this, "tokenBasedTrigger", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.messageBasedTrigger = builder.messageBasedTrigger;
                this.timeBasedTrigger = builder.timeBasedTrigger;
                this.tokenBasedTrigger = builder.tokenBasedTrigger;
            }

            @Override
            public final java.lang.Object getMessageBasedTrigger() {
                return this.messageBasedTrigger;
            }

            @Override
            public final java.lang.Object getTimeBasedTrigger() {
                return this.timeBasedTrigger;
            }

            @Override
            public final java.lang.Object getTokenBasedTrigger() {
                return this.tokenBasedTrigger;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessageBasedTrigger() != null) {
                    data.set("messageBasedTrigger", om.valueToTree(this.getMessageBasedTrigger()));
                }
                if (this.getTimeBasedTrigger() != null) {
                    data.set("timeBasedTrigger", om.valueToTree(this.getTimeBasedTrigger()));
                }
                if (this.getTokenBasedTrigger() != null) {
                    data.set("tokenBasedTrigger", om.valueToTree(this.getTokenBasedTrigger()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.TriggerConditionInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerConditionInputProperty.Jsii$Proxy that = (TriggerConditionInputProperty.Jsii$Proxy) o;

                if (this.messageBasedTrigger != null ? !this.messageBasedTrigger.equals(that.messageBasedTrigger) : that.messageBasedTrigger != null) return false;
                if (this.timeBasedTrigger != null ? !this.timeBasedTrigger.equals(that.timeBasedTrigger) : that.timeBasedTrigger != null) return false;
                return this.tokenBasedTrigger != null ? this.tokenBasedTrigger.equals(that.tokenBasedTrigger) : that.tokenBasedTrigger == null;
            }

            @Override
            public final int hashCode() {
                int result = this.messageBasedTrigger != null ? this.messageBasedTrigger.hashCode() : 0;
                result = 31 * result + (this.timeBasedTrigger != null ? this.timeBasedTrigger.hashCode() : 0);
                result = 31 * result + (this.tokenBasedTrigger != null ? this.tokenBasedTrigger.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The memory strategy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * UserPreferenceMemoryStrategyProperty userPreferenceMemoryStrategyProperty = UserPreferenceMemoryStrategyProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .createdAt("createdAt")
     *         .description("description")
     *         .namespaces(List.of("namespaces"))
     *         .status("status")
     *         .strategyId("strategyId")
     *         .type("type")
     *         .updatedAt("updatedAt")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceMemoryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPreferenceMemoryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPreferenceMemoryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory strategy name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Creation timestamp of the memory strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-createdat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedAt() {
            return null;
        }

        /**
         * The memory strategy description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The memory namespaces.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-namespaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-namespaces</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNamespaces() {
            return null;
        }

        /**
         * The memory strategy status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The memory strategy ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-strategyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-strategyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStrategyId() {
            return null;
        }

        /**
         * The memory strategy type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The memory strategy update date and time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-updatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferencememorystrategy.html#cfn-bedrockagentcore-memory-userpreferencememorystrategy-updatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdatedAt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPreferenceMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPreferenceMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPreferenceMemoryStrategyProperty> {
            java.lang.String name;
            java.lang.String createdAt;
            java.lang.String description;
            java.util.List<java.lang.String> namespaces;
            java.lang.String status;
            java.lang.String strategyId;
            java.lang.String type;
            java.lang.String updatedAt;

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getName}
             * @param name The memory strategy name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getCreatedAt}
             * @param createdAt Creation timestamp of the memory strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.lang.String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getDescription}
             * @param description The memory strategy description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getNamespaces}
             * @param namespaces The memory namespaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaces(java.util.List<java.lang.String> namespaces) {
                this.namespaces = namespaces;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getStatus}
             * @param status The memory strategy status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getStrategyId}
             * @param strategyId The memory strategy ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strategyId(java.lang.String strategyId) {
                this.strategyId = strategyId;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getType}
             * @param type The memory strategy type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceMemoryStrategyProperty#getUpdatedAt}
             * @param updatedAt The memory strategy update date and time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(java.lang.String updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPreferenceMemoryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPreferenceMemoryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPreferenceMemoryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPreferenceMemoryStrategyProperty {
            private final java.lang.String name;
            private final java.lang.String createdAt;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> namespaces;
            private final java.lang.String status;
            private final java.lang.String strategyId;
            private final java.lang.String type;
            private final java.lang.String updatedAt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaces = software.amazon.jsii.Kernel.get(this, "namespaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.strategyId = software.amazon.jsii.Kernel.get(this, "strategyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updatedAt = software.amazon.jsii.Kernel.get(this, "updatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.createdAt = builder.createdAt;
                this.description = builder.description;
                this.namespaces = builder.namespaces;
                this.status = builder.status;
                this.strategyId = builder.strategyId;
                this.type = builder.type;
                this.updatedAt = builder.updatedAt;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getNamespaces() {
                return this.namespaces;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getStrategyId() {
                return this.strategyId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUpdatedAt() {
                return this.updatedAt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getNamespaces() != null) {
                    data.set("namespaces", om.valueToTree(this.getNamespaces()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getStrategyId() != null) {
                    data.set("strategyId", om.valueToTree(this.getStrategyId()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUpdatedAt() != null) {
                    data.set("updatedAt", om.valueToTree(this.getUpdatedAt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceMemoryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPreferenceMemoryStrategyProperty.Jsii$Proxy that = (UserPreferenceMemoryStrategyProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.strategyId != null ? !this.strategyId.equals(that.strategyId) : that.strategyId != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.updatedAt != null ? this.updatedAt.equals(that.updatedAt) : that.updatedAt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.namespaces != null ? this.namespaces.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.strategyId != null ? this.strategyId.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * UserPreferenceOverrideConsolidationConfigurationInputProperty userPreferenceOverrideConsolidationConfigurationInputProperty = UserPreferenceOverrideConsolidationConfigurationInputProperty.builder()
     *         .appendToPrompt("appendToPrompt")
     *         .modelId("modelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceOverrideConsolidationConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPreferenceOverrideConsolidationConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPreferenceOverrideConsolidationConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput-appendtoprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput-appendtoprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppendToPrompt();

        /**
         * The memory override configuration model ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideconsolidationconfigurationinput-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelId();

        /**
         * @return a {@link Builder} of {@link UserPreferenceOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPreferenceOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPreferenceOverrideConsolidationConfigurationInputProperty> {
            java.lang.String appendToPrompt;
            java.lang.String modelId;

            /**
             * Sets the value of {@link UserPreferenceOverrideConsolidationConfigurationInputProperty#getAppendToPrompt}
             * @param appendToPrompt The memory configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendToPrompt(java.lang.String appendToPrompt) {
                this.appendToPrompt = appendToPrompt;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceOverrideConsolidationConfigurationInputProperty#getModelId}
             * @param modelId The memory override configuration model ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPreferenceOverrideConsolidationConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPreferenceOverrideConsolidationConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPreferenceOverrideConsolidationConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPreferenceOverrideConsolidationConfigurationInputProperty {
            private final java.lang.String appendToPrompt;
            private final java.lang.String modelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appendToPrompt = software.amazon.jsii.Kernel.get(this, "appendToPrompt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appendToPrompt = java.util.Objects.requireNonNull(builder.appendToPrompt, "appendToPrompt is required");
                this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
            }

            @Override
            public final java.lang.String getAppendToPrompt() {
                return this.appendToPrompt;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appendToPrompt", om.valueToTree(this.getAppendToPrompt()));
                data.set("modelId", om.valueToTree(this.getModelId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceOverrideConsolidationConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPreferenceOverrideConsolidationConfigurationInputProperty.Jsii$Proxy that = (UserPreferenceOverrideConsolidationConfigurationInputProperty.Jsii$Proxy) o;

                if (!appendToPrompt.equals(that.appendToPrompt)) return false;
                return this.modelId.equals(that.modelId);
            }

            @Override
            public final int hashCode() {
                int result = this.appendToPrompt.hashCode();
                result = 31 * result + (this.modelId.hashCode());
                return result;
            }
        }
    }
    /**
     * The memory override configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * UserPreferenceOverrideExtractionConfigurationInputProperty userPreferenceOverrideExtractionConfigurationInputProperty = UserPreferenceOverrideExtractionConfigurationInputProperty.builder()
     *         .appendToPrompt("appendToPrompt")
     *         .modelId("modelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceOverrideExtractionConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPreferenceOverrideExtractionConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPreferenceOverrideExtractionConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The extraction configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput-appendtoprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput-appendtoprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppendToPrompt();

        /**
         * The memory override for the model ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput.html#cfn-bedrockagentcore-memory-userpreferenceoverrideextractionconfigurationinput-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelId();

        /**
         * @return a {@link Builder} of {@link UserPreferenceOverrideExtractionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPreferenceOverrideExtractionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPreferenceOverrideExtractionConfigurationInputProperty> {
            java.lang.String appendToPrompt;
            java.lang.String modelId;

            /**
             * Sets the value of {@link UserPreferenceOverrideExtractionConfigurationInputProperty#getAppendToPrompt}
             * @param appendToPrompt The extraction configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendToPrompt(java.lang.String appendToPrompt) {
                this.appendToPrompt = appendToPrompt;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceOverrideExtractionConfigurationInputProperty#getModelId}
             * @param modelId The memory override for the model ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPreferenceOverrideExtractionConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPreferenceOverrideExtractionConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPreferenceOverrideExtractionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPreferenceOverrideExtractionConfigurationInputProperty {
            private final java.lang.String appendToPrompt;
            private final java.lang.String modelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appendToPrompt = software.amazon.jsii.Kernel.get(this, "appendToPrompt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appendToPrompt = java.util.Objects.requireNonNull(builder.appendToPrompt, "appendToPrompt is required");
                this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
            }

            @Override
            public final java.lang.String getAppendToPrompt() {
                return this.appendToPrompt;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appendToPrompt", om.valueToTree(this.getAppendToPrompt()));
                data.set("modelId", om.valueToTree(this.getModelId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceOverrideExtractionConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPreferenceOverrideExtractionConfigurationInputProperty.Jsii$Proxy that = (UserPreferenceOverrideExtractionConfigurationInputProperty.Jsii$Proxy) o;

                if (!appendToPrompt.equals(that.appendToPrompt)) return false;
                return this.modelId.equals(that.modelId);
            }

            @Override
            public final int hashCode() {
                int result = this.appendToPrompt.hashCode();
                result = 31 * result + (this.modelId.hashCode());
                return result;
            }
        }
    }
    /**
     * The memory user preference override.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * UserPreferenceOverrideProperty userPreferenceOverrideProperty = UserPreferenceOverrideProperty.builder()
     *         .consolidation(UserPreferenceOverrideConsolidationConfigurationInputProperty.builder()
     *                 .appendToPrompt("appendToPrompt")
     *                 .modelId("modelId")
     *                 .build())
     *         .extraction(UserPreferenceOverrideExtractionConfigurationInputProperty.builder()
     *                 .appendToPrompt("appendToPrompt")
     *                 .modelId("modelId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPreferenceOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPreferenceOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The memory override consolidation information.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceOverrideConsolidationConfigurationInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverride.html#cfn-bedrockagentcore-memory-userpreferenceoverride-consolidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverride.html#cfn-bedrockagentcore-memory-userpreferenceoverride-consolidation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConsolidation() {
            return null;
        }

        /**
         * The memory user preferences for extraction.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceOverrideExtractionConfigurationInputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverride.html#cfn-bedrockagentcore-memory-userpreferenceoverride-extraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-memory-userpreferenceoverride.html#cfn-bedrockagentcore-memory-userpreferenceoverride-extraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPreferenceOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPreferenceOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPreferenceOverrideProperty> {
            java.lang.Object consolidation;
            java.lang.Object extraction;

            /**
             * Sets the value of {@link UserPreferenceOverrideProperty#getConsolidation}
             * @param consolidation The memory override consolidation information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.IResolvable consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceOverrideProperty#getConsolidation}
             * @param consolidation The memory override consolidation information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consolidation(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceOverrideConsolidationConfigurationInputProperty consolidation) {
                this.consolidation = consolidation;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceOverrideProperty#getExtraction}
             * @param extraction The memory user preferences for extraction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.IResolvable extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link UserPreferenceOverrideProperty#getExtraction}
             * @param extraction The memory user preferences for extraction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.services.bedrockagentcore.CfnMemory.UserPreferenceOverrideExtractionConfigurationInputProperty extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPreferenceOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPreferenceOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPreferenceOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPreferenceOverrideProperty {
            private final java.lang.Object consolidation;
            private final java.lang.Object extraction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.consolidation = software.amazon.jsii.Kernel.get(this, "consolidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extraction = software.amazon.jsii.Kernel.get(this, "extraction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.consolidation = builder.consolidation;
                this.extraction = builder.extraction;
            }

            @Override
            public final java.lang.Object getConsolidation() {
                return this.consolidation;
            }

            @Override
            public final java.lang.Object getExtraction() {
                return this.extraction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConsolidation() != null) {
                    data.set("consolidation", om.valueToTree(this.getConsolidation()));
                }
                if (this.getExtraction() != null) {
                    data.set("extraction", om.valueToTree(this.getExtraction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemory.UserPreferenceOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPreferenceOverrideProperty.Jsii$Proxy that = (UserPreferenceOverrideProperty.Jsii$Proxy) o;

                if (this.consolidation != null ? !this.consolidation.equals(that.consolidation) : that.consolidation != null) return false;
                return this.extraction != null ? this.extraction.equals(that.extraction) : that.extraction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.consolidation != null ? this.consolidation.hashCode() : 0;
                result = 31 * result + (this.extraction != null ? this.extraction.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrockagentcore.CfnMemory> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrockagentcore.CfnMemoryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrockagentcore.CfnMemoryProps.Builder();
        }

        /**
         * The event expiry configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-eventexpiryduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-eventexpiryduration</a>
         * @param eventExpiryDuration The event expiry configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventExpiryDuration(final java.lang.Number eventExpiryDuration) {
            this.props.eventExpiryDuration(eventExpiryDuration);
            return this;
        }

        /**
         * The memory name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-name</a>
         * @param name The memory name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Description of the Memory resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-description</a>
         * @param description Description of the Memory resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The memory encryption key Amazon Resource Name (ARN).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-encryptionkeyarn</a>
         * @param encryptionKeyArn The memory encryption key Amazon Resource Name (ARN). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKeyArn(final java.lang.String encryptionKeyArn) {
            this.props.encryptionKeyArn(encryptionKeyArn);
            return this;
        }

        /**
         * The memory role ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memoryexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memoryexecutionrolearn</a>
         * @param memoryExecutionRoleArn The memory role ARN. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryExecutionRoleArn(final java.lang.String memoryExecutionRoleArn) {
            this.props.memoryExecutionRoleArn(memoryExecutionRoleArn);
            return this;
        }

        /**
         * The memory strategies.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memorystrategies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memorystrategies</a>
         * @param memoryStrategies The memory strategies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryStrategies(final software.amazon.awscdk.IResolvable memoryStrategies) {
            this.props.memoryStrategies(memoryStrategies);
            return this;
        }
        /**
         * The memory strategies.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memorystrategies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memorystrategies</a>
         * @param memoryStrategies The memory strategies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryStrategies(final java.util.List<? extends java.lang.Object> memoryStrategies) {
            this.props.memoryStrategies(memoryStrategies);
            return this;
        }

        /**
         * The tags for the resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-tags</a>
         * @param tags The tags for the resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrockagentcore.CfnMemory build() {
            return new software.amazon.awscdk.services.bedrockagentcore.CfnMemory(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
