package software.amazon.awscdk.services.cleanrooms;

/**
 * Properties for defining a <code>CfnCollaboration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnCollaborationProps cfnCollaborationProps = CfnCollaborationProps.builder()
 *         .creatorDisplayName("creatorDisplayName")
 *         .description("description")
 *         .name("name")
 *         .queryLogStatus("queryLogStatus")
 *         // the properties below are optional
 *         .allowedResultRegions(List.of("allowedResultRegions"))
 *         .analyticsEngine("analyticsEngine")
 *         .autoApprovedChangeTypes(List.of("autoApprovedChangeTypes"))
 *         .creatorMemberAbilities(List.of("creatorMemberAbilities"))
 *         .creatorMlMemberAbilities(MLMemberAbilitiesProperty.builder()
 *                 .customMlMemberAbilities(List.of("customMlMemberAbilities"))
 *                 .build())
 *         .creatorPaymentConfiguration(PaymentConfigurationProperty.builder()
 *                 .queryCompute(QueryComputePaymentConfigProperty.builder()
 *                         .isResponsible(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .jobCompute(JobComputePaymentConfigProperty.builder()
 *                         .isResponsible(false)
 *                         .build())
 *                 .machineLearning(MLPaymentConfigProperty.builder()
 *                         .modelInference(ModelInferencePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .modelTraining(ModelTrainingPaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .dataEncryptionMetadata(DataEncryptionMetadataProperty.builder()
 *                 .allowCleartext(false)
 *                 .allowDuplicates(false)
 *                 .allowJoinsOnColumnsWithDifferentNames(false)
 *                 .preserveNulls(false)
 *                 .build())
 *         .jobLogStatus("jobLogStatus")
 *         .members(List.of(MemberSpecificationProperty.builder()
 *                 .accountId("accountId")
 *                 .displayName("displayName")
 *                 // the properties below are optional
 *                 .memberAbilities(List.of("memberAbilities"))
 *                 .mlMemberAbilities(MLMemberAbilitiesProperty.builder()
 *                         .customMlMemberAbilities(List.of("customMlMemberAbilities"))
 *                         .build())
 *                 .paymentConfiguration(PaymentConfigurationProperty.builder()
 *                         .queryCompute(QueryComputePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .jobCompute(JobComputePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .machineLearning(MLPaymentConfigProperty.builder()
 *                                 .modelInference(ModelInferencePaymentConfigProperty.builder()
 *                                         .isResponsible(false)
 *                                         .build())
 *                                 .modelTraining(ModelTrainingPaymentConfigProperty.builder()
 *                                         .isResponsible(false)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.756Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaborationProps")
@software.amazon.jsii.Jsii.Proxy(CfnCollaborationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCollaborationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A display name of the collaboration creator.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCreatorDisplayName();

    /**
     * A description of the collaboration provided by the collaboration owner.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * A human-readable identifier provided by the collaboration owner.
     * <p>
     * Display names are not unique.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     * <p>
     * When <code>ENABLED</code> , AWS Clean Rooms logs details about queries run within this collaboration and those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryLogStatus();

    /**
     * The AWS Regions where collaboration query results can be stored.
     * <p>
     * Returns the list of Region identifiers that were specified when the collaboration was created. This list is used to enforce regional storage policies and compliance requirements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-allowedresultregions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-allowedresultregions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedResultRegions() {
        return null;
    }

    /**
     * The analytics engine for the collaboration.
     * <p>
     * <blockquote>
     * <p>
     * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-analyticsengine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-analyticsengine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAnalyticsEngine() {
        return null;
    }

    /**
     * The types of change requests that are automatically approved for this collaboration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-autoapprovedchangetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-autoapprovedchangetypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoApprovedChangeTypes() {
        return null;
    }

    /**
     * The abilities granted to the collaboration creator.
     * <p>
     * <em>Allowed values</em> <code>CAN_QUERY</code> | <code>CAN_RECEIVE_RESULTS</code> | <code>CAN_RUN_JOB</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCreatorMemberAbilities() {
        return null;
    }

    /**
     * The ML member abilities for a collaboration member.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MLMemberAbilitiesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormlmemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormlmemberabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreatorMlMemberAbilities() {
        return null;
    }

    /**
     * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cleanrooms.CfnCollaboration.PaymentConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreatorPaymentConfiguration() {
        return null;
    }

    /**
     * The settings for client-side encryption for cryptographic computing.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cleanrooms.CfnCollaboration.DataEncryptionMetadataProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataEncryptionMetadata() {
        return null;
    }

    /**
     * An indicator as to whether job logging has been enabled or disabled for the collaboration.
     * <p>
     * When <code>ENABLED</code> , AWS Clean Rooms logs details about jobs run within this collaboration and those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-joblogstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-joblogstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobLogStatus() {
        return null;
    }

    /**
     * A list of initial members, not including the creator.
     * <p>
     * This list is immutable.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MemberSpecificationProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMembers() {
        return null;
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCollaborationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCollaborationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCollaborationProps> {
        java.lang.String creatorDisplayName;
        java.lang.String description;
        java.lang.String name;
        java.lang.String queryLogStatus;
        java.util.List<java.lang.String> allowedResultRegions;
        java.lang.String analyticsEngine;
        java.util.List<java.lang.String> autoApprovedChangeTypes;
        java.util.List<java.lang.String> creatorMemberAbilities;
        java.lang.Object creatorMlMemberAbilities;
        java.lang.Object creatorPaymentConfiguration;
        java.lang.Object dataEncryptionMetadata;
        java.lang.String jobLogStatus;
        java.lang.Object members;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorDisplayName}
         * @param creatorDisplayName A display name of the collaboration creator. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorDisplayName(java.lang.String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getDescription}
         * @param description A description of the collaboration provided by the collaboration owner. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getName}
         * @param name A human-readable identifier provided by the collaboration owner. This parameter is required.
         *             Display names are not unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getQueryLogStatus}
         * @param queryLogStatus An indicator as to whether query logging has been enabled or disabled for the collaboration. This parameter is required.
         *                       When <code>ENABLED</code> , AWS Clean Rooms logs details about queries run within this collaboration and those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogStatus(java.lang.String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getAllowedResultRegions}
         * @param allowedResultRegions The AWS Regions where collaboration query results can be stored.
         *                             Returns the list of Region identifiers that were specified when the collaboration was created. This list is used to enforce regional storage policies and compliance requirements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedResultRegions(java.util.List<java.lang.String> allowedResultRegions) {
            this.allowedResultRegions = allowedResultRegions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getAnalyticsEngine}
         * @param analyticsEngine The analytics engine for the collaboration.
         *                        <blockquote>
         *                        <p>
         *                        After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsEngine(java.lang.String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getAutoApprovedChangeTypes}
         * @param autoApprovedChangeTypes The types of change requests that are automatically approved for this collaboration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoApprovedChangeTypes(java.util.List<java.lang.String> autoApprovedChangeTypes) {
            this.autoApprovedChangeTypes = autoApprovedChangeTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorMemberAbilities}
         * @param creatorMemberAbilities The abilities granted to the collaboration creator.
         *                               <em>Allowed values</em> <code>CAN_QUERY</code> | <code>CAN_RECEIVE_RESULTS</code> | <code>CAN_RUN_JOB</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorMemberAbilities(java.util.List<java.lang.String> creatorMemberAbilities) {
            this.creatorMemberAbilities = creatorMemberAbilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorMlMemberAbilities}
         * @param creatorMlMemberAbilities The ML member abilities for a collaboration member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorMlMemberAbilities(software.amazon.awscdk.IResolvable creatorMlMemberAbilities) {
            this.creatorMlMemberAbilities = creatorMlMemberAbilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorMlMemberAbilities}
         * @param creatorMlMemberAbilities The ML member abilities for a collaboration member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorMlMemberAbilities(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MLMemberAbilitiesProperty creatorMlMemberAbilities) {
            this.creatorMlMemberAbilities = creatorMlMemberAbilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorPaymentConfiguration}
         * @param creatorPaymentConfiguration An object representing the collaboration member's payment responsibilities set by the collaboration creator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorPaymentConfiguration(software.amazon.awscdk.IResolvable creatorPaymentConfiguration) {
            this.creatorPaymentConfiguration = creatorPaymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorPaymentConfiguration}
         * @param creatorPaymentConfiguration An object representing the collaboration member's payment responsibilities set by the collaboration creator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorPaymentConfiguration(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.PaymentConfigurationProperty creatorPaymentConfiguration) {
            this.creatorPaymentConfiguration = creatorPaymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getDataEncryptionMetadata}
         * @param dataEncryptionMetadata The settings for client-side encryption for cryptographic computing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataEncryptionMetadata(software.amazon.awscdk.IResolvable dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getDataEncryptionMetadata}
         * @param dataEncryptionMetadata The settings for client-side encryption for cryptographic computing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataEncryptionMetadata(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.DataEncryptionMetadataProperty dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getJobLogStatus}
         * @param jobLogStatus An indicator as to whether job logging has been enabled or disabled for the collaboration.
         *                     When <code>ENABLED</code> , AWS Clean Rooms logs details about jobs run within this collaboration and those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobLogStatus(java.lang.String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getMembers}
         * @param members A list of initial members, not including the creator.
         *                This list is immutable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(software.amazon.awscdk.IResolvable members) {
            this.members = members;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getMembers}
         * @param members A list of initial members, not including the creator.
         *                This list is immutable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(java.util.List<? extends java.lang.Object> members) {
            this.members = members;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getTags}
         * @param tags An optional label that you can assign to a resource when you create it.
         *             Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCollaborationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCollaborationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCollaborationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCollaborationProps {
        private final java.lang.String creatorDisplayName;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.String queryLogStatus;
        private final java.util.List<java.lang.String> allowedResultRegions;
        private final java.lang.String analyticsEngine;
        private final java.util.List<java.lang.String> autoApprovedChangeTypes;
        private final java.util.List<java.lang.String> creatorMemberAbilities;
        private final java.lang.Object creatorMlMemberAbilities;
        private final java.lang.Object creatorPaymentConfiguration;
        private final java.lang.Object dataEncryptionMetadata;
        private final java.lang.String jobLogStatus;
        private final java.lang.Object members;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.creatorDisplayName = software.amazon.jsii.Kernel.get(this, "creatorDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLogStatus = software.amazon.jsii.Kernel.get(this, "queryLogStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowedResultRegions = software.amazon.jsii.Kernel.get(this, "allowedResultRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.analyticsEngine = software.amazon.jsii.Kernel.get(this, "analyticsEngine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoApprovedChangeTypes = software.amazon.jsii.Kernel.get(this, "autoApprovedChangeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.creatorMemberAbilities = software.amazon.jsii.Kernel.get(this, "creatorMemberAbilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.creatorMlMemberAbilities = software.amazon.jsii.Kernel.get(this, "creatorMlMemberAbilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.creatorPaymentConfiguration = software.amazon.jsii.Kernel.get(this, "creatorPaymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataEncryptionMetadata = software.amazon.jsii.Kernel.get(this, "dataEncryptionMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobLogStatus = software.amazon.jsii.Kernel.get(this, "jobLogStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.members = software.amazon.jsii.Kernel.get(this, "members", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.creatorDisplayName = java.util.Objects.requireNonNull(builder.creatorDisplayName, "creatorDisplayName is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.queryLogStatus = java.util.Objects.requireNonNull(builder.queryLogStatus, "queryLogStatus is required");
            this.allowedResultRegions = builder.allowedResultRegions;
            this.analyticsEngine = builder.analyticsEngine;
            this.autoApprovedChangeTypes = builder.autoApprovedChangeTypes;
            this.creatorMemberAbilities = builder.creatorMemberAbilities;
            this.creatorMlMemberAbilities = builder.creatorMlMemberAbilities;
            this.creatorPaymentConfiguration = builder.creatorPaymentConfiguration;
            this.dataEncryptionMetadata = builder.dataEncryptionMetadata;
            this.jobLogStatus = builder.jobLogStatus;
            this.members = builder.members;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCreatorDisplayName() {
            return this.creatorDisplayName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedResultRegions() {
            return this.allowedResultRegions;
        }

        @Override
        public final java.lang.String getAnalyticsEngine() {
            return this.analyticsEngine;
        }

        @Override
        public final java.util.List<java.lang.String> getAutoApprovedChangeTypes() {
            return this.autoApprovedChangeTypes;
        }

        @Override
        public final java.util.List<java.lang.String> getCreatorMemberAbilities() {
            return this.creatorMemberAbilities;
        }

        @Override
        public final java.lang.Object getCreatorMlMemberAbilities() {
            return this.creatorMlMemberAbilities;
        }

        @Override
        public final java.lang.Object getCreatorPaymentConfiguration() {
            return this.creatorPaymentConfiguration;
        }

        @Override
        public final java.lang.Object getDataEncryptionMetadata() {
            return this.dataEncryptionMetadata;
        }

        @Override
        public final java.lang.String getJobLogStatus() {
            return this.jobLogStatus;
        }

        @Override
        public final java.lang.Object getMembers() {
            return this.members;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("creatorDisplayName", om.valueToTree(this.getCreatorDisplayName()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("queryLogStatus", om.valueToTree(this.getQueryLogStatus()));
            if (this.getAllowedResultRegions() != null) {
                data.set("allowedResultRegions", om.valueToTree(this.getAllowedResultRegions()));
            }
            if (this.getAnalyticsEngine() != null) {
                data.set("analyticsEngine", om.valueToTree(this.getAnalyticsEngine()));
            }
            if (this.getAutoApprovedChangeTypes() != null) {
                data.set("autoApprovedChangeTypes", om.valueToTree(this.getAutoApprovedChangeTypes()));
            }
            if (this.getCreatorMemberAbilities() != null) {
                data.set("creatorMemberAbilities", om.valueToTree(this.getCreatorMemberAbilities()));
            }
            if (this.getCreatorMlMemberAbilities() != null) {
                data.set("creatorMlMemberAbilities", om.valueToTree(this.getCreatorMlMemberAbilities()));
            }
            if (this.getCreatorPaymentConfiguration() != null) {
                data.set("creatorPaymentConfiguration", om.valueToTree(this.getCreatorPaymentConfiguration()));
            }
            if (this.getDataEncryptionMetadata() != null) {
                data.set("dataEncryptionMetadata", om.valueToTree(this.getDataEncryptionMetadata()));
            }
            if (this.getJobLogStatus() != null) {
                data.set("jobLogStatus", om.valueToTree(this.getJobLogStatus()));
            }
            if (this.getMembers() != null) {
                data.set("members", om.valueToTree(this.getMembers()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaborationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCollaborationProps.Jsii$Proxy that = (CfnCollaborationProps.Jsii$Proxy) o;

            if (!creatorDisplayName.equals(that.creatorDisplayName)) return false;
            if (!description.equals(that.description)) return false;
            if (!name.equals(that.name)) return false;
            if (!queryLogStatus.equals(that.queryLogStatus)) return false;
            if (this.allowedResultRegions != null ? !this.allowedResultRegions.equals(that.allowedResultRegions) : that.allowedResultRegions != null) return false;
            if (this.analyticsEngine != null ? !this.analyticsEngine.equals(that.analyticsEngine) : that.analyticsEngine != null) return false;
            if (this.autoApprovedChangeTypes != null ? !this.autoApprovedChangeTypes.equals(that.autoApprovedChangeTypes) : that.autoApprovedChangeTypes != null) return false;
            if (this.creatorMemberAbilities != null ? !this.creatorMemberAbilities.equals(that.creatorMemberAbilities) : that.creatorMemberAbilities != null) return false;
            if (this.creatorMlMemberAbilities != null ? !this.creatorMlMemberAbilities.equals(that.creatorMlMemberAbilities) : that.creatorMlMemberAbilities != null) return false;
            if (this.creatorPaymentConfiguration != null ? !this.creatorPaymentConfiguration.equals(that.creatorPaymentConfiguration) : that.creatorPaymentConfiguration != null) return false;
            if (this.dataEncryptionMetadata != null ? !this.dataEncryptionMetadata.equals(that.dataEncryptionMetadata) : that.dataEncryptionMetadata != null) return false;
            if (this.jobLogStatus != null ? !this.jobLogStatus.equals(that.jobLogStatus) : that.jobLogStatus != null) return false;
            if (this.members != null ? !this.members.equals(that.members) : that.members != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.creatorDisplayName.hashCode();
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.queryLogStatus.hashCode());
            result = 31 * result + (this.allowedResultRegions != null ? this.allowedResultRegions.hashCode() : 0);
            result = 31 * result + (this.analyticsEngine != null ? this.analyticsEngine.hashCode() : 0);
            result = 31 * result + (this.autoApprovedChangeTypes != null ? this.autoApprovedChangeTypes.hashCode() : 0);
            result = 31 * result + (this.creatorMemberAbilities != null ? this.creatorMemberAbilities.hashCode() : 0);
            result = 31 * result + (this.creatorMlMemberAbilities != null ? this.creatorMlMemberAbilities.hashCode() : 0);
            result = 31 * result + (this.creatorPaymentConfiguration != null ? this.creatorPaymentConfiguration.hashCode() : 0);
            result = 31 * result + (this.dataEncryptionMetadata != null ? this.dataEncryptionMetadata.hashCode() : 0);
            result = 31 * result + (this.jobLogStatus != null ? this.jobLogStatus.hashCode() : 0);
            result = 31 * result + (this.members != null ? this.members.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
