package software.amazon.awscdk.services.cloudfront;

/**
 * A cache policy.
 * <p>
 * When it's attached to a cache behavior, the cache policy determines the following:
 * <p>
 * <ul>
 * <li>The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.</li>
 * <li>The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.</li>
 * </ul>
 * <p>
 * The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but <em>not</em> include them in the cache key, use <code>OriginRequestPolicy</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnCachePolicy cfnCachePolicy = CfnCachePolicy.Builder.create(this, "MyCfnCachePolicy")
 *         .cachePolicyConfig(CachePolicyConfigProperty.builder()
 *                 .defaultTtl(123)
 *                 .maxTtl(123)
 *                 .minTtl(123)
 *                 .name("name")
 *                 .parametersInCacheKeyAndForwardedToOrigin(ParametersInCacheKeyAndForwardedToOriginProperty.builder()
 *                         .cookiesConfig(CookiesConfigProperty.builder()
 *                                 .cookieBehavior("cookieBehavior")
 *                                 // the properties below are optional
 *                                 .cookies(List.of("cookies"))
 *                                 .build())
 *                         .enableAcceptEncodingGzip(false)
 *                         .headersConfig(HeadersConfigProperty.builder()
 *                                 .headerBehavior("headerBehavior")
 *                                 // the properties below are optional
 *                                 .headers(List.of("headers"))
 *                                 .build())
 *                         .queryStringsConfig(QueryStringsConfigProperty.builder()
 *                                 .queryStringBehavior("queryStringBehavior")
 *                                 // the properties below are optional
 *                                 .queryStrings(List.of("queryStrings"))
 *                                 .build())
 *                         // the properties below are optional
 *                         .enableAcceptEncodingBrotli(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:46.930Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy")
public class CfnCachePolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.cloudfront.ICachePolicyRef {

    protected CfnCachePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCachePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::CloudFront::CachePolicy</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCachePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnCachePolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier for the cache policy.
     * <p>
     * For example: <code>2766f7b2-75c5-41c6-8f06-bf4303a2f2f5</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the cache policy was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A reference to a CachePolicy resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.cloudfront.CachePolicyReference getCachePolicyRef() {
        return software.amazon.jsii.Kernel.get(this, "cachePolicyRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.cloudfront.CachePolicyReference.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The cache policy configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CachePolicyConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCachePolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "cachePolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The cache policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCachePolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cachePolicyConfig", java.util.Objects.requireNonNull(value, "cachePolicyConfig is required"));
    }

    /**
     * The cache policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCachePolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CachePolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "cachePolicyConfig", java.util.Objects.requireNonNull(value, "cachePolicyConfig is required"));
    }
    /**
     * A cache policy configuration.
     * <p>
     * This configuration determines the following:
     * <p>
     * <ul>
     * <li>The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.</li>
     * <li>The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If your minimum TTL is greater than 0, CloudFront will cache content for at least the duration specified in the cache policy's minimum TTL, even if the <code>Cache-Control: no-cache</code> , <code>no-store</code> , or <code>private</code> directives are present in the origin headers.
     * <p>
     * </blockquote>
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but <em>not</em> include them in the cache key, use <code>OriginRequestPolicy</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CachePolicyConfigProperty cachePolicyConfigProperty = CachePolicyConfigProperty.builder()
     *         .defaultTtl(123)
     *         .maxTtl(123)
     *         .minTtl(123)
     *         .name("name")
     *         .parametersInCacheKeyAndForwardedToOrigin(ParametersInCacheKeyAndForwardedToOriginProperty.builder()
     *                 .cookiesConfig(CookiesConfigProperty.builder()
     *                         .cookieBehavior("cookieBehavior")
     *                         // the properties below are optional
     *                         .cookies(List.of("cookies"))
     *                         .build())
     *                 .enableAcceptEncodingGzip(false)
     *                 .headersConfig(HeadersConfigProperty.builder()
     *                         .headerBehavior("headerBehavior")
     *                         // the properties below are optional
     *                         .headers(List.of("headers"))
     *                         .build())
     *                 .queryStringsConfig(QueryStringsConfigProperty.builder()
     *                         .queryStringBehavior("queryStringBehavior")
     *                         // the properties below are optional
     *                         .queryStrings(List.of("queryStrings"))
     *                         .build())
     *                 // the properties below are optional
     *                 .enableAcceptEncodingBrotli(false)
     *                 .build())
     *         // the properties below are optional
     *         .comment("comment")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CachePolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CachePolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CachePolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
         * <p>
         * CloudFront uses this value as the object's time to live (TTL) only when the origin does <em>not</em> send <code>Cache-Control</code> or <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The default value for this field is 86400 seconds (one day). If the value of <code>MinTTL</code> is more than 86400 seconds, then the default value for this field is the same as the value of <code>MinTTL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-defaultttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-defaultttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDefaultTtl();

        /**
         * The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
         * <p>
         * CloudFront uses this value only when the origin sends <code>Cache-Control</code> or <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The default value for this field is 31536000 seconds (one year). If the value of <code>MinTTL</code> or <code>DefaultTTL</code> is more than 31536000 seconds, then the default value for this field is the same as the value of <code>DefaultTTL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-maxttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-maxttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTtl();

        /**
         * The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-minttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-minttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinTtl();

        /**
         * A unique name to identify the cache policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The HTTP headers, cookies, and URL query strings to include in the cache key.
         * <p>
         * The values included in the cache key are also included in requests that CloudFront sends to the origin.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-parametersincachekeyandforwardedtoorigin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-parametersincachekeyandforwardedtoorigin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getParametersInCacheKeyAndForwardedToOrigin();

        /**
         * A comment to describe the cache policy.
         * <p>
         * The comment cannot be longer than 128 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CachePolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CachePolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CachePolicyConfigProperty> {
            java.lang.Number defaultTtl;
            java.lang.Number maxTtl;
            java.lang.Number minTtl;
            java.lang.String name;
            java.lang.Object parametersInCacheKeyAndForwardedToOrigin;
            java.lang.String comment;

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getDefaultTtl}
             * @param defaultTtl The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. This parameter is required.
             *                   CloudFront uses this value as the object's time to live (TTL) only when the origin does <em>not</em> send <code>Cache-Control</code> or <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                   <p>
             *                   The default value for this field is 86400 seconds (one day). If the value of <code>MinTTL</code> is more than 86400 seconds, then the default value for this field is the same as the value of <code>MinTTL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getMaxTtl}
             * @param maxTtl The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. This parameter is required.
             *               CloudFront uses this value only when the origin sends <code>Cache-Control</code> or <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *               <p>
             *               The default value for this field is 31536000 seconds (one year). If the value of <code>MinTTL</code> or <code>DefaultTTL</code> is more than 31536000 seconds, then the default value for this field is the same as the value of <code>DefaultTTL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getMinTtl}
             * @param minTtl The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. This parameter is required.
             *               For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getName}
             * @param name A unique name to identify the cache policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getParametersInCacheKeyAndForwardedToOrigin}
             * @param parametersInCacheKeyAndForwardedToOrigin The HTTP headers, cookies, and URL query strings to include in the cache key. This parameter is required.
             *                                                 The values included in the cache key are also included in requests that CloudFront sends to the origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parametersInCacheKeyAndForwardedToOrigin(software.amazon.awscdk.IResolvable parametersInCacheKeyAndForwardedToOrigin) {
                this.parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getParametersInCacheKeyAndForwardedToOrigin}
             * @param parametersInCacheKeyAndForwardedToOrigin The HTTP headers, cookies, and URL query strings to include in the cache key. This parameter is required.
             *                                                 The values included in the cache key are also included in requests that CloudFront sends to the origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parametersInCacheKeyAndForwardedToOrigin(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty parametersInCacheKeyAndForwardedToOrigin) {
                this.parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin;
                return this;
            }

            /**
             * Sets the value of {@link CachePolicyConfigProperty#getComment}
             * @param comment A comment to describe the cache policy.
             *                The comment cannot be longer than 128 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CachePolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CachePolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CachePolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CachePolicyConfigProperty {
            private final java.lang.Number defaultTtl;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String name;
            private final java.lang.Object parametersInCacheKeyAndForwardedToOrigin;
            private final java.lang.String comment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parametersInCacheKeyAndForwardedToOrigin = software.amazon.jsii.Kernel.get(this, "parametersInCacheKeyAndForwardedToOrigin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultTtl = java.util.Objects.requireNonNull(builder.defaultTtl, "defaultTtl is required");
                this.maxTtl = java.util.Objects.requireNonNull(builder.maxTtl, "maxTtl is required");
                this.minTtl = java.util.Objects.requireNonNull(builder.minTtl, "minTtl is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.parametersInCacheKeyAndForwardedToOrigin = java.util.Objects.requireNonNull(builder.parametersInCacheKeyAndForwardedToOrigin, "parametersInCacheKeyAndForwardedToOrigin is required");
                this.comment = builder.comment;
            }

            @Override
            public final java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public final java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public final java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getParametersInCacheKeyAndForwardedToOrigin() {
                return this.parametersInCacheKeyAndForwardedToOrigin;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                data.set("minTtl", om.valueToTree(this.getMinTtl()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("parametersInCacheKeyAndForwardedToOrigin", om.valueToTree(this.getParametersInCacheKeyAndForwardedToOrigin()));
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CachePolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CachePolicyConfigProperty.Jsii$Proxy that = (CachePolicyConfigProperty.Jsii$Proxy) o;

                if (!defaultTtl.equals(that.defaultTtl)) return false;
                if (!maxTtl.equals(that.maxTtl)) return false;
                if (!minTtl.equals(that.minTtl)) return false;
                if (!name.equals(that.name)) return false;
                if (!parametersInCacheKeyAndForwardedToOrigin.equals(that.parametersInCacheKeyAndForwardedToOrigin)) return false;
                return this.comment != null ? this.comment.equals(that.comment) : that.comment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultTtl.hashCode();
                result = 31 * result + (this.maxTtl.hashCode());
                result = 31 * result + (this.minTtl.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.parametersInCacheKeyAndForwardedToOrigin.hashCode());
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CookiesConfigProperty cookiesConfigProperty = CookiesConfigProperty.builder()
     *         .cookieBehavior("cookieBehavior")
     *         // the properties below are optional
     *         .cookies(List.of("cookies"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CookiesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>none</code> – No cookies in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any cookies that are listed in an <code>OriginRequestPolicy</code> <em>are</em> included in origin requests.</li>
         * <li><code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code> type are included in the cache key and in requests that CloudFront sends to the origin.</li>
         * <li><code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, <strong>except</strong> for those that are listed in the <code>CookieNames</code> type, which are not included.</li>
         * <li><code>all</code> – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html#cfn-cloudfront-cachepolicy-cookiesconfig-cookiebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html#cfn-cloudfront-cachepolicy-cookiesconfig-cookiebehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCookieBehavior();

        /**
         * Contains a list of cookie names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html#cfn-cloudfront-cachepolicy-cookiesconfig-cookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html#cfn-cloudfront-cachepolicy-cookiesconfig-cookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCookies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesConfigProperty> {
            java.lang.String cookieBehavior;
            java.util.List<java.lang.String> cookies;

            /**
             * Sets the value of {@link CookiesConfigProperty#getCookieBehavior}
             * @param cookieBehavior Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             *                       Valid values are:
             *                       <p>
             *                       <ul>
             *                       <li><code>none</code> – No cookies in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any cookies that are listed in an <code>OriginRequestPolicy</code> <em>are</em> included in origin requests.</li>
             *                       <li><code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code> type are included in the cache key and in requests that CloudFront sends to the origin.</li>
             *                       <li><code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, <strong>except</strong> for those that are listed in the <code>CookieNames</code> type, which are not included.</li>
             *                       <li><code>all</code> – All cookies in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookieBehavior(java.lang.String cookieBehavior) {
                this.cookieBehavior = cookieBehavior;
                return this;
            }

            /**
             * Sets the value of {@link CookiesConfigProperty#getCookies}
             * @param cookies Contains a list of cookie names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(java.util.List<java.lang.String> cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesConfigProperty {
            private final java.lang.String cookieBehavior;
            private final java.util.List<java.lang.String> cookies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookieBehavior = software.amazon.jsii.Kernel.get(this, "cookieBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cookies = software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookieBehavior = java.util.Objects.requireNonNull(builder.cookieBehavior, "cookieBehavior is required");
                this.cookies = builder.cookies;
            }

            @Override
            public final java.lang.String getCookieBehavior() {
                return this.cookieBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getCookies() {
                return this.cookies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookieBehavior", om.valueToTree(this.getCookieBehavior()));
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.CookiesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesConfigProperty.Jsii$Proxy that = (CookiesConfigProperty.Jsii$Proxy) o;

                if (!cookieBehavior.equals(that.cookieBehavior)) return false;
                return this.cookies != null ? this.cookies.equals(that.cookies) : that.cookies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cookieBehavior.hashCode();
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * HeadersConfigProperty headersConfigProperty = HeadersConfigProperty.builder()
     *         .headerBehavior("headerBehavior")
     *         // the properties below are optional
     *         .headers(List.of("headers"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.HeadersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HeadersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeadersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>none</code> – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any headers that are listed in an <code>OriginRequestPolicy</code> <em>are</em> included in origin requests.</li>
         * <li><code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included in the cache key and in requests that CloudFront sends to the origin.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html#cfn-cloudfront-cachepolicy-headersconfig-headerbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html#cfn-cloudfront-cachepolicy-headersconfig-headerbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderBehavior();

        /**
         * Contains a list of HTTP header names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html#cfn-cloudfront-cachepolicy-headersconfig-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html#cfn-cloudfront-cachepolicy-headersconfig-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeadersConfigProperty> {
            java.lang.String headerBehavior;
            java.util.List<java.lang.String> headers;

            /**
             * Sets the value of {@link HeadersConfigProperty#getHeaderBehavior}
             * @param headerBehavior Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             *                       Valid values are:
             *                       <p>
             *                       <ul>
             *                       <li><code>none</code> – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any headers that are listed in an <code>OriginRequestPolicy</code> <em>are</em> included in origin requests.</li>
             *                       <li><code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included in the cache key and in requests that CloudFront sends to the origin.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerBehavior(java.lang.String headerBehavior) {
                this.headerBehavior = headerBehavior;
                return this;
            }

            /**
             * Sets the value of {@link HeadersConfigProperty#getHeaders}
             * @param headers Contains a list of HTTP header names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<java.lang.String> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeadersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeadersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeadersConfigProperty {
            private final java.lang.String headerBehavior;
            private final java.util.List<java.lang.String> headers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerBehavior = software.amazon.jsii.Kernel.get(this, "headerBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerBehavior = java.util.Objects.requireNonNull(builder.headerBehavior, "headerBehavior is required");
                this.headers = builder.headers;
            }

            @Override
            public final java.lang.String getHeaderBehavior() {
                return this.headerBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getHeaders() {
                return this.headers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerBehavior", om.valueToTree(this.getHeaderBehavior()));
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.HeadersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeadersConfigProperty.Jsii$Proxy that = (HeadersConfigProperty.Jsii$Proxy) o;

                if (!headerBehavior.equals(that.headerBehavior)) return false;
                return this.headers != null ? this.headers.equals(that.headers) : that.headers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headerBehavior.hashCode();
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This object determines the values that CloudFront includes in the cache key.
     * <p>
     * These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches the request's cache key. If you want to send values to the origin but <em>not</em> include them in the cache key, use <code>OriginRequestPolicy</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ParametersInCacheKeyAndForwardedToOriginProperty parametersInCacheKeyAndForwardedToOriginProperty = ParametersInCacheKeyAndForwardedToOriginProperty.builder()
     *         .cookiesConfig(CookiesConfigProperty.builder()
     *                 .cookieBehavior("cookieBehavior")
     *                 // the properties below are optional
     *                 .cookies(List.of("cookies"))
     *                 .build())
     *         .enableAcceptEncodingGzip(false)
     *         .headersConfig(HeadersConfigProperty.builder()
     *                 .headerBehavior("headerBehavior")
     *                 // the properties below are optional
     *                 .headers(List.of("headers"))
     *                 .build())
     *         .queryStringsConfig(QueryStringsConfigProperty.builder()
     *                 .queryStringBehavior("queryStringBehavior")
     *                 // the properties below are optional
     *                 .queryStrings(List.of("queryStrings"))
     *                 .build())
     *         // the properties below are optional
     *         .enableAcceptEncodingBrotli(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty")
    @software.amazon.jsii.Jsii.Proxy(ParametersInCacheKeyAndForwardedToOriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParametersInCacheKeyAndForwardedToOriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CookiesConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-cookiesconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-cookiesconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCookiesConfig();

        /**
         * A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         * <p>
         * This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or both of these fields is <code>true</code> <em>and</em> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:
         * <p>
         * <ul>
         * <li>Normalizes the value of the viewer's <code>Accept-Encoding</code> header</li>
         * <li>Includes the normalized header in the cache key</li>
         * <li>Includes the normalized header in the request to the origin, if a request is necessary</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you set this value to <code>true</code> , and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code> , so including this header in an origin request policy has no effect.
         * <p>
         * If both of these fields are <code>false</code> , then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-enableacceptencodinggzip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-enableacceptencodinggzip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableAcceptEncodingGzip();

        /**
         * An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy.HeadersConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-headersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-headersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHeadersConfig();

        /**
         * An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy.QueryStringsConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-querystringsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-querystringsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryStringsConfig();

        /**
         * A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
         * <p>
         * This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or both of these fields is <code>true</code> <em>and</em> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:
         * <p>
         * <ul>
         * <li>Normalizes the value of the viewer's <code>Accept-Encoding</code> header</li>
         * <li>Includes the normalized header in the cache key</li>
         * <li>Includes the normalized header in the request to the origin, if a request is necessary</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you set this value to <code>true</code> , and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code> , so including this header in an origin request policy has no effect.
         * <p>
         * If both of these fields are <code>false</code> , then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-enableacceptencodingbrotli">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-enableacceptencodingbrotli</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableAcceptEncodingBrotli() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParametersInCacheKeyAndForwardedToOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParametersInCacheKeyAndForwardedToOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParametersInCacheKeyAndForwardedToOriginProperty> {
            java.lang.Object cookiesConfig;
            java.lang.Object enableAcceptEncodingGzip;
            java.lang.Object headersConfig;
            java.lang.Object queryStringsConfig;
            java.lang.Object enableAcceptEncodingBrotli;

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getCookiesConfig}
             * @param cookiesConfig An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookiesConfig(software.amazon.awscdk.IResolvable cookiesConfig) {
                this.cookiesConfig = cookiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getCookiesConfig}
             * @param cookiesConfig An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookiesConfig(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CookiesConfigProperty cookiesConfig) {
                this.cookiesConfig = cookiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingGzip}
             * @param enableAcceptEncodingGzip A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin. This parameter is required.
             *                                 This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or both of these fields is <code>true</code> <em>and</em> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:
             *                                 <p>
             *                                 <ul>
             *                                 <li>Normalizes the value of the viewer's <code>Accept-Encoding</code> header</li>
             *                                 <li>Includes the normalized header in the cache key</li>
             *                                 <li>Includes the normalized header in the request to the origin, if a request is necessary</li>
             *                                 </ul>
             *                                 <p>
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                                 <p>
             *                                 If you set this value to <code>true</code> , and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code> , so including this header in an origin request policy has no effect.
             *                                 <p>
             *                                 If both of these fields are <code>false</code> , then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingGzip(java.lang.Boolean enableAcceptEncodingGzip) {
                this.enableAcceptEncodingGzip = enableAcceptEncodingGzip;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingGzip}
             * @param enableAcceptEncodingGzip A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin. This parameter is required.
             *                                 This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or both of these fields is <code>true</code> <em>and</em> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:
             *                                 <p>
             *                                 <ul>
             *                                 <li>Normalizes the value of the viewer's <code>Accept-Encoding</code> header</li>
             *                                 <li>Includes the normalized header in the cache key</li>
             *                                 <li>Includes the normalized header in the request to the origin, if a request is necessary</li>
             *                                 </ul>
             *                                 <p>
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                                 <p>
             *                                 If you set this value to <code>true</code> , and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code> , so including this header in an origin request policy has no effect.
             *                                 <p>
             *                                 If both of these fields are <code>false</code> , then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingGzip(software.amazon.awscdk.IResolvable enableAcceptEncodingGzip) {
                this.enableAcceptEncodingGzip = enableAcceptEncodingGzip;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getHeadersConfig}
             * @param headersConfig An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headersConfig(software.amazon.awscdk.IResolvable headersConfig) {
                this.headersConfig = headersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getHeadersConfig}
             * @param headersConfig An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headersConfig(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.HeadersConfigProperty headersConfig) {
                this.headersConfig = headersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getQueryStringsConfig}
             * @param queryStringsConfig An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringsConfig(software.amazon.awscdk.IResolvable queryStringsConfig) {
                this.queryStringsConfig = queryStringsConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getQueryStringsConfig}
             * @param queryStringsConfig An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringsConfig(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.QueryStringsConfigProperty queryStringsConfig) {
                this.queryStringsConfig = queryStringsConfig;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingBrotli}
             * @param enableAcceptEncodingBrotli A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
             *                                   This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or both of these fields is <code>true</code> <em>and</em> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:
             *                                   <p>
             *                                   <ul>
             *                                   <li>Normalizes the value of the viewer's <code>Accept-Encoding</code> header</li>
             *                                   <li>Includes the normalized header in the cache key</li>
             *                                   <li>Includes the normalized header in the request to the origin, if a request is necessary</li>
             *                                   </ul>
             *                                   <p>
             *                                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                                   <p>
             *                                   If you set this value to <code>true</code> , and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code> , so including this header in an origin request policy has no effect.
             *                                   <p>
             *                                   If both of these fields are <code>false</code> , then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingBrotli(java.lang.Boolean enableAcceptEncodingBrotli) {
                this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
                return this;
            }

            /**
             * Sets the value of {@link ParametersInCacheKeyAndForwardedToOriginProperty#getEnableAcceptEncodingBrotli}
             * @param enableAcceptEncodingBrotli A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
             *                                   This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or both of these fields is <code>true</code> <em>and</em> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:
             *                                   <p>
             *                                   <ul>
             *                                   <li>Normalizes the value of the viewer's <code>Accept-Encoding</code> header</li>
             *                                   <li>Includes the normalized header in the cache key</li>
             *                                   <li>Includes the normalized header in the request to the origin, if a request is necessary</li>
             *                                   </ul>
             *                                   <p>
             *                                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                                   <p>
             *                                   If you set this value to <code>true</code> , and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code> , so including this header in an origin request policy has no effect.
             *                                   <p>
             *                                   If both of these fields are <code>false</code> , then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it's not included in the cache key and it's not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAcceptEncodingBrotli(software.amazon.awscdk.IResolvable enableAcceptEncodingBrotli) {
                this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParametersInCacheKeyAndForwardedToOriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParametersInCacheKeyAndForwardedToOriginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParametersInCacheKeyAndForwardedToOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParametersInCacheKeyAndForwardedToOriginProperty {
            private final java.lang.Object cookiesConfig;
            private final java.lang.Object enableAcceptEncodingGzip;
            private final java.lang.Object headersConfig;
            private final java.lang.Object queryStringsConfig;
            private final java.lang.Object enableAcceptEncodingBrotli;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookiesConfig = software.amazon.jsii.Kernel.get(this, "cookiesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableAcceptEncodingGzip = software.amazon.jsii.Kernel.get(this, "enableAcceptEncodingGzip", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headersConfig = software.amazon.jsii.Kernel.get(this, "headersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryStringsConfig = software.amazon.jsii.Kernel.get(this, "queryStringsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableAcceptEncodingBrotli = software.amazon.jsii.Kernel.get(this, "enableAcceptEncodingBrotli", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookiesConfig = java.util.Objects.requireNonNull(builder.cookiesConfig, "cookiesConfig is required");
                this.enableAcceptEncodingGzip = java.util.Objects.requireNonNull(builder.enableAcceptEncodingGzip, "enableAcceptEncodingGzip is required");
                this.headersConfig = java.util.Objects.requireNonNull(builder.headersConfig, "headersConfig is required");
                this.queryStringsConfig = java.util.Objects.requireNonNull(builder.queryStringsConfig, "queryStringsConfig is required");
                this.enableAcceptEncodingBrotli = builder.enableAcceptEncodingBrotli;
            }

            @Override
            public final java.lang.Object getCookiesConfig() {
                return this.cookiesConfig;
            }

            @Override
            public final java.lang.Object getEnableAcceptEncodingGzip() {
                return this.enableAcceptEncodingGzip;
            }

            @Override
            public final java.lang.Object getHeadersConfig() {
                return this.headersConfig;
            }

            @Override
            public final java.lang.Object getQueryStringsConfig() {
                return this.queryStringsConfig;
            }

            @Override
            public final java.lang.Object getEnableAcceptEncodingBrotli() {
                return this.enableAcceptEncodingBrotli;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookiesConfig", om.valueToTree(this.getCookiesConfig()));
                data.set("enableAcceptEncodingGzip", om.valueToTree(this.getEnableAcceptEncodingGzip()));
                data.set("headersConfig", om.valueToTree(this.getHeadersConfig()));
                data.set("queryStringsConfig", om.valueToTree(this.getQueryStringsConfig()));
                if (this.getEnableAcceptEncodingBrotli() != null) {
                    data.set("enableAcceptEncodingBrotli", om.valueToTree(this.getEnableAcceptEncodingBrotli()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParametersInCacheKeyAndForwardedToOriginProperty.Jsii$Proxy that = (ParametersInCacheKeyAndForwardedToOriginProperty.Jsii$Proxy) o;

                if (!cookiesConfig.equals(that.cookiesConfig)) return false;
                if (!enableAcceptEncodingGzip.equals(that.enableAcceptEncodingGzip)) return false;
                if (!headersConfig.equals(that.headersConfig)) return false;
                if (!queryStringsConfig.equals(that.queryStringsConfig)) return false;
                return this.enableAcceptEncodingBrotli != null ? this.enableAcceptEncodingBrotli.equals(that.enableAcceptEncodingBrotli) : that.enableAcceptEncodingBrotli == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cookiesConfig.hashCode();
                result = 31 * result + (this.enableAcceptEncodingGzip.hashCode());
                result = 31 * result + (this.headersConfig.hashCode());
                result = 31 * result + (this.queryStringsConfig.hashCode());
                result = 31 * result + (this.enableAcceptEncodingBrotli != null ? this.enableAcceptEncodingBrotli.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * QueryStringsConfigProperty queryStringsConfigProperty = QueryStringsConfigProperty.builder()
     *         .queryStringBehavior("queryStringBehavior")
     *         // the properties below are optional
     *         .queryStrings(List.of("queryStrings"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicy.QueryStringsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryStringsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>none</code> – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any query strings that are listed in an <code>OriginRequestPolicy</code> <em>are</em> included in origin requests.</li>
         * <li><code>whitelist</code> – Only the query strings in viewer requests that are listed in the <code>QueryStringNames</code> type are included in the cache key and in requests that CloudFront sends to the origin.</li>
         * <li><code>allExcept</code> – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, <strong>except</strong> those that are listed in the <code>QueryStringNames</code> type, which are not included.</li>
         * <li><code>all</code> – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html#cfn-cloudfront-cachepolicy-querystringsconfig-querystringbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html#cfn-cloudfront-cachepolicy-querystringsconfig-querystringbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueryStringBehavior();

        /**
         * Contains a list of query string names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html#cfn-cloudfront-cachepolicy-querystringsconfig-querystrings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html#cfn-cloudfront-cachepolicy-querystringsconfig-querystrings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStrings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryStringsConfigProperty> {
            java.lang.String queryStringBehavior;
            java.util.List<java.lang.String> queryStrings;

            /**
             * Sets the value of {@link QueryStringsConfigProperty#getQueryStringBehavior}
             * @param queryStringBehavior Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. This parameter is required.
             *                            Valid values are:
             *                            <p>
             *                            <ul>
             *                            <li><code>none</code> – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any query strings that are listed in an <code>OriginRequestPolicy</code> <em>are</em> included in origin requests.</li>
             *                            <li><code>whitelist</code> – Only the query strings in viewer requests that are listed in the <code>QueryStringNames</code> type are included in the cache key and in requests that CloudFront sends to the origin.</li>
             *                            <li><code>allExcept</code> – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, <strong>except</strong> those that are listed in the <code>QueryStringNames</code> type, which are not included.</li>
             *                            <li><code>all</code> – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringBehavior(java.lang.String queryStringBehavior) {
                this.queryStringBehavior = queryStringBehavior;
                return this;
            }

            /**
             * Sets the value of {@link QueryStringsConfigProperty#getQueryStrings}
             * @param queryStrings Contains a list of query string names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStrings(java.util.List<java.lang.String> queryStrings) {
                this.queryStrings = queryStrings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryStringsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringsConfigProperty {
            private final java.lang.String queryStringBehavior;
            private final java.util.List<java.lang.String> queryStrings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryStringBehavior = software.amazon.jsii.Kernel.get(this, "queryStringBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryStrings = software.amazon.jsii.Kernel.get(this, "queryStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryStringBehavior = java.util.Objects.requireNonNull(builder.queryStringBehavior, "queryStringBehavior is required");
                this.queryStrings = builder.queryStrings;
            }

            @Override
            public final java.lang.String getQueryStringBehavior() {
                return this.queryStringBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getQueryStrings() {
                return this.queryStrings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryStringBehavior", om.valueToTree(this.getQueryStringBehavior()));
                if (this.getQueryStrings() != null) {
                    data.set("queryStrings", om.valueToTree(this.getQueryStrings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicy.QueryStringsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringsConfigProperty.Jsii$Proxy that = (QueryStringsConfigProperty.Jsii$Proxy) o;

                if (!queryStringBehavior.equals(that.queryStringBehavior)) return false;
                return this.queryStrings != null ? this.queryStrings.equals(that.queryStrings) : that.queryStrings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryStringBehavior.hashCode();
                result = 31 * result + (this.queryStrings != null ? this.queryStrings.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnCachePolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnCachePolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnCachePolicyProps.Builder();
        }

        /**
         * The cache policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig</a>
         * @param cachePolicyConfig The cache policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicyConfig(final software.amazon.awscdk.IResolvable cachePolicyConfig) {
            this.props.cachePolicyConfig(cachePolicyConfig);
            return this;
        }
        /**
         * The cache policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig</a>
         * @param cachePolicyConfig The cache policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicyConfig(final software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CachePolicyConfigProperty cachePolicyConfig) {
            this.props.cachePolicyConfig(cachePolicyConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnCachePolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnCachePolicy build() {
            return new software.amazon.awscdk.services.cloudfront.CfnCachePolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
