package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnKeyGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnKeyGroupProps cfnKeyGroupProps = CfnKeyGroupProps.builder()
 *         .keyGroupConfig(KeyGroupConfigProperty.builder()
 *                 .items(List.of("items"))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-keygroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-keygroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.026Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnKeyGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnKeyGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKeyGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key group configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnKeyGroup.KeyGroupConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-keygroup.html#cfn-cloudfront-keygroup-keygroupconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-keygroup.html#cfn-cloudfront-keygroup-keygroupconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKeyGroupConfig();

    /**
     * @return a {@link Builder} of {@link CfnKeyGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKeyGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKeyGroupProps> {
        java.lang.Object keyGroupConfig;

        /**
         * Sets the value of {@link CfnKeyGroupProps#getKeyGroupConfig}
         * @param keyGroupConfig The key group configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyGroupConfig(software.amazon.awscdk.IResolvable keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyGroupProps#getKeyGroupConfig}
         * @param keyGroupConfig The key group configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyGroupConfig(software.amazon.awscdk.services.cloudfront.CfnKeyGroup.KeyGroupConfigProperty keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKeyGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKeyGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKeyGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKeyGroupProps {
        private final java.lang.Object keyGroupConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyGroupConfig = software.amazon.jsii.Kernel.get(this, "keyGroupConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyGroupConfig = java.util.Objects.requireNonNull(builder.keyGroupConfig, "keyGroupConfig is required");
        }

        @Override
        public final java.lang.Object getKeyGroupConfig() {
            return this.keyGroupConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyGroupConfig", om.valueToTree(this.getKeyGroupConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnKeyGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKeyGroupProps.Jsii$Proxy that = (CfnKeyGroupProps.Jsii$Proxy) o;

            return this.keyGroupConfig.equals(that.keyGroupConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.keyGroupConfig.hashCode();
            return result;
        }
    }
}
