package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnResponseHeadersPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnResponseHeadersPolicyProps cfnResponseHeadersPolicyProps = CfnResponseHeadersPolicyProps.builder()
 *         .responseHeadersPolicyConfig(ResponseHeadersPolicyConfigProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .corsConfig(CorsConfigProperty.builder()
 *                         .accessControlAllowCredentials(false)
 *                         .accessControlAllowHeaders(AccessControlAllowHeadersProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .accessControlAllowMethods(AccessControlAllowMethodsProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .accessControlAllowOrigins(AccessControlAllowOriginsProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .originOverride(false)
 *                         // the properties below are optional
 *                         .accessControlExposeHeaders(AccessControlExposeHeadersProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .accessControlMaxAgeSec(123)
 *                         .build())
 *                 .customHeadersConfig(CustomHeadersConfigProperty.builder()
 *                         .items(List.of(CustomHeaderProperty.builder()
 *                                 .header("header")
 *                                 .override(false)
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .removeHeadersConfig(RemoveHeadersConfigProperty.builder()
 *                         .items(List.of(RemoveHeaderProperty.builder()
 *                                 .header("header")
 *                                 .build()))
 *                         .build())
 *                 .securityHeadersConfig(SecurityHeadersConfigProperty.builder()
 *                         .contentSecurityPolicy(ContentSecurityPolicyProperty.builder()
 *                                 .contentSecurityPolicy("contentSecurityPolicy")
 *                                 .override(false)
 *                                 .build())
 *                         .contentTypeOptions(ContentTypeOptionsProperty.builder()
 *                                 .override(false)
 *                                 .build())
 *                         .frameOptions(FrameOptionsProperty.builder()
 *                                 .frameOption("frameOption")
 *                                 .override(false)
 *                                 .build())
 *                         .referrerPolicy(ReferrerPolicyProperty.builder()
 *                                 .override(false)
 *                                 .referrerPolicy("referrerPolicy")
 *                                 .build())
 *                         .strictTransportSecurity(StrictTransportSecurityProperty.builder()
 *                                 .accessControlMaxAgeSec(123)
 *                                 .override(false)
 *                                 // the properties below are optional
 *                                 .includeSubdomains(false)
 *                                 .preload(false)
 *                                 .build())
 *                         .xssProtection(XSSProtectionProperty.builder()
 *                                 .override(false)
 *                                 .protection(false)
 *                                 // the properties below are optional
 *                                 .modeBlock(false)
 *                                 .reportUri("reportUri")
 *                                 .build())
 *                         .build())
 *                 .serverTimingHeadersConfig(ServerTimingHeadersConfigProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .samplingRate(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.065Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnResponseHeadersPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResponseHeadersPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A response headers policy configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResponseHeadersPolicyConfig();

    /**
     * @return a {@link Builder} of {@link CfnResponseHeadersPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResponseHeadersPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResponseHeadersPolicyProps> {
        java.lang.Object responseHeadersPolicyConfig;

        /**
         * Sets the value of {@link CfnResponseHeadersPolicyProps#getResponseHeadersPolicyConfig}
         * @param responseHeadersPolicyConfig A response headers policy configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicyConfig(software.amazon.awscdk.IResolvable responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponseHeadersPolicyProps#getResponseHeadersPolicyConfig}
         * @param responseHeadersPolicyConfig A response headers policy configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicyConfig(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResponseHeadersPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResponseHeadersPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResponseHeadersPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResponseHeadersPolicyProps {
        private final java.lang.Object responseHeadersPolicyConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.responseHeadersPolicyConfig = software.amazon.jsii.Kernel.get(this, "responseHeadersPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.responseHeadersPolicyConfig = java.util.Objects.requireNonNull(builder.responseHeadersPolicyConfig, "responseHeadersPolicyConfig is required");
        }

        @Override
        public final java.lang.Object getResponseHeadersPolicyConfig() {
            return this.responseHeadersPolicyConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("responseHeadersPolicyConfig", om.valueToTree(this.getResponseHeadersPolicyConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResponseHeadersPolicyProps.Jsii$Proxy that = (CfnResponseHeadersPolicyProps.Jsii$Proxy) o;

            return this.responseHeadersPolicyConfig.equals(that.responseHeadersPolicyConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.responseHeadersPolicyConfig.hashCode();
            return result;
        }
    }
}
