package software.amazon.awscdk.services.cloudfront;

/**
 * The IP address type for the origin.
 * <p>
 * Determines whether CloudFront uses IPv4, IPv6, or both when connecting to the origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HttpOrigin origin = HttpOrigin.Builder.create("www.example.com")
 *         .ipAddressType(OriginIpAddressType.IPV6)
 *         .build();
 * Distribution.Builder.create(this, "Distribution")
 *         .defaultBehavior(BehaviorOptions.builder().origin(origin).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.115Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginIpAddressType")
public enum OriginIpAddressType {
    /**
     * Use only IPv4 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * Use only IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV6,
    /**
     * Use both IPv4 and IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUALSTACK,
}
