package software.amazon.awscdk.services.cloudfront;

/**
 * Defines what protocols CloudFront will use to connect to an origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationLoadBalancer loadBalancer;
 * LoadBalancerV2Origin origin = LoadBalancerV2Origin.Builder.create(loadBalancer)
 *         .connectionAttempts(3)
 *         .connectionTimeout(Duration.seconds(5))
 *         .readTimeout(Duration.seconds(45))
 *         .responseCompletionTimeout(Duration.seconds(120))
 *         .keepaliveTimeout(Duration.seconds(45))
 *         .protocolPolicy(OriginProtocolPolicy.MATCH_VIEWER)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.117Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginProtocolPolicy")
public enum OriginProtocolPolicy {
    /**
     * Connect on HTTP only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP_ONLY,
    /**
     * Connect with the same protocol as the viewer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MATCH_VIEWER,
    /**
     * Connect on HTTPS only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS_ONLY,
}
