package software.amazon.awscdk.services.cloudtrail;

/**
 * Types of events that CloudTrail can log.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Trail trail = Trail.Builder.create(this, "CloudTrail")
 *         // ...
 *         .managementEvents(ReadWriteType.READ_ONLY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.246Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.ReadWriteType")
public enum ReadWriteType {
    /**
     * Read-only events include API operations that read your resources, but don't make changes.
     * <p>
     * For example, read-only events include the Amazon EC2 DescribeSecurityGroups
     * and DescribeSubnets API operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ_ONLY,
    /**
     * Write-only events include API operations that modify (or might modify) your resources.
     * <p>
     * For example, the Amazon EC2 RunInstances and TerminateInstances API
     * operations modify your instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WRITE_ONLY,
    /**
     * All events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * No events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
