package software.amazon.awscdk.services.cloudwatch;

/**
 * Vertical annotation to be added to a graph.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * VerticalAnnotation verticalAnnotation = VerticalAnnotation.builder()
 *         .date("date")
 *         // the properties below are optional
 *         .color("color")
 *         .fill(VerticalShading.NONE)
 *         .label("label")
 *         .visible(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.388Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.VerticalAnnotation")
@software.amazon.jsii.Jsii.Proxy(VerticalAnnotation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VerticalAnnotation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The date and time (in ISO 8601 format) in the graph where the vertical annotation line is to appear.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDate();

    /**
     * The hex color code, prefixed with '#' (e.g. '#00ff00'), to be used for the annotation. The <code>Color</code> class has a set of standard colors that can be used here.
     * <p>
     * Default: - Automatic color
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return null;
    }

    /**
     * Add shading before or after the annotation.
     * <p>
     * Default: No shading
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.VerticalShading getFill() {
        return null;
    }

    /**
     * Label for the annotation.
     * <p>
     * Default: - No label
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return null;
    }

    /**
     * Whether the annotation is visible.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVisible() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VerticalAnnotation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VerticalAnnotation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VerticalAnnotation> {
        java.lang.String date;
        java.lang.String color;
        software.amazon.awscdk.services.cloudwatch.VerticalShading fill;
        java.lang.String label;
        java.lang.Boolean visible;

        /**
         * Sets the value of {@link VerticalAnnotation#getDate}
         * @param date The date and time (in ISO 8601 format) in the graph where the vertical annotation line is to appear. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder date(java.lang.String date) {
            this.date = date;
            return this;
        }

        /**
         * Sets the value of {@link VerticalAnnotation#getColor}
         * @param color The hex color code, prefixed with '#' (e.g. '#00ff00'), to be used for the annotation. The <code>Color</code> class has a set of standard colors that can be used here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link VerticalAnnotation#getFill}
         * @param fill Add shading before or after the annotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fill(software.amazon.awscdk.services.cloudwatch.VerticalShading fill) {
            this.fill = fill;
            return this;
        }

        /**
         * Sets the value of {@link VerticalAnnotation#getLabel}
         * @param label Label for the annotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link VerticalAnnotation#getVisible}
         * @param visible Whether the annotation is visible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visible(java.lang.Boolean visible) {
            this.visible = visible;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VerticalAnnotation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VerticalAnnotation build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VerticalAnnotation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VerticalAnnotation {
        private final java.lang.String date;
        private final java.lang.String color;
        private final software.amazon.awscdk.services.cloudwatch.VerticalShading fill;
        private final java.lang.String label;
        private final java.lang.Boolean visible;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.date = software.amazon.jsii.Kernel.get(this, "date", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fill = software.amazon.jsii.Kernel.get(this, "fill", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.VerticalShading.class));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.visible = software.amazon.jsii.Kernel.get(this, "visible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.date = java.util.Objects.requireNonNull(builder.date, "date is required");
            this.color = builder.color;
            this.fill = builder.fill;
            this.label = builder.label;
            this.visible = builder.visible;
        }

        @Override
        public final java.lang.String getDate() {
            return this.date;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.VerticalShading getFill() {
            return this.fill;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final java.lang.Boolean getVisible() {
            return this.visible;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("date", om.valueToTree(this.getDate()));
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getFill() != null) {
                data.set("fill", om.valueToTree(this.getFill()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getVisible() != null) {
                data.set("visible", om.valueToTree(this.getVisible()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.VerticalAnnotation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VerticalAnnotation.Jsii$Proxy that = (VerticalAnnotation.Jsii$Proxy) o;

            if (!date.equals(that.date)) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.fill != null ? !this.fill.equals(that.fill) : that.fill != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            return this.visible != null ? this.visible.equals(that.visible) : that.visible == null;
        }

        @Override
        public final int hashCode() {
            int result = this.date.hashCode();
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.fill != null ? this.fill.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.visible != null ? this.visible.hashCode() : 0);
            return result;
        }
    }
}
