package software.amazon.awscdk.services.codebuild;

/**
 * The compute configuration for the fleet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Size;
 * Fleet fleet = Fleet.Builder.create(this, "MyFleet")
 *         .baseCapacity(1)
 *         .computeType(FleetComputeType.ATTRIBUTE_BASED)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .computeConfiguration(ComputeConfiguration.builder()
 *                 .vCpu(2)
 *                 .memory(Size.gibibytes(4))
 *                 .disk(Size.gibibytes(10))
 *                 .machineType(MachineType.GENERAL)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.503Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.ComputeConfiguration")
@software.amazon.jsii.Jsii.Proxy(ComputeConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * When using ATTRIBUTE_BASED, the amount of disk space of the instance type included in your fleet.
     * <p>
     * When using CUSTOM_INSTANCE_TYPE,
     * the additional amount of disk space to provision over the 64GB included by
     * default.
     * <p>
     * Default: - No requirement, the actual value will be based on the other selected configuration properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getDisk() {
        return null;
    }

    /**
     * When using CUSTOM_INSTANCE_TYPE, the EC2 instance type to use for fleet instances.
     * <p>
     * Not all instance types are supported by CodeBuild. If you use a disallowed type, the
     * CloudFormation deployment will fail.
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.instance-types">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.instance-types</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * When using ATTRIBUTE_BASED, the machine type of the instance type included in your fleet.
     * <p>
     * Default: - No requirement, the actual value will be based on the other selected configuration properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.MachineType getMachineType() {
        return null;
    }

    /**
     * When using ATTRIBUTE_BASED, the amount of memory of the instance type included in your fleet.
     * <p>
     * Default: - No requirement, the actual value will be based on the other selected configuration properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemory() {
        return null;
    }

    /**
     * When using ATTRIBUTE_BASED, the number of vCPUs of the instance type included in your fleet.
     * <p>
     * Default: - No requirement, the actual value will be based on the other selected configuration properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVCpu() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeConfiguration> {
        software.amazon.awscdk.Size disk;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.codebuild.MachineType machineType;
        software.amazon.awscdk.Size memory;
        java.lang.Number vCpu;

        /**
         * Sets the value of {@link ComputeConfiguration#getDisk}
         * @param disk When using ATTRIBUTE_BASED, the amount of disk space of the instance type included in your fleet.
         *             When using CUSTOM_INSTANCE_TYPE,
         *             the additional amount of disk space to provision over the 64GB included by
         *             default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disk(software.amazon.awscdk.Size disk) {
            this.disk = disk;
            return this;
        }

        /**
         * Sets the value of {@link ComputeConfiguration#getInstanceType}
         * @param instanceType When using CUSTOM_INSTANCE_TYPE, the EC2 instance type to use for fleet instances.
         *                     Not all instance types are supported by CodeBuild. If you use a disallowed type, the
         *                     CloudFormation deployment will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ComputeConfiguration#getMachineType}
         * @param machineType When using ATTRIBUTE_BASED, the machine type of the instance type included in your fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineType(software.amazon.awscdk.services.codebuild.MachineType machineType) {
            this.machineType = machineType;
            return this;
        }

        /**
         * Sets the value of {@link ComputeConfiguration#getMemory}
         * @param memory When using ATTRIBUTE_BASED, the amount of memory of the instance type included in your fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(software.amazon.awscdk.Size memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link ComputeConfiguration#getVCpu}
         * @param vCpu When using ATTRIBUTE_BASED, the number of vCPUs of the instance type included in your fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vCpu(java.lang.Number vCpu) {
            this.vCpu = vCpu;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeConfiguration {
        private final software.amazon.awscdk.Size disk;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.codebuild.MachineType machineType;
        private final software.amazon.awscdk.Size memory;
        private final java.lang.Number vCpu;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.disk = software.amazon.jsii.Kernel.get(this, "disk", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.machineType = software.amazon.jsii.Kernel.get(this, "machineType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.MachineType.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.vCpu = software.amazon.jsii.Kernel.get(this, "vCpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.disk = builder.disk;
            this.instanceType = builder.instanceType;
            this.machineType = builder.machineType;
            this.memory = builder.memory;
            this.vCpu = builder.vCpu;
        }

        @Override
        public final software.amazon.awscdk.Size getDisk() {
            return this.disk;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.MachineType getMachineType() {
            return this.machineType;
        }

        @Override
        public final software.amazon.awscdk.Size getMemory() {
            return this.memory;
        }

        @Override
        public final java.lang.Number getVCpu() {
            return this.vCpu;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDisk() != null) {
                data.set("disk", om.valueToTree(this.getDisk()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getMachineType() != null) {
                data.set("machineType", om.valueToTree(this.getMachineType()));
            }
            if (this.getMemory() != null) {
                data.set("memory", om.valueToTree(this.getMemory()));
            }
            if (this.getVCpu() != null) {
                data.set("vCpu", om.valueToTree(this.getVCpu()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.ComputeConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeConfiguration.Jsii$Proxy that = (ComputeConfiguration.Jsii$Proxy) o;

            if (this.disk != null ? !this.disk.equals(that.disk) : that.disk != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.machineType != null ? !this.machineType.equals(that.machineType) : that.machineType != null) return false;
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
            return this.vCpu != null ? this.vCpu.equals(that.vCpu) : that.vCpu == null;
        }

        @Override
        public final int hashCode() {
            int result = this.disk != null ? this.disk.hashCode() : 0;
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.machineType != null ? this.machineType.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.vCpu != null ? this.vCpu.hashCode() : 0);
            return result;
        }
    }
}
