package software.amazon.awscdk.services.codebuild;

/**
 * Docker server compute type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup;
 * CodeBuildStep.Builder.create("Synth")
 *         // ...standard ShellStep props...
 *         .commands(List.of())
 *         .env(Map.of())
 *         // If you are using a CodeBuildStep explicitly, set the 'cdk.out' directory
 *         // to be the synth step's output.
 *         .primaryOutputDirectory("cdk.out")
 *         // Control the name of the project
 *         .projectName("MyProject")
 *         // Control parts of the BuildSpec other than the regular 'build' and 'install' commands
 *         .partialBuildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         // Control the build environment
 *         .buildEnvironment(BuildEnvironment.builder()
 *                 .computeType(ComputeType.LARGE)
 *                 .privileged(true)
 *                 .dockerServer(DockerServerOptions.builder()
 *                         .computeType(DockerServerComputeType.SMALL)
 *                         .securityGroups(List.of(mySecurityGroup))
 *                         .build())
 *                 .build())
 *         .timeout(Duration.minutes(90))
 *         .fileSystemLocations(List.of(FileSystemLocation.efs(EfsFileSystemLocationProps.builder()
 *                 .identifier("myidentifier2")
 *                 .location("myclodation.mydnsroot.com:/loc")
 *                 .mountPoint("/media")
 *                 .mountOptions("opts")
 *                 .build())))
 *         // Control Elastic Network Interface creation
 *         .vpc(vpc)
 *         .subnetSelection(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_EGRESS).build())
 *         .securityGroups(List.of(mySecurityGroup))
 *         // Control caching
 *         .cache(Cache.bucket(new Bucket(this, "Cache")))
 *         // Additional policy statements for the execution role
 *         .rolePolicyStatements(List.of(
 *             PolicyStatement.Builder.create().build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_DockerServer.html">https://docs.aws.amazon.com/codebuild/latest/APIReference/API_DockerServer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.505Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.DockerServerComputeType")
public enum DockerServerComputeType {
    /**
     * BUILD_GENERAL1_SMALL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SMALL,
    /**
     * BUILD_GENERAL1_MEDIUM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     * BUILD_GENERAL1_LARGE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LARGE,
    /**
     * BUILD_GENERAL1_XLARGE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X_LARGE,
    /**
     * BUILD_GENERAL1_2XLARGE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2_LARGE,
    /**
     * ATTRIBUTE_BASED_COMPUTE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ATTRIBUTE_BASED_COMPUTE,
    /**
     * BUILD_LAMBDA_10GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_LAMBDA_10GB,
    /**
     * BUILD_LAMBDA_1GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_LAMBDA_1GB,
    /**
     * BUILD_LAMBDA_2GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_LAMBDA_2GB,
    /**
     * BUILD_LAMBDA_4GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_LAMBDA_4GB,
    /**
     * BUILD_LAMBDA_8GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_LAMBDA_8GB,
    /**
     * CUSTOM_INSTANCE_TYPE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOM_INSTANCE_TYPE,
}
