package software.amazon.awscdk.services.codebuild;

/**
 * Build environment type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Size;
 * Fleet fleet = Fleet.Builder.create(this, "MyFleet")
 *         .baseCapacity(1)
 *         .computeType(FleetComputeType.CUSTOM_INSTANCE_TYPE)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .computeConfiguration(ComputeConfiguration.builder()
 *                 .instanceType(InstanceType.of(InstanceClass.T3, InstanceSize.MEDIUM))
 *                 // By default, 64 GiB of disk space is included. Any value optionally
 *                 // specified here is _incremental_ on top of the included disk space.
 *                 .disk(Size.gibibytes(10))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.506Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.EnvironmentType")
public enum EnvironmentType {
    /**
     * ARM container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM_CONTAINER,
    /**
     * Linux container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINUX_CONTAINER,
    /**
     * Linux GPU container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINUX_GPU_CONTAINER,
    /**
     * Windows Server 2019 container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_SERVER_2019_CONTAINER,
    /**
     * Windows Server 2022 container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_SERVER_2022_CONTAINER,
    /**
     * MacOS ARM container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC_ARM,
    /**
     * Linux EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINUX_EC2,
    /**
     * ARM EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM_EC2,
    /**
     * Windows EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_EC2,
}
