package software.amazon.awscdk.services.codebuild;

/**
 * Permissions Boundary for a CodeBuild Project running untrusted code.
 * <p>
 * This class is a Policy, intended to be used as a Permissions Boundary
 * for a CodeBuild project. It allows most of the actions necessary to run
 * the CodeBuild project, but disallows reading from Parameter Store
 * and Secrets Manager.
 * <p>
 * Use this when your CodeBuild project is running untrusted code (for
 * example, if you are using one to automatically build Pull Requests
 * that anyone can submit), and you want to prevent your future self
 * from accidentally exposing Secrets to this build.
 * <p>
 * (The reason you might want to do this is because otherwise anyone
 * who can submit a Pull Request to your project can write a script
 * to email those secrets to themselves).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Project project;
 * PermissionsBoundary.of(project).apply(new UntrustedCodeBoundaryPolicy(this, "Boundary"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.570Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.UntrustedCodeBoundaryPolicy")
public class UntrustedCodeBoundaryPolicy extends software.amazon.awscdk.services.iam.ManagedPolicy {

    protected UntrustedCodeBoundaryPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UntrustedCodeBoundaryPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicy.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UntrustedCodeBoundaryPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UntrustedCodeBoundaryPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Additional statements to add to the default set of statements.
         * <p>
         * Default: - No additional statements
         * <p>
         * @return {@code this}
         * @param additionalStatements Additional statements to add to the default set of statements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalStatements(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> additionalStatements) {
            this.props().additionalStatements(additionalStatements);
            return this;
        }

        /**
         * The name of the managed policy.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param managedPolicyName The name of the managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyName(final java.lang.String managedPolicyName) {
            this.props().managedPolicyName(managedPolicyName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicy build() {
            return new software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codebuild.UntrustedCodeBoundaryPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
