package software.amazon.awscdk.services.codepipeline;

/**
 * The abstract view of an AWS CodePipeline as required and used by Actions.
 * <p>
 * It extends <code>events.IRuleTarget</code>,
 * so this interface can be used as a Target for CloudWatch Events.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:47.780Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.IPipeline")
@software.amazon.jsii.Jsii.Proxy(IPipeline.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPipeline extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource, software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource {

    /**
     * The ARN of the Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPipelineArn();

    /**
     * The name of the Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPipelineName();

    /**
     * Defines a CodeStar notification rule triggered when the pipeline events emitted by you specified, it very similar to <code>onEvent</code> API.
     * <p>
     * You can also use the methods <code>notifyOnExecutionStateChange</code>, <code>notifyOnAnyStageStateChange</code>,
     * <code>notifyOnAnyActionStateChange</code> and <code>notifyOnAnyManualApprovalStateChange</code>
     * to define rules for these specific event emitted.
     * <p>
     * @return CodeStar notification rule associated with this build project.
     * @param id The id of the CodeStar notification rule. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     * @param options Customization options for CodeStar notification rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOn(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.PipelineNotifyOnOptions options);

    /**
     * Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     * @param options Additional options to pass to the notification rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options);

    /**
     * Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target);

    /**
     * Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     * @param options Additional options to pass to the notification rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options);

    /**
     * Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target);

    /**
     * Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     * @param options Additional options to pass to the notification rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options);

    /**
     * Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target);

    /**
     * Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     * @param options Additional options to pass to the notification rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options);

    /**
     * Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
     * @param id Identifier for this notification handler. This parameter is required.
     * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target);

    /**
     * Define an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * Define an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.IPipeline.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed in a Stack (those created by
         * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
         * is always the same as the environment of the stack they belong to.
         * <p>
         * For referenced resources (those obtained from referencing methods like
         * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
         * different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of the Pipeline.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getPipelineArn() {
            return software.amazon.jsii.Kernel.get(this, "pipelineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the Pipeline.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getPipelineName() {
            return software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Returns a source configuration for notification rule.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig bindAsNotificationRuleSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bindAsNotificationRuleSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }

        /**
         * Defines a CodeStar notification rule triggered when the pipeline events emitted by you specified, it very similar to <code>onEvent</code> API.
         * <p>
         * You can also use the methods <code>notifyOnExecutionStateChange</code>, <code>notifyOnAnyStageStateChange</code>,
         * <code>notifyOnAnyActionStateChange</code> and <code>notifyOnAnyManualApprovalStateChange</code>
         * to define rules for these specific event emitted.
         * <p>
         * @return CodeStar notification rule associated with this build project.
         * @param id The id of the CodeStar notification rule. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Customization options for CodeStar notification rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOn(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.PipelineNotifyOnOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyActionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyActionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
        }

        /**
         * Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyManualApprovalStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyManualApprovalStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
        }

        /**
         * Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyStageStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyStageStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
        }

        /**
         * Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnExecutionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnExecutionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
        }

        /**
         * Define an event rule triggered by this CodePipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         * @param options Additional options to pass to the event rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Define an event rule triggered by this CodePipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         * @param options Additional options to pass to the event rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }
    }

    /**
     * Internal default implementation for {@link IPipeline}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IPipeline, software.amazon.awscdk.IResource.Jsii$Default, software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed in a Stack (those created by
         * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
         * is always the same as the environment of the stack they belong to.
         * <p>
         * For referenced resources (those obtained from referencing methods like
         * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
         * different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of the Pipeline.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getPipelineArn() {
            return software.amazon.jsii.Kernel.get(this, "pipelineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the Pipeline.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getPipelineName() {
            return software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Returns a source configuration for notification rule.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig bindAsNotificationRuleSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bindAsNotificationRuleSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }

        /**
         * Defines a CodeStar notification rule triggered when the pipeline events emitted by you specified, it very similar to <code>onEvent</code> API.
         * <p>
         * You can also use the methods <code>notifyOnExecutionStateChange</code>, <code>notifyOnAnyStageStateChange</code>,
         * <code>notifyOnAnyActionStateChange</code> and <code>notifyOnAnyManualApprovalStateChange</code>
         * to define rules for these specific event emitted.
         * <p>
         * @return CodeStar notification rule associated with this build project.
         * @param id The id of the CodeStar notification rule. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Customization options for CodeStar notification rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOn(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.PipelineNotifyOnOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyActionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyManualApprovalStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnAnyStageStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline</a>
         * @param id Identifier for this notification handler. This parameter is required.
         * @param target The target to register for the CodeStar Notifications destination. This parameter is required.
         * @param options Additional options to pass to the notification rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
            return software.amazon.jsii.Kernel.call(this, "notifyOnExecutionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
        }

        /**
         * Define an event rule triggered by this CodePipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         * @param options Additional options to pass to the event rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         * @param options Additional options to pass to the event rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }
    }
}
