package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnTerms</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnTermsProps cfnTermsProps = CfnTermsProps.builder()
 *         .enforcement("enforcement")
 *         .links(Map.of(
 *                 "linksKey", "links"))
 *         .termsName("termsName")
 *         .termsSource("termsSource")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .clientId("clientId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.016Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnTermsProps")
@software.amazon.jsii.Jsii.Proxy(CfnTermsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTermsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-enforcement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-enforcement</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnforcement();

    /**
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-links">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-links</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLinks();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-termsname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-termsname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTermsName();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-termssource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-termssource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTermsSource();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-userpoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-terms.html#cfn-cognito-terms-clientid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTermsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTermsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTermsProps> {
        java.lang.String enforcement;
        java.lang.Object links;
        java.lang.String termsName;
        java.lang.String termsSource;
        java.lang.String userPoolId;
        java.lang.String clientId;

        /**
         * Sets the value of {@link CfnTermsProps#getEnforcement}
         * @param enforcement the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforcement(java.lang.String enforcement) {
            this.enforcement = enforcement;
            return this;
        }

        /**
         * Sets the value of {@link CfnTermsProps#getLinks}
         * @param links the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder links(java.util.Map<java.lang.String, java.lang.String> links) {
            this.links = links;
            return this;
        }

        /**
         * Sets the value of {@link CfnTermsProps#getLinks}
         * @param links the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder links(software.amazon.awscdk.IResolvable links) {
            this.links = links;
            return this;
        }

        /**
         * Sets the value of {@link CfnTermsProps#getTermsName}
         * @param termsName the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder termsName(java.lang.String termsName) {
            this.termsName = termsName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTermsProps#getTermsSource}
         * @param termsSource the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder termsSource(java.lang.String termsSource) {
            this.termsSource = termsSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnTermsProps#getUserPoolId}
         * @param userPoolId the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTermsProps#getClientId}
         * @param clientId the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTermsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTermsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTermsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTermsProps {
        private final java.lang.String enforcement;
        private final java.lang.Object links;
        private final java.lang.String termsName;
        private final java.lang.String termsSource;
        private final java.lang.String userPoolId;
        private final java.lang.String clientId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enforcement = software.amazon.jsii.Kernel.get(this, "enforcement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.links = software.amazon.jsii.Kernel.get(this, "links", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.termsName = software.amazon.jsii.Kernel.get(this, "termsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.termsSource = software.amazon.jsii.Kernel.get(this, "termsSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enforcement = java.util.Objects.requireNonNull(builder.enforcement, "enforcement is required");
            this.links = java.util.Objects.requireNonNull(builder.links, "links is required");
            this.termsName = java.util.Objects.requireNonNull(builder.termsName, "termsName is required");
            this.termsSource = java.util.Objects.requireNonNull(builder.termsSource, "termsSource is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.clientId = builder.clientId;
        }

        @Override
        public final java.lang.String getEnforcement() {
            return this.enforcement;
        }

        @Override
        public final java.lang.Object getLinks() {
            return this.links;
        }

        @Override
        public final java.lang.String getTermsName() {
            return this.termsName;
        }

        @Override
        public final java.lang.String getTermsSource() {
            return this.termsSource;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("enforcement", om.valueToTree(this.getEnforcement()));
            data.set("links", om.valueToTree(this.getLinks()));
            data.set("termsName", om.valueToTree(this.getTermsName()));
            data.set("termsSource", om.valueToTree(this.getTermsSource()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getClientId() != null) {
                data.set("clientId", om.valueToTree(this.getClientId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnTermsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTermsProps.Jsii$Proxy that = (CfnTermsProps.Jsii$Proxy) o;

            if (!enforcement.equals(that.enforcement)) return false;
            if (!links.equals(that.links)) return false;
            if (!termsName.equals(that.termsName)) return false;
            if (!termsSource.equals(that.termsSource)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            return this.clientId != null ? this.clientId.equals(that.clientId) : that.clientId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enforcement.hashCode();
            result = 31 * result + (this.links.hashCode());
            result = 31 * result + (this.termsName.hashCode());
            result = 31 * result + (this.termsSource.hashCode());
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
            return result;
        }
    }
}
