package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnUserPool</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object userPoolTags;
 * CfnUserPoolProps cfnUserPoolProps = CfnUserPoolProps.builder()
 *         .accountRecoverySetting(AccountRecoverySettingProperty.builder()
 *                 .recoveryMechanisms(List.of(RecoveryOptionProperty.builder()
 *                         .name("name")
 *                         .priority(123)
 *                         .build()))
 *                 .build())
 *         .adminCreateUserConfig(AdminCreateUserConfigProperty.builder()
 *                 .allowAdminCreateUserOnly(false)
 *                 .inviteMessageTemplate(InviteMessageTemplateProperty.builder()
 *                         .emailMessage("emailMessage")
 *                         .emailSubject("emailSubject")
 *                         .smsMessage("smsMessage")
 *                         .build())
 *                 .unusedAccountValidityDays(123)
 *                 .build())
 *         .aliasAttributes(List.of("aliasAttributes"))
 *         .autoVerifiedAttributes(List.of("autoVerifiedAttributes"))
 *         .deletionProtection("deletionProtection")
 *         .deviceConfiguration(DeviceConfigurationProperty.builder()
 *                 .challengeRequiredOnNewDevice(false)
 *                 .deviceOnlyRememberedOnUserPrompt(false)
 *                 .build())
 *         .emailAuthenticationMessage("emailAuthenticationMessage")
 *         .emailAuthenticationSubject("emailAuthenticationSubject")
 *         .emailConfiguration(EmailConfigurationProperty.builder()
 *                 .configurationSet("configurationSet")
 *                 .emailSendingAccount("emailSendingAccount")
 *                 .from("from")
 *                 .replyToEmailAddress("replyToEmailAddress")
 *                 .sourceArn("sourceArn")
 *                 .build())
 *         .emailVerificationMessage("emailVerificationMessage")
 *         .emailVerificationSubject("emailVerificationSubject")
 *         .enabledMfas(List.of("enabledMfas"))
 *         .lambdaConfig(LambdaConfigProperty.builder()
 *                 .createAuthChallenge("createAuthChallenge")
 *                 .customEmailSender(CustomEmailSenderProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .lambdaVersion("lambdaVersion")
 *                         .build())
 *                 .customMessage("customMessage")
 *                 .customSmsSender(CustomSMSSenderProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .lambdaVersion("lambdaVersion")
 *                         .build())
 *                 .defineAuthChallenge("defineAuthChallenge")
 *                 .kmsKeyId("kmsKeyId")
 *                 .postAuthentication("postAuthentication")
 *                 .postConfirmation("postConfirmation")
 *                 .preAuthentication("preAuthentication")
 *                 .preSignUp("preSignUp")
 *                 .preTokenGeneration("preTokenGeneration")
 *                 .preTokenGenerationConfig(PreTokenGenerationConfigProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .lambdaVersion("lambdaVersion")
 *                         .build())
 *                 .userMigration("userMigration")
 *                 .verifyAuthChallengeResponse("verifyAuthChallengeResponse")
 *                 .build())
 *         .mfaConfiguration("mfaConfiguration")
 *         .policies(PoliciesProperty.builder()
 *                 .passwordPolicy(PasswordPolicyProperty.builder()
 *                         .minimumLength(123)
 *                         .passwordHistorySize(123)
 *                         .requireLowercase(false)
 *                         .requireNumbers(false)
 *                         .requireSymbols(false)
 *                         .requireUppercase(false)
 *                         .temporaryPasswordValidityDays(123)
 *                         .build())
 *                 .signInPolicy(SignInPolicyProperty.builder()
 *                         .allowedFirstAuthFactors(List.of("allowedFirstAuthFactors"))
 *                         .build())
 *                 .build())
 *         .schema(List.of(SchemaAttributeProperty.builder()
 *                 .attributeDataType("attributeDataType")
 *                 .developerOnlyAttribute(false)
 *                 .mutable(false)
 *                 .name("name")
 *                 .numberAttributeConstraints(NumberAttributeConstraintsProperty.builder()
 *                         .maxValue("maxValue")
 *                         .minValue("minValue")
 *                         .build())
 *                 .required(false)
 *                 .stringAttributeConstraints(StringAttributeConstraintsProperty.builder()
 *                         .maxLength("maxLength")
 *                         .minLength("minLength")
 *                         .build())
 *                 .build()))
 *         .smsAuthenticationMessage("smsAuthenticationMessage")
 *         .smsConfiguration(SmsConfigurationProperty.builder()
 *                 .externalId("externalId")
 *                 .snsCallerArn("snsCallerArn")
 *                 .snsRegion("snsRegion")
 *                 .build())
 *         .smsVerificationMessage("smsVerificationMessage")
 *         .userAttributeUpdateSettings(UserAttributeUpdateSettingsProperty.builder()
 *                 .attributesRequireVerificationBeforeUpdate(List.of("attributesRequireVerificationBeforeUpdate"))
 *                 .build())
 *         .usernameAttributes(List.of("usernameAttributes"))
 *         .usernameConfiguration(UsernameConfigurationProperty.builder()
 *                 .caseSensitive(false)
 *                 .build())
 *         .userPoolAddOns(UserPoolAddOnsProperty.builder()
 *                 .advancedSecurityAdditionalFlows(AdvancedSecurityAdditionalFlowsProperty.builder()
 *                         .customAuthMode("customAuthMode")
 *                         .build())
 *                 .advancedSecurityMode("advancedSecurityMode")
 *                 .build())
 *         .userPoolName("userPoolName")
 *         .userPoolTags(userPoolTags)
 *         .userPoolTier("userPoolTier")
 *         .verificationMessageTemplate(VerificationMessageTemplateProperty.builder()
 *                 .defaultEmailOption("defaultEmailOption")
 *                 .emailMessage("emailMessage")
 *                 .emailMessageByLink("emailMessageByLink")
 *                 .emailSubject("emailSubject")
 *                 .emailSubjectByLink("emailSubjectByLink")
 *                 .smsMessage("smsMessage")
 *                 .build())
 *         .webAuthnRelyingPartyId("webAuthnRelyingPartyId")
 *         .webAuthnUserVerification("webAuthnUserVerification")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.076Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The available verified method a user can use to recover their password when they call <code>ForgotPassword</code> .
     * <p>
     * You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.AccountRecoverySettingProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-accountrecoverysetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-accountrecoverysetting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccountRecoverySetting() {
        return null;
    }

    /**
     * The settings for administrator creation of users in a user pool.
     * <p>
     * Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.AdminCreateUserConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-admincreateuserconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-admincreateuserconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdminCreateUserConfig() {
        return null;
    }

    /**
     * Attributes supported as an alias for this user pool.
     * <p>
     * For more information about alias attributes, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases">Customizing sign-in attributes</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-aliasattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-aliasattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliasAttributes() {
        return null;
    }

    /**
     * The attributes that you want your user pool to automatically verify.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves">Verifying contact information at sign-up</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-autoverifiedattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-autoverifiedattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoVerifiedAttributes() {
        return null;
    }

    /**
     * When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool.
     * <p>
     * Before you can delete a user pool that you have protected against deletion, you
     * must deactivate this feature.
     * <p>
     * When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new <code>DeleteUserPool</code> request after you deactivate deletion protection in an <code>UpdateUserPool</code> API request.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-deletionprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeletionProtection() {
        return null;
    }

    /**
     * The device-remembering configuration for a user pool.
     * <p>
     * Device remembering or device tracking is a "Remember me on this device" option for user pools that perform authentication with the device key of a trusted device in the back end, instead of a user-provided MFA code. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a> . A null value indicates that you have deactivated device remembering in your user pool.
     * <p>
     * <blockquote>
     * <p>
     * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with devices</a> .
     * <p>
     * </blockquote>
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.DeviceConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-deviceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-deviceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceConfiguration() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailauthenticationmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailauthenticationmessage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailAuthenticationMessage() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailauthenticationsubject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailauthenticationsubject</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailAuthenticationSubject() {
        return null;
    }

    /**
     * The email configuration of your user pool.
     * <p>
     * The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.EmailConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEmailConfiguration() {
        return null;
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html">VerificationMessageTemplateType</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationmessage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailVerificationMessage() {
        return null;
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html">VerificationMessageTemplateType</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationsubject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-emailverificationsubject</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailVerificationSubject() {
        return null;
    }

    /**
     * Set enabled MFA options on a specified user pool.
     * <p>
     * To disable all MFAs after it has been enabled, set <code>MfaConfiguration</code> to <code>OFF</code> and remove EnabledMfas. MFAs can only be all disabled if <code>MfaConfiguration</code> is <code>OFF</code> . After you enable <code>SMS_MFA</code> , you can only disable it by setting <code>MfaConfiguration</code> to <code>OFF</code> . Can be one of the following values:
     * <p>
     * <ul>
     * <li><code>SMS_MFA</code> - Enables MFA with SMS for the user pool. To select this option, you must also provide values for <code>SmsConfiguration</code> .</li>
     * <li><code>SOFTWARE_TOKEN_MFA</code> - Enables software token MFA for the user pool.</li>
     * <li><code>EMAIL_OTP</code> - Enables MFA with email for the user pool. To select this option, you must provide values for <code>EmailConfiguration</code> and within those, set <code>EmailSendingAccount</code> to <code>DEVELOPER</code> .</li>
     * </ul>
     * <p>
     * Allowed values: <code>SMS_MFA</code> | <code>SOFTWARE_TOKEN_MFA</code> | <code>EMAIL_OTP</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-enabledmfas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-enabledmfas</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnabledMfas() {
        return null;
    }

    /**
     * A collection of user pool Lambda triggers.
     * <p>
     * Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.LambdaConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-lambdaconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-lambdaconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfig() {
        return null;
    }

    /**
     * Displays the state of multi-factor authentication (MFA) as on, off, or optional.
     * <p>
     * When <code>ON</code> , all users must set up MFA before they can sign in. When <code>OPTIONAL</code> , your application must make a client-side determination of whether a user wants to register an MFA device. For user pools with adaptive authentication with threat protection, choose <code>OPTIONAL</code> .
     * <p>
     * When <code>MfaConfiguration</code> is <code>OPTIONAL</code> , managed login doesn't automatically prompt users to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users who have chosen and configured a preferred MFA factor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-mfaconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-mfaconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMfaConfiguration() {
        return null;
    }

    /**
     * A list of user pool policies.
     * <p>
     * Contains the policy that sets password-complexity requirements.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.PoliciesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-policies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return null;
    }

    /**
     * An array of attributes for the new user pool.
     * <p>
     * You can add custom attributes and modify the properties of default attributes. The specifications in this parameter set the required attributes in your user pool. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">Working with user attributes</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.SchemaAttributeProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-schema</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchema() {
        return null;
    }

    /**
     * The contents of the SMS authentication message.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsauthenticationmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsauthenticationmessage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsAuthenticationMessage() {
        return null;
    }

    /**
     * The settings for your Amazon Cognito user pool to send SMS messages with Amazon Simple Notification Service.
     * <p>
     * To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account . For more information see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.SmsConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSmsConfiguration() {
        return null;
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html">VerificationMessageTemplateType</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsverificationmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-smsverificationmessage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsVerificationMessage() {
        return null;
    }

    /**
     * The settings for updates to user attributes.
     * <p>
     * These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
     * a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
     * more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.UserAttributeUpdateSettingsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userattributeupdatesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userattributeupdatesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserAttributeUpdateSettings() {
        return null;
    }

    /**
     * Specifies whether a user can use an email address or phone number as a username when they sign up.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUsernameAttributes() {
        return null;
    }

    /**
     * Sets the case sensitivity option for sign-in usernames.
     * <p>
     * When <code>CaseSensitive</code> is <code>false</code> (case insensitive), users can sign in with any combination of capital and lowercase letters. For example, <code>username</code> , <code>USERNAME</code> , or <code>UserName</code> , or for email, <code>email&#64;example.com</code> or <code>EMaiL&#64;eXamplE.Com</code> . For most use cases, set case sensitivity to <code>false</code> as a best practice. When usernames and email addresses are case insensitive, Amazon Cognito treats any variation in case as the same user, and prevents a case variation from being assigned to the same attribute for a different user.
     * <p>
     * When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets <code>USERNAME</code> and <code>UserName</code> as distinct users.
     * <p>
     * This configuration is immutable after you set it.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.UsernameConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-usernameconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUsernameConfiguration() {
        return null;
    }

    /**
     * Contains settings for activation of threat protection, including the operating mode and additional authentication types.
     * <p>
     * To log user security information but take no action, set to <code>AUDIT</code> . To configure automatic security responses to potentially unwanted traffic to your user pool, set to <code>ENFORCED</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a> . To activate this setting, your user pool must be on the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html">Plus tier</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.UserPoolAddOnsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooladdons">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooladdons</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolAddOns() {
        return null;
    }

    /**
     * A friendly name for your user pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpoolname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpoolname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolName() {
        return null;
    }

    /**
     * The tag keys and values to assign to the user pool.
     * <p>
     * A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooltags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolTags() {
        return null;
    }

    /**
     * The user pool <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature plan</a> , or tier. This parameter determines the eligibility of the user pool for features like managed login, access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooltier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-userpooltier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolTier() {
        return null;
    }

    /**
     * The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.
     * <p>
     * Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For <code>CONFIRM_WITH_LINK</code> , specify an <code>EmailMessageByLink</code> and leave <code>EmailMessage</code> blank. For <code>CONFIRM_WITH_CODE</code> , specify an <code>EmailMessage</code> and leave <code>EmailMessageByLink</code> blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cognito.CfnUserPool.VerificationMessageTemplateProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-verificationmessagetemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-verificationmessagetemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVerificationMessageTemplate() {
        return null;
    }

    /**
     * Sets or displays the authentication domain, typically your user pool domain, that passkey providers must use as a relying party (RP) in their configuration.
     * <p>
     * Under the following conditions, the passkey relying party ID must be the fully-qualified domain name of your custom domain:
     * <p>
     * <ul>
     * <li>The user pool is configured for passkey authentication.</li>
     * <li>The user pool has a custom domain, whether or not it also has a prefix domain.</li>
     * <li>Your application performs authentication with managed login or the classic hosted UI.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-webauthnrelyingpartyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-webauthnrelyingpartyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebAuthnRelyingPartyId() {
        return null;
    }

    /**
     * When <code>required</code> , users can only register and sign in users with passkeys that are capable of <a href="https://docs.aws.amazon.com/https://www.w3.org/TR/webauthn-2/#enum-userVerificationRequirement">user verification</a> . When <code>preferred</code> , your user pool doesn't require the use of authenticators with user verification but encourages it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-webauthnuserverification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html#cfn-cognito-userpool-webauthnuserverification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebAuthnUserVerification() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolProps> {
        java.lang.Object accountRecoverySetting;
        java.lang.Object adminCreateUserConfig;
        java.util.List<java.lang.String> aliasAttributes;
        java.util.List<java.lang.String> autoVerifiedAttributes;
        java.lang.String deletionProtection;
        java.lang.Object deviceConfiguration;
        java.lang.String emailAuthenticationMessage;
        java.lang.String emailAuthenticationSubject;
        java.lang.Object emailConfiguration;
        java.lang.String emailVerificationMessage;
        java.lang.String emailVerificationSubject;
        java.util.List<java.lang.String> enabledMfas;
        java.lang.Object lambdaConfig;
        java.lang.String mfaConfiguration;
        java.lang.Object policies;
        java.lang.Object schema;
        java.lang.String smsAuthenticationMessage;
        java.lang.Object smsConfiguration;
        java.lang.String smsVerificationMessage;
        java.lang.Object userAttributeUpdateSettings;
        java.util.List<java.lang.String> usernameAttributes;
        java.lang.Object usernameConfiguration;
        java.lang.Object userPoolAddOns;
        java.lang.String userPoolName;
        java.lang.Object userPoolTags;
        java.lang.String userPoolTier;
        java.lang.Object verificationMessageTemplate;
        java.lang.String webAuthnRelyingPartyId;
        java.lang.String webAuthnUserVerification;

        /**
         * Sets the value of {@link CfnUserPoolProps#getAccountRecoverySetting}
         * @param accountRecoverySetting The available verified method a user can use to recover their password when they call <code>ForgotPassword</code> .
         *                               You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountRecoverySetting(software.amazon.awscdk.IResolvable accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAccountRecoverySetting}
         * @param accountRecoverySetting The available verified method a user can use to recover their password when they call <code>ForgotPassword</code> .
         *                               You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountRecoverySetting(software.amazon.awscdk.services.cognito.CfnUserPool.AccountRecoverySettingProperty accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAdminCreateUserConfig}
         * @param adminCreateUserConfig The settings for administrator creation of users in a user pool.
         *                              Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminCreateUserConfig(software.amazon.awscdk.IResolvable adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAdminCreateUserConfig}
         * @param adminCreateUserConfig The settings for administrator creation of users in a user pool.
         *                              Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminCreateUserConfig(software.amazon.awscdk.services.cognito.CfnUserPool.AdminCreateUserConfigProperty adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAliasAttributes}
         * @param aliasAttributes Attributes supported as an alias for this user pool.
         *                        For more information about alias attributes, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases">Customizing sign-in attributes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasAttributes(java.util.List<java.lang.String> aliasAttributes) {
            this.aliasAttributes = aliasAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAutoVerifiedAttributes}
         * @param autoVerifiedAttributes The attributes that you want your user pool to automatically verify.
         *                               For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves">Verifying contact information at sign-up</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoVerifiedAttributes(java.util.List<java.lang.String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = autoVerifiedAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getDeletionProtection}
         * @param deletionProtection When active, <code>DeletionProtection</code> prevents accidental deletion of your user pool.
         *                           Before you can delete a user pool that you have protected against deletion, you
         *                           must deactivate this feature.
         *                           <p>
         *                           When you try to delete a protected user pool in a <code>DeleteUserPool</code> API request, Amazon Cognito returns an <code>InvalidParameterException</code> error. To delete a protected user pool, send a new <code>DeleteUserPool</code> request after you deactivate deletion protection in an <code>UpdateUserPool</code> API request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.String deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getDeviceConfiguration}
         * @param deviceConfiguration The device-remembering configuration for a user pool.
         *                            Device remembering or device tracking is a "Remember me on this device" option for user pools that perform authentication with the device key of a trusted device in the back end, instead of a user-provided MFA code. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a> . A null value indicates that you have deactivated device remembering in your user pool.
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with devices</a> .
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceConfiguration(software.amazon.awscdk.IResolvable deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getDeviceConfiguration}
         * @param deviceConfiguration The device-remembering configuration for a user pool.
         *                            Device remembering or device tracking is a "Remember me on this device" option for user pools that perform authentication with the device key of a trusted device in the back end, instead of a user-provided MFA code. For more information about device authentication, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with user devices in your user pool</a> . A null value indicates that you have deactivated device remembering in your user pool.
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">Working with devices</a> .
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.DeviceConfigurationProperty deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailAuthenticationMessage}
         * @param emailAuthenticationMessage the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailAuthenticationMessage(java.lang.String emailAuthenticationMessage) {
            this.emailAuthenticationMessage = emailAuthenticationMessage;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailAuthenticationSubject}
         * @param emailAuthenticationSubject the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailAuthenticationSubject(java.lang.String emailAuthenticationSubject) {
            this.emailAuthenticationSubject = emailAuthenticationSubject;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailConfiguration}
         * @param emailConfiguration The email configuration of your user pool.
         *                           The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailConfiguration(software.amazon.awscdk.IResolvable emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailConfiguration}
         * @param emailConfiguration The email configuration of your user pool.
         *                           The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.EmailConfigurationProperty emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailVerificationMessage}
         * @param emailVerificationMessage This parameter is no longer used.
         *                                 See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html">VerificationMessageTemplateType</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerificationMessage(java.lang.String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailVerificationSubject}
         * @param emailVerificationSubject This parameter is no longer used.
         *                                 See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html">VerificationMessageTemplateType</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerificationSubject(java.lang.String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEnabledMfas}
         * @param enabledMfas Set enabled MFA options on a specified user pool.
         *                    To disable all MFAs after it has been enabled, set <code>MfaConfiguration</code> to <code>OFF</code> and remove EnabledMfas. MFAs can only be all disabled if <code>MfaConfiguration</code> is <code>OFF</code> . After you enable <code>SMS_MFA</code> , you can only disable it by setting <code>MfaConfiguration</code> to <code>OFF</code> . Can be one of the following values:
         *                    <p>
         *                    <ul>
         *                    <li><code>SMS_MFA</code> - Enables MFA with SMS for the user pool. To select this option, you must also provide values for <code>SmsConfiguration</code> .</li>
         *                    <li><code>SOFTWARE_TOKEN_MFA</code> - Enables software token MFA for the user pool.</li>
         *                    <li><code>EMAIL_OTP</code> - Enables MFA with email for the user pool. To select this option, you must provide values for <code>EmailConfiguration</code> and within those, set <code>EmailSendingAccount</code> to <code>DEVELOPER</code> .</li>
         *                    </ul>
         *                    <p>
         *                    Allowed values: <code>SMS_MFA</code> | <code>SOFTWARE_TOKEN_MFA</code> | <code>EMAIL_OTP</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabledMfas(java.util.List<java.lang.String> enabledMfas) {
            this.enabledMfas = enabledMfas;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getLambdaConfig}
         * @param lambdaConfig A collection of user pool Lambda triggers.
         *                     Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.IResolvable lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getLambdaConfig}
         * @param lambdaConfig A collection of user pool Lambda triggers.
         *                     Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.services.cognito.CfnUserPool.LambdaConfigProperty lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getMfaConfiguration}
         * @param mfaConfiguration Displays the state of multi-factor authentication (MFA) as on, off, or optional.
         *                         When <code>ON</code> , all users must set up MFA before they can sign in. When <code>OPTIONAL</code> , your application must make a client-side determination of whether a user wants to register an MFA device. For user pools with adaptive authentication with threat protection, choose <code>OPTIONAL</code> .
         *                         <p>
         *                         When <code>MfaConfiguration</code> is <code>OPTIONAL</code> , managed login doesn't automatically prompt users to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users who have chosen and configured a preferred MFA factor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mfaConfiguration(java.lang.String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getPolicies}
         * @param policies A list of user pool policies.
         *                 Contains the policy that sets password-complexity requirements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(software.amazon.awscdk.IResolvable policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getPolicies}
         * @param policies A list of user pool policies.
         *                 Contains the policy that sets password-complexity requirements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(software.amazon.awscdk.services.cognito.CfnUserPool.PoliciesProperty policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSchema}
         * @param schema An array of attributes for the new user pool.
         *               You can add custom attributes and modify the properties of default attributes. The specifications in this parameter set the required attributes in your user pool. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">Working with user attributes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(software.amazon.awscdk.IResolvable schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSchema}
         * @param schema An array of attributes for the new user pool.
         *               You can add custom attributes and modify the properties of default attributes. The specifications in this parameter set the required attributes in your user pool. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html">Working with user attributes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(java.util.List<? extends java.lang.Object> schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsAuthenticationMessage}
         * @param smsAuthenticationMessage The contents of the SMS authentication message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsAuthenticationMessage(java.lang.String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsConfiguration}
         * @param smsConfiguration The settings for your Amazon Cognito user pool to send SMS messages with Amazon Simple Notification Service.
         *                         To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account . For more information see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsConfiguration(software.amazon.awscdk.IResolvable smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsConfiguration}
         * @param smsConfiguration The settings for your Amazon Cognito user pool to send SMS messages with Amazon Simple Notification Service.
         *                         To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account . For more information see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.SmsConfigurationProperty smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsVerificationMessage}
         * @param smsVerificationMessage This parameter is no longer used.
         *                               See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html">VerificationMessageTemplateType</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsVerificationMessage(java.lang.String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserAttributeUpdateSettings}
         * @param userAttributeUpdateSettings The settings for updates to user attributes.
         *                                    These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
         *                                    a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
         *                                    more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributeUpdateSettings(software.amazon.awscdk.IResolvable userAttributeUpdateSettings) {
            this.userAttributeUpdateSettings = userAttributeUpdateSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserAttributeUpdateSettings}
         * @param userAttributeUpdateSettings The settings for updates to user attributes.
         *                                    These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
         *                                    a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
         *                                    more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributeUpdateSettings(software.amazon.awscdk.services.cognito.CfnUserPool.UserAttributeUpdateSettingsProperty userAttributeUpdateSettings) {
            this.userAttributeUpdateSettings = userAttributeUpdateSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUsernameAttributes}
         * @param usernameAttributes Specifies whether a user can use an email address or phone number as a username when they sign up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameAttributes(java.util.List<java.lang.String> usernameAttributes) {
            this.usernameAttributes = usernameAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUsernameConfiguration}
         * @param usernameConfiguration Sets the case sensitivity option for sign-in usernames.
         *                              When <code>CaseSensitive</code> is <code>false</code> (case insensitive), users can sign in with any combination of capital and lowercase letters. For example, <code>username</code> , <code>USERNAME</code> , or <code>UserName</code> , or for email, <code>email&#64;example.com</code> or <code>EMaiL&#64;eXamplE.Com</code> . For most use cases, set case sensitivity to <code>false</code> as a best practice. When usernames and email addresses are case insensitive, Amazon Cognito treats any variation in case as the same user, and prevents a case variation from being assigned to the same attribute for a different user.
         *                              <p>
         *                              When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets <code>USERNAME</code> and <code>UserName</code> as distinct users.
         *                              <p>
         *                              This configuration is immutable after you set it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameConfiguration(software.amazon.awscdk.IResolvable usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUsernameConfiguration}
         * @param usernameConfiguration Sets the case sensitivity option for sign-in usernames.
         *                              When <code>CaseSensitive</code> is <code>false</code> (case insensitive), users can sign in with any combination of capital and lowercase letters. For example, <code>username</code> , <code>USERNAME</code> , or <code>UserName</code> , or for email, <code>email&#64;example.com</code> or <code>EMaiL&#64;eXamplE.Com</code> . For most use cases, set case sensitivity to <code>false</code> as a best practice. When usernames and email addresses are case insensitive, Amazon Cognito treats any variation in case as the same user, and prevents a case variation from being assigned to the same attribute for a different user.
         *                              <p>
         *                              When <code>CaseSensitive</code> is <code>true</code> (case sensitive), Amazon Cognito interprets <code>USERNAME</code> and <code>UserName</code> as distinct users.
         *                              <p>
         *                              This configuration is immutable after you set it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.UsernameConfigurationProperty usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolAddOns}
         * @param userPoolAddOns Contains settings for activation of threat protection, including the operating mode and additional authentication types.
         *                       To log user security information but take no action, set to <code>AUDIT</code> . To configure automatic security responses to potentially unwanted traffic to your user pool, set to <code>ENFORCED</code> .
         *                       <p>
         *                       For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a> . To activate this setting, your user pool must be on the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html">Plus tier</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolAddOns(software.amazon.awscdk.IResolvable userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolAddOns}
         * @param userPoolAddOns Contains settings for activation of threat protection, including the operating mode and additional authentication types.
         *                       To log user security information but take no action, set to <code>AUDIT</code> . To configure automatic security responses to potentially unwanted traffic to your user pool, set to <code>ENFORCED</code> .
         *                       <p>
         *                       For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">Adding advanced security to a user pool</a> . To activate this setting, your user pool must be on the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html">Plus tier</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolAddOns(software.amazon.awscdk.services.cognito.CfnUserPool.UserPoolAddOnsProperty userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolName}
         * @param userPoolName A friendly name for your user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolName(java.lang.String userPoolName) {
            this.userPoolName = userPoolName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolTags}
         * @param userPoolTags The tag keys and values to assign to the user pool.
         *                     A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolTags(java.lang.Object userPoolTags) {
            this.userPoolTags = userPoolTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolTier}
         * @param userPoolTier The user pool <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">feature plan</a> , or tier. This parameter determines the eligibility of the user pool for features like managed login, access-token customization, and threat protection. Defaults to <code>ESSENTIALS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolTier(java.lang.String userPoolTier) {
            this.userPoolTier = userPoolTier;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getVerificationMessageTemplate}
         * @param verificationMessageTemplate The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.
         *                                    Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For <code>CONFIRM_WITH_LINK</code> , specify an <code>EmailMessageByLink</code> and leave <code>EmailMessage</code> blank. For <code>CONFIRM_WITH_CODE</code> , specify an <code>EmailMessage</code> and leave <code>EmailMessageByLink</code> blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationMessageTemplate(software.amazon.awscdk.IResolvable verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getVerificationMessageTemplate}
         * @param verificationMessageTemplate The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.
         *                                    Set the email message type that corresponds to your <code>DefaultEmailOption</code> selection. For <code>CONFIRM_WITH_LINK</code> , specify an <code>EmailMessageByLink</code> and leave <code>EmailMessage</code> blank. For <code>CONFIRM_WITH_CODE</code> , specify an <code>EmailMessage</code> and leave <code>EmailMessageByLink</code> blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationMessageTemplate(software.amazon.awscdk.services.cognito.CfnUserPool.VerificationMessageTemplateProperty verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getWebAuthnRelyingPartyId}
         * @param webAuthnRelyingPartyId Sets or displays the authentication domain, typically your user pool domain, that passkey providers must use as a relying party (RP) in their configuration.
         *                               Under the following conditions, the passkey relying party ID must be the fully-qualified domain name of your custom domain:
         *                               <p>
         *                               <ul>
         *                               <li>The user pool is configured for passkey authentication.</li>
         *                               <li>The user pool has a custom domain, whether or not it also has a prefix domain.</li>
         *                               <li>Your application performs authentication with managed login or the classic hosted UI.</li>
         *                               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAuthnRelyingPartyId(java.lang.String webAuthnRelyingPartyId) {
            this.webAuthnRelyingPartyId = webAuthnRelyingPartyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getWebAuthnUserVerification}
         * @param webAuthnUserVerification When <code>required</code> , users can only register and sign in users with passkeys that are capable of <a href="https://docs.aws.amazon.com/https://www.w3.org/TR/webauthn-2/#enum-userVerificationRequirement">user verification</a> . When <code>preferred</code> , your user pool doesn't require the use of authenticators with user verification but encourages it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAuthnUserVerification(java.lang.String webAuthnUserVerification) {
            this.webAuthnUserVerification = webAuthnUserVerification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolProps {
        private final java.lang.Object accountRecoverySetting;
        private final java.lang.Object adminCreateUserConfig;
        private final java.util.List<java.lang.String> aliasAttributes;
        private final java.util.List<java.lang.String> autoVerifiedAttributes;
        private final java.lang.String deletionProtection;
        private final java.lang.Object deviceConfiguration;
        private final java.lang.String emailAuthenticationMessage;
        private final java.lang.String emailAuthenticationSubject;
        private final java.lang.Object emailConfiguration;
        private final java.lang.String emailVerificationMessage;
        private final java.lang.String emailVerificationSubject;
        private final java.util.List<java.lang.String> enabledMfas;
        private final java.lang.Object lambdaConfig;
        private final java.lang.String mfaConfiguration;
        private final java.lang.Object policies;
        private final java.lang.Object schema;
        private final java.lang.String smsAuthenticationMessage;
        private final java.lang.Object smsConfiguration;
        private final java.lang.String smsVerificationMessage;
        private final java.lang.Object userAttributeUpdateSettings;
        private final java.util.List<java.lang.String> usernameAttributes;
        private final java.lang.Object usernameConfiguration;
        private final java.lang.Object userPoolAddOns;
        private final java.lang.String userPoolName;
        private final java.lang.Object userPoolTags;
        private final java.lang.String userPoolTier;
        private final java.lang.Object verificationMessageTemplate;
        private final java.lang.String webAuthnRelyingPartyId;
        private final java.lang.String webAuthnUserVerification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountRecoverySetting = software.amazon.jsii.Kernel.get(this, "accountRecoverySetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.adminCreateUserConfig = software.amazon.jsii.Kernel.get(this, "adminCreateUserConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.aliasAttributes = software.amazon.jsii.Kernel.get(this, "aliasAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.autoVerifiedAttributes = software.amazon.jsii.Kernel.get(this, "autoVerifiedAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deviceConfiguration = software.amazon.jsii.Kernel.get(this, "deviceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.emailAuthenticationMessage = software.amazon.jsii.Kernel.get(this, "emailAuthenticationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.emailAuthenticationSubject = software.amazon.jsii.Kernel.get(this, "emailAuthenticationSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.emailConfiguration = software.amazon.jsii.Kernel.get(this, "emailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.emailVerificationMessage = software.amazon.jsii.Kernel.get(this, "emailVerificationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.emailVerificationSubject = software.amazon.jsii.Kernel.get(this, "emailVerificationSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabledMfas = software.amazon.jsii.Kernel.get(this, "enabledMfas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.lambdaConfig = software.amazon.jsii.Kernel.get(this, "lambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mfaConfiguration = software.amazon.jsii.Kernel.get(this, "mfaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policies = software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.smsAuthenticationMessage = software.amazon.jsii.Kernel.get(this, "smsAuthenticationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.smsConfiguration = software.amazon.jsii.Kernel.get(this, "smsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.smsVerificationMessage = software.amazon.jsii.Kernel.get(this, "smsVerificationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userAttributeUpdateSettings = software.amazon.jsii.Kernel.get(this, "userAttributeUpdateSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.usernameAttributes = software.amazon.jsii.Kernel.get(this, "usernameAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.usernameConfiguration = software.amazon.jsii.Kernel.get(this, "usernameConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.userPoolAddOns = software.amazon.jsii.Kernel.get(this, "userPoolAddOns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.userPoolName = software.amazon.jsii.Kernel.get(this, "userPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolTags = software.amazon.jsii.Kernel.get(this, "userPoolTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.userPoolTier = software.amazon.jsii.Kernel.get(this, "userPoolTier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.verificationMessageTemplate = software.amazon.jsii.Kernel.get(this, "verificationMessageTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.webAuthnRelyingPartyId = software.amazon.jsii.Kernel.get(this, "webAuthnRelyingPartyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webAuthnUserVerification = software.amazon.jsii.Kernel.get(this, "webAuthnUserVerification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountRecoverySetting = builder.accountRecoverySetting;
            this.adminCreateUserConfig = builder.adminCreateUserConfig;
            this.aliasAttributes = builder.aliasAttributes;
            this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
            this.deletionProtection = builder.deletionProtection;
            this.deviceConfiguration = builder.deviceConfiguration;
            this.emailAuthenticationMessage = builder.emailAuthenticationMessage;
            this.emailAuthenticationSubject = builder.emailAuthenticationSubject;
            this.emailConfiguration = builder.emailConfiguration;
            this.emailVerificationMessage = builder.emailVerificationMessage;
            this.emailVerificationSubject = builder.emailVerificationSubject;
            this.enabledMfas = builder.enabledMfas;
            this.lambdaConfig = builder.lambdaConfig;
            this.mfaConfiguration = builder.mfaConfiguration;
            this.policies = builder.policies;
            this.schema = builder.schema;
            this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
            this.smsConfiguration = builder.smsConfiguration;
            this.smsVerificationMessage = builder.smsVerificationMessage;
            this.userAttributeUpdateSettings = builder.userAttributeUpdateSettings;
            this.usernameAttributes = builder.usernameAttributes;
            this.usernameConfiguration = builder.usernameConfiguration;
            this.userPoolAddOns = builder.userPoolAddOns;
            this.userPoolName = builder.userPoolName;
            this.userPoolTags = builder.userPoolTags;
            this.userPoolTier = builder.userPoolTier;
            this.verificationMessageTemplate = builder.verificationMessageTemplate;
            this.webAuthnRelyingPartyId = builder.webAuthnRelyingPartyId;
            this.webAuthnUserVerification = builder.webAuthnUserVerification;
        }

        @Override
        public final java.lang.Object getAccountRecoverySetting() {
            return this.accountRecoverySetting;
        }

        @Override
        public final java.lang.Object getAdminCreateUserConfig() {
            return this.adminCreateUserConfig;
        }

        @Override
        public final java.util.List<java.lang.String> getAliasAttributes() {
            return this.aliasAttributes;
        }

        @Override
        public final java.util.List<java.lang.String> getAutoVerifiedAttributes() {
            return this.autoVerifiedAttributes;
        }

        @Override
        public final java.lang.String getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.Object getDeviceConfiguration() {
            return this.deviceConfiguration;
        }

        @Override
        public final java.lang.String getEmailAuthenticationMessage() {
            return this.emailAuthenticationMessage;
        }

        @Override
        public final java.lang.String getEmailAuthenticationSubject() {
            return this.emailAuthenticationSubject;
        }

        @Override
        public final java.lang.Object getEmailConfiguration() {
            return this.emailConfiguration;
        }

        @Override
        public final java.lang.String getEmailVerificationMessage() {
            return this.emailVerificationMessage;
        }

        @Override
        public final java.lang.String getEmailVerificationSubject() {
            return this.emailVerificationSubject;
        }

        @Override
        public final java.util.List<java.lang.String> getEnabledMfas() {
            return this.enabledMfas;
        }

        @Override
        public final java.lang.Object getLambdaConfig() {
            return this.lambdaConfig;
        }

        @Override
        public final java.lang.String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        @Override
        public final java.lang.Object getPolicies() {
            return this.policies;
        }

        @Override
        public final java.lang.Object getSchema() {
            return this.schema;
        }

        @Override
        public final java.lang.String getSmsAuthenticationMessage() {
            return this.smsAuthenticationMessage;
        }

        @Override
        public final java.lang.Object getSmsConfiguration() {
            return this.smsConfiguration;
        }

        @Override
        public final java.lang.String getSmsVerificationMessage() {
            return this.smsVerificationMessage;
        }

        @Override
        public final java.lang.Object getUserAttributeUpdateSettings() {
            return this.userAttributeUpdateSettings;
        }

        @Override
        public final java.util.List<java.lang.String> getUsernameAttributes() {
            return this.usernameAttributes;
        }

        @Override
        public final java.lang.Object getUsernameConfiguration() {
            return this.usernameConfiguration;
        }

        @Override
        public final java.lang.Object getUserPoolAddOns() {
            return this.userPoolAddOns;
        }

        @Override
        public final java.lang.String getUserPoolName() {
            return this.userPoolName;
        }

        @Override
        public final java.lang.Object getUserPoolTags() {
            return this.userPoolTags;
        }

        @Override
        public final java.lang.String getUserPoolTier() {
            return this.userPoolTier;
        }

        @Override
        public final java.lang.Object getVerificationMessageTemplate() {
            return this.verificationMessageTemplate;
        }

        @Override
        public final java.lang.String getWebAuthnRelyingPartyId() {
            return this.webAuthnRelyingPartyId;
        }

        @Override
        public final java.lang.String getWebAuthnUserVerification() {
            return this.webAuthnUserVerification;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountRecoverySetting() != null) {
                data.set("accountRecoverySetting", om.valueToTree(this.getAccountRecoverySetting()));
            }
            if (this.getAdminCreateUserConfig() != null) {
                data.set("adminCreateUserConfig", om.valueToTree(this.getAdminCreateUserConfig()));
            }
            if (this.getAliasAttributes() != null) {
                data.set("aliasAttributes", om.valueToTree(this.getAliasAttributes()));
            }
            if (this.getAutoVerifiedAttributes() != null) {
                data.set("autoVerifiedAttributes", om.valueToTree(this.getAutoVerifiedAttributes()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getDeviceConfiguration() != null) {
                data.set("deviceConfiguration", om.valueToTree(this.getDeviceConfiguration()));
            }
            if (this.getEmailAuthenticationMessage() != null) {
                data.set("emailAuthenticationMessage", om.valueToTree(this.getEmailAuthenticationMessage()));
            }
            if (this.getEmailAuthenticationSubject() != null) {
                data.set("emailAuthenticationSubject", om.valueToTree(this.getEmailAuthenticationSubject()));
            }
            if (this.getEmailConfiguration() != null) {
                data.set("emailConfiguration", om.valueToTree(this.getEmailConfiguration()));
            }
            if (this.getEmailVerificationMessage() != null) {
                data.set("emailVerificationMessage", om.valueToTree(this.getEmailVerificationMessage()));
            }
            if (this.getEmailVerificationSubject() != null) {
                data.set("emailVerificationSubject", om.valueToTree(this.getEmailVerificationSubject()));
            }
            if (this.getEnabledMfas() != null) {
                data.set("enabledMfas", om.valueToTree(this.getEnabledMfas()));
            }
            if (this.getLambdaConfig() != null) {
                data.set("lambdaConfig", om.valueToTree(this.getLambdaConfig()));
            }
            if (this.getMfaConfiguration() != null) {
                data.set("mfaConfiguration", om.valueToTree(this.getMfaConfiguration()));
            }
            if (this.getPolicies() != null) {
                data.set("policies", om.valueToTree(this.getPolicies()));
            }
            if (this.getSchema() != null) {
                data.set("schema", om.valueToTree(this.getSchema()));
            }
            if (this.getSmsAuthenticationMessage() != null) {
                data.set("smsAuthenticationMessage", om.valueToTree(this.getSmsAuthenticationMessage()));
            }
            if (this.getSmsConfiguration() != null) {
                data.set("smsConfiguration", om.valueToTree(this.getSmsConfiguration()));
            }
            if (this.getSmsVerificationMessage() != null) {
                data.set("smsVerificationMessage", om.valueToTree(this.getSmsVerificationMessage()));
            }
            if (this.getUserAttributeUpdateSettings() != null) {
                data.set("userAttributeUpdateSettings", om.valueToTree(this.getUserAttributeUpdateSettings()));
            }
            if (this.getUsernameAttributes() != null) {
                data.set("usernameAttributes", om.valueToTree(this.getUsernameAttributes()));
            }
            if (this.getUsernameConfiguration() != null) {
                data.set("usernameConfiguration", om.valueToTree(this.getUsernameConfiguration()));
            }
            if (this.getUserPoolAddOns() != null) {
                data.set("userPoolAddOns", om.valueToTree(this.getUserPoolAddOns()));
            }
            if (this.getUserPoolName() != null) {
                data.set("userPoolName", om.valueToTree(this.getUserPoolName()));
            }
            if (this.getUserPoolTags() != null) {
                data.set("userPoolTags", om.valueToTree(this.getUserPoolTags()));
            }
            if (this.getUserPoolTier() != null) {
                data.set("userPoolTier", om.valueToTree(this.getUserPoolTier()));
            }
            if (this.getVerificationMessageTemplate() != null) {
                data.set("verificationMessageTemplate", om.valueToTree(this.getVerificationMessageTemplate()));
            }
            if (this.getWebAuthnRelyingPartyId() != null) {
                data.set("webAuthnRelyingPartyId", om.valueToTree(this.getWebAuthnRelyingPartyId()));
            }
            if (this.getWebAuthnUserVerification() != null) {
                data.set("webAuthnUserVerification", om.valueToTree(this.getWebAuthnUserVerification()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolProps.Jsii$Proxy that = (CfnUserPoolProps.Jsii$Proxy) o;

            if (this.accountRecoverySetting != null ? !this.accountRecoverySetting.equals(that.accountRecoverySetting) : that.accountRecoverySetting != null) return false;
            if (this.adminCreateUserConfig != null ? !this.adminCreateUserConfig.equals(that.adminCreateUserConfig) : that.adminCreateUserConfig != null) return false;
            if (this.aliasAttributes != null ? !this.aliasAttributes.equals(that.aliasAttributes) : that.aliasAttributes != null) return false;
            if (this.autoVerifiedAttributes != null ? !this.autoVerifiedAttributes.equals(that.autoVerifiedAttributes) : that.autoVerifiedAttributes != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.deviceConfiguration != null ? !this.deviceConfiguration.equals(that.deviceConfiguration) : that.deviceConfiguration != null) return false;
            if (this.emailAuthenticationMessage != null ? !this.emailAuthenticationMessage.equals(that.emailAuthenticationMessage) : that.emailAuthenticationMessage != null) return false;
            if (this.emailAuthenticationSubject != null ? !this.emailAuthenticationSubject.equals(that.emailAuthenticationSubject) : that.emailAuthenticationSubject != null) return false;
            if (this.emailConfiguration != null ? !this.emailConfiguration.equals(that.emailConfiguration) : that.emailConfiguration != null) return false;
            if (this.emailVerificationMessage != null ? !this.emailVerificationMessage.equals(that.emailVerificationMessage) : that.emailVerificationMessage != null) return false;
            if (this.emailVerificationSubject != null ? !this.emailVerificationSubject.equals(that.emailVerificationSubject) : that.emailVerificationSubject != null) return false;
            if (this.enabledMfas != null ? !this.enabledMfas.equals(that.enabledMfas) : that.enabledMfas != null) return false;
            if (this.lambdaConfig != null ? !this.lambdaConfig.equals(that.lambdaConfig) : that.lambdaConfig != null) return false;
            if (this.mfaConfiguration != null ? !this.mfaConfiguration.equals(that.mfaConfiguration) : that.mfaConfiguration != null) return false;
            if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) return false;
            if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) return false;
            if (this.smsAuthenticationMessage != null ? !this.smsAuthenticationMessage.equals(that.smsAuthenticationMessage) : that.smsAuthenticationMessage != null) return false;
            if (this.smsConfiguration != null ? !this.smsConfiguration.equals(that.smsConfiguration) : that.smsConfiguration != null) return false;
            if (this.smsVerificationMessage != null ? !this.smsVerificationMessage.equals(that.smsVerificationMessage) : that.smsVerificationMessage != null) return false;
            if (this.userAttributeUpdateSettings != null ? !this.userAttributeUpdateSettings.equals(that.userAttributeUpdateSettings) : that.userAttributeUpdateSettings != null) return false;
            if (this.usernameAttributes != null ? !this.usernameAttributes.equals(that.usernameAttributes) : that.usernameAttributes != null) return false;
            if (this.usernameConfiguration != null ? !this.usernameConfiguration.equals(that.usernameConfiguration) : that.usernameConfiguration != null) return false;
            if (this.userPoolAddOns != null ? !this.userPoolAddOns.equals(that.userPoolAddOns) : that.userPoolAddOns != null) return false;
            if (this.userPoolName != null ? !this.userPoolName.equals(that.userPoolName) : that.userPoolName != null) return false;
            if (this.userPoolTags != null ? !this.userPoolTags.equals(that.userPoolTags) : that.userPoolTags != null) return false;
            if (this.userPoolTier != null ? !this.userPoolTier.equals(that.userPoolTier) : that.userPoolTier != null) return false;
            if (this.verificationMessageTemplate != null ? !this.verificationMessageTemplate.equals(that.verificationMessageTemplate) : that.verificationMessageTemplate != null) return false;
            if (this.webAuthnRelyingPartyId != null ? !this.webAuthnRelyingPartyId.equals(that.webAuthnRelyingPartyId) : that.webAuthnRelyingPartyId != null) return false;
            return this.webAuthnUserVerification != null ? this.webAuthnUserVerification.equals(that.webAuthnUserVerification) : that.webAuthnUserVerification == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountRecoverySetting != null ? this.accountRecoverySetting.hashCode() : 0;
            result = 31 * result + (this.adminCreateUserConfig != null ? this.adminCreateUserConfig.hashCode() : 0);
            result = 31 * result + (this.aliasAttributes != null ? this.aliasAttributes.hashCode() : 0);
            result = 31 * result + (this.autoVerifiedAttributes != null ? this.autoVerifiedAttributes.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.deviceConfiguration != null ? this.deviceConfiguration.hashCode() : 0);
            result = 31 * result + (this.emailAuthenticationMessage != null ? this.emailAuthenticationMessage.hashCode() : 0);
            result = 31 * result + (this.emailAuthenticationSubject != null ? this.emailAuthenticationSubject.hashCode() : 0);
            result = 31 * result + (this.emailConfiguration != null ? this.emailConfiguration.hashCode() : 0);
            result = 31 * result + (this.emailVerificationMessage != null ? this.emailVerificationMessage.hashCode() : 0);
            result = 31 * result + (this.emailVerificationSubject != null ? this.emailVerificationSubject.hashCode() : 0);
            result = 31 * result + (this.enabledMfas != null ? this.enabledMfas.hashCode() : 0);
            result = 31 * result + (this.lambdaConfig != null ? this.lambdaConfig.hashCode() : 0);
            result = 31 * result + (this.mfaConfiguration != null ? this.mfaConfiguration.hashCode() : 0);
            result = 31 * result + (this.policies != null ? this.policies.hashCode() : 0);
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            result = 31 * result + (this.smsAuthenticationMessage != null ? this.smsAuthenticationMessage.hashCode() : 0);
            result = 31 * result + (this.smsConfiguration != null ? this.smsConfiguration.hashCode() : 0);
            result = 31 * result + (this.smsVerificationMessage != null ? this.smsVerificationMessage.hashCode() : 0);
            result = 31 * result + (this.userAttributeUpdateSettings != null ? this.userAttributeUpdateSettings.hashCode() : 0);
            result = 31 * result + (this.usernameAttributes != null ? this.usernameAttributes.hashCode() : 0);
            result = 31 * result + (this.usernameConfiguration != null ? this.usernameConfiguration.hashCode() : 0);
            result = 31 * result + (this.userPoolAddOns != null ? this.userPoolAddOns.hashCode() : 0);
            result = 31 * result + (this.userPoolName != null ? this.userPoolName.hashCode() : 0);
            result = 31 * result + (this.userPoolTags != null ? this.userPoolTags.hashCode() : 0);
            result = 31 * result + (this.userPoolTier != null ? this.userPoolTier.hashCode() : 0);
            result = 31 * result + (this.verificationMessageTemplate != null ? this.verificationMessageTemplate.hashCode() : 0);
            result = 31 * result + (this.webAuthnRelyingPartyId != null ? this.webAuthnRelyingPartyId.hashCode() : 0);
            result = 31 * result + (this.webAuthnUserVerification != null ? this.webAuthnUserVerification.hashCode() : 0);
            return result;
        }
    }
}
