package software.amazon.awscdk.services.cognito;

/**
 * Sign-in policy for User Pools.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         .signInPolicy(SignInPolicy.builder()
 *                 .allowedFirstAuthFactors(AllowedFirstAuthFactors.builder().password(true).passkey(true).build())
 *                 .build())
 *         .passkeyRelyingPartyId("auth.example.com")
 *         .passkeyUserVerification(PasskeyUserVerification.REQUIRED)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.123Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.SignInPolicy")
@software.amazon.jsii.Jsii.Proxy(SignInPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SignInPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The types of authentication that you want to allow for users' first authentication prompt.
     * <p>
     * Default: - Password only
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice">https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AllowedFirstAuthFactors getAllowedFirstAuthFactors() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SignInPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SignInPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SignInPolicy> {
        software.amazon.awscdk.services.cognito.AllowedFirstAuthFactors allowedFirstAuthFactors;

        /**
         * Sets the value of {@link SignInPolicy#getAllowedFirstAuthFactors}
         * @param allowedFirstAuthFactors The types of authentication that you want to allow for users' first authentication prompt.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedFirstAuthFactors(software.amazon.awscdk.services.cognito.AllowedFirstAuthFactors allowedFirstAuthFactors) {
            this.allowedFirstAuthFactors = allowedFirstAuthFactors;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SignInPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SignInPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SignInPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignInPolicy {
        private final software.amazon.awscdk.services.cognito.AllowedFirstAuthFactors allowedFirstAuthFactors;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedFirstAuthFactors = software.amazon.jsii.Kernel.get(this, "allowedFirstAuthFactors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AllowedFirstAuthFactors.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedFirstAuthFactors = builder.allowedFirstAuthFactors;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AllowedFirstAuthFactors getAllowedFirstAuthFactors() {
            return this.allowedFirstAuthFactors;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedFirstAuthFactors() != null) {
                data.set("allowedFirstAuthFactors", om.valueToTree(this.getAllowedFirstAuthFactors()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.SignInPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SignInPolicy.Jsii$Proxy that = (SignInPolicy.Jsii$Proxy) o;

            return this.allowedFirstAuthFactors != null ? this.allowedFirstAuthFactors.equals(that.allowedFirstAuthFactors) : that.allowedFirstAuthFactors == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedFirstAuthFactors != null ? this.allowedFirstAuthFactors.hashCode() : 0;
            return result;
        }
    }
}
