package software.amazon.awscdk.services.cognito;

/**
 * Signing algorithms for SAML requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = new UserPool(this, "Pool");
 * // specify the metadata as a file content
 * // specify the metadata as a file content
 * UserPoolIdentityProviderSaml.Builder.create(this, "userpoolIdpFile")
 *         .userPool(userpool)
 *         .metadata(UserPoolIdentityProviderSamlMetadata.file("my-file-contents"))
 *         // Whether to require encrypted SAML assertions from IdP
 *         .encryptedResponses(true)
 *         // The signing algorithm for the SAML requests
 *         .requestSigningAlgorithm(SigningAlgorithm.RSA_SHA256)
 *         // Enable IdP initiated SAML auth flow
 *         .idpInitiated(true)
 *         .build();
 * // specify the metadata as a URL
 * // specify the metadata as a URL
 * UserPoolIdentityProviderSaml.Builder.create(this, "userpoolidpUrl")
 *         .userPool(userpool)
 *         .metadata(UserPoolIdentityProviderSamlMetadata.url("https://my-metadata-url.com"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.123Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.SigningAlgorithm")
public enum SigningAlgorithm {
    /**
     * RSA with SHA-256.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA_SHA256,
}
