package software.amazon.awscdk.services.cognito.identitypool;

/**
 * Types of matches allowed for role mapping.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl;
 * import software.amazon.awscdk.services.cognito.identitypool.RoleMappingMatchType;
 * Role adminRole;
 * Role nonAdminRole;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         // Assign specific roles to users based on whether or not the custom admin claim is passed from the identity provider
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .providerUrl(IdentityPoolProviderUrl.AMAZON)
 *                 .rules(List.of(RoleMappingRule.builder()
 *                         .claim("custom:admin")
 *                         .claimValue("admin")
 *                         .mappedRole(adminRole)
 *                         .build(), RoleMappingRule.builder()
 *                         .claim("custom:admin")
 *                         .claimValue("admin")
 *                         .matchType(RoleMappingMatchType.NOTEQUAL)
 *                         .mappedRole(nonAdminRole)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.191Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito_identitypool.RoleMappingMatchType")
public enum RoleMappingMatchType {
    /**
     * The claim from the token must equal the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EQUALS,
    /**
     * The claim from the token must contain the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONTAINS,
    /**
     * The claim from the token must start with the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STARTS_WITH,
    /**
     * The claim from the token must not equal the given value in order for a match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NOTEQUAL,
}
