package software.amazon.awscdk.services.customerprofiles;

/**
 * Properties for defining a <code>CfnDomain</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnDomainProps cfnDomainProps = CfnDomainProps.builder()
 *         .defaultExpirationDays(123)
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .deadLetterQueueUrl("deadLetterQueueUrl")
 *         .defaultEncryptionKey("defaultEncryptionKey")
 *         .matching(MatchingProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .autoMerging(AutoMergingProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .conflictResolution(ConflictResolutionProperty.builder()
 *                                 .conflictResolvingModel("conflictResolvingModel")
 *                                 // the properties below are optional
 *                                 .sourceName("sourceName")
 *                                 .build())
 *                         .consolidation(ConsolidationProperty.builder()
 *                                 .matchingAttributesList(List.of(List.of("matchingAttributesList")))
 *                                 .build())
 *                         .minAllowedConfidenceScoreForMerging(123)
 *                         .build())
 *                 .exportingConfig(ExportingConfigProperty.builder()
 *                         .s3Exporting(S3ExportingConfigProperty.builder()
 *                                 .s3BucketName("s3BucketName")
 *                                 // the properties below are optional
 *                                 .s3KeyName("s3KeyName")
 *                                 .build())
 *                         .build())
 *                 .jobSchedule(JobScheduleProperty.builder()
 *                         .dayOfTheWeek("dayOfTheWeek")
 *                         .time("time")
 *                         .build())
 *                 .build())
 *         .ruleBasedMatching(RuleBasedMatchingProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .attributeTypesSelector(AttributeTypesSelectorProperty.builder()
 *                         .attributeMatchingModel("attributeMatchingModel")
 *                         // the properties below are optional
 *                         .address(List.of("address"))
 *                         .emailAddress(List.of("emailAddress"))
 *                         .phoneNumber(List.of("phoneNumber"))
 *                         .build())
 *                 .conflictResolution(ConflictResolutionProperty.builder()
 *                         .conflictResolvingModel("conflictResolvingModel")
 *                         // the properties below are optional
 *                         .sourceName("sourceName")
 *                         .build())
 *                 .exportingConfig(ExportingConfigProperty.builder()
 *                         .s3Exporting(S3ExportingConfigProperty.builder()
 *                                 .s3BucketName("s3BucketName")
 *                                 // the properties below are optional
 *                                 .s3KeyName("s3KeyName")
 *                                 .build())
 *                         .build())
 *                 .matchingRules(List.of(MatchingRuleProperty.builder()
 *                         .rule(List.of("rule"))
 *                         .build()))
 *                 .maxAllowedRuleLevelForMatching(123)
 *                 .maxAllowedRuleLevelForMerging(123)
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.519Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The default number of days until the data within the domain expires.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultexpirationdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultexpirationdays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getDefaultExpirationDays();

    /**
     * The unique name of the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
     * <p>
     * You must set up a policy on the <code>DeadLetterQueue</code> for the <code>SendMessage</code> operation to enable Amazon Connect Customer Profiles to send messages to the <code>DeadLetterQueue</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-deadletterqueueurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-deadletterqueueurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeadLetterQueueUrl() {
        return null;
    }

    /**
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified.
     * <p>
     * It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultencryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultencryptionkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultEncryptionKey() {
        return null;
    }

    /**
     * The process of matching duplicate profiles.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.customerprofiles.CfnDomain.MatchingProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-matching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-matching</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMatching() {
        return null;
    }

    /**
     * The process of matching duplicate profiles using Rule-Based matching.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.customerprofiles.CfnDomain.RuleBasedMatchingProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-rulebasedmatching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-rulebasedmatching</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuleBasedMatching() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainProps> {
        java.lang.Number defaultExpirationDays;
        java.lang.String domainName;
        java.lang.String deadLetterQueueUrl;
        java.lang.String defaultEncryptionKey;
        java.lang.Object matching;
        java.lang.Object ruleBasedMatching;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultExpirationDays}
         * @param defaultExpirationDays The default number of days until the data within the domain expires. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultExpirationDays(java.lang.Number defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainName}
         * @param domainName The unique name of the domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDeadLetterQueueUrl}
         * @param deadLetterQueueUrl The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
         *                           You must set up a policy on the <code>DeadLetterQueue</code> for the <code>SendMessage</code> operation to enable Amazon Connect Customer Profiles to send messages to the <code>DeadLetterQueue</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueUrl(java.lang.String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultEncryptionKey}
         * @param defaultEncryptionKey The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified.
         *                             It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultEncryptionKey(java.lang.String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getMatching}
         * @param matching The process of matching duplicate profiles.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matching(software.amazon.awscdk.IResolvable matching) {
            this.matching = matching;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getMatching}
         * @param matching The process of matching duplicate profiles.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matching(software.amazon.awscdk.services.customerprofiles.CfnDomain.MatchingProperty matching) {
            this.matching = matching;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getRuleBasedMatching}
         * @param ruleBasedMatching The process of matching duplicate profiles using Rule-Based matching.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleBasedMatching(software.amazon.awscdk.IResolvable ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getRuleBasedMatching}
         * @param ruleBasedMatching The process of matching duplicate profiles using Rule-Based matching.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleBasedMatching(software.amazon.awscdk.services.customerprofiles.CfnDomain.RuleBasedMatchingProperty ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainProps {
        private final java.lang.Number defaultExpirationDays;
        private final java.lang.String domainName;
        private final java.lang.String deadLetterQueueUrl;
        private final java.lang.String defaultEncryptionKey;
        private final java.lang.Object matching;
        private final java.lang.Object ruleBasedMatching;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultExpirationDays = software.amazon.jsii.Kernel.get(this, "defaultExpirationDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deadLetterQueueUrl = software.amazon.jsii.Kernel.get(this, "deadLetterQueueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultEncryptionKey = software.amazon.jsii.Kernel.get(this, "defaultEncryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.matching = software.amazon.jsii.Kernel.get(this, "matching", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ruleBasedMatching = software.amazon.jsii.Kernel.get(this, "ruleBasedMatching", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultExpirationDays = java.util.Objects.requireNonNull(builder.defaultExpirationDays, "defaultExpirationDays is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.deadLetterQueueUrl = builder.deadLetterQueueUrl;
            this.defaultEncryptionKey = builder.defaultEncryptionKey;
            this.matching = builder.matching;
            this.ruleBasedMatching = builder.ruleBasedMatching;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getDefaultExpirationDays() {
            return this.defaultExpirationDays;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getDeadLetterQueueUrl() {
            return this.deadLetterQueueUrl;
        }

        @Override
        public final java.lang.String getDefaultEncryptionKey() {
            return this.defaultEncryptionKey;
        }

        @Override
        public final java.lang.Object getMatching() {
            return this.matching;
        }

        @Override
        public final java.lang.Object getRuleBasedMatching() {
            return this.ruleBasedMatching;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultExpirationDays", om.valueToTree(this.getDefaultExpirationDays()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getDeadLetterQueueUrl() != null) {
                data.set("deadLetterQueueUrl", om.valueToTree(this.getDeadLetterQueueUrl()));
            }
            if (this.getDefaultEncryptionKey() != null) {
                data.set("defaultEncryptionKey", om.valueToTree(this.getDefaultEncryptionKey()));
            }
            if (this.getMatching() != null) {
                data.set("matching", om.valueToTree(this.getMatching()));
            }
            if (this.getRuleBasedMatching() != null) {
                data.set("ruleBasedMatching", om.valueToTree(this.getRuleBasedMatching()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainProps.Jsii$Proxy that = (CfnDomainProps.Jsii$Proxy) o;

            if (!defaultExpirationDays.equals(that.defaultExpirationDays)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.deadLetterQueueUrl != null ? !this.deadLetterQueueUrl.equals(that.deadLetterQueueUrl) : that.deadLetterQueueUrl != null) return false;
            if (this.defaultEncryptionKey != null ? !this.defaultEncryptionKey.equals(that.defaultEncryptionKey) : that.defaultEncryptionKey != null) return false;
            if (this.matching != null ? !this.matching.equals(that.matching) : that.matching != null) return false;
            if (this.ruleBasedMatching != null ? !this.ruleBasedMatching.equals(that.ruleBasedMatching) : that.ruleBasedMatching != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultExpirationDays.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.deadLetterQueueUrl != null ? this.deadLetterQueueUrl.hashCode() : 0);
            result = 31 * result + (this.defaultEncryptionKey != null ? this.defaultEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.matching != null ? this.matching.hashCode() : 0);
            result = 31 * result + (this.ruleBasedMatching != null ? this.ruleBasedMatching.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
