package software.amazon.awscdk.services.databrew;

/**
 * Specifies a new DataBrew dataset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * CfnDataset cfnDataset = CfnDataset.Builder.create(this, "MyCfnDataset")
 *         .input(InputProperty.builder()
 *                 .databaseInputDefinition(DatabaseInputDefinitionProperty.builder()
 *                         .glueConnectionName("glueConnectionName")
 *                         // the properties below are optional
 *                         .databaseTableName("databaseTableName")
 *                         .queryString("queryString")
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .dataCatalogInputDefinition(DataCatalogInputDefinitionProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .tableName("tableName")
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .metadata(MetadataProperty.builder()
 *                         .sourceArn("sourceArn")
 *                         .build())
 *                 .s3InputDefinition(S3LocationProperty.builder()
 *                         .bucket("bucket")
 *                         // the properties below are optional
 *                         .bucketOwner("bucketOwner")
 *                         .key("key")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .format("format")
 *         .formatOptions(FormatOptionsProperty.builder()
 *                 .csv(CsvOptionsProperty.builder()
 *                         .delimiter("delimiter")
 *                         .headerRow(false)
 *                         .build())
 *                 .excel(ExcelOptionsProperty.builder()
 *                         .headerRow(false)
 *                         .sheetIndexes(List.of(123))
 *                         .sheetNames(List.of("sheetNames"))
 *                         .build())
 *                 .json(JsonOptionsProperty.builder()
 *                         .multiLine(false)
 *                         .build())
 *                 .build())
 *         .pathOptions(PathOptionsProperty.builder()
 *                 .filesLimit(FilesLimitProperty.builder()
 *                         .maxFiles(123)
 *                         // the properties below are optional
 *                         .order("order")
 *                         .orderedBy("orderedBy")
 *                         .build())
 *                 .lastModifiedDateCondition(FilterExpressionProperty.builder()
 *                         .expression("expression")
 *                         .valuesMap(List.of(FilterValueProperty.builder()
 *                                 .value("value")
 *                                 .valueReference("valueReference")
 *                                 .build()))
 *                         .build())
 *                 .parameters(List.of(PathParameterProperty.builder()
 *                         .datasetParameter(DatasetParameterProperty.builder()
 *                                 .name("name")
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .createColumn(false)
 *                                 .datetimeOptions(DatetimeOptionsProperty.builder()
 *                                         .format("format")
 *                                         // the properties below are optional
 *                                         .localeCode("localeCode")
 *                                         .timezoneOffset("timezoneOffset")
 *                                         .build())
 *                                 .filter(FilterExpressionProperty.builder()
 *                                         .expression("expression")
 *                                         .valuesMap(List.of(FilterValueProperty.builder()
 *                                                 .value("value")
 *                                                 .valueReference("valueReference")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .pathParameterName("pathParameterName")
 *                         .build()))
 *                 .build())
 *         .source("source")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.576Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset")
public class CfnDataset extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.databrew.IDatasetRef, software.amazon.awscdk.ITaggable {

    protected CfnDataset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.databrew.CfnDataset.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::DataBrew::Dataset</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.databrew.CfnDatasetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Dataset resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.databrew.DatasetReference getDatasetRef() {
        return software.amazon.jsii.Kernel.get(this, "datasetRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.databrew.DatasetReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Information on how DataBrew can find the dataset, in either the AWS Glue Data Catalog or Amazon S3 .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.InputProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInput() {
        return software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information on how DataBrew can find the dataset, in either the AWS Glue Data Catalog or Amazon S3 .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "input", java.util.Objects.requireNonNull(value, "input is required"));
    }

    /**
     * Information on how DataBrew can find the dataset, in either the AWS Glue Data Catalog or Amazon S3 .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.databrew.CfnDataset.InputProperty value) {
        software.amazon.jsii.Kernel.set(this, "input", java.util.Objects.requireNonNull(value, "input is required"));
    }

    /**
     * The unique name of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The file format of a dataset that is created from an Amazon S3 file or folder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
        return software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The file format of a dataset that is created from an Amazon S3 file or folder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFormat(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "format", value);
    }

    /**
     * A set of options that define how DataBrew interprets the data in the dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.FormatOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFormatOptions() {
        return software.amazon.jsii.Kernel.get(this, "formatOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of options that define how DataBrew interprets the data in the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFormatOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "formatOptions", value);
    }

    /**
     * A set of options that define how DataBrew interprets the data in the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFormatOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnDataset.FormatOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "formatOptions", value);
    }

    /**
     * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.PathOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPathOptions() {
        return software.amazon.jsii.Kernel.get(this, "pathOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPathOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pathOptions", value);
    }

    /**
     * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPathOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnDataset.PathOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "pathOptions", value);
    }

    /**
     * The location of the data for the dataset, either Amazon S3 or the AWS Glue Data Catalog .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location of the data for the dataset, either Amazon S3 or the AWS Glue Data Catalog .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "source", value);
    }

    /**
     * Metadata tags that have been applied to the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata tags that have been applied to the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Represents a set of options that define how DataBrew will read a comma-separated value (CSV) file when creating a dataset from that file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * CsvOptionsProperty csvOptionsProperty = CsvOptionsProperty.builder()
     *         .delimiter("delimiter")
     *         .headerRow(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-csvoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-csvoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.CsvOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A single character that specifies the delimiter being used in the CSV file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-csvoptions.html#cfn-databrew-dataset-csvoptions-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-csvoptions.html#cfn-databrew-dataset-csvoptions-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * A variable that specifies whether the first row in the file is parsed as the header.
         * <p>
         * If this value is false, column names are auto-generated.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-csvoptions.html#cfn-databrew-dataset-csvoptions-headerrow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-csvoptions.html#cfn-databrew-dataset-csvoptions-headerrow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderRow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvOptionsProperty> {
            java.lang.String delimiter;
            java.lang.Object headerRow;

            /**
             * Sets the value of {@link CsvOptionsProperty#getDelimiter}
             * @param delimiter A single character that specifies the delimiter being used in the CSV file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link CsvOptionsProperty#getHeaderRow}
             * @param headerRow A variable that specifies whether the first row in the file is parsed as the header.
             *                  If this value is false, column names are auto-generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerRow(java.lang.Boolean headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            /**
             * Sets the value of {@link CsvOptionsProperty#getHeaderRow}
             * @param headerRow A variable that specifies whether the first row in the file is parsed as the header.
             *                  If this value is false, column names are auto-generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerRow(software.amazon.awscdk.IResolvable headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvOptionsProperty {
            private final java.lang.String delimiter;
            private final java.lang.Object headerRow;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerRow = software.amazon.jsii.Kernel.get(this, "headerRow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delimiter = builder.delimiter;
                this.headerRow = builder.headerRow;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.Object getHeaderRow() {
                return this.headerRow;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getHeaderRow() != null) {
                    data.set("headerRow", om.valueToTree(this.getHeaderRow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.CsvOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvOptionsProperty.Jsii$Proxy that = (CsvOptionsProperty.Jsii$Proxy) o;

                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                return this.headerRow != null ? this.headerRow.equals(that.headerRow) : that.headerRow == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delimiter != null ? this.delimiter.hashCode() : 0;
                result = 31 * result + (this.headerRow != null ? this.headerRow.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents how metadata stored in the AWS Glue Data Catalog is defined in a DataBrew dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DataCatalogInputDefinitionProperty dataCatalogInputDefinitionProperty = DataCatalogInputDefinitionProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         .tableName("tableName")
     *         .tempDirectory(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.DataCatalogInputDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCatalogInputDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCatalogInputDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the AWS account that holds the Data Catalog that stores the data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * The name of a database in the Data Catalog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * The name of a database table in the Data Catalog.
         * <p>
         * This table corresponds to a DataBrew dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
            return null;
        }

        /**
         * An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-tempdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datacataloginputdefinition.html#cfn-databrew-dataset-datacataloginputdefinition-tempdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTempDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCatalogInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCatalogInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCatalogInputDefinitionProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String tableName;
            java.lang.Object tempDirectory;

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getCatalogId}
             * @param catalogId The unique identifier of the AWS account that holds the Data Catalog that stores the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getDatabaseName}
             * @param databaseName The name of a database in the Data Catalog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getTableName}
             * @param tableName The name of a database table in the Data Catalog.
             *                  This table corresponds to a DataBrew dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getTempDirectory}
             * @param tempDirectory An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogInputDefinitionProperty#getTempDirectory}
             * @param tempDirectory An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCatalogInputDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCatalogInputDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCatalogInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCatalogInputDefinitionProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String tableName;
            private final java.lang.Object tempDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tempDirectory = software.amazon.jsii.Kernel.get(this, "tempDirectory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = builder.catalogId;
                this.databaseName = builder.databaseName;
                this.tableName = builder.tableName;
                this.tempDirectory = builder.tempDirectory;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getTempDirectory() {
                return this.tempDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getTableName() != null) {
                    data.set("tableName", om.valueToTree(this.getTableName()));
                }
                if (this.getTempDirectory() != null) {
                    data.set("tempDirectory", om.valueToTree(this.getTempDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.DataCatalogInputDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCatalogInputDefinitionProperty.Jsii$Proxy that = (DataCatalogInputDefinitionProperty.Jsii$Proxy) o;

                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
                return this.tempDirectory != null ? this.tempDirectory.equals(that.tempDirectory) : that.tempDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId != null ? this.catalogId.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
                result = 31 * result + (this.tempDirectory != null ? this.tempDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Connection information for dataset input files stored in a database.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DatabaseInputDefinitionProperty databaseInputDefinitionProperty = DatabaseInputDefinitionProperty.builder()
     *         .glueConnectionName("glueConnectionName")
     *         // the properties below are optional
     *         .databaseTableName("databaseTableName")
     *         .queryString("queryString")
     *         .tempDirectory(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.DatabaseInputDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseInputDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseInputDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Glue Connection that stores the connection information for the target database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-glueconnectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-glueconnectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGlueConnectionName();

        /**
         * The table within the target database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-databasetablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-databasetablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseTableName() {
            return null;
        }

        /**
         * Custom SQL to run against the provided AWS Glue connection.
         * <p>
         * This SQL will be used as the input for DataBrew projects and jobs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-querystring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQueryString() {
            return null;
        }

        /**
         * An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-tempdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-databaseinputdefinition.html#cfn-databrew-dataset-databaseinputdefinition-tempdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTempDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseInputDefinitionProperty> {
            java.lang.String glueConnectionName;
            java.lang.String databaseTableName;
            java.lang.String queryString;
            java.lang.Object tempDirectory;

            /**
             * Sets the value of {@link DatabaseInputDefinitionProperty#getGlueConnectionName}
             * @param glueConnectionName The AWS Glue Connection that stores the connection information for the target database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConnectionName(java.lang.String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputDefinitionProperty#getDatabaseTableName}
             * @param databaseTableName The table within the target database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseTableName(java.lang.String databaseTableName) {
                this.databaseTableName = databaseTableName;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputDefinitionProperty#getQueryString}
             * @param queryString Custom SQL to run against the provided AWS Glue connection.
             *                    This SQL will be used as the input for DataBrew projects and jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.String queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputDefinitionProperty#getTempDirectory}
             * @param tempDirectory An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputDefinitionProperty#getTempDirectory}
             * @param tempDirectory An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseInputDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseInputDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseInputDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInputDefinitionProperty {
            private final java.lang.String glueConnectionName;
            private final java.lang.String databaseTableName;
            private final java.lang.String queryString;
            private final java.lang.Object tempDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueConnectionName = software.amazon.jsii.Kernel.get(this, "glueConnectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseTableName = software.amazon.jsii.Kernel.get(this, "databaseTableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tempDirectory = software.amazon.jsii.Kernel.get(this, "tempDirectory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueConnectionName = java.util.Objects.requireNonNull(builder.glueConnectionName, "glueConnectionName is required");
                this.databaseTableName = builder.databaseTableName;
                this.queryString = builder.queryString;
                this.tempDirectory = builder.tempDirectory;
            }

            @Override
            public final java.lang.String getGlueConnectionName() {
                return this.glueConnectionName;
            }

            @Override
            public final java.lang.String getDatabaseTableName() {
                return this.databaseTableName;
            }

            @Override
            public final java.lang.String getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getTempDirectory() {
                return this.tempDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("glueConnectionName", om.valueToTree(this.getGlueConnectionName()));
                if (this.getDatabaseTableName() != null) {
                    data.set("databaseTableName", om.valueToTree(this.getDatabaseTableName()));
                }
                if (this.getQueryString() != null) {
                    data.set("queryString", om.valueToTree(this.getQueryString()));
                }
                if (this.getTempDirectory() != null) {
                    data.set("tempDirectory", om.valueToTree(this.getTempDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.DatabaseInputDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseInputDefinitionProperty.Jsii$Proxy that = (DatabaseInputDefinitionProperty.Jsii$Proxy) o;

                if (!glueConnectionName.equals(that.glueConnectionName)) return false;
                if (this.databaseTableName != null ? !this.databaseTableName.equals(that.databaseTableName) : that.databaseTableName != null) return false;
                if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
                return this.tempDirectory != null ? this.tempDirectory.equals(that.tempDirectory) : that.tempDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueConnectionName.hashCode();
                result = 31 * result + (this.databaseTableName != null ? this.databaseTableName.hashCode() : 0);
                result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
                result = 31 * result + (this.tempDirectory != null ? this.tempDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a dataset paramater that defines type and conditions for a parameter in the Amazon S3 path of the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DatasetParameterProperty datasetParameterProperty = DatasetParameterProperty.builder()
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .createColumn(false)
     *         .datetimeOptions(DatetimeOptionsProperty.builder()
     *                 .format("format")
     *                 // the properties below are optional
     *                 .localeCode("localeCode")
     *                 .timezoneOffset("timezoneOffset")
     *                 .build())
     *         .filter(FilterExpressionProperty.builder()
     *                 .expression("expression")
     *                 .valuesMap(List.of(FilterValueProperty.builder()
     *                         .value("value")
     *                         .valueReference("valueReference")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.DatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the parameter that is used in the dataset's Amazon S3 path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of the dataset parameter, can be one of a 'String', 'Number' or 'Datetime'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Optional boolean value that defines whether the captured value of this parameter should be loaded as an additional column in the dataset.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-createcolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-createcolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateColumn() {
            return null;
        }

        /**
         * Additional parameter options such as a format and a timezone.
         * <p>
         * Required for datetime parameters.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.DatetimeOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-datetimeoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-datetimeoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatetimeOptions() {
            return null;
        }

        /**
         * The optional filter expression structure to apply additional matching criteria to the parameter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.FilterExpressionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datasetparameter.html#cfn-databrew-dataset-datasetparameter-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetParameterProperty> {
            java.lang.String name;
            java.lang.String type;
            java.lang.Object createColumn;
            java.lang.Object datetimeOptions;
            java.lang.Object filter;

            /**
             * Sets the value of {@link DatasetParameterProperty#getName}
             * @param name The name of the parameter that is used in the dataset's Amazon S3 path. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getType}
             * @param type The type of the dataset parameter, can be one of a 'String', 'Number' or 'Datetime'. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getCreateColumn}
             * @param createColumn Optional boolean value that defines whether the captured value of this parameter should be loaded as an additional column in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createColumn(java.lang.Boolean createColumn) {
                this.createColumn = createColumn;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getCreateColumn}
             * @param createColumn Optional boolean value that defines whether the captured value of this parameter should be loaded as an additional column in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createColumn(software.amazon.awscdk.IResolvable createColumn) {
                this.createColumn = createColumn;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDatetimeOptions}
             * @param datetimeOptions Additional parameter options such as a format and a timezone.
             *                        Required for datetime parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datetimeOptions(software.amazon.awscdk.IResolvable datetimeOptions) {
                this.datetimeOptions = datetimeOptions;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDatetimeOptions}
             * @param datetimeOptions Additional parameter options such as a format and a timezone.
             *                        Required for datetime parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datetimeOptions(software.amazon.awscdk.services.databrew.CfnDataset.DatetimeOptionsProperty datetimeOptions) {
                this.datetimeOptions = datetimeOptions;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getFilter}
             * @param filter The optional filter expression structure to apply additional matching criteria to the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getFilter}
             * @param filter The optional filter expression structure to apply additional matching criteria to the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.databrew.CfnDataset.FilterExpressionProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetParameterProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.Object createColumn;
            private final java.lang.Object datetimeOptions;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createColumn = software.amazon.jsii.Kernel.get(this, "createColumn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datetimeOptions = software.amazon.jsii.Kernel.get(this, "datetimeOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.createColumn = builder.createColumn;
                this.datetimeOptions = builder.datetimeOptions;
                this.filter = builder.filter;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getCreateColumn() {
                return this.createColumn;
            }

            @Override
            public final java.lang.Object getDatetimeOptions() {
                return this.datetimeOptions;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getCreateColumn() != null) {
                    data.set("createColumn", om.valueToTree(this.getCreateColumn()));
                }
                if (this.getDatetimeOptions() != null) {
                    data.set("datetimeOptions", om.valueToTree(this.getDatetimeOptions()));
                }
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.DatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetParameterProperty.Jsii$Proxy that = (DatasetParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.createColumn != null ? !this.createColumn.equals(that.createColumn) : that.createColumn != null) return false;
                if (this.datetimeOptions != null ? !this.datetimeOptions.equals(that.datetimeOptions) : that.datetimeOptions != null) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.createColumn != null ? this.createColumn.hashCode() : 0);
                result = 31 * result + (this.datetimeOptions != null ? this.datetimeOptions.hashCode() : 0);
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents additional options for correct interpretation of datetime parameters used in the Amazon S3 path of a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DatetimeOptionsProperty datetimeOptionsProperty = DatetimeOptionsProperty.builder()
     *         .format("format")
     *         // the properties below are optional
     *         .localeCode("localeCode")
     *         .timezoneOffset("timezoneOffset")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.DatetimeOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DatetimeOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatetimeOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required option, that defines the datetime format used for a date parameter in the Amazon S3 path.
         * <p>
         * Should use only supported datetime specifiers and separation characters, all litera a-z or A-Z character should be escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html#cfn-databrew-dataset-datetimeoptions-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html#cfn-databrew-dataset-datetimeoptions-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFormat();

        /**
         * Optional value for a non-US locale code, needed for correct interpretation of some date formats.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html#cfn-databrew-dataset-datetimeoptions-localecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html#cfn-databrew-dataset-datetimeoptions-localecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocaleCode() {
            return null;
        }

        /**
         * Optional value for a timezone offset of the datetime parameter value in the Amazon S3 path.
         * <p>
         * Shouldn't be used if Format for this parameter includes timezone fields. If no offset specified, UTC is assumed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html#cfn-databrew-dataset-datetimeoptions-timezoneoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-datetimeoptions.html#cfn-databrew-dataset-datetimeoptions-timezoneoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimezoneOffset() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatetimeOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatetimeOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatetimeOptionsProperty> {
            java.lang.String format;
            java.lang.String localeCode;
            java.lang.String timezoneOffset;

            /**
             * Sets the value of {@link DatetimeOptionsProperty#getFormat}
             * @param format Required option, that defines the datetime format used for a date parameter in the Amazon S3 path. This parameter is required.
             *               Should use only supported datetime specifiers and separation characters, all litera a-z or A-Z character should be escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link DatetimeOptionsProperty#getLocaleCode}
             * @param localeCode Optional value for a non-US locale code, needed for correct interpretation of some date formats.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeCode(java.lang.String localeCode) {
                this.localeCode = localeCode;
                return this;
            }

            /**
             * Sets the value of {@link DatetimeOptionsProperty#getTimezoneOffset}
             * @param timezoneOffset Optional value for a timezone offset of the datetime parameter value in the Amazon S3 path.
             *                       Shouldn't be used if Format for this parameter includes timezone fields. If no offset specified, UTC is assumed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timezoneOffset(java.lang.String timezoneOffset) {
                this.timezoneOffset = timezoneOffset;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatetimeOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatetimeOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatetimeOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatetimeOptionsProperty {
            private final java.lang.String format;
            private final java.lang.String localeCode;
            private final java.lang.String timezoneOffset;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localeCode = software.amazon.jsii.Kernel.get(this, "localeCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timezoneOffset = software.amazon.jsii.Kernel.get(this, "timezoneOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.format = java.util.Objects.requireNonNull(builder.format, "format is required");
                this.localeCode = builder.localeCode;
                this.timezoneOffset = builder.timezoneOffset;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.String getLocaleCode() {
                return this.localeCode;
            }

            @Override
            public final java.lang.String getTimezoneOffset() {
                return this.timezoneOffset;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("format", om.valueToTree(this.getFormat()));
                if (this.getLocaleCode() != null) {
                    data.set("localeCode", om.valueToTree(this.getLocaleCode()));
                }
                if (this.getTimezoneOffset() != null) {
                    data.set("timezoneOffset", om.valueToTree(this.getTimezoneOffset()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.DatetimeOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatetimeOptionsProperty.Jsii$Proxy that = (DatetimeOptionsProperty.Jsii$Proxy) o;

                if (!format.equals(that.format)) return false;
                if (this.localeCode != null ? !this.localeCode.equals(that.localeCode) : that.localeCode != null) return false;
                return this.timezoneOffset != null ? this.timezoneOffset.equals(that.timezoneOffset) : that.timezoneOffset == null;
            }

            @Override
            public final int hashCode() {
                int result = this.format.hashCode();
                result = 31 * result + (this.localeCode != null ? this.localeCode.hashCode() : 0);
                result = 31 * result + (this.timezoneOffset != null ? this.timezoneOffset.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a set of options that define how DataBrew will interpret a Microsoft Excel file when creating a dataset from that file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ExcelOptionsProperty excelOptionsProperty = ExcelOptionsProperty.builder()
     *         .headerRow(false)
     *         .sheetIndexes(List.of(123))
     *         .sheetNames(List.of("sheetNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.ExcelOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ExcelOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExcelOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A variable that specifies whether the first row in the file is parsed as the header.
         * <p>
         * If this value is false, column names are auto-generated.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html#cfn-databrew-dataset-exceloptions-headerrow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html#cfn-databrew-dataset-exceloptions-headerrow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderRow() {
            return null;
        }

        /**
         * One or more sheet numbers in the Excel file that will be included in the dataset.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html#cfn-databrew-dataset-exceloptions-sheetindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html#cfn-databrew-dataset-exceloptions-sheetindexes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSheetIndexes() {
            return null;
        }

        /**
         * One or more named sheets in the Excel file that will be included in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html#cfn-databrew-dataset-exceloptions-sheetnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-exceloptions.html#cfn-databrew-dataset-exceloptions-sheetnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSheetNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExcelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExcelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExcelOptionsProperty> {
            java.lang.Object headerRow;
            java.lang.Object sheetIndexes;
            java.util.List<java.lang.String> sheetNames;

            /**
             * Sets the value of {@link ExcelOptionsProperty#getHeaderRow}
             * @param headerRow A variable that specifies whether the first row in the file is parsed as the header.
             *                  If this value is false, column names are auto-generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerRow(java.lang.Boolean headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            /**
             * Sets the value of {@link ExcelOptionsProperty#getHeaderRow}
             * @param headerRow A variable that specifies whether the first row in the file is parsed as the header.
             *                  If this value is false, column names are auto-generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerRow(software.amazon.awscdk.IResolvable headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            /**
             * Sets the value of {@link ExcelOptionsProperty#getSheetIndexes}
             * @param sheetIndexes One or more sheet numbers in the Excel file that will be included in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetIndexes(java.util.List<? extends java.lang.Number> sheetIndexes) {
                this.sheetIndexes = sheetIndexes;
                return this;
            }

            /**
             * Sets the value of {@link ExcelOptionsProperty#getSheetIndexes}
             * @param sheetIndexes One or more sheet numbers in the Excel file that will be included in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetIndexes(software.amazon.awscdk.IResolvable sheetIndexes) {
                this.sheetIndexes = sheetIndexes;
                return this;
            }

            /**
             * Sets the value of {@link ExcelOptionsProperty#getSheetNames}
             * @param sheetNames One or more named sheets in the Excel file that will be included in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetNames(java.util.List<java.lang.String> sheetNames) {
                this.sheetNames = sheetNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExcelOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExcelOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExcelOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExcelOptionsProperty {
            private final java.lang.Object headerRow;
            private final java.lang.Object sheetIndexes;
            private final java.util.List<java.lang.String> sheetNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerRow = software.amazon.jsii.Kernel.get(this, "headerRow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sheetIndexes = software.amazon.jsii.Kernel.get(this, "sheetIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sheetNames = software.amazon.jsii.Kernel.get(this, "sheetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerRow = builder.headerRow;
                this.sheetIndexes = builder.sheetIndexes;
                this.sheetNames = builder.sheetNames;
            }

            @Override
            public final java.lang.Object getHeaderRow() {
                return this.headerRow;
            }

            @Override
            public final java.lang.Object getSheetIndexes() {
                return this.sheetIndexes;
            }

            @Override
            public final java.util.List<java.lang.String> getSheetNames() {
                return this.sheetNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeaderRow() != null) {
                    data.set("headerRow", om.valueToTree(this.getHeaderRow()));
                }
                if (this.getSheetIndexes() != null) {
                    data.set("sheetIndexes", om.valueToTree(this.getSheetIndexes()));
                }
                if (this.getSheetNames() != null) {
                    data.set("sheetNames", om.valueToTree(this.getSheetNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.ExcelOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExcelOptionsProperty.Jsii$Proxy that = (ExcelOptionsProperty.Jsii$Proxy) o;

                if (this.headerRow != null ? !this.headerRow.equals(that.headerRow) : that.headerRow != null) return false;
                if (this.sheetIndexes != null ? !this.sheetIndexes.equals(that.sheetIndexes) : that.sheetIndexes != null) return false;
                return this.sheetNames != null ? this.sheetNames.equals(that.sheetNames) : that.sheetNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headerRow != null ? this.headerRow.hashCode() : 0;
                result = 31 * result + (this.sheetIndexes != null ? this.sheetIndexes.hashCode() : 0);
                result = 31 * result + (this.sheetNames != null ? this.sheetNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a limit imposed on number of Amazon S3 files that should be selected for a dataset from a connected Amazon S3 path.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * FilesLimitProperty filesLimitProperty = FilesLimitProperty.builder()
     *         .maxFiles(123)
     *         // the properties below are optional
     *         .order("order")
     *         .orderedBy("orderedBy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.FilesLimitProperty")
    @software.amazon.jsii.Jsii.Proxy(FilesLimitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilesLimitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of Amazon S3 files to select.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html#cfn-databrew-dataset-fileslimit-maxfiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html#cfn-databrew-dataset-fileslimit-maxfiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxFiles();

        /**
         * A criteria to use for Amazon S3 files sorting before their selection.
         * <p>
         * By default uses DESCENDING order, i.e. most recent files are selected first. Anotherpossible value is ASCENDING.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html#cfn-databrew-dataset-fileslimit-order">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html#cfn-databrew-dataset-fileslimit-order</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrder() {
            return null;
        }

        /**
         * A criteria to use for Amazon S3 files sorting before their selection.
         * <p>
         * By default uses LAST_MODIFIED_DATE as a sorting criteria. Currently it's the only allowed value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html#cfn-databrew-dataset-fileslimit-orderedby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-fileslimit.html#cfn-databrew-dataset-fileslimit-orderedby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrderedBy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilesLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilesLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilesLimitProperty> {
            java.lang.Number maxFiles;
            java.lang.String order;
            java.lang.String orderedBy;

            /**
             * Sets the value of {@link FilesLimitProperty#getMaxFiles}
             * @param maxFiles The number of Amazon S3 files to select. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFiles(java.lang.Number maxFiles) {
                this.maxFiles = maxFiles;
                return this;
            }

            /**
             * Sets the value of {@link FilesLimitProperty#getOrder}
             * @param order A criteria to use for Amazon S3 files sorting before their selection.
             *              By default uses DESCENDING order, i.e. most recent files are selected first. Anotherpossible value is ASCENDING.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder order(java.lang.String order) {
                this.order = order;
                return this;
            }

            /**
             * Sets the value of {@link FilesLimitProperty#getOrderedBy}
             * @param orderedBy A criteria to use for Amazon S3 files sorting before their selection.
             *                  By default uses LAST_MODIFIED_DATE as a sorting criteria. Currently it's the only allowed value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orderedBy(java.lang.String orderedBy) {
                this.orderedBy = orderedBy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilesLimitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilesLimitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilesLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilesLimitProperty {
            private final java.lang.Number maxFiles;
            private final java.lang.String order;
            private final java.lang.String orderedBy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxFiles = software.amazon.jsii.Kernel.get(this, "maxFiles", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.order = software.amazon.jsii.Kernel.get(this, "order", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.orderedBy = software.amazon.jsii.Kernel.get(this, "orderedBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxFiles = java.util.Objects.requireNonNull(builder.maxFiles, "maxFiles is required");
                this.order = builder.order;
                this.orderedBy = builder.orderedBy;
            }

            @Override
            public final java.lang.Number getMaxFiles() {
                return this.maxFiles;
            }

            @Override
            public final java.lang.String getOrder() {
                return this.order;
            }

            @Override
            public final java.lang.String getOrderedBy() {
                return this.orderedBy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxFiles", om.valueToTree(this.getMaxFiles()));
                if (this.getOrder() != null) {
                    data.set("order", om.valueToTree(this.getOrder()));
                }
                if (this.getOrderedBy() != null) {
                    data.set("orderedBy", om.valueToTree(this.getOrderedBy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.FilesLimitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilesLimitProperty.Jsii$Proxy that = (FilesLimitProperty.Jsii$Proxy) o;

                if (!maxFiles.equals(that.maxFiles)) return false;
                if (this.order != null ? !this.order.equals(that.order) : that.order != null) return false;
                return this.orderedBy != null ? this.orderedBy.equals(that.orderedBy) : that.orderedBy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxFiles.hashCode();
                result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
                result = 31 * result + (this.orderedBy != null ? this.orderedBy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a structure for defining parameter conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * FilterExpressionProperty filterExpressionProperty = FilterExpressionProperty.builder()
     *         .expression("expression")
     *         .valuesMap(List.of(FilterValueProperty.builder()
     *                 .value("value")
     *                 .valueReference("valueReference")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filterexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filterexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.FilterExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The expression which includes condition names followed by substitution variables, possibly grouped and combined with other conditions.
         * <p>
         * For example, "(starts_with :prefix1 or starts_with :prefix2) and (ends_with :suffix1 or ends_with :suffix2)". Substitution variables should start with ':' symbol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filterexpression.html#cfn-databrew-dataset-filterexpression-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filterexpression.html#cfn-databrew-dataset-filterexpression-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * The map of substitution variable names to their values used in this filter expression.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.FilterValueProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filterexpression.html#cfn-databrew-dataset-filterexpression-valuesmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filterexpression.html#cfn-databrew-dataset-filterexpression-valuesmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValuesMap();

        /**
         * @return a {@link Builder} of {@link FilterExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterExpressionProperty> {
            java.lang.String expression;
            java.lang.Object valuesMap;

            /**
             * Sets the value of {@link FilterExpressionProperty#getExpression}
             * @param expression The expression which includes condition names followed by substitution variables, possibly grouped and combined with other conditions. This parameter is required.
             *                   For example, "(starts_with :prefix1 or starts_with :prefix2) and (ends_with :suffix1 or ends_with :suffix2)". Substitution variables should start with ':' symbol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link FilterExpressionProperty#getValuesMap}
             * @param valuesMap The map of substitution variable names to their values used in this filter expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valuesMap(software.amazon.awscdk.IResolvable valuesMap) {
                this.valuesMap = valuesMap;
                return this;
            }

            /**
             * Sets the value of {@link FilterExpressionProperty#getValuesMap}
             * @param valuesMap The map of substitution variable names to their values used in this filter expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valuesMap(java.util.List<? extends java.lang.Object> valuesMap) {
                this.valuesMap = valuesMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterExpressionProperty {
            private final java.lang.String expression;
            private final java.lang.Object valuesMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valuesMap = software.amazon.jsii.Kernel.get(this, "valuesMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.valuesMap = java.util.Objects.requireNonNull(builder.valuesMap, "valuesMap is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Object getValuesMap() {
                return this.valuesMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("valuesMap", om.valueToTree(this.getValuesMap()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.FilterExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterExpressionProperty.Jsii$Proxy that = (FilterExpressionProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                return this.valuesMap.equals(that.valuesMap);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.valuesMap.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents a single entry in the <code>ValuesMap</code> of a <code>FilterExpression</code> .
     * <p>
     * A <code>FilterValue</code> associates the name of a substitution variable in an expression to its value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * FilterValueProperty filterValueProperty = FilterValueProperty.builder()
     *         .value("value")
     *         .valueReference("valueReference")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filtervalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filtervalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.FilterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to be associated with the substitution variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filtervalue.html#cfn-databrew-dataset-filtervalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filtervalue.html#cfn-databrew-dataset-filtervalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * The substitution variable reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filtervalue.html#cfn-databrew-dataset-filtervalue-valuereference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-filtervalue.html#cfn-databrew-dataset-filtervalue-valuereference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueReference();

        /**
         * @return a {@link Builder} of {@link FilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterValueProperty> {
            java.lang.String value;
            java.lang.String valueReference;

            /**
             * Sets the value of {@link FilterValueProperty#getValue}
             * @param value The value to be associated with the substitution variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link FilterValueProperty#getValueReference}
             * @param valueReference The substitution variable reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueReference(java.lang.String valueReference) {
                this.valueReference = valueReference;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterValueProperty {
            private final java.lang.String value;
            private final java.lang.String valueReference;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueReference = software.amazon.jsii.Kernel.get(this, "valueReference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.valueReference = java.util.Objects.requireNonNull(builder.valueReference, "valueReference is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getValueReference() {
                return this.valueReference;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));
                data.set("valueReference", om.valueToTree(this.getValueReference()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.FilterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterValueProperty.Jsii$Proxy that = (FilterValueProperty.Jsii$Proxy) o;

                if (!value.equals(that.value)) return false;
                return this.valueReference.equals(that.valueReference);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                result = 31 * result + (this.valueReference.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * FormatOptionsProperty formatOptionsProperty = FormatOptionsProperty.builder()
     *         .csv(CsvOptionsProperty.builder()
     *                 .delimiter("delimiter")
     *                 .headerRow(false)
     *                 .build())
     *         .excel(ExcelOptionsProperty.builder()
     *                 .headerRow(false)
     *                 .sheetIndexes(List.of(123))
     *                 .sheetNames(List.of("sheetNames"))
     *                 .build())
     *         .json(JsonOptionsProperty.builder()
     *                 .multiLine(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.FormatOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(FormatOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormatOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Options that define how CSV input is to be interpreted by DataBrew.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.CsvOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html#cfn-databrew-dataset-formatoptions-csv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html#cfn-databrew-dataset-formatoptions-csv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsv() {
            return null;
        }

        /**
         * Options that define how Excel input is to be interpreted by DataBrew.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.ExcelOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html#cfn-databrew-dataset-formatoptions-excel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html#cfn-databrew-dataset-formatoptions-excel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcel() {
            return null;
        }

        /**
         * Options that define how JSON input is to be interpreted by DataBrew.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.JsonOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html#cfn-databrew-dataset-formatoptions-json">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-formatoptions.html#cfn-databrew-dataset-formatoptions-json</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJson() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormatOptionsProperty> {
            java.lang.Object csv;
            java.lang.Object excel;
            java.lang.Object json;

            /**
             * Sets the value of {@link FormatOptionsProperty#getCsv}
             * @param csv Options that define how CSV input is to be interpreted by DataBrew.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.IResolvable csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link FormatOptionsProperty#getCsv}
             * @param csv Options that define how CSV input is to be interpreted by DataBrew.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.services.databrew.CfnDataset.CsvOptionsProperty csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link FormatOptionsProperty#getExcel}
             * @param excel Options that define how Excel input is to be interpreted by DataBrew.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excel(software.amazon.awscdk.IResolvable excel) {
                this.excel = excel;
                return this;
            }

            /**
             * Sets the value of {@link FormatOptionsProperty#getExcel}
             * @param excel Options that define how Excel input is to be interpreted by DataBrew.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excel(software.amazon.awscdk.services.databrew.CfnDataset.ExcelOptionsProperty excel) {
                this.excel = excel;
                return this;
            }

            /**
             * Sets the value of {@link FormatOptionsProperty#getJson}
             * @param json Options that define how JSON input is to be interpreted by DataBrew.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.IResolvable json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link FormatOptionsProperty#getJson}
             * @param json Options that define how JSON input is to be interpreted by DataBrew.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.services.databrew.CfnDataset.JsonOptionsProperty json) {
                this.json = json;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormatOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormatOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormatOptionsProperty {
            private final java.lang.Object csv;
            private final java.lang.Object excel;
            private final java.lang.Object json;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csv = software.amazon.jsii.Kernel.get(this, "csv", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excel = software.amazon.jsii.Kernel.get(this, "excel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.json = software.amazon.jsii.Kernel.get(this, "json", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csv = builder.csv;
                this.excel = builder.excel;
                this.json = builder.json;
            }

            @Override
            public final java.lang.Object getCsv() {
                return this.csv;
            }

            @Override
            public final java.lang.Object getExcel() {
                return this.excel;
            }

            @Override
            public final java.lang.Object getJson() {
                return this.json;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsv() != null) {
                    data.set("csv", om.valueToTree(this.getCsv()));
                }
                if (this.getExcel() != null) {
                    data.set("excel", om.valueToTree(this.getExcel()));
                }
                if (this.getJson() != null) {
                    data.set("json", om.valueToTree(this.getJson()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.FormatOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormatOptionsProperty.Jsii$Proxy that = (FormatOptionsProperty.Jsii$Proxy) o;

                if (this.csv != null ? !this.csv.equals(that.csv) : that.csv != null) return false;
                if (this.excel != null ? !this.excel.equals(that.excel) : that.excel != null) return false;
                return this.json != null ? this.json.equals(that.json) : that.json == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csv != null ? this.csv.hashCode() : 0;
                result = 31 * result + (this.excel != null ? this.excel.hashCode() : 0);
                result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents information on how DataBrew can find data, in either the AWS Glue Data Catalog or Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * InputProperty inputProperty = InputProperty.builder()
     *         .databaseInputDefinition(DatabaseInputDefinitionProperty.builder()
     *                 .glueConnectionName("glueConnectionName")
     *                 // the properties below are optional
     *                 .databaseTableName("databaseTableName")
     *                 .queryString("queryString")
     *                 .tempDirectory(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .dataCatalogInputDefinition(DataCatalogInputDefinitionProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 .tableName("tableName")
     *                 .tempDirectory(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .metadata(MetadataProperty.builder()
     *                 .sourceArn("sourceArn")
     *                 .build())
     *         .s3InputDefinition(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.InputProperty")
    @software.amazon.jsii.Jsii.Proxy(InputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Connection information for dataset input files stored in a database.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.DatabaseInputDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-databaseinputdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-databaseinputdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseInputDefinition() {
            return null;
        }

        /**
         * The AWS Glue Data Catalog parameters for the data.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.DataCatalogInputDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-datacataloginputdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-datacataloginputdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataCatalogInputDefinition() {
            return null;
        }

        /**
         * Contains additional resource information needed for specific datasets.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.MetadataProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-metadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-metadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadata() {
            return null;
        }

        /**
         * The Amazon S3 location where the data is stored.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-s3inputdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-input.html#cfn-databrew-dataset-input-s3inputdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3InputDefinition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputProperty> {
            java.lang.Object databaseInputDefinition;
            java.lang.Object dataCatalogInputDefinition;
            java.lang.Object metadata;
            java.lang.Object s3InputDefinition;

            /**
             * Sets the value of {@link InputProperty#getDatabaseInputDefinition}
             * @param databaseInputDefinition Connection information for dataset input files stored in a database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseInputDefinition(software.amazon.awscdk.IResolvable databaseInputDefinition) {
                this.databaseInputDefinition = databaseInputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getDatabaseInputDefinition}
             * @param databaseInputDefinition Connection information for dataset input files stored in a database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseInputDefinition(software.amazon.awscdk.services.databrew.CfnDataset.DatabaseInputDefinitionProperty databaseInputDefinition) {
                this.databaseInputDefinition = databaseInputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getDataCatalogInputDefinition}
             * @param dataCatalogInputDefinition The AWS Glue Data Catalog parameters for the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCatalogInputDefinition(software.amazon.awscdk.IResolvable dataCatalogInputDefinition) {
                this.dataCatalogInputDefinition = dataCatalogInputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getDataCatalogInputDefinition}
             * @param dataCatalogInputDefinition The AWS Glue Data Catalog parameters for the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCatalogInputDefinition(software.amazon.awscdk.services.databrew.CfnDataset.DataCatalogInputDefinitionProperty dataCatalogInputDefinition) {
                this.dataCatalogInputDefinition = dataCatalogInputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getMetadata}
             * @param metadata Contains additional resource information needed for specific datasets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(software.amazon.awscdk.IResolvable metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getMetadata}
             * @param metadata Contains additional resource information needed for specific datasets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(software.amazon.awscdk.services.databrew.CfnDataset.MetadataProperty metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getS3InputDefinition}
             * @param s3InputDefinition The Amazon S3 location where the data is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputDefinition(software.amazon.awscdk.IResolvable s3InputDefinition) {
                this.s3InputDefinition = s3InputDefinition;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getS3InputDefinition}
             * @param s3InputDefinition The Amazon S3 location where the data is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputDefinition(software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty s3InputDefinition) {
                this.s3InputDefinition = s3InputDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProperty {
            private final java.lang.Object databaseInputDefinition;
            private final java.lang.Object dataCatalogInputDefinition;
            private final java.lang.Object metadata;
            private final java.lang.Object s3InputDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseInputDefinition = software.amazon.jsii.Kernel.get(this, "databaseInputDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataCatalogInputDefinition = software.amazon.jsii.Kernel.get(this, "dataCatalogInputDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3InputDefinition = software.amazon.jsii.Kernel.get(this, "s3InputDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseInputDefinition = builder.databaseInputDefinition;
                this.dataCatalogInputDefinition = builder.dataCatalogInputDefinition;
                this.metadata = builder.metadata;
                this.s3InputDefinition = builder.s3InputDefinition;
            }

            @Override
            public final java.lang.Object getDatabaseInputDefinition() {
                return this.databaseInputDefinition;
            }

            @Override
            public final java.lang.Object getDataCatalogInputDefinition() {
                return this.dataCatalogInputDefinition;
            }

            @Override
            public final java.lang.Object getMetadata() {
                return this.metadata;
            }

            @Override
            public final java.lang.Object getS3InputDefinition() {
                return this.s3InputDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatabaseInputDefinition() != null) {
                    data.set("databaseInputDefinition", om.valueToTree(this.getDatabaseInputDefinition()));
                }
                if (this.getDataCatalogInputDefinition() != null) {
                    data.set("dataCatalogInputDefinition", om.valueToTree(this.getDataCatalogInputDefinition()));
                }
                if (this.getMetadata() != null) {
                    data.set("metadata", om.valueToTree(this.getMetadata()));
                }
                if (this.getS3InputDefinition() != null) {
                    data.set("s3InputDefinition", om.valueToTree(this.getS3InputDefinition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.InputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProperty.Jsii$Proxy that = (InputProperty.Jsii$Proxy) o;

                if (this.databaseInputDefinition != null ? !this.databaseInputDefinition.equals(that.databaseInputDefinition) : that.databaseInputDefinition != null) return false;
                if (this.dataCatalogInputDefinition != null ? !this.dataCatalogInputDefinition.equals(that.dataCatalogInputDefinition) : that.dataCatalogInputDefinition != null) return false;
                if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
                return this.s3InputDefinition != null ? this.s3InputDefinition.equals(that.s3InputDefinition) : that.s3InputDefinition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseInputDefinition != null ? this.databaseInputDefinition.hashCode() : 0;
                result = 31 * result + (this.dataCatalogInputDefinition != null ? this.dataCatalogInputDefinition.hashCode() : 0);
                result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
                result = 31 * result + (this.s3InputDefinition != null ? this.s3InputDefinition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the JSON-specific options that define how input is to be interpreted by AWS Glue DataBrew .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * JsonOptionsProperty jsonOptionsProperty = JsonOptionsProperty.builder()
     *         .multiLine(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-jsonoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-jsonoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.JsonOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that specifies whether JSON input contains embedded new line characters.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-jsonoptions.html#cfn-databrew-dataset-jsonoptions-multiline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-jsonoptions.html#cfn-databrew-dataset-jsonoptions-multiline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiLine() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonOptionsProperty> {
            java.lang.Object multiLine;

            /**
             * Sets the value of {@link JsonOptionsProperty#getMultiLine}
             * @param multiLine A value that specifies whether JSON input contains embedded new line characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiLine(java.lang.Boolean multiLine) {
                this.multiLine = multiLine;
                return this;
            }

            /**
             * Sets the value of {@link JsonOptionsProperty#getMultiLine}
             * @param multiLine A value that specifies whether JSON input contains embedded new line characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiLine(software.amazon.awscdk.IResolvable multiLine) {
                this.multiLine = multiLine;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonOptionsProperty {
            private final java.lang.Object multiLine;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.multiLine = software.amazon.jsii.Kernel.get(this, "multiLine", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.multiLine = builder.multiLine;
            }

            @Override
            public final java.lang.Object getMultiLine() {
                return this.multiLine;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMultiLine() != null) {
                    data.set("multiLine", om.valueToTree(this.getMultiLine()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.JsonOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonOptionsProperty.Jsii$Proxy that = (JsonOptionsProperty.Jsii$Proxy) o;

                return this.multiLine != null ? this.multiLine.equals(that.multiLine) : that.multiLine == null;
            }

            @Override
            public final int hashCode() {
                int result = this.multiLine != null ? this.multiLine.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains additional resource information needed for specific datasets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * MetadataProperty metadataProperty = MetadataProperty.builder()
     *         .sourceArn("sourceArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-metadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-metadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.MetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) associated with the dataset.
         * <p>
         * Currently, DataBrew only supports ARNs from Amazon AppFlow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-metadata.html#cfn-databrew-dataset-metadata-sourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-metadata.html#cfn-databrew-dataset-metadata-sourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataProperty> {
            java.lang.String sourceArn;

            /**
             * Sets the value of {@link MetadataProperty#getSourceArn}
             * @param sourceArn The Amazon Resource Name (ARN) associated with the dataset.
             *                  Currently, DataBrew only supports ARNs from Amazon AppFlow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceArn(java.lang.String sourceArn) {
                this.sourceArn = sourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataProperty {
            private final java.lang.String sourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceArn = builder.sourceArn;
            }

            @Override
            public final java.lang.String getSourceArn() {
                return this.sourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceArn() != null) {
                    data.set("sourceArn", om.valueToTree(this.getSourceArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.MetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataProperty.Jsii$Proxy that = (MetadataProperty.Jsii$Proxy) o;

                return this.sourceArn != null ? this.sourceArn.equals(that.sourceArn) : that.sourceArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceArn != null ? this.sourceArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents a set of options that define how DataBrew selects files for a given Amazon S3 path in a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * PathOptionsProperty pathOptionsProperty = PathOptionsProperty.builder()
     *         .filesLimit(FilesLimitProperty.builder()
     *                 .maxFiles(123)
     *                 // the properties below are optional
     *                 .order("order")
     *                 .orderedBy("orderedBy")
     *                 .build())
     *         .lastModifiedDateCondition(FilterExpressionProperty.builder()
     *                 .expression("expression")
     *                 .valuesMap(List.of(FilterValueProperty.builder()
     *                         .value("value")
     *                         .valueReference("valueReference")
     *                         .build()))
     *                 .build())
     *         .parameters(List.of(PathParameterProperty.builder()
     *                 .datasetParameter(DatasetParameterProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .createColumn(false)
     *                         .datetimeOptions(DatetimeOptionsProperty.builder()
     *                                 .format("format")
     *                                 // the properties below are optional
     *                                 .localeCode("localeCode")
     *                                 .timezoneOffset("timezoneOffset")
     *                                 .build())
     *                         .filter(FilterExpressionProperty.builder()
     *                                 .expression("expression")
     *                                 .valuesMap(List.of(FilterValueProperty.builder()
     *                                         .value("value")
     *                                         .valueReference("valueReference")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .pathParameterName("pathParameterName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.PathOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(PathOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PathOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If provided, this structure imposes a limit on a number of files that should be selected.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.FilesLimitProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html#cfn-databrew-dataset-pathoptions-fileslimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html#cfn-databrew-dataset-pathoptions-fileslimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilesLimit() {
            return null;
        }

        /**
         * If provided, this structure defines a date range for matching Amazon S3 objects based on their LastModifiedDate attribute in Amazon S3 .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.FilterExpressionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html#cfn-databrew-dataset-pathoptions-lastmodifieddatecondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html#cfn-databrew-dataset-pathoptions-lastmodifieddatecondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLastModifiedDateCondition() {
            return null;
        }

        /**
         * A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.PathParameterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html#cfn-databrew-dataset-pathoptions-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathoptions.html#cfn-databrew-dataset-pathoptions-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PathOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PathOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PathOptionsProperty> {
            java.lang.Object filesLimit;
            java.lang.Object lastModifiedDateCondition;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link PathOptionsProperty#getFilesLimit}
             * @param filesLimit If provided, this structure imposes a limit on a number of files that should be selected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filesLimit(software.amazon.awscdk.IResolvable filesLimit) {
                this.filesLimit = filesLimit;
                return this;
            }

            /**
             * Sets the value of {@link PathOptionsProperty#getFilesLimit}
             * @param filesLimit If provided, this structure imposes a limit on a number of files that should be selected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filesLimit(software.amazon.awscdk.services.databrew.CfnDataset.FilesLimitProperty filesLimit) {
                this.filesLimit = filesLimit;
                return this;
            }

            /**
             * Sets the value of {@link PathOptionsProperty#getLastModifiedDateCondition}
             * @param lastModifiedDateCondition If provided, this structure defines a date range for matching Amazon S3 objects based on their LastModifiedDate attribute in Amazon S3 .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastModifiedDateCondition(software.amazon.awscdk.IResolvable lastModifiedDateCondition) {
                this.lastModifiedDateCondition = lastModifiedDateCondition;
                return this;
            }

            /**
             * Sets the value of {@link PathOptionsProperty#getLastModifiedDateCondition}
             * @param lastModifiedDateCondition If provided, this structure defines a date range for matching Amazon S3 objects based on their LastModifiedDate attribute in Amazon S3 .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastModifiedDateCondition(software.amazon.awscdk.services.databrew.CfnDataset.FilterExpressionProperty lastModifiedDateCondition) {
                this.lastModifiedDateCondition = lastModifiedDateCondition;
                return this;
            }

            /**
             * Sets the value of {@link PathOptionsProperty#getParameters}
             * @param parameters A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link PathOptionsProperty#getParameters}
             * @param parameters A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PathOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PathOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PathOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PathOptionsProperty {
            private final java.lang.Object filesLimit;
            private final java.lang.Object lastModifiedDateCondition;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filesLimit = software.amazon.jsii.Kernel.get(this, "filesLimit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastModifiedDateCondition = software.amazon.jsii.Kernel.get(this, "lastModifiedDateCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filesLimit = builder.filesLimit;
                this.lastModifiedDateCondition = builder.lastModifiedDateCondition;
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.Object getFilesLimit() {
                return this.filesLimit;
            }

            @Override
            public final java.lang.Object getLastModifiedDateCondition() {
                return this.lastModifiedDateCondition;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilesLimit() != null) {
                    data.set("filesLimit", om.valueToTree(this.getFilesLimit()));
                }
                if (this.getLastModifiedDateCondition() != null) {
                    data.set("lastModifiedDateCondition", om.valueToTree(this.getLastModifiedDateCondition()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.PathOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PathOptionsProperty.Jsii$Proxy that = (PathOptionsProperty.Jsii$Proxy) o;

                if (this.filesLimit != null ? !this.filesLimit.equals(that.filesLimit) : that.filesLimit != null) return false;
                if (this.lastModifiedDateCondition != null ? !this.lastModifiedDateCondition.equals(that.lastModifiedDateCondition) : that.lastModifiedDateCondition != null) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filesLimit != null ? this.filesLimit.hashCode() : 0;
                result = 31 * result + (this.lastModifiedDateCondition != null ? this.lastModifiedDateCondition.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a single entry in the path parameters of a dataset.
     * <p>
     * Each <code>PathParameter</code> consists of a name and a parameter definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * PathParameterProperty pathParameterProperty = PathParameterProperty.builder()
     *         .datasetParameter(DatasetParameterProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .createColumn(false)
     *                 .datetimeOptions(DatetimeOptionsProperty.builder()
     *                         .format("format")
     *                         // the properties below are optional
     *                         .localeCode("localeCode")
     *                         .timezoneOffset("timezoneOffset")
     *                         .build())
     *                 .filter(FilterExpressionProperty.builder()
     *                         .expression("expression")
     *                         .valuesMap(List.of(FilterValueProperty.builder()
     *                                 .value("value")
     *                                 .valueReference("valueReference")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .pathParameterName("pathParameterName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.PathParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(PathParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PathParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path parameter definition.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.databrew.CfnDataset.DatasetParameterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathparameter.html#cfn-databrew-dataset-pathparameter-datasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathparameter.html#cfn-databrew-dataset-pathparameter-datasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatasetParameter();

        /**
         * The name of the path parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathparameter.html#cfn-databrew-dataset-pathparameter-pathparametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-pathparameter.html#cfn-databrew-dataset-pathparameter-pathparametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPathParameterName();

        /**
         * @return a {@link Builder} of {@link PathParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PathParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PathParameterProperty> {
            java.lang.Object datasetParameter;
            java.lang.String pathParameterName;

            /**
             * Sets the value of {@link PathParameterProperty#getDatasetParameter}
             * @param datasetParameter The path parameter definition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetParameter(software.amazon.awscdk.IResolvable datasetParameter) {
                this.datasetParameter = datasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link PathParameterProperty#getDatasetParameter}
             * @param datasetParameter The path parameter definition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetParameter(software.amazon.awscdk.services.databrew.CfnDataset.DatasetParameterProperty datasetParameter) {
                this.datasetParameter = datasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link PathParameterProperty#getPathParameterName}
             * @param pathParameterName The name of the path parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathParameterName(java.lang.String pathParameterName) {
                this.pathParameterName = pathParameterName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PathParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PathParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PathParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PathParameterProperty {
            private final java.lang.Object datasetParameter;
            private final java.lang.String pathParameterName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datasetParameter = software.amazon.jsii.Kernel.get(this, "datasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pathParameterName = software.amazon.jsii.Kernel.get(this, "pathParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datasetParameter = java.util.Objects.requireNonNull(builder.datasetParameter, "datasetParameter is required");
                this.pathParameterName = java.util.Objects.requireNonNull(builder.pathParameterName, "pathParameterName is required");
            }

            @Override
            public final java.lang.Object getDatasetParameter() {
                return this.datasetParameter;
            }

            @Override
            public final java.lang.String getPathParameterName() {
                return this.pathParameterName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("datasetParameter", om.valueToTree(this.getDatasetParameter()));
                data.set("pathParameterName", om.valueToTree(this.getPathParameterName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.PathParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PathParameterProperty.Jsii$Proxy that = (PathParameterProperty.Jsii$Proxy) o;

                if (!datasetParameter.equals(that.datasetParameter)) return false;
                return this.pathParameterName.equals(that.pathParameterName);
            }

            @Override
            public final int hashCode() {
                int result = this.datasetParameter.hashCode();
                result = 31 * result + (this.pathParameterName.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .bucketOwner("bucketOwner")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnDataset.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html#cfn-databrew-dataset-s3location-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html#cfn-databrew-dataset-s3location-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The AWS account ID of the bucket owner.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html#cfn-databrew-dataset-s3location-bucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html#cfn-databrew-dataset-s3location-bucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwner() {
            return null;
        }

        /**
         * The unique name of the object in the bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html#cfn-databrew-dataset-s3location-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-dataset-s3location.html#cfn-databrew-dataset-s3location-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String bucketOwner;
            java.lang.String key;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket The Amazon S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getBucketOwner}
             * @param bucketOwner The AWS account ID of the bucket owner.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwner(java.lang.String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key The unique name of the object in the bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String bucketOwner;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwner = software.amazon.jsii.Kernel.get(this, "bucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.bucketOwner = builder.bucketOwner;
                this.key = builder.key;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getBucketOwner() {
                return this.bucketOwner;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getBucketOwner() != null) {
                    data.set("bucketOwner", om.valueToTree(this.getBucketOwner()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnDataset.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.bucketOwner != null ? !this.bucketOwner.equals(that.bucketOwner) : that.bucketOwner != null) return false;
                return this.key != null ? this.key.equals(that.key) : that.key == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.bucketOwner != null ? this.bucketOwner.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.databrew.CfnDataset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.databrew.CfnDataset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.databrew.CfnDatasetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.databrew.CfnDatasetProps.Builder();
        }

        /**
         * Information on how DataBrew can find the dataset, in either the AWS Glue Data Catalog or Amazon S3 .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-input</a>
         * @param input Information on how DataBrew can find the dataset, in either the AWS Glue Data Catalog or Amazon S3 . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.IResolvable input) {
            this.props.input(input);
            return this;
        }
        /**
         * Information on how DataBrew can find the dataset, in either the AWS Glue Data Catalog or Amazon S3 .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-input</a>
         * @param input Information on how DataBrew can find the dataset, in either the AWS Glue Data Catalog or Amazon S3 . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.databrew.CfnDataset.InputProperty input) {
            this.props.input(input);
            return this;
        }

        /**
         * The unique name of the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-name</a>
         * @param name The unique name of the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The file format of a dataset that is created from an Amazon S3 file or folder.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-format</a>
         * @param format The file format of a dataset that is created from an Amazon S3 file or folder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(final java.lang.String format) {
            this.props.format(format);
            return this;
        }

        /**
         * A set of options that define how DataBrew interprets the data in the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-formatoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-formatoptions</a>
         * @param formatOptions A set of options that define how DataBrew interprets the data in the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formatOptions(final software.amazon.awscdk.IResolvable formatOptions) {
            this.props.formatOptions(formatOptions);
            return this;
        }
        /**
         * A set of options that define how DataBrew interprets the data in the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-formatoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-formatoptions</a>
         * @param formatOptions A set of options that define how DataBrew interprets the data in the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formatOptions(final software.amazon.awscdk.services.databrew.CfnDataset.FormatOptionsProperty formatOptions) {
            this.props.formatOptions(formatOptions);
            return this;
        }

        /**
         * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-pathoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-pathoptions</a>
         * @param pathOptions A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathOptions(final software.amazon.awscdk.IResolvable pathOptions) {
            this.props.pathOptions(pathOptions);
            return this;
        }
        /**
         * A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-pathoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-pathoptions</a>
         * @param pathOptions A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathOptions(final software.amazon.awscdk.services.databrew.CfnDataset.PathOptionsProperty pathOptions) {
            this.props.pathOptions(pathOptions);
            return this;
        }

        /**
         * The location of the data for the dataset, either Amazon S3 or the AWS Glue Data Catalog .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-source</a>
         * @param source The location of the data for the dataset, either Amazon S3 or the AWS Glue Data Catalog . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final java.lang.String source) {
            this.props.source(source);
            return this;
        }

        /**
         * Metadata tags that have been applied to the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-tags</a>
         * @param tags Metadata tags that have been applied to the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.databrew.CfnDataset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.databrew.CfnDataset build() {
            return new software.amazon.awscdk.services.databrew.CfnDataset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
