package software.amazon.awscdk.services.dms;

/**
 * Properties for defining a <code>CfnDataMigration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnDataMigrationProps cfnDataMigrationProps = CfnDataMigrationProps.builder()
 *         .dataMigrationType("dataMigrationType")
 *         .migrationProjectIdentifier("migrationProjectIdentifier")
 *         .serviceAccessRoleArn("serviceAccessRoleArn")
 *         // the properties below are optional
 *         .dataMigrationIdentifier("dataMigrationIdentifier")
 *         .dataMigrationName("dataMigrationName")
 *         .dataMigrationSettings(DataMigrationSettingsProperty.builder()
 *                 .cloudwatchLogsEnabled(false)
 *                 .numberOfJobs(123)
 *                 .selectionRules("selectionRules")
 *                 .build())
 *         .sourceDataSettings(List.of(SourceDataSettingsProperty.builder()
 *                 .cdcStartPosition("cdcStartPosition")
 *                 .cdcStartTime("cdcStartTime")
 *                 .cdcStopTime("cdcStopTime")
 *                 .slotName("slotName")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:48.984Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataMigrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataMigrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataMigrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataMigrationType();

    /**
     * The property describes an identifier for the migration project.
     * <p>
     * It is used for describing/deleting/modifying can be name/arn
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-migrationprojectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-migrationprojectidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMigrationProjectIdentifier();

    /**
     * The IAM role that the data migration uses to access AWS resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-serviceaccessrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceAccessRoleArn();

    /**
     * The property describes an ARN of the data migration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataMigrationIdentifier() {
        return null;
    }

    /**
     * The user-friendly name for the data migration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataMigrationName() {
        return null;
    }

    /**
     * Specifies CloudWatch settings and selection rules for the data migration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dms.CfnDataMigration.DataMigrationSettingsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataMigrationSettings() {
        return null;
    }

    /**
     * Specifies information about the data migration's source data provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dms.CfnDataMigration.SourceDataSettingsProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-sourcedatasettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-sourcedatasettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceDataSettings() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataMigrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataMigrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataMigrationProps> {
        java.lang.String dataMigrationType;
        java.lang.String migrationProjectIdentifier;
        java.lang.String serviceAccessRoleArn;
        java.lang.String dataMigrationIdentifier;
        java.lang.String dataMigrationName;
        java.lang.Object dataMigrationSettings;
        java.lang.Object sourceDataSettings;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataMigrationProps#getDataMigrationType}
         * @param dataMigrationType Specifies whether the data migration is full-load only, change data capture (CDC) only, or full-load and CDC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationType(java.lang.String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getMigrationProjectIdentifier}
         * @param migrationProjectIdentifier The property describes an identifier for the migration project. This parameter is required.
         *                                   It is used for describing/deleting/modifying can be name/arn
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrationProjectIdentifier(java.lang.String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getServiceAccessRoleArn}
         * @param serviceAccessRoleArn The IAM role that the data migration uses to access AWS resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getDataMigrationIdentifier}
         * @param dataMigrationIdentifier The property describes an ARN of the data migration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationIdentifier(java.lang.String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getDataMigrationName}
         * @param dataMigrationName The user-friendly name for the data migration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationName(java.lang.String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getDataMigrationSettings}
         * @param dataMigrationSettings Specifies CloudWatch settings and selection rules for the data migration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationSettings(software.amazon.awscdk.IResolvable dataMigrationSettings) {
            this.dataMigrationSettings = dataMigrationSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getDataMigrationSettings}
         * @param dataMigrationSettings Specifies CloudWatch settings and selection rules for the data migration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationSettings(software.amazon.awscdk.services.dms.CfnDataMigration.DataMigrationSettingsProperty dataMigrationSettings) {
            this.dataMigrationSettings = dataMigrationSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getSourceDataSettings}
         * @param sourceDataSettings Specifies information about the data migration's source data provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataSettings(software.amazon.awscdk.IResolvable sourceDataSettings) {
            this.sourceDataSettings = sourceDataSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getSourceDataSettings}
         * @param sourceDataSettings Specifies information about the data migration's source data provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataSettings(java.util.List<? extends java.lang.Object> sourceDataSettings) {
            this.sourceDataSettings = sourceDataSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataMigrationProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataMigrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataMigrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataMigrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataMigrationProps {
        private final java.lang.String dataMigrationType;
        private final java.lang.String migrationProjectIdentifier;
        private final java.lang.String serviceAccessRoleArn;
        private final java.lang.String dataMigrationIdentifier;
        private final java.lang.String dataMigrationName;
        private final java.lang.Object dataMigrationSettings;
        private final java.lang.Object sourceDataSettings;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataMigrationType = software.amazon.jsii.Kernel.get(this, "dataMigrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.migrationProjectIdentifier = software.amazon.jsii.Kernel.get(this, "migrationProjectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataMigrationIdentifier = software.amazon.jsii.Kernel.get(this, "dataMigrationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataMigrationName = software.amazon.jsii.Kernel.get(this, "dataMigrationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataMigrationSettings = software.amazon.jsii.Kernel.get(this, "dataMigrationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceDataSettings = software.amazon.jsii.Kernel.get(this, "sourceDataSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataMigrationType = java.util.Objects.requireNonNull(builder.dataMigrationType, "dataMigrationType is required");
            this.migrationProjectIdentifier = java.util.Objects.requireNonNull(builder.migrationProjectIdentifier, "migrationProjectIdentifier is required");
            this.serviceAccessRoleArn = java.util.Objects.requireNonNull(builder.serviceAccessRoleArn, "serviceAccessRoleArn is required");
            this.dataMigrationIdentifier = builder.dataMigrationIdentifier;
            this.dataMigrationName = builder.dataMigrationName;
            this.dataMigrationSettings = builder.dataMigrationSettings;
            this.sourceDataSettings = builder.sourceDataSettings;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDataMigrationType() {
            return this.dataMigrationType;
        }

        @Override
        public final java.lang.String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        @Override
        public final java.lang.String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final java.lang.String getDataMigrationIdentifier() {
            return this.dataMigrationIdentifier;
        }

        @Override
        public final java.lang.String getDataMigrationName() {
            return this.dataMigrationName;
        }

        @Override
        public final java.lang.Object getDataMigrationSettings() {
            return this.dataMigrationSettings;
        }

        @Override
        public final java.lang.Object getSourceDataSettings() {
            return this.sourceDataSettings;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataMigrationType", om.valueToTree(this.getDataMigrationType()));
            data.set("migrationProjectIdentifier", om.valueToTree(this.getMigrationProjectIdentifier()));
            data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
            if (this.getDataMigrationIdentifier() != null) {
                data.set("dataMigrationIdentifier", om.valueToTree(this.getDataMigrationIdentifier()));
            }
            if (this.getDataMigrationName() != null) {
                data.set("dataMigrationName", om.valueToTree(this.getDataMigrationName()));
            }
            if (this.getDataMigrationSettings() != null) {
                data.set("dataMigrationSettings", om.valueToTree(this.getDataMigrationSettings()));
            }
            if (this.getSourceDataSettings() != null) {
                data.set("sourceDataSettings", om.valueToTree(this.getSourceDataSettings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataMigrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataMigrationProps.Jsii$Proxy that = (CfnDataMigrationProps.Jsii$Proxy) o;

            if (!dataMigrationType.equals(that.dataMigrationType)) return false;
            if (!migrationProjectIdentifier.equals(that.migrationProjectIdentifier)) return false;
            if (!serviceAccessRoleArn.equals(that.serviceAccessRoleArn)) return false;
            if (this.dataMigrationIdentifier != null ? !this.dataMigrationIdentifier.equals(that.dataMigrationIdentifier) : that.dataMigrationIdentifier != null) return false;
            if (this.dataMigrationName != null ? !this.dataMigrationName.equals(that.dataMigrationName) : that.dataMigrationName != null) return false;
            if (this.dataMigrationSettings != null ? !this.dataMigrationSettings.equals(that.dataMigrationSettings) : that.dataMigrationSettings != null) return false;
            if (this.sourceDataSettings != null ? !this.sourceDataSettings.equals(that.sourceDataSettings) : that.sourceDataSettings != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataMigrationType.hashCode();
            result = 31 * result + (this.migrationProjectIdentifier.hashCode());
            result = 31 * result + (this.serviceAccessRoleArn.hashCode());
            result = 31 * result + (this.dataMigrationIdentifier != null ? this.dataMigrationIdentifier.hashCode() : 0);
            result = 31 * result + (this.dataMigrationName != null ? this.dataMigrationName.hashCode() : 0);
            result = 31 * result + (this.dataMigrationSettings != null ? this.dataMigrationSettings.hashCode() : 0);
            result = 31 * result + (this.sourceDataSettings != null ? this.sourceDataSettings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
