package software.amazon.awscdk.services.dms;

/**
 * Properties for defining a <code>CfnReplicationConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * Object replicationSettings;
 * Object supplementalSettings;
 * Object tableMappings;
 * CfnReplicationConfigProps cfnReplicationConfigProps = CfnReplicationConfigProps.builder()
 *         .computeConfig(ComputeConfigProperty.builder()
 *                 .maxCapacityUnits(123)
 *                 // the properties below are optional
 *                 .availabilityZone("availabilityZone")
 *                 .dnsNameServers("dnsNameServers")
 *                 .kmsKeyId("kmsKeyId")
 *                 .minCapacityUnits(123)
 *                 .multiAz(false)
 *                 .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *                 .replicationSubnetGroupId("replicationSubnetGroupId")
 *                 .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *                 .build())
 *         .replicationConfigIdentifier("replicationConfigIdentifier")
 *         .replicationType("replicationType")
 *         .sourceEndpointArn("sourceEndpointArn")
 *         .tableMappings(tableMappings)
 *         .targetEndpointArn("targetEndpointArn")
 *         // the properties below are optional
 *         .replicationSettings(replicationSettings)
 *         .resourceIdentifier("resourceIdentifier")
 *         .supplementalSettings(supplementalSettings)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:49.079Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnReplicationConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnReplicationConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReplicationConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration parameters for provisioning an AWS DMS Serverless replication.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dms.CfnReplicationConfig.ComputeConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-computeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-computeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComputeConfig();

    /**
     * A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as part of the output from this action.
     * <p>
     * You can then pass this output <code>ReplicationConfigArn</code> as the value of the <code>ReplicationConfigArn</code> option for other actions to identify both AWS DMS Serverless replications and replication configurations that you want those actions to operate on. For some actions, you can also use either this unique identifier or a corresponding ARN in action filters to identify the specific replication and replication configuration to operate on.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationconfigidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationconfigidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicationConfigIdentifier();

    /**
     * The type of AWS DMS Serverless replication to provision using this replication configuration.
     * <p>
     * Possible values:
     * <p>
     * <ul>
     * <li><code>"full-load"</code></li>
     * <li><code>"cdc"</code></li>
     * <li><code>"full-load-and-cdc"</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicationType();

    /**
     * The Amazon Resource Name (ARN) of the source endpoint for this AWS DMS Serverless replication configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-sourceendpointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-sourceendpointarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceEndpointArn();

    /**
     * JSON table mappings for AWS DMS Serverless replications that are provisioned using this replication configuration.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html">Specifying table selection and transformations rules using JSON</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tablemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tablemappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTableMappings();

    /**
     * The Amazon Resource Name (ARN) of the target endpoint for this AWS DMS serverless replication configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-targetendpointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-targetendpointarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetEndpointArn();

    /**
     * Optional JSON settings for AWS DMS Serverless replications that are provisioned using this replication configuration.
     * <p>
     * For example, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html">Change processing tuning settings</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-replicationsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationSettings() {
        return null;
    }

    /**
     * Optional unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess">Fine-grained access control using resource names and tags</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-resourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-resourceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdentifier() {
        return null;
    }

    /**
     * Optional JSON settings for specifying supplemental data.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying supplemental data for task settings</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-supplementalsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-supplementalsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSupplementalSettings() {
        return null;
    }

    /**
     * One or more optional tags associated with resources used by the AWS DMS Serverless replication.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html">Tagging resources in AWS Database Migration Service</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationconfig.html#cfn-dms-replicationconfig-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReplicationConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReplicationConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReplicationConfigProps> {
        java.lang.Object computeConfig;
        java.lang.String replicationConfigIdentifier;
        java.lang.String replicationType;
        java.lang.String sourceEndpointArn;
        java.lang.Object tableMappings;
        java.lang.String targetEndpointArn;
        java.lang.Object replicationSettings;
        java.lang.String resourceIdentifier;
        java.lang.Object supplementalSettings;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getComputeConfig}
         * @param computeConfig Configuration parameters for provisioning an AWS DMS Serverless replication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfig(software.amazon.awscdk.IResolvable computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getComputeConfig}
         * @param computeConfig Configuration parameters for provisioning an AWS DMS Serverless replication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfig(software.amazon.awscdk.services.dms.CfnReplicationConfig.ComputeConfigProperty computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getReplicationConfigIdentifier}
         * @param replicationConfigIdentifier A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as part of the output from this action. This parameter is required.
         *                                    You can then pass this output <code>ReplicationConfigArn</code> as the value of the <code>ReplicationConfigArn</code> option for other actions to identify both AWS DMS Serverless replications and replication configurations that you want those actions to operate on. For some actions, you can also use either this unique identifier or a corresponding ARN in action filters to identify the specific replication and replication configuration to operate on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationConfigIdentifier(java.lang.String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getReplicationType}
         * @param replicationType The type of AWS DMS Serverless replication to provision using this replication configuration. This parameter is required.
         *                        Possible values:
         *                        <p>
         *                        <ul>
         *                        <li><code>"full-load"</code></li>
         *                        <li><code>"cdc"</code></li>
         *                        <li><code>"full-load-and-cdc"</code></li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationType(java.lang.String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getSourceEndpointArn}
         * @param sourceEndpointArn The Amazon Resource Name (ARN) of the source endpoint for this AWS DMS Serverless replication configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEndpointArn(java.lang.String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getTableMappings}
         * @param tableMappings JSON table mappings for AWS DMS Serverless replications that are provisioned using this replication configuration. This parameter is required.
         *                      For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html">Specifying table selection and transformations rules using JSON</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableMappings(java.lang.Object tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getTargetEndpointArn}
         * @param targetEndpointArn The Amazon Resource Name (ARN) of the target endpoint for this AWS DMS serverless replication configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetEndpointArn(java.lang.String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getReplicationSettings}
         * @param replicationSettings Optional JSON settings for AWS DMS Serverless replications that are provisioned using this replication configuration.
         *                            For example, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html">Change processing tuning settings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSettings(java.lang.Object replicationSettings) {
            this.replicationSettings = replicationSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getResourceIdentifier}
         * @param resourceIdentifier Optional unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource.
         *                           For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess">Fine-grained access control using resource names and tags</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(java.lang.String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getSupplementalSettings}
         * @param supplementalSettings Optional JSON settings for specifying supplemental data.
         *                             For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying supplemental data for task settings</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supplementalSettings(java.lang.Object supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationConfigProps#getTags}
         * @param tags One or more optional tags associated with resources used by the AWS DMS Serverless replication.
         *             For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html">Tagging resources in AWS Database Migration Service</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReplicationConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReplicationConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReplicationConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReplicationConfigProps {
        private final java.lang.Object computeConfig;
        private final java.lang.String replicationConfigIdentifier;
        private final java.lang.String replicationType;
        private final java.lang.String sourceEndpointArn;
        private final java.lang.Object tableMappings;
        private final java.lang.String targetEndpointArn;
        private final java.lang.Object replicationSettings;
        private final java.lang.String resourceIdentifier;
        private final java.lang.Object supplementalSettings;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeConfig = software.amazon.jsii.Kernel.get(this, "computeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicationConfigIdentifier = software.amazon.jsii.Kernel.get(this, "replicationConfigIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationType = software.amazon.jsii.Kernel.get(this, "replicationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceEndpointArn = software.amazon.jsii.Kernel.get(this, "sourceEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableMappings = software.amazon.jsii.Kernel.get(this, "tableMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetEndpointArn = software.amazon.jsii.Kernel.get(this, "targetEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationSettings = software.amazon.jsii.Kernel.get(this, "replicationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceIdentifier = software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.supplementalSettings = software.amazon.jsii.Kernel.get(this, "supplementalSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeConfig = java.util.Objects.requireNonNull(builder.computeConfig, "computeConfig is required");
            this.replicationConfigIdentifier = java.util.Objects.requireNonNull(builder.replicationConfigIdentifier, "replicationConfigIdentifier is required");
            this.replicationType = java.util.Objects.requireNonNull(builder.replicationType, "replicationType is required");
            this.sourceEndpointArn = java.util.Objects.requireNonNull(builder.sourceEndpointArn, "sourceEndpointArn is required");
            this.tableMappings = java.util.Objects.requireNonNull(builder.tableMappings, "tableMappings is required");
            this.targetEndpointArn = java.util.Objects.requireNonNull(builder.targetEndpointArn, "targetEndpointArn is required");
            this.replicationSettings = builder.replicationSettings;
            this.resourceIdentifier = builder.resourceIdentifier;
            this.supplementalSettings = builder.supplementalSettings;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getComputeConfig() {
            return this.computeConfig;
        }

        @Override
        public final java.lang.String getReplicationConfigIdentifier() {
            return this.replicationConfigIdentifier;
        }

        @Override
        public final java.lang.String getReplicationType() {
            return this.replicationType;
        }

        @Override
        public final java.lang.String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        @Override
        public final java.lang.Object getTableMappings() {
            return this.tableMappings;
        }

        @Override
        public final java.lang.String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        @Override
        public final java.lang.Object getReplicationSettings() {
            return this.replicationSettings;
        }

        @Override
        public final java.lang.String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final java.lang.Object getSupplementalSettings() {
            return this.supplementalSettings;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeConfig", om.valueToTree(this.getComputeConfig()));
            data.set("replicationConfigIdentifier", om.valueToTree(this.getReplicationConfigIdentifier()));
            data.set("replicationType", om.valueToTree(this.getReplicationType()));
            data.set("sourceEndpointArn", om.valueToTree(this.getSourceEndpointArn()));
            data.set("tableMappings", om.valueToTree(this.getTableMappings()));
            data.set("targetEndpointArn", om.valueToTree(this.getTargetEndpointArn()));
            if (this.getReplicationSettings() != null) {
                data.set("replicationSettings", om.valueToTree(this.getReplicationSettings()));
            }
            if (this.getResourceIdentifier() != null) {
                data.set("resourceIdentifier", om.valueToTree(this.getResourceIdentifier()));
            }
            if (this.getSupplementalSettings() != null) {
                data.set("supplementalSettings", om.valueToTree(this.getSupplementalSettings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnReplicationConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReplicationConfigProps.Jsii$Proxy that = (CfnReplicationConfigProps.Jsii$Proxy) o;

            if (!computeConfig.equals(that.computeConfig)) return false;
            if (!replicationConfigIdentifier.equals(that.replicationConfigIdentifier)) return false;
            if (!replicationType.equals(that.replicationType)) return false;
            if (!sourceEndpointArn.equals(that.sourceEndpointArn)) return false;
            if (!tableMappings.equals(that.tableMappings)) return false;
            if (!targetEndpointArn.equals(that.targetEndpointArn)) return false;
            if (this.replicationSettings != null ? !this.replicationSettings.equals(that.replicationSettings) : that.replicationSettings != null) return false;
            if (this.resourceIdentifier != null ? !this.resourceIdentifier.equals(that.resourceIdentifier) : that.resourceIdentifier != null) return false;
            if (this.supplementalSettings != null ? !this.supplementalSettings.equals(that.supplementalSettings) : that.supplementalSettings != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computeConfig.hashCode();
            result = 31 * result + (this.replicationConfigIdentifier.hashCode());
            result = 31 * result + (this.replicationType.hashCode());
            result = 31 * result + (this.sourceEndpointArn.hashCode());
            result = 31 * result + (this.tableMappings.hashCode());
            result = 31 * result + (this.targetEndpointArn.hashCode());
            result = 31 * result + (this.replicationSettings != null ? this.replicationSettings.hashCode() : 0);
            result = 31 * result + (this.resourceIdentifier != null ? this.resourceIdentifier.hashCode() : 0);
            result = 31 * result + (this.supplementalSettings != null ? this.supplementalSettings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
