package software.amazon.awscdk.services.dynamodb;

/**
 * Reference to ContributorInsightsSpecification.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .contributorInsightsSpecification(ContributorInsightsSpecification.builder()
 *                 .enabled(true)
 *                 .build())
 *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecification.builder()
 *                 .pointInTimeRecoveryEnabled(true)
 *                 .build())
 *         .replicas(List.of(ReplicaTableProps.builder()
 *                 .region("us-east-1")
 *                 .tableClass(TableClass.STANDARD_INFREQUENT_ACCESS)
 *                 .pointInTimeRecoverySpecification(PointInTimeRecoverySpecification.builder()
 *                         .pointInTimeRecoveryEnabled(false)
 *                         .build())
 *                 .build(), ReplicaTableProps.builder()
 *                 .region("us-east-2")
 *                 .contributorInsightsSpecification(ContributorInsightsSpecification.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:49.234Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.ContributorInsightsSpecification")
@software.amazon.jsii.Jsii.Proxy(ContributorInsightsSpecification.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContributorInsightsSpecification extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether contributor insights is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getEnabled();

    /**
     * Indicates the type of metrics captured by contributor insights.
     * <p>
     * Default: ACCESSED_AND_THROTTLED_KEYS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.ContributorInsightsMode getMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContributorInsightsSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContributorInsightsSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContributorInsightsSpecification> {
        java.lang.Boolean enabled;
        software.amazon.awscdk.services.dynamodb.ContributorInsightsMode mode;

        /**
         * Sets the value of {@link ContributorInsightsSpecification#getEnabled}
         * @param enabled Indicates whether contributor insights is enabled. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ContributorInsightsSpecification#getMode}
         * @param mode Indicates the type of metrics captured by contributor insights.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(software.amazon.awscdk.services.dynamodb.ContributorInsightsMode mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContributorInsightsSpecification}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContributorInsightsSpecification build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContributorInsightsSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContributorInsightsSpecification {
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.dynamodb.ContributorInsightsMode mode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ContributorInsightsMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            this.mode = builder.mode;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ContributorInsightsMode getMode() {
            return this.mode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("enabled", om.valueToTree(this.getEnabled()));
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.ContributorInsightsSpecification"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContributorInsightsSpecification.Jsii$Proxy that = (ContributorInsightsSpecification.Jsii$Proxy) o;

            if (!enabled.equals(that.enabled)) return false;
            return this.mode != null ? this.mode.equals(that.mode) : that.mode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enabled.hashCode();
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            return result;
        }
    }
}
