package software.amazon.awscdk.services.dynamodb;

/**
 * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.*;
 * import software.amazon.awscdk.services.dynamodb.*;
 * Function fn;
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .stream(StreamViewType.NEW_IMAGE)
 *         .build();
 * fn.addEventSource(DynamoEventSource.Builder.create(table)
 *         .startingPosition(StartingPosition.LATEST)
 *         .metricsConfig(MetricsConfig.builder()
 *                 .metrics(List.of(MetricType.EVENT_COUNT))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:49.260Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.StreamViewType")
public enum StreamViewType {
    /**
     * The entire item, as it appears after it was modified, is written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEW_IMAGE,
    /**
     * The entire item, as it appeared before it was modified, is written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLD_IMAGE,
    /**
     * Both the new and the old item images of the item are written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEW_AND_OLD_IMAGES,
    /**
     * Only the key attributes of the modified item are written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KEYS_ONLY,
}
