package software.amazon.awscdk.services.ec2;

/**
 * Supported hardware accelerator manufacturers.
 * <p>
 * Restricts instance selection to accelerators from a particular vendor.
 * Useful for choosing specific ecosystems (e.g., NVIDIA CUDA, AWS chips).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * // Create a Managed Instances Capacity Provider
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(SecurityGroup.Builder.create(this, "MISecurityGroup").vpc(vpc).build()))
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 .vCpuCountMin(1)
 *                 .memoryMin(Size.gibibytes(2))
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .build())
 *         .propagateTags(PropagateManagedInstancesTags.CAPACITY_PROVIDER)
 *         .build();
 * // Optionally configure security group rules using IConnectable interface
 * miCapacityProvider.connections.allowFrom(Peer.ipv4(vpc.getVpcCidrBlock()), Port.tcp(80));
 * // Add the capacity provider to the cluster
 * cluster.addManagedInstancesCapacityProvider(miCapacityProvider);
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryReservationMiB(256)
 *         .build());
 * Ec2Service.Builder.create(this, "EC2Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider(miCapacityProvider.getCapacityProviderName())
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:49.324Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AcceleratorManufacturer")
public enum AcceleratorManufacturer {
    /**
     * Amazon Web Services (e.g., Inferentia, Trainium accelerators).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS,
    /**
     * AMD (e.g., Radeon Pro V520 GPU).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMD,
    /**
     * NVIDIA (e.g., A100, V100, T4, K80, M60 GPUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NVIDIA,
    /**
     * Xilinx (e.g., VU9P FPGA).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XILINX,
    /**
     * Habana Labs(e.g, Gaudi accelerator).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HABANA,
}
