package software.amazon.awscdk.services.ec2;

/**
 * In IPAM, a scope is the highest-level container within IPAM.
 * <p>
 * An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com//vpc/latest/ipam/how-it-works-ipam.html">How IPAM works</a> in the <em>Amazon VPC IPAM User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnIPAMScope cfnIPAMScope = CfnIPAMScope.Builder.create(this, "MyCfnIPAMScope")
 *         .ipamId("ipamId")
 *         // the properties below are optional
 *         .description("description")
 *         .externalAuthorityConfiguration(IpamScopeExternalAuthorityConfigurationProperty.builder()
 *                 .externalResourceIdentifier("externalResourceIdentifier")
 *                 .ipamScopeExternalAuthorityType("ipamScopeExternalAuthorityType")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:49.500Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnIPAMScope")
public class CfnIPAMScope extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.ec2.IIPAMScopeRef, software.amazon.awscdk.ITaggable {

    protected CfnIPAMScope(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIPAMScope(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnIPAMScope.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::EC2::IPAMScope</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIPAMScope(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnIPAMScopeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new IIPAMScopeRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ec2.IIPAMScopeRef fromIPAMScopeArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CfnIPAMScope.class, "fromIPAMScopeArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ec2.IIPAMScopeRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new IIPAMScopeRef from a ipamScopeId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param ipamScopeId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ec2.IIPAMScopeRef fromIpamScopeId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String ipamScopeId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CfnIPAMScope.class, "fromIpamScopeId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ec2.IIPAMScopeRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(ipamScopeId, "ipamScopeId is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of an IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of an IPAM scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamScopeId() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamScopeType() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamScopeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines if the scope is the default scope or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrIsDefault() {
        return software.amazon.jsii.Kernel.get(this, "attrIsDefault", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The number of pools in a scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrPoolCount() {
        return software.amazon.jsii.Kernel.get(this, "attrPoolCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a IPAMScope resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ec2.IPAMScopeReference getIpamScopeRef() {
        return software.amazon.jsii.Kernel.get(this, "ipamScopeRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ec2.IPAMScopeReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the IPAM for which you're creating this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIpamId() {
        return software.amazon.jsii.Kernel.get(this, "ipamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the IPAM for which you're creating this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpamId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipamId", java.util.Objects.requireNonNull(value, "ipamId is required"));
    }

    /**
     * The description of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The configuration that links an Amazon VPC IPAM scope to an external authority system.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnIPAMScope.IpamScopeExternalAuthorityConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExternalAuthorityConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "externalAuthorityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration that links an Amazon VPC IPAM scope to an external authority system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExternalAuthorityConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "externalAuthorityConfiguration", value);
    }

    /**
     * The configuration that links an Amazon VPC IPAM scope to an external authority system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExternalAuthorityConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnIPAMScope.IpamScopeExternalAuthorityConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "externalAuthorityConfiguration", value);
    }

    /**
     * The key/value combination of a tag assigned to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The key/value combination of a tag assigned to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The configuration that links an Amazon VPC IPAM scope to an external authority system.
     * <p>
     * It specifies the type of external system and the external resource identifier that identifies your account or instance in that system.
     * <p>
     * In IPAM, an external authority is a third-party IP address management system that provides CIDR blocks when you provision address space for top-level IPAM pools. This allows you to use your existing IP management system to control which address ranges are allocated to AWS while using Amazon VPC IPAM to manage subnets within those ranges.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * IpamScopeExternalAuthorityConfigurationProperty ipamScopeExternalAuthorityConfigurationProperty = IpamScopeExternalAuthorityConfigurationProperty.builder()
     *         .externalResourceIdentifier("externalResourceIdentifier")
     *         .ipamScopeExternalAuthorityType("ipamScopeExternalAuthorityType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipamscope-ipamscopeexternalauthorityconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipamscope-ipamscopeexternalauthorityconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnIPAMScope.IpamScopeExternalAuthorityConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IpamScopeExternalAuthorityConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IpamScopeExternalAuthorityConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the external resource managing this scope.
         * <p>
         * For Infoblox integrations, this is the Infoblox resource identifier in the format <code>&lt;version&gt;.identity.account.&lt;entity_realm&gt;.&lt;entity_id&gt;</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipamscope-ipamscopeexternalauthorityconfiguration.html#cfn-ec2-ipamscope-ipamscopeexternalauthorityconfiguration-externalresourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipamscope-ipamscopeexternalauthorityconfiguration.html#cfn-ec2-ipamscope-ipamscopeexternalauthorityconfiguration-externalresourceidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExternalResourceIdentifier();

        /**
         * The type of external authority managing this scope.
         * <p>
         * Currently supports <code>Infoblox</code> for integration with Infoblox Universal DDI.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipamscope-ipamscopeexternalauthorityconfiguration.html#cfn-ec2-ipamscope-ipamscopeexternalauthorityconfiguration-ipamscopeexternalauthoritytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ipamscope-ipamscopeexternalauthorityconfiguration.html#cfn-ec2-ipamscope-ipamscopeexternalauthorityconfiguration-ipamscopeexternalauthoritytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpamScopeExternalAuthorityType();

        /**
         * @return a {@link Builder} of {@link IpamScopeExternalAuthorityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IpamScopeExternalAuthorityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IpamScopeExternalAuthorityConfigurationProperty> {
            java.lang.String externalResourceIdentifier;
            java.lang.String ipamScopeExternalAuthorityType;

            /**
             * Sets the value of {@link IpamScopeExternalAuthorityConfigurationProperty#getExternalResourceIdentifier}
             * @param externalResourceIdentifier The identifier for the external resource managing this scope. This parameter is required.
             *                                   For Infoblox integrations, this is the Infoblox resource identifier in the format <code>&lt;version&gt;.identity.account.&lt;entity_realm&gt;.&lt;entity_id&gt;</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalResourceIdentifier(java.lang.String externalResourceIdentifier) {
                this.externalResourceIdentifier = externalResourceIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link IpamScopeExternalAuthorityConfigurationProperty#getIpamScopeExternalAuthorityType}
             * @param ipamScopeExternalAuthorityType The type of external authority managing this scope. This parameter is required.
             *                                       Currently supports <code>Infoblox</code> for integration with Infoblox Universal DDI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipamScopeExternalAuthorityType(java.lang.String ipamScopeExternalAuthorityType) {
                this.ipamScopeExternalAuthorityType = ipamScopeExternalAuthorityType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IpamScopeExternalAuthorityConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IpamScopeExternalAuthorityConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IpamScopeExternalAuthorityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpamScopeExternalAuthorityConfigurationProperty {
            private final java.lang.String externalResourceIdentifier;
            private final java.lang.String ipamScopeExternalAuthorityType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.externalResourceIdentifier = software.amazon.jsii.Kernel.get(this, "externalResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipamScopeExternalAuthorityType = software.amazon.jsii.Kernel.get(this, "ipamScopeExternalAuthorityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.externalResourceIdentifier = java.util.Objects.requireNonNull(builder.externalResourceIdentifier, "externalResourceIdentifier is required");
                this.ipamScopeExternalAuthorityType = java.util.Objects.requireNonNull(builder.ipamScopeExternalAuthorityType, "ipamScopeExternalAuthorityType is required");
            }

            @Override
            public final java.lang.String getExternalResourceIdentifier() {
                return this.externalResourceIdentifier;
            }

            @Override
            public final java.lang.String getIpamScopeExternalAuthorityType() {
                return this.ipamScopeExternalAuthorityType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("externalResourceIdentifier", om.valueToTree(this.getExternalResourceIdentifier()));
                data.set("ipamScopeExternalAuthorityType", om.valueToTree(this.getIpamScopeExternalAuthorityType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnIPAMScope.IpamScopeExternalAuthorityConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IpamScopeExternalAuthorityConfigurationProperty.Jsii$Proxy that = (IpamScopeExternalAuthorityConfigurationProperty.Jsii$Proxy) o;

                if (!externalResourceIdentifier.equals(that.externalResourceIdentifier)) return false;
                return this.ipamScopeExternalAuthorityType.equals(that.ipamScopeExternalAuthorityType);
            }

            @Override
            public final int hashCode() {
                int result = this.externalResourceIdentifier.hashCode();
                result = 31 * result + (this.ipamScopeExternalAuthorityType.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnIPAMScope}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnIPAMScope> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnIPAMScopeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnIPAMScopeProps.Builder();
        }

        /**
         * The ID of the IPAM for which you're creating this scope.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-ipamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-ipamid</a>
         * @param ipamId The ID of the IPAM for which you're creating this scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamId(final java.lang.String ipamId) {
            this.props.ipamId(ipamId);
            return this;
        }

        /**
         * The description of the scope.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-description</a>
         * @param description The description of the scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The configuration that links an Amazon VPC IPAM scope to an external authority system.
         * <p>
         * It specifies the type of external system and the external resource identifier that identifies your account or instance in that system.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/integrate-infoblox-ipam.html">Integrate VPC IPAM with Infoblox infrastructure</a> in the <em>Amazon VPC IPAM User Guide</em> ..
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-externalauthorityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-externalauthorityconfiguration</a>
         * @param externalAuthorityConfiguration The configuration that links an Amazon VPC IPAM scope to an external authority system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalAuthorityConfiguration(final software.amazon.awscdk.IResolvable externalAuthorityConfiguration) {
            this.props.externalAuthorityConfiguration(externalAuthorityConfiguration);
            return this;
        }
        /**
         * The configuration that links an Amazon VPC IPAM scope to an external authority system.
         * <p>
         * It specifies the type of external system and the external resource identifier that identifies your account or instance in that system.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/integrate-infoblox-ipam.html">Integrate VPC IPAM with Infoblox infrastructure</a> in the <em>Amazon VPC IPAM User Guide</em> ..
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-externalauthorityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-externalauthorityconfiguration</a>
         * @param externalAuthorityConfiguration The configuration that links an Amazon VPC IPAM scope to an external authority system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalAuthorityConfiguration(final software.amazon.awscdk.services.ec2.CfnIPAMScope.IpamScopeExternalAuthorityConfigurationProperty externalAuthorityConfiguration) {
            this.props.externalAuthorityConfiguration(externalAuthorityConfiguration);
            return this;
        }

        /**
         * The key/value combination of a tag assigned to the resource.
         * <p>
         * Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code> , specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ipamscope.html#cfn-ec2-ipamscope-tags</a>
         * @param tags The key/value combination of a tag assigned to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnIPAMScope}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnIPAMScope build() {
            return new software.amazon.awscdk.services.ec2.CfnIPAMScope(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
