package software.amazon.awscdk.services.ec2;

/**
 * Options for Client Route Enforcement.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ClientVpnEndpoint endpoint = vpc.addClientVpnEndpoint("Endpoint", ClientVpnEndpointOptions.builder()
 *         .cidr("10.100.0.0/16")
 *         .serverCertificateArn("arn:aws:acm:us-east-1:123456789012:certificate/server-certificate-id")
 *         .clientCertificateArn("arn:aws:acm:us-east-1:123456789012:certificate/client-certificate-id")
 *         .clientRouteEnforcementOptions(ClientRouteEnforcementOptions.builder()
 *                 .enforced(true)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:49.919Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ClientRouteEnforcementOptions")
@software.amazon.jsii.Jsii.Proxy(ClientRouteEnforcementOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClientRouteEnforcementOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enable or disable Client Route Enforcement.
     * <p>
     * The state can either be true (enabled) or false (disabled).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getEnforced();

    /**
     * @return a {@link Builder} of {@link ClientRouteEnforcementOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClientRouteEnforcementOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClientRouteEnforcementOptions> {
        java.lang.Boolean enforced;

        /**
         * Sets the value of {@link ClientRouteEnforcementOptions#getEnforced}
         * @param enforced Enable or disable Client Route Enforcement. This parameter is required.
         *                 The state can either be true (enabled) or false (disabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforced(java.lang.Boolean enforced) {
            this.enforced = enforced;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClientRouteEnforcementOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClientRouteEnforcementOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClientRouteEnforcementOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientRouteEnforcementOptions {
        private final java.lang.Boolean enforced;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enforced = software.amazon.jsii.Kernel.get(this, "enforced", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enforced = java.util.Objects.requireNonNull(builder.enforced, "enforced is required");
        }

        @Override
        public final java.lang.Boolean getEnforced() {
            return this.enforced;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("enforced", om.valueToTree(this.getEnforced()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.ClientRouteEnforcementOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClientRouteEnforcementOptions.Jsii$Proxy that = (ClientRouteEnforcementOptions.Jsii$Proxy) o;

            return this.enforced.equals(that.enforced);
        }

        @Override
        public final int hashCode() {
            int result = this.enforced.hashCode();
            return result;
        }
    }
}
