package software.amazon.awscdk.services.ec2;

/**
 * Instance type for EC2 instances.
 * <p>
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Login.builder()
 *                 .username("myuser")
 *                 .build())
 *         .instanceType(InstanceType.of(InstanceClass.MEMORY5, InstanceSize.LARGE))
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .vpc(vpc)
 *         .caCertificate(CaCertificate.RDS_CA_RSA4096_G1)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.033Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InstanceType")
public class InstanceType extends software.amazon.jsii.JsiiObject {

    protected InstanceType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instanceTypeIdentifier This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceType(final @org.jetbrains.annotations.NotNull java.lang.String instanceTypeIdentifier) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceTypeIdentifier, "instanceTypeIdentifier is required") });
    }

    /**
     * Instance type for EC2 instances.
     * <p>
     * This class takes a combination of a class and size.
     * <p>
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     * <p>
     * @param instanceClass This parameter is required.
     * @param instanceSize This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceClass instanceClass, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceSize instanceSize) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InstanceType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class), new Object[] { java.util.Objects.requireNonNull(instanceClass, "instanceClass is required"), java.util.Objects.requireNonNull(instanceSize, "instanceSize is required") });
    }

    /**
     * Return whether this instance type is a burstable instance type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isBurstable() {
        return software.amazon.jsii.Kernel.call(this, "isBurstable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean sameInstanceClassAs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType other) {
        return software.amazon.jsii.Kernel.call(this, "sameInstanceClassAs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     * Return the instance type as a dotted string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance's CPU architecture.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceArchitecture getArchitecture() {
        return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceArchitecture.class));
    }
}
