package software.amazon.awscdk.services.ec2;

/**
 * IP address types supported for VPC endpoint service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NetworkLoadBalancer networkLoadBalancer;
 * VpcEndpointService.Builder.create(this, "EndpointService")
 *         .vpcEndpointServiceLoadBalancers(List.of(networkLoadBalancer))
 *         // Support both IPv4 and IPv6 connections to the endpoint service
 *         .supportedIpAddressTypes(List.of(IpAddressType.IPV4, IpAddressType.IPV6))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.056Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IpAddressType")
public enum IpAddressType {
    /**
     * ipv4 address type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * ipv6 address type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV6,
}
