package software.amazon.awscdk.services.ec2;

/**
 * The types of IP addresses provisioned in the VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * // The VPC and subnet must have associated IPv6 CIDR blocks.
 * Vpc vpc = Vpc.Builder.create(this, "Vpc")
 *         .ipProtocol(IpProtocol.DUAL_STACK)
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "EcsCluster").vpc(vpc).build();
 * ApplicationLoadBalancedFargateService service = ApplicationLoadBalancedFargateService.Builder.create(this, "myService")
 *         .cluster(cluster)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .minHealthyPercent(100)
 *         .ipAddressType(IpAddressType.DUAL_STACK)
 *         .build();
 * ApplicationLoadBalancedEc2Service applicationLoadBalancedEc2Service = ApplicationLoadBalancedEc2Service.Builder.create(this, "myService")
 *         .cluster(cluster)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .minHealthyPercent(100)
 *         .ipAddressType(IpAddressType.DUAL_STACK)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.057Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IpProtocol")
public enum IpProtocol {
    /**
     * The vpc will be configured with only IPv4 addresses.
     * <p>
     * This is the default protocol if unset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4_ONLY,
    /**
     * The vpc will have both IPv4 and IPv6 addresses.
     * <p>
     * Unless specified, public IPv4 addresses will not be auto assigned,
     * an egress only internet gateway (EIGW) will be created and configured,
     * and NATs and internet gateways (IGW) will be configured with IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUAL_STACK,
}
