package software.amazon.awscdk.services.ecr;

/**
 * Represents an image tag mutability exclusion filter for ECR repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Make all tags immutable except for those starting with 'dev-' or 'test-'
 * // Make all tags immutable except for those starting with 'dev-' or 'test-'
 * Repository.Builder.create(this, "Repo")
 *         .imageTagMutability(TagMutability.IMMUTABLE_WITH_EXCLUSION)
 *         .imageTagMutabilityExclusionFilters(List.of(ImageTagMutabilityExclusionFilter.wildcard("dev-*"), ImageTagMutabilityExclusionFilter.wildcard("test-*")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.205Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.ImageTagMutabilityExclusionFilter")
public class ImageTagMutabilityExclusionFilter extends software.amazon.jsii.JsiiObject {

    protected ImageTagMutabilityExclusionFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ImageTagMutabilityExclusionFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a wildcard filter for image tag mutability exclusion.
     * <p>
     * @param pattern The wildcard pattern to match image tags (e.g., 'dev-<em>', 'release-v</em>'). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.ImageTagMutabilityExclusionFilter wildcard(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.ImageTagMutabilityExclusionFilter.class, "wildcard", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.ImageTagMutabilityExclusionFilter.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }
}
