package software.amazon.awscdk.services.ecs;

/**
 * Configuration for alternate target groups used in blue/green deployments with load balancers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Function lambdaHook;
 * ApplicationTargetGroup blueTargetGroup;
 * ApplicationTargetGroup greenTargetGroup;
 * ApplicationListenerRule prodListenerRule;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentStrategy(DeploymentStrategy.BLUE_GREEN)
 *         .build();
 * service.addLifecycleHook(DeploymentLifecycleLambdaTarget.Builder.create(lambdaHook, "PreScaleHook")
 *         .lifecycleStages(List.of(DeploymentLifecycleStage.PRE_SCALE_UP))
 *         .build());
 * IEcsLoadBalancerTarget target = service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
 *         .containerName("nginx")
 *         .containerPort(80)
 *         .protocol(Protocol.TCP)
 *         .alternateTarget(AlternateTarget.Builder.create("AlternateTarget")
 *                 .alternateTargetGroup(greenTargetGroup)
 *                 .productionListener(ListenerRuleConfiguration.applicationListenerRule(prodListenerRule))
 *                 .build())
 *         .build());
 * target.attachToApplicationTargetGroup(blueTargetGroup);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.268Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AlternateTarget")
public class AlternateTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.IAlternateTarget {

    protected AlternateTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlternateTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AlternateTarget(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AlternateTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Bind this configuration to a service.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AlternateTargetConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AlternateTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.AlternateTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AlternateTarget> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.AlternateTargetProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.AlternateTargetProps.Builder();
        }

        /**
         * The IAM role for the configuration.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role for the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The test listener configuration.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param testListener The test listener configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testListener(final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration testListener) {
            this.props.testListener(testListener);
            return this;
        }

        /**
         * The alternate target group.
         * <p>
         * @return {@code this}
         * @param alternateTargetGroup The alternate target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternateTargetGroup(final software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup alternateTargetGroup) {
            this.props.alternateTargetGroup(alternateTargetGroup);
            return this;
        }

        /**
         * The production listener rule ARN (ALB) or listener ARN (NLB).
         * <p>
         * @return {@code this}
         * @param productionListener The production listener rule ARN (ALB) or listener ARN (NLB). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionListener(final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration productionListener) {
            this.props.productionListener(productionListener);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.AlternateTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.AlternateTarget build() {
            return new software.amazon.awscdk.services.ecs.AlternateTarget(
                this.id,
                this.props.build()
            );
        }
    }
}
