package software.amazon.awscdk.services.ecs;

/**
 * Configuration returned by AlternateTargetConfiguration.bind().
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * AlternateTargetConfig alternateTargetConfig = AlternateTargetConfig.builder()
 *         .alternateTargetGroupArn("alternateTargetGroupArn")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .productionListenerRule("productionListenerRule")
 *         .testListenerRule("testListenerRule")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.269Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AlternateTargetConfig")
@software.amazon.jsii.Jsii.Proxy(AlternateTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlternateTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the alternate target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlternateTargetGroupArn();

    /**
     * The IAM role ARN for the configuration.
     * <p>
     * Default: - a new role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The production listener rule ARN (ALB) or listener ARN (NLB).
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProductionListenerRule() {
        return null;
    }

    /**
     * The test listener rule ARN (ALB) or listener ARN (NLB).
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTestListenerRule() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AlternateTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlternateTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlternateTargetConfig> {
        java.lang.String alternateTargetGroupArn;
        java.lang.String roleArn;
        java.lang.String productionListenerRule;
        java.lang.String testListenerRule;

        /**
         * Sets the value of {@link AlternateTargetConfig#getAlternateTargetGroupArn}
         * @param alternateTargetGroupArn The ARN of the alternate target group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternateTargetGroupArn(java.lang.String alternateTargetGroupArn) {
            this.alternateTargetGroupArn = alternateTargetGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link AlternateTargetConfig#getRoleArn}
         * @param roleArn The IAM role ARN for the configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link AlternateTargetConfig#getProductionListenerRule}
         * @param productionListenerRule The production listener rule ARN (ALB) or listener ARN (NLB).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionListenerRule(java.lang.String productionListenerRule) {
            this.productionListenerRule = productionListenerRule;
            return this;
        }

        /**
         * Sets the value of {@link AlternateTargetConfig#getTestListenerRule}
         * @param testListenerRule The test listener rule ARN (ALB) or listener ARN (NLB).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testListenerRule(java.lang.String testListenerRule) {
            this.testListenerRule = testListenerRule;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlternateTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlternateTargetConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlternateTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlternateTargetConfig {
        private final java.lang.String alternateTargetGroupArn;
        private final java.lang.String roleArn;
        private final java.lang.String productionListenerRule;
        private final java.lang.String testListenerRule;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alternateTargetGroupArn = software.amazon.jsii.Kernel.get(this, "alternateTargetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productionListenerRule = software.amazon.jsii.Kernel.get(this, "productionListenerRule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.testListenerRule = software.amazon.jsii.Kernel.get(this, "testListenerRule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alternateTargetGroupArn = java.util.Objects.requireNonNull(builder.alternateTargetGroupArn, "alternateTargetGroupArn is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.productionListenerRule = builder.productionListenerRule;
            this.testListenerRule = builder.testListenerRule;
        }

        @Override
        public final java.lang.String getAlternateTargetGroupArn() {
            return this.alternateTargetGroupArn;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getProductionListenerRule() {
            return this.productionListenerRule;
        }

        @Override
        public final java.lang.String getTestListenerRule() {
            return this.testListenerRule;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alternateTargetGroupArn", om.valueToTree(this.getAlternateTargetGroupArn()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getProductionListenerRule() != null) {
                data.set("productionListenerRule", om.valueToTree(this.getProductionListenerRule()));
            }
            if (this.getTestListenerRule() != null) {
                data.set("testListenerRule", om.valueToTree(this.getTestListenerRule()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AlternateTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlternateTargetConfig.Jsii$Proxy that = (AlternateTargetConfig.Jsii$Proxy) o;

            if (!alternateTargetGroupArn.equals(that.alternateTargetGroupArn)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.productionListenerRule != null ? !this.productionListenerRule.equals(that.productionListenerRule) : that.productionListenerRule != null) return false;
            return this.testListenerRule != null ? this.testListenerRule.equals(that.testListenerRule) : that.testListenerRule == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alternateTargetGroupArn.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.productionListenerRule != null ? this.productionListenerRule.hashCode() : 0);
            result = 31 * result + (this.testListenerRule != null ? this.testListenerRule.hashCode() : 0);
            return result;
        }
    }
}
