package software.amazon.awscdk.services.ecs;

/**
 * Properties for defining a <code>CfnClusterCapacityProviderAssociations</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnClusterCapacityProviderAssociationsProps cfnClusterCapacityProviderAssociationsProps = CfnClusterCapacityProviderAssociationsProps.builder()
 *         .cluster("cluster")
 *         .defaultCapacityProviderStrategy(List.of(CapacityProviderStrategyProperty.builder()
 *                 .capacityProvider("capacityProvider")
 *                 // the properties below are optional
 *                 .base(123)
 *                 .weight(123)
 *                 .build()))
 *         // the properties below are optional
 *         .capacityProviders(List.of("capacityProviders"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.329Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnClusterCapacityProviderAssociationsProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterCapacityProviderAssociationsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterCapacityProviderAssociationsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The cluster the capacity provider association is the target of.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html#cfn-ecs-clustercapacityproviderassociations-cluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html#cfn-ecs-clustercapacityproviderassociations-cluster</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCluster();

    /**
     * The default capacity provider strategy to associate with the cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnClusterCapacityProviderAssociations.CapacityProviderStrategyProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html#cfn-ecs-clustercapacityproviderassociations-defaultcapacityproviderstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html#cfn-ecs-clustercapacityproviderassociations-defaultcapacityproviderstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefaultCapacityProviderStrategy();

    /**
     * The capacity providers to associate with the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html#cfn-ecs-clustercapacityproviderassociations-capacityproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html#cfn-ecs-clustercapacityproviderassociations-capacityproviders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCapacityProviders() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterCapacityProviderAssociationsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterCapacityProviderAssociationsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterCapacityProviderAssociationsProps> {
        java.lang.String cluster;
        java.lang.Object defaultCapacityProviderStrategy;
        java.util.List<java.lang.String> capacityProviders;

        /**
         * Sets the value of {@link CfnClusterCapacityProviderAssociationsProps#getCluster}
         * @param cluster The cluster the capacity provider association is the target of. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(java.lang.String cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterCapacityProviderAssociationsProps#getDefaultCapacityProviderStrategy}
         * @param defaultCapacityProviderStrategy The default capacity provider strategy to associate with the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(software.amazon.awscdk.IResolvable defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = defaultCapacityProviderStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterCapacityProviderAssociationsProps#getDefaultCapacityProviderStrategy}
         * @param defaultCapacityProviderStrategy The default capacity provider strategy to associate with the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(java.util.List<? extends java.lang.Object> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = defaultCapacityProviderStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterCapacityProviderAssociationsProps#getCapacityProviders}
         * @param capacityProviders The capacity providers to associate with the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviders(java.util.List<java.lang.String> capacityProviders) {
            this.capacityProviders = capacityProviders;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterCapacityProviderAssociationsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterCapacityProviderAssociationsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterCapacityProviderAssociationsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterCapacityProviderAssociationsProps {
        private final java.lang.String cluster;
        private final java.lang.Object defaultCapacityProviderStrategy;
        private final java.util.List<java.lang.String> capacityProviders;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultCapacityProviderStrategy = software.amazon.jsii.Kernel.get(this, "defaultCapacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.capacityProviders = software.amazon.jsii.Kernel.get(this, "capacityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.defaultCapacityProviderStrategy = java.util.Objects.requireNonNull(builder.defaultCapacityProviderStrategy, "defaultCapacityProviderStrategy is required");
            this.capacityProviders = builder.capacityProviders;
        }

        @Override
        public final java.lang.String getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.Object getDefaultCapacityProviderStrategy() {
            return this.defaultCapacityProviderStrategy;
        }

        @Override
        public final java.util.List<java.lang.String> getCapacityProviders() {
            return this.capacityProviders;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("defaultCapacityProviderStrategy", om.valueToTree(this.getDefaultCapacityProviderStrategy()));
            if (this.getCapacityProviders() != null) {
                data.set("capacityProviders", om.valueToTree(this.getCapacityProviders()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnClusterCapacityProviderAssociationsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterCapacityProviderAssociationsProps.Jsii$Proxy that = (CfnClusterCapacityProviderAssociationsProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!defaultCapacityProviderStrategy.equals(that.defaultCapacityProviderStrategy)) return false;
            return this.capacityProviders != null ? this.capacityProviders.equals(that.capacityProviders) : that.capacityProviders == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.defaultCapacityProviderStrategy.hashCode());
            result = 31 * result + (this.capacityProviders != null ? this.capacityProviders.hashCode() : 0);
            return result;
        }
    }
}
