package software.amazon.awscdk.services.ecs;

/**
 * The task launch type compatibility requirement.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc = Vpc.fromLookup(this, "Vpc", VpcLookupOptions.builder()
 *         .isDefault(true)
 *         .build());
 * Cluster cluster = Cluster.Builder.create(this, "FargateCluster").vpc(vpc).build();
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TD")
 *         .memoryMiB("512")
 *         .cpu("256")
 *         .compatibility(Compatibility.FARGATE)
 *         .build();
 * ContainerDefinition containerDefinition = taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("foo/bar"))
 *         .memoryLimitMiB(256)
 *         .build());
 * EcsRunTask runTask = EcsRunTask.Builder.create(this, "RunFargate")
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .assignPublicIp(true)
 *         .containerOverrides(List.of(ContainerOverride.builder()
 *                 .containerDefinition(containerDefinition)
 *                 .environment(List.of(TaskEnvironmentVariable.builder().name("SOME_KEY").value(JsonPath.stringAt("$.SomeKey")).build()))
 *                 .build()))
 *         .launchTarget(new EcsFargateLaunchTarget())
 *         .propagatedTagSource(PropagatedTagSource.TASK_DEFINITION)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.473Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Compatibility")
public enum Compatibility {
    /**
     * The task should specify the EC2 launch type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2,
    /**
     * The task should specify the Fargate launch type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FARGATE,
    /**
     * The task can specify either the EC2 or Fargate launch types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2_AND_FARGATE,
    /**
     * The task should specify the External launch type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXTERNAL,
    /**
     * The task should specify the Managed Instances launch type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MANAGED_INSTANCES,
    /**
     * The task can specify either the EC2 or Managed Instances launch types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2_AND_MANAGED_INSTANCES,
    /**
     * The task can specify either the Fargate or Managed Instances launch types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FARGATE_AND_MANAGED_INSTANCES,
    /**
     * The task can specify either the Fargate, EC2 or Managed Instances launch types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FARGATE_AND_EC2_AND_MANAGED_INSTANCES,
}
