package software.amazon.awscdk.services.ecs;

/**
 * The base class for log drivers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret secret;
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("example-image"))
 *         .memoryLimitMiB(256)
 *         .logging(LogDrivers.splunk(SplunkLogDriverProps.builder()
 *                 .secretToken(secret)
 *                 .url("my-splunk-url")
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.584Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.LogDrivers")
public class LogDrivers extends software.amazon.jsii.JsiiObject {

    protected LogDrivers(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogDrivers(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LogDrivers() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver awsLogs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AwsLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "awsLogs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a log driver configuration that sends log information to firelens log router.
     * <p>
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver firelens(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FireLensLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "firelens", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver fluentd(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FluentdLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "fluentd", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { props });
    }

    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver fluentd() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "fluentd", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
    }

    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver gelf(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.GelfLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "gelf", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver journald(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.JournaldLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "journald", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { props });
    }

    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver journald() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "journald", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
    }

    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver jsonFile(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.JsonFileLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "jsonFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { props });
    }

    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver jsonFile() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "jsonFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
    }

    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver splunk(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.SplunkLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "splunk", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver syslog(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.SyslogLogDriverProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "syslog", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class), new Object[] { props });
    }

    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriver syslog() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.LogDrivers.class, "syslog", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
    }
}
