package software.amazon.awscdk.services.ecs;

/**
 * A Managed Instances Capacity Provider.
 * <p>
 * This allows an ECS cluster to use
 * Managed Instances for task placement with managed infrastructure.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * // Create a Managed Instances Capacity Provider
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(SecurityGroup.Builder.create(this, "MISecurityGroup").vpc(vpc).build()))
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 .vCpuCountMin(1)
 *                 .memoryMin(Size.gibibytes(2))
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .build())
 *         .propagateTags(PropagateManagedInstancesTags.CAPACITY_PROVIDER)
 *         .build();
 * // Optionally configure security group rules using IConnectable interface
 * miCapacityProvider.connections.allowFrom(Peer.ipv4(vpc.getVpcCidrBlock()), Port.tcp(80));
 * // Add the capacity provider to the cluster
 * cluster.addManagedInstancesCapacityProvider(miCapacityProvider);
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryReservationMiB(256)
 *         .build());
 * Ec2Service.Builder.create(this, "EC2Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider(miCapacityProvider.getCapacityProviderName())
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.585Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ManagedInstancesCapacityProvider")
public class ManagedInstancesCapacityProvider extends software.constructs.Construct implements software.amazon.awscdk.services.ec2.IConnectable {

    protected ManagedInstancesCapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedInstancesCapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProvider.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedInstancesCapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Associates the capacity provider with the specified cluster.
     * <p>
     * This method is called by the cluster when adding the capacity provider.
     * <p>
     * @param cluster This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster cluster) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(cluster, "cluster is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Capacity provider name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCapacityProviderName() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProviderProps.Builder();
        }

        /**
         * The EC2 instance profile that will be attached to instances launched by this capacity provider.
         * <p>
         * This instance profile must contain the necessary IAM permissions for ECS container instances
         * to register with the cluster and run tasks. At minimum, it should include permissions for
         * ECS agent communication, ECR image pulling, and CloudWatch logging.
         * <p>
         * @return {@code this}
         * @param ec2InstanceProfile The EC2 instance profile that will be attached to instances launched by this capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InstanceProfile(final software.amazon.awscdk.services.iam.IInstanceProfile ec2InstanceProfile) {
            this.props.ec2InstanceProfile(ec2InstanceProfile);
            return this;
        }

        /**
         * The VPC subnets where EC2 instances will be launched.
         * <p>
         * This array must be non-empty and should contain subnets from the VPC where you want
         * the managed instances to be deployed.
         * <p>
         * @return {@code this}
         * @param subnets The VPC subnets where EC2 instances will be launched. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * The name of the capacity provider.
         * <p>
         * If a name is specified, it cannot start with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>.
         * If no name is specified, a default name in the CFNStackName-CFNResourceName-RandomString format is used.
         * If the stack name starts with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>, a unique resource name
         * is generated that starts with <code>cp-</code>.
         * <p>
         * Default: CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param capacityProviderName The name of the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(final java.lang.String capacityProviderName) {
            this.props.capacityProviderName(capacityProviderName);
            return this;
        }

        /**
         * The IAM role that ECS uses to manage the infrastructure for the capacity provider.
         * <p>
         * This role is used by ECS to perform actions such as launching and terminating instances,
         * managing Auto Scaling Groups, and other infrastructure operations required for the
         * managed instances capacity provider.
         * <p>
         * Default: - A new role will be created with the AmazonECSInfrastructureRolePolicyForManagedInstances managed policy
         * <p>
         * @return {@code this}
         * @param infrastructureRole The IAM role that ECS uses to manage the infrastructure for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureRole(final software.amazon.awscdk.services.iam.IRole infrastructureRole) {
            this.props.infrastructureRole(infrastructureRole);
            return this;
        }

        /**
         * The instance requirements configuration for EC2 instance selection.
         * <p>
         * This allows you to specify detailed requirements for instance selection including
         * vCPU count ranges, memory ranges, CPU manufacturers (Intel, AMD, AWS Graviton),
         * instance generations, network performance requirements, and many other criteria.
         * ECS will automatically select appropriate instance types that meet these requirements.
         * <p>
         * Default: - no specific instance requirements, ECS will choose appropriate instances
         * <p>
         * @return {@code this}
         * @param instanceRequirements The instance requirements configuration for EC2 instance selection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRequirements(final software.amazon.awscdk.services.ec2.InstanceRequirementsConfig instanceRequirements) {
            this.props.instanceRequirements(instanceRequirements);
            return this;
        }

        /**
         * The CloudWatch monitoring configuration for the EC2 instances.
         * <p>
         * Determines the granularity of CloudWatch metrics collection for the instances.
         * Detailed monitoring incurs additional costs but provides better observability.
         * <p>
         * Default: - no enhanced monitoring (basic monitoring only)
         * <p>
         * @return {@code this}
         * @param monitoring The CloudWatch monitoring configuration for the EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoring(final software.amazon.awscdk.services.ecs.InstanceMonitoring monitoring) {
            this.props.monitoring(monitoring);
            return this;
        }

        /**
         * Specifies whether to propagate tags from the capacity provider to the launched instances.
         * <p>
         * When set to CAPACITY_PROVIDER, tags applied to the capacity provider resource will be
         * automatically applied to all EC2 instances launched by this capacity provider.
         * <p>
         * Default: PropagateManagedInstancesTags.NONE - no tag propagation
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate tags from the capacity provider to the launched instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagateManagedInstancesTags propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * The security groups to associate with the launched EC2 instances.
         * <p>
         * These security groups control the network traffic allowed to and from the instances.
         * If not specified, the default security group of the VPC containing the subnets will be used.
         * <p>
         * Default: - default security group of the VPC
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups to associate with the launched EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The size of the task volume storage attached to each instance.
         * <p>
         * This storage is used for container images, container logs, and temporary files.
         * Larger storage may be needed for workloads with large container images or
         * applications that generate significant temporary data.
         * <p>
         * Default: Size.gibibytes(80)
         * <p>
         * @return {@code this}
         * @param taskVolumeStorage The size of the task volume storage attached to each instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskVolumeStorage(final software.amazon.awscdk.Size taskVolumeStorage) {
            this.props.taskVolumeStorage(taskVolumeStorage);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProvider build() {
            return new software.amazon.awscdk.services.ecs.ManagedInstancesCapacityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
