package software.amazon.awscdk.services.ecs;

/**
 * The options for creating a Managed Instances Capacity Provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * // Create a Managed Instances Capacity Provider
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(SecurityGroup.Builder.create(this, "MISecurityGroup").vpc(vpc).build()))
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 .vCpuCountMin(1)
 *                 .memoryMin(Size.gibibytes(2))
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .build())
 *         .propagateTags(PropagateManagedInstancesTags.CAPACITY_PROVIDER)
 *         .build();
 * // Optionally configure security group rules using IConnectable interface
 * miCapacityProvider.connections.allowFrom(Peer.ipv4(vpc.getVpcCidrBlock()), Port.tcp(80));
 * // Add the capacity provider to the cluster
 * cluster.addManagedInstancesCapacityProvider(miCapacityProvider);
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryReservationMiB(256)
 *         .build());
 * Ec2Service.Builder.create(this, "EC2Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider(miCapacityProvider.getCapacityProviderName())
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.586Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ManagedInstancesCapacityProviderProps")
@software.amazon.jsii.Jsii.Proxy(ManagedInstancesCapacityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedInstancesCapacityProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The EC2 instance profile that will be attached to instances launched by this capacity provider.
     * <p>
     * This instance profile must contain the necessary IAM permissions for ECS container instances
     * to register with the cluster and run tasks. At minimum, it should include permissions for
     * ECS agent communication, ECR image pulling, and CloudWatch logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IInstanceProfile getEc2InstanceProfile();

    /**
     * The VPC subnets where EC2 instances will be launched.
     * <p>
     * This array must be non-empty and should contain subnets from the VPC where you want
     * the managed instances to be deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets();

    /**
     * The name of the capacity provider.
     * <p>
     * If a name is specified, it cannot start with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>.
     * If no name is specified, a default name in the CFNStackName-CFNResourceName-RandomString format is used.
     * If the stack name starts with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>, a unique resource name
     * is generated that starts with <code>cp-</code>.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProviderName() {
        return null;
    }

    /**
     * The IAM role that ECS uses to manage the infrastructure for the capacity provider.
     * <p>
     * This role is used by ECS to perform actions such as launching and terminating instances,
     * managing Auto Scaling Groups, and other infrastructure operations required for the
     * managed instances capacity provider.
     * <p>
     * Default: - A new role will be created with the AmazonECSInfrastructureRolePolicyForManagedInstances managed policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getInfrastructureRole() {
        return null;
    }

    /**
     * The instance requirements configuration for EC2 instance selection.
     * <p>
     * This allows you to specify detailed requirements for instance selection including
     * vCPU count ranges, memory ranges, CPU manufacturers (Intel, AMD, AWS Graviton),
     * instance generations, network performance requirements, and many other criteria.
     * ECS will automatically select appropriate instance types that meet these requirements.
     * <p>
     * Default: - no specific instance requirements, ECS will choose appropriate instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceRequirementsConfig getInstanceRequirements() {
        return null;
    }

    /**
     * The CloudWatch monitoring configuration for the EC2 instances.
     * <p>
     * Determines the granularity of CloudWatch metrics collection for the instances.
     * Detailed monitoring incurs additional costs but provides better observability.
     * <p>
     * Default: - no enhanced monitoring (basic monitoring only)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.InstanceMonitoring getMonitoring() {
        return null;
    }

    /**
     * Specifies whether to propagate tags from the capacity provider to the launched instances.
     * <p>
     * When set to CAPACITY_PROVIDER, tags applied to the capacity provider resource will be
     * automatically applied to all EC2 instances launched by this capacity provider.
     * <p>
     * Default: PropagateManagedInstancesTags.NONE - no tag propagation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PropagateManagedInstancesTags getPropagateTags() {
        return null;
    }

    /**
     * The security groups to associate with the launched EC2 instances.
     * <p>
     * These security groups control the network traffic allowed to and from the instances.
     * If not specified, the default security group of the VPC containing the subnets will be used.
     * <p>
     * Default: - default security group of the VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * The size of the task volume storage attached to each instance.
     * <p>
     * This storage is used for container images, container logs, and temporary files.
     * Larger storage may be needed for workloads with large container images or
     * applications that generate significant temporary data.
     * <p>
     * Default: Size.gibibytes(80)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getTaskVolumeStorage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ManagedInstancesCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ManagedInstancesCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ManagedInstancesCapacityProviderProps> {
        software.amazon.awscdk.services.iam.IInstanceProfile ec2InstanceProfile;
        java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        java.lang.String capacityProviderName;
        software.amazon.awscdk.services.iam.IRole infrastructureRole;
        software.amazon.awscdk.services.ec2.InstanceRequirementsConfig instanceRequirements;
        software.amazon.awscdk.services.ecs.InstanceMonitoring monitoring;
        software.amazon.awscdk.services.ecs.PropagateManagedInstancesTags propagateTags;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.Size taskVolumeStorage;

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getEc2InstanceProfile}
         * @param ec2InstanceProfile The EC2 instance profile that will be attached to instances launched by this capacity provider. This parameter is required.
         *                           This instance profile must contain the necessary IAM permissions for ECS container instances
         *                           to register with the cluster and run tasks. At minimum, it should include permissions for
         *                           ECS agent communication, ECR image pulling, and CloudWatch logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InstanceProfile(software.amazon.awscdk.services.iam.IInstanceProfile ec2InstanceProfile) {
            this.ec2InstanceProfile = ec2InstanceProfile;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getSubnets}
         * @param subnets The VPC subnets where EC2 instances will be launched. This parameter is required.
         *                This array must be non-empty and should contain subnets from the VPC where you want
         *                the managed instances to be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)subnets;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getCapacityProviderName}
         * @param capacityProviderName The name of the capacity provider.
         *                             If a name is specified, it cannot start with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>.
         *                             If no name is specified, a default name in the CFNStackName-CFNResourceName-RandomString format is used.
         *                             If the stack name starts with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>, a unique resource name
         *                             is generated that starts with <code>cp-</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(java.lang.String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getInfrastructureRole}
         * @param infrastructureRole The IAM role that ECS uses to manage the infrastructure for the capacity provider.
         *                           This role is used by ECS to perform actions such as launching and terminating instances,
         *                           managing Auto Scaling Groups, and other infrastructure operations required for the
         *                           managed instances capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureRole(software.amazon.awscdk.services.iam.IRole infrastructureRole) {
            this.infrastructureRole = infrastructureRole;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getInstanceRequirements}
         * @param instanceRequirements The instance requirements configuration for EC2 instance selection.
         *                             This allows you to specify detailed requirements for instance selection including
         *                             vCPU count ranges, memory ranges, CPU manufacturers (Intel, AMD, AWS Graviton),
         *                             instance generations, network performance requirements, and many other criteria.
         *                             ECS will automatically select appropriate instance types that meet these requirements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRequirements(software.amazon.awscdk.services.ec2.InstanceRequirementsConfig instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getMonitoring}
         * @param monitoring The CloudWatch monitoring configuration for the EC2 instances.
         *                   Determines the granularity of CloudWatch metrics collection for the instances.
         *                   Detailed monitoring incurs additional costs but provides better observability.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoring(software.amazon.awscdk.services.ecs.InstanceMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate tags from the capacity provider to the launched instances.
         *                      When set to CAPACITY_PROVIDER, tags applied to the capacity provider resource will be
         *                      automatically applied to all EC2 instances launched by this capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagateManagedInstancesTags propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getSecurityGroups}
         * @param securityGroups The security groups to associate with the launched EC2 instances.
         *                       These security groups control the network traffic allowed to and from the instances.
         *                       If not specified, the default security group of the VPC containing the subnets will be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ManagedInstancesCapacityProviderProps#getTaskVolumeStorage}
         * @param taskVolumeStorage The size of the task volume storage attached to each instance.
         *                          This storage is used for container images, container logs, and temporary files.
         *                          Larger storage may be needed for workloads with large container images or
         *                          applications that generate significant temporary data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskVolumeStorage(software.amazon.awscdk.Size taskVolumeStorage) {
            this.taskVolumeStorage = taskVolumeStorage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedInstancesCapacityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ManagedInstancesCapacityProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ManagedInstancesCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedInstancesCapacityProviderProps {
        private final software.amazon.awscdk.services.iam.IInstanceProfile ec2InstanceProfile;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        private final java.lang.String capacityProviderName;
        private final software.amazon.awscdk.services.iam.IRole infrastructureRole;
        private final software.amazon.awscdk.services.ec2.InstanceRequirementsConfig instanceRequirements;
        private final software.amazon.awscdk.services.ecs.InstanceMonitoring monitoring;
        private final software.amazon.awscdk.services.ecs.PropagateManagedInstancesTags propagateTags;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.Size taskVolumeStorage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ec2InstanceProfile = software.amazon.jsii.Kernel.get(this, "ec2InstanceProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IInstanceProfile.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)));
            this.capacityProviderName = software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.infrastructureRole = software.amazon.jsii.Kernel.get(this, "infrastructureRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceRequirementsConfig.class));
            this.monitoring = software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.InstanceMonitoring.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagateManagedInstancesTags.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.taskVolumeStorage = software.amazon.jsii.Kernel.get(this, "taskVolumeStorage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ec2InstanceProfile = java.util.Objects.requireNonNull(builder.ec2InstanceProfile, "ec2InstanceProfile is required");
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            this.capacityProviderName = builder.capacityProviderName;
            this.infrastructureRole = builder.infrastructureRole;
            this.instanceRequirements = builder.instanceRequirements;
            this.monitoring = builder.monitoring;
            this.propagateTags = builder.propagateTags;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.taskVolumeStorage = builder.taskVolumeStorage;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IInstanceProfile getEc2InstanceProfile() {
            return this.ec2InstanceProfile;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final java.lang.String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getInfrastructureRole() {
            return this.infrastructureRole;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceRequirementsConfig getInstanceRequirements() {
            return this.instanceRequirements;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.InstanceMonitoring getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagateManagedInstancesTags getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.Size getTaskVolumeStorage() {
            return this.taskVolumeStorage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ec2InstanceProfile", om.valueToTree(this.getEc2InstanceProfile()));
            data.set("subnets", om.valueToTree(this.getSubnets()));
            if (this.getCapacityProviderName() != null) {
                data.set("capacityProviderName", om.valueToTree(this.getCapacityProviderName()));
            }
            if (this.getInfrastructureRole() != null) {
                data.set("infrastructureRole", om.valueToTree(this.getInfrastructureRole()));
            }
            if (this.getInstanceRequirements() != null) {
                data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
            }
            if (this.getMonitoring() != null) {
                data.set("monitoring", om.valueToTree(this.getMonitoring()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTaskVolumeStorage() != null) {
                data.set("taskVolumeStorage", om.valueToTree(this.getTaskVolumeStorage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ManagedInstancesCapacityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManagedInstancesCapacityProviderProps.Jsii$Proxy that = (ManagedInstancesCapacityProviderProps.Jsii$Proxy) o;

            if (!ec2InstanceProfile.equals(that.ec2InstanceProfile)) return false;
            if (!subnets.equals(that.subnets)) return false;
            if (this.capacityProviderName != null ? !this.capacityProviderName.equals(that.capacityProviderName) : that.capacityProviderName != null) return false;
            if (this.infrastructureRole != null ? !this.infrastructureRole.equals(that.infrastructureRole) : that.infrastructureRole != null) return false;
            if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
            if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            return this.taskVolumeStorage != null ? this.taskVolumeStorage.equals(that.taskVolumeStorage) : that.taskVolumeStorage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ec2InstanceProfile.hashCode();
            result = 31 * result + (this.subnets.hashCode());
            result = 31 * result + (this.capacityProviderName != null ? this.capacityProviderName.hashCode() : 0);
            result = 31 * result + (this.infrastructureRole != null ? this.infrastructureRole.hashCode() : 0);
            result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
            result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.taskVolumeStorage != null ? this.taskVolumeStorage.hashCode() : 0);
            return result;
        }
    }
}
