package software.amazon.awscdk.services.ecs;

/**
 * Propagate tags for Managed Instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * // Create a Managed Instances Capacity Provider
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(SecurityGroup.Builder.create(this, "MISecurityGroup").vpc(vpc).build()))
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 .vCpuCountMin(1)
 *                 .memoryMin(Size.gibibytes(2))
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .build())
 *         .propagateTags(PropagateManagedInstancesTags.CAPACITY_PROVIDER)
 *         .build();
 * // Optionally configure security group rules using IConnectable interface
 * miCapacityProvider.connections.allowFrom(Peer.ipv4(vpc.getVpcCidrBlock()), Port.tcp(80));
 * // Add the capacity provider to the cluster
 * cluster.addManagedInstancesCapacityProvider(miCapacityProvider);
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryReservationMiB(256)
 *         .build());
 * Ec2Service.Builder.create(this, "EC2Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider(miCapacityProvider.getCapacityProviderName())
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:50.592Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.PropagateManagedInstancesTags")
public enum PropagateManagedInstancesTags {
    /**
     * Propagate tags from the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CAPACITY_PROVIDER,
    /**
     * Do not propagate tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
