package software.amazon.awscdk.services.eks;

/**
 * Properties for defining a <code>CfnCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .resourcesVpcConfig(ResourcesVpcConfigProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .endpointPrivateAccess(false)
 *                 .endpointPublicAccess(false)
 *                 .publicAccessCidrs(List.of("publicAccessCidrs"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .accessConfig(AccessConfigProperty.builder()
 *                 .authenticationMode("authenticationMode")
 *                 .bootstrapClusterCreatorAdminPermissions(false)
 *                 .build())
 *         .bootstrapSelfManagedAddons(false)
 *         .computeConfig(ComputeConfigProperty.builder()
 *                 .enabled(false)
 *                 .nodePools(List.of("nodePools"))
 *                 .nodeRoleArn("nodeRoleArn")
 *                 .build())
 *         .deletionProtection(false)
 *         .encryptionConfig(List.of(EncryptionConfigProperty.builder()
 *                 .provider(ProviderProperty.builder()
 *                         .keyArn("keyArn")
 *                         .build())
 *                 .resources(List.of("resources"))
 *                 .build()))
 *         .force(false)
 *         .kubernetesNetworkConfig(KubernetesNetworkConfigProperty.builder()
 *                 .elasticLoadBalancing(ElasticLoadBalancingProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .ipFamily("ipFamily")
 *                 .serviceIpv4Cidr("serviceIpv4Cidr")
 *                 .serviceIpv6Cidr("serviceIpv6Cidr")
 *                 .build())
 *         .logging(LoggingProperty.builder()
 *                 .clusterLogging(ClusterLoggingProperty.builder()
 *                         .enabledTypes(List.of(LoggingTypeConfigProperty.builder()
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .outpostConfig(OutpostConfigProperty.builder()
 *                 .controlPlaneInstanceType("controlPlaneInstanceType")
 *                 .outpostArns(List.of("outpostArns"))
 *                 // the properties below are optional
 *                 .controlPlanePlacement(ControlPlanePlacementProperty.builder()
 *                         .groupName("groupName")
 *                         .build())
 *                 .build())
 *         .remoteNetworkConfig(RemoteNetworkConfigProperty.builder()
 *                 .remoteNodeNetworks(List.of(RemoteNodeNetworkProperty.builder()
 *                         .cidrs(List.of("cidrs"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .remotePodNetworks(List.of(RemotePodNetworkProperty.builder()
 *                         .cidrs(List.of("cidrs"))
 *                         .build()))
 *                 .build())
 *         .storageConfig(StorageConfigProperty.builder()
 *                 .blockStorage(BlockStorageProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .upgradePolicy(UpgradePolicyProperty.builder()
 *                 .supportType("supportType")
 *                 .build())
 *         .version("version")
 *         .zonalShiftConfig(ZonalShiftConfigProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:51.163Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VPC configuration that's used by the cluster control plane.
     * <p>
     * Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.ResourcesVpcConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourcesVpcConfig();

    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <strong>Amazon EKS User Guide</strong> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The access configuration for the cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.AccessConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-accessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-accessconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessConfig() {
        return null;
    }

    /**
     * If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
     * <p>
     * The default networking add-ons include <code>vpc-cni</code> , <code>coredns</code> , and <code>kube-proxy</code> .
     * <p>
     * Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-bootstrapselfmanagedaddons">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-bootstrapselfmanagedaddons</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBootstrapSelfManagedAddons() {
        return null;
    }

    /**
     * Indicates the current configuration of the compute capability on your EKS Auto Mode cluster.
     * <p>
     * For example, if the capability is enabled or disabled. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your AWS account. For more information, see EKS Auto Mode compute capability in the <em>Amazon EKS User Guide</em> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.ComputeConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-computeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-computeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComputeConfig() {
        return null;
    }

    /**
     * The current deletion protection setting for the cluster.
     * <p>
     * When <code>true</code> , deletion protection is enabled and the cluster cannot be deleted until protection is disabled. When <code>false</code> , the cluster can be deleted normally. This setting only applies to clusters in an active state.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-deletionprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * The encryption configuration for the cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.EncryptionConfigProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfig() {
        return null;
    }

    /**
     * Set this value to <code>true</code> to override upgrade-blocking readiness checks when updating a cluster.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-force">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-force</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForce() {
        return null;
    }

    /**
     * The Kubernetes network configuration for the cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.KubernetesNetworkConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKubernetesNetworkConfig() {
        return null;
    }

    /**
     * The logging configuration for your cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.LoggingProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-logging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
        return null;
    }

    /**
     * The unique name to give to your cluster.
     * <p>
     * The name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphanumeric character and can't be longer than 100 characters. The name must be unique within the AWS Region and AWS account that you're creating the cluster in. Note that underscores can't be used in AWS CloudFormation .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
     * <p>
     * This object isn't available for clusters on the AWS cloud.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.OutpostConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-outpostconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-outpostconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutpostConfig() {
        return null;
    }

    /**
     * The configuration in the cluster for EKS Hybrid Nodes.
     * <p>
     * You can add, change, or remove this configuration after the cluster is created.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.RemoteNetworkConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-remotenetworkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-remotenetworkconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRemoteNetworkConfig() {
        return null;
    }

    /**
     * Indicates the current configuration of the block storage capability on your EKS Auto Mode cluster.
     * <p>
     * For example, if the capability is enabled or disabled. If the block storage capability is enabled, EKS Auto Mode will create and delete EBS volumes in your AWS account. For more information, see EKS Auto Mode block storage capability in the <em>Amazon EKS User Guide</em> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.StorageConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-storageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-storageconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStorageConfig() {
        return null;
    }

    /**
     * The metadata that you apply to the cluster to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Cluster tags don't propagate to any other resources associated with the cluster.
     * <p>
     * <blockquote>
     * <p>
     * You must have the <code>eks:TagResource</code> and <code>eks:UntagResource</code> permissions for your <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> to manage the AWS CloudFormation stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * This value indicates if extended support is enabled or disabled for the cluster.
     * <p>
     * <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS Extended Support in the <em>Amazon EKS User Guide</em> .</a>
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.UpgradePolicyProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-upgradepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-upgradepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUpgradePolicy() {
        return null;
    }

    /**
     * The desired Kubernetes version for your cluster.
     * <p>
     * If you don't specify a value here, the default version available in Amazon EKS is used.
     * <p>
     * <blockquote>
     * <p>
     * The default version might not be the latest version available.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * The configuration for zonal shift for the cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCluster.ZonalShiftConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-zonalshiftconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-zonalshiftconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getZonalShiftConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.Object resourcesVpcConfig;
        java.lang.String roleArn;
        java.lang.Object accessConfig;
        java.lang.Object bootstrapSelfManagedAddons;
        java.lang.Object computeConfig;
        java.lang.Object deletionProtection;
        java.lang.Object encryptionConfig;
        java.lang.Object force;
        java.lang.Object kubernetesNetworkConfig;
        java.lang.Object logging;
        java.lang.String name;
        java.lang.Object outpostConfig;
        java.lang.Object remoteNetworkConfig;
        java.lang.Object storageConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object upgradePolicy;
        java.lang.String version;
        java.lang.Object zonalShiftConfig;

        /**
         * Sets the value of {@link CfnClusterProps#getResourcesVpcConfig}
         * @param resourcesVpcConfig The VPC configuration that's used by the cluster control plane. This parameter is required.
         *                           Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesVpcConfig(software.amazon.awscdk.IResolvable resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getResourcesVpcConfig}
         * @param resourcesVpcConfig The VPC configuration that's used by the cluster control plane. This parameter is required.
         *                           Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <em>Amazon EKS User Guide</em> . You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesVpcConfig(software.amazon.awscdk.services.eks.CfnCluster.ResourcesVpcConfigProperty resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. This parameter is required.
         *                For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <strong>Amazon EKS User Guide</strong> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAccessConfig}
         * @param accessConfig The access configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessConfig(software.amazon.awscdk.IResolvable accessConfig) {
            this.accessConfig = accessConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAccessConfig}
         * @param accessConfig The access configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessConfig(software.amazon.awscdk.services.eks.CfnCluster.AccessConfigProperty accessConfig) {
            this.accessConfig = accessConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getBootstrapSelfManagedAddons}
         * @param bootstrapSelfManagedAddons If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
         *                                   The default networking add-ons include <code>vpc-cni</code> , <code>coredns</code> , and <code>kube-proxy</code> .
         *                                   <p>
         *                                   Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapSelfManagedAddons(java.lang.Boolean bootstrapSelfManagedAddons) {
            this.bootstrapSelfManagedAddons = bootstrapSelfManagedAddons;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getBootstrapSelfManagedAddons}
         * @param bootstrapSelfManagedAddons If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.
         *                                   The default networking add-ons include <code>vpc-cni</code> , <code>coredns</code> , and <code>kube-proxy</code> .
         *                                   <p>
         *                                   Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapSelfManagedAddons(software.amazon.awscdk.IResolvable bootstrapSelfManagedAddons) {
            this.bootstrapSelfManagedAddons = bootstrapSelfManagedAddons;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getComputeConfig}
         * @param computeConfig Indicates the current configuration of the compute capability on your EKS Auto Mode cluster.
         *                      For example, if the capability is enabled or disabled. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your AWS account. For more information, see EKS Auto Mode compute capability in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfig(software.amazon.awscdk.IResolvable computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getComputeConfig}
         * @param computeConfig Indicates the current configuration of the compute capability on your EKS Auto Mode cluster.
         *                      For example, if the capability is enabled or disabled. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your AWS account. For more information, see EKS Auto Mode compute capability in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfig(software.amazon.awscdk.services.eks.CfnCluster.ComputeConfigProperty computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeletionProtection}
         * @param deletionProtection The current deletion protection setting for the cluster.
         *                           When <code>true</code> , deletion protection is enabled and the cluster cannot be deleted until protection is disabled. When <code>false</code> , the cluster can be deleted normally. This setting only applies to clusters in an active state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeletionProtection}
         * @param deletionProtection The current deletion protection setting for the cluster.
         *                           When <code>true</code> , deletion protection is enabled and the cluster cannot be deleted until protection is disabled. When <code>false</code> , the cluster can be deleted normally. This setting only applies to clusters in an active state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncryptionConfig}
         * @param encryptionConfig The encryption configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(software.amazon.awscdk.IResolvable encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncryptionConfig}
         * @param encryptionConfig The encryption configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfig(java.util.List<? extends java.lang.Object> encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getForce}
         * @param force Set this value to <code>true</code> to override upgrade-blocking readiness checks when updating a cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(java.lang.Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getForce}
         * @param force Set this value to <code>true</code> to override upgrade-blocking readiness checks when updating a cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(software.amazon.awscdk.IResolvable force) {
            this.force = force;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKubernetesNetworkConfig}
         * @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesNetworkConfig(software.amazon.awscdk.IResolvable kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKubernetesNetworkConfig}
         * @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesNetworkConfig(software.amazon.awscdk.services.eks.CfnCluster.KubernetesNetworkConfigProperty kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLogging}
         * @param logging The logging configuration for your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.IResolvable logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLogging}
         * @param logging The logging configuration for your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.eks.CfnCluster.LoggingProperty logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getName}
         * @param name The unique name to give to your cluster.
         *             The name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphanumeric character and can't be longer than 100 characters. The name must be unique within the AWS Region and AWS account that you're creating the cluster in. Note that underscores can't be used in AWS CloudFormation .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOutpostConfig}
         * @param outpostConfig An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
         *                      This object isn't available for clusters on the AWS cloud.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostConfig(software.amazon.awscdk.IResolvable outpostConfig) {
            this.outpostConfig = outpostConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOutpostConfig}
         * @param outpostConfig An object representing the configuration of your local Amazon EKS cluster on an AWS Outpost.
         *                      This object isn't available for clusters on the AWS cloud.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostConfig(software.amazon.awscdk.services.eks.CfnCluster.OutpostConfigProperty outpostConfig) {
            this.outpostConfig = outpostConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRemoteNetworkConfig}
         * @param remoteNetworkConfig The configuration in the cluster for EKS Hybrid Nodes.
         *                            You can add, change, or remove this configuration after the cluster is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteNetworkConfig(software.amazon.awscdk.IResolvable remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRemoteNetworkConfig}
         * @param remoteNetworkConfig The configuration in the cluster for EKS Hybrid Nodes.
         *                            You can add, change, or remove this configuration after the cluster is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteNetworkConfig(software.amazon.awscdk.services.eks.CfnCluster.RemoteNetworkConfigProperty remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getStorageConfig}
         * @param storageConfig Indicates the current configuration of the block storage capability on your EKS Auto Mode cluster.
         *                      For example, if the capability is enabled or disabled. If the block storage capability is enabled, EKS Auto Mode will create and delete EBS volumes in your AWS account. For more information, see EKS Auto Mode block storage capability in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfig(software.amazon.awscdk.IResolvable storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getStorageConfig}
         * @param storageConfig Indicates the current configuration of the block storage capability on your EKS Auto Mode cluster.
         *                      For example, if the capability is enabled or disabled. If the block storage capability is enabled, EKS Auto Mode will create and delete EBS volumes in your AWS account. For more information, see EKS Auto Mode block storage capability in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfig(software.amazon.awscdk.services.eks.CfnCluster.StorageConfigProperty storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags The metadata that you apply to the cluster to assist with categorization and organization.
         *             Each tag consists of a key and an optional value, both of which you define. Cluster tags don't propagate to any other resources associated with the cluster.
         *             <p>
         *             <blockquote>
         *             <p>
         *             You must have the <code>eks:TagResource</code> and <code>eks:UntagResource</code> permissions for your <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> to manage the AWS CloudFormation stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getUpgradePolicy}
         * @param upgradePolicy This value indicates if extended support is enabled or disabled for the cluster.
         *                      <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS Extended Support in the <em>Amazon EKS User Guide</em> .</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upgradePolicy(software.amazon.awscdk.IResolvable upgradePolicy) {
            this.upgradePolicy = upgradePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getUpgradePolicy}
         * @param upgradePolicy This value indicates if extended support is enabled or disabled for the cluster.
         *                      <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS Extended Support in the <em>Amazon EKS User Guide</em> .</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upgradePolicy(software.amazon.awscdk.services.eks.CfnCluster.UpgradePolicyProperty upgradePolicy) {
            this.upgradePolicy = upgradePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVersion}
         * @param version The desired Kubernetes version for your cluster.
         *                If you don't specify a value here, the default version available in Amazon EKS is used.
         *                <p>
         *                <blockquote>
         *                <p>
         *                The default version might not be the latest version available.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getZonalShiftConfig}
         * @param zonalShiftConfig The configuration for zonal shift for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalShiftConfig(software.amazon.awscdk.IResolvable zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getZonalShiftConfig}
         * @param zonalShiftConfig The configuration for zonal shift for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalShiftConfig(software.amazon.awscdk.services.eks.CfnCluster.ZonalShiftConfigProperty zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.Object resourcesVpcConfig;
        private final java.lang.String roleArn;
        private final java.lang.Object accessConfig;
        private final java.lang.Object bootstrapSelfManagedAddons;
        private final java.lang.Object computeConfig;
        private final java.lang.Object deletionProtection;
        private final java.lang.Object encryptionConfig;
        private final java.lang.Object force;
        private final java.lang.Object kubernetesNetworkConfig;
        private final java.lang.Object logging;
        private final java.lang.String name;
        private final java.lang.Object outpostConfig;
        private final java.lang.Object remoteNetworkConfig;
        private final java.lang.Object storageConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object upgradePolicy;
        private final java.lang.String version;
        private final java.lang.Object zonalShiftConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourcesVpcConfig = software.amazon.jsii.Kernel.get(this, "resourcesVpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessConfig = software.amazon.jsii.Kernel.get(this, "accessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bootstrapSelfManagedAddons = software.amazon.jsii.Kernel.get(this, "bootstrapSelfManagedAddons", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computeConfig = software.amazon.jsii.Kernel.get(this, "computeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encryptionConfig = software.amazon.jsii.Kernel.get(this, "encryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.force = software.amazon.jsii.Kernel.get(this, "force", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kubernetesNetworkConfig = software.amazon.jsii.Kernel.get(this, "kubernetesNetworkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outpostConfig = software.amazon.jsii.Kernel.get(this, "outpostConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.remoteNetworkConfig = software.amazon.jsii.Kernel.get(this, "remoteNetworkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.storageConfig = software.amazon.jsii.Kernel.get(this, "storageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.upgradePolicy = software.amazon.jsii.Kernel.get(this, "upgradePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.zonalShiftConfig = software.amazon.jsii.Kernel.get(this, "zonalShiftConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourcesVpcConfig = java.util.Objects.requireNonNull(builder.resourcesVpcConfig, "resourcesVpcConfig is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.accessConfig = builder.accessConfig;
            this.bootstrapSelfManagedAddons = builder.bootstrapSelfManagedAddons;
            this.computeConfig = builder.computeConfig;
            this.deletionProtection = builder.deletionProtection;
            this.encryptionConfig = builder.encryptionConfig;
            this.force = builder.force;
            this.kubernetesNetworkConfig = builder.kubernetesNetworkConfig;
            this.logging = builder.logging;
            this.name = builder.name;
            this.outpostConfig = builder.outpostConfig;
            this.remoteNetworkConfig = builder.remoteNetworkConfig;
            this.storageConfig = builder.storageConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.upgradePolicy = builder.upgradePolicy;
            this.version = builder.version;
            this.zonalShiftConfig = builder.zonalShiftConfig;
        }

        @Override
        public final java.lang.Object getResourcesVpcConfig() {
            return this.resourcesVpcConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAccessConfig() {
            return this.accessConfig;
        }

        @Override
        public final java.lang.Object getBootstrapSelfManagedAddons() {
            return this.bootstrapSelfManagedAddons;
        }

        @Override
        public final java.lang.Object getComputeConfig() {
            return this.computeConfig;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.Object getEncryptionConfig() {
            return this.encryptionConfig;
        }

        @Override
        public final java.lang.Object getForce() {
            return this.force;
        }

        @Override
        public final java.lang.Object getKubernetesNetworkConfig() {
            return this.kubernetesNetworkConfig;
        }

        @Override
        public final java.lang.Object getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOutpostConfig() {
            return this.outpostConfig;
        }

        @Override
        public final java.lang.Object getRemoteNetworkConfig() {
            return this.remoteNetworkConfig;
        }

        @Override
        public final java.lang.Object getStorageConfig() {
            return this.storageConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUpgradePolicy() {
            return this.upgradePolicy;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.Object getZonalShiftConfig() {
            return this.zonalShiftConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourcesVpcConfig", om.valueToTree(this.getResourcesVpcConfig()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAccessConfig() != null) {
                data.set("accessConfig", om.valueToTree(this.getAccessConfig()));
            }
            if (this.getBootstrapSelfManagedAddons() != null) {
                data.set("bootstrapSelfManagedAddons", om.valueToTree(this.getBootstrapSelfManagedAddons()));
            }
            if (this.getComputeConfig() != null) {
                data.set("computeConfig", om.valueToTree(this.getComputeConfig()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getEncryptionConfig() != null) {
                data.set("encryptionConfig", om.valueToTree(this.getEncryptionConfig()));
            }
            if (this.getForce() != null) {
                data.set("force", om.valueToTree(this.getForce()));
            }
            if (this.getKubernetesNetworkConfig() != null) {
                data.set("kubernetesNetworkConfig", om.valueToTree(this.getKubernetesNetworkConfig()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOutpostConfig() != null) {
                data.set("outpostConfig", om.valueToTree(this.getOutpostConfig()));
            }
            if (this.getRemoteNetworkConfig() != null) {
                data.set("remoteNetworkConfig", om.valueToTree(this.getRemoteNetworkConfig()));
            }
            if (this.getStorageConfig() != null) {
                data.set("storageConfig", om.valueToTree(this.getStorageConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUpgradePolicy() != null) {
                data.set("upgradePolicy", om.valueToTree(this.getUpgradePolicy()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }
            if (this.getZonalShiftConfig() != null) {
                data.set("zonalShiftConfig", om.valueToTree(this.getZonalShiftConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (!resourcesVpcConfig.equals(that.resourcesVpcConfig)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.accessConfig != null ? !this.accessConfig.equals(that.accessConfig) : that.accessConfig != null) return false;
            if (this.bootstrapSelfManagedAddons != null ? !this.bootstrapSelfManagedAddons.equals(that.bootstrapSelfManagedAddons) : that.bootstrapSelfManagedAddons != null) return false;
            if (this.computeConfig != null ? !this.computeConfig.equals(that.computeConfig) : that.computeConfig != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.encryptionConfig != null ? !this.encryptionConfig.equals(that.encryptionConfig) : that.encryptionConfig != null) return false;
            if (this.force != null ? !this.force.equals(that.force) : that.force != null) return false;
            if (this.kubernetesNetworkConfig != null ? !this.kubernetesNetworkConfig.equals(that.kubernetesNetworkConfig) : that.kubernetesNetworkConfig != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.outpostConfig != null ? !this.outpostConfig.equals(that.outpostConfig) : that.outpostConfig != null) return false;
            if (this.remoteNetworkConfig != null ? !this.remoteNetworkConfig.equals(that.remoteNetworkConfig) : that.remoteNetworkConfig != null) return false;
            if (this.storageConfig != null ? !this.storageConfig.equals(that.storageConfig) : that.storageConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.upgradePolicy != null ? !this.upgradePolicy.equals(that.upgradePolicy) : that.upgradePolicy != null) return false;
            if (this.version != null ? !this.version.equals(that.version) : that.version != null) return false;
            return this.zonalShiftConfig != null ? this.zonalShiftConfig.equals(that.zonalShiftConfig) : that.zonalShiftConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourcesVpcConfig.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.accessConfig != null ? this.accessConfig.hashCode() : 0);
            result = 31 * result + (this.bootstrapSelfManagedAddons != null ? this.bootstrapSelfManagedAddons.hashCode() : 0);
            result = 31 * result + (this.computeConfig != null ? this.computeConfig.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.encryptionConfig != null ? this.encryptionConfig.hashCode() : 0);
            result = 31 * result + (this.force != null ? this.force.hashCode() : 0);
            result = 31 * result + (this.kubernetesNetworkConfig != null ? this.kubernetesNetworkConfig.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.outpostConfig != null ? this.outpostConfig.hashCode() : 0);
            result = 31 * result + (this.remoteNetworkConfig != null ? this.remoteNetworkConfig.hashCode() : 0);
            result = 31 * result + (this.storageConfig != null ? this.storageConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.upgradePolicy != null ? this.upgradePolicy.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.zonalShiftConfig != null ? this.zonalShiftConfig.hashCode() : 0);
            return result;
        }
    }
}
