package software.amazon.awscdk.services.eks;

/**
 * The default capacity type for the cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v34.KubectlV34Layer;
 * Cluster cluster = Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_34)
 *         .defaultCapacityType(DefaultCapacityType.EC2)
 *         .kubectlLayer(new KubectlV34Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:51.299Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.DefaultCapacityType")
public enum DefaultCapacityType {
    /**
     * managed node group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEGROUP,
    /**
     * EC2 autoscaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2,
}
