package software.amazon.awscdk.services.eks;

/**
 * EKS cluster IP family.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v34.KubectlV34Layer;
 * Vpc vpc;
 * public void associateSubnetWithV6Cidr(Vpc vpc, Number count, ISubnet subnet) {
 *     CfnSubnet cfnSubnet = (CfnSubnet)subnet.getNode().getDefaultChild();
 *     cfnSubnet.getIpv6CidrBlock() = Fn.select(count, Fn.cidr(Fn.select(0, vpc.getVpcIpv6CidrBlocks()), 256, (128 - 64).toString()));
 *     cfnSubnet.getAssignIpv6AddressOnCreation() = true;
 * }
 * // make an ipv6 cidr
 * CfnVPCCidrBlock ipv6cidr = CfnVPCCidrBlock.Builder.create(this, "CIDR6")
 *         .vpcId(vpc.getVpcId())
 *         .amazonProvidedIpv6CidrBlock(true)
 *         .build();
 * // connect the ipv6 cidr to all vpc subnets
 * Number subnetcount = 0;
 * ISubnet[] subnets = vpc.publicSubnets.concat(vpc.getPrivateSubnets());
 * for (Object subnet : subnets) {
 *     // Wait for the ipv6 cidr to complete
 *     subnet.node.addDependency(ipv6cidr);
 *     associateSubnetWithV6Cidr(vpc, subnetcount, subnet);
 *     subnetcount = subnetcount + 1;
 * }
 * Cluster cluster = Cluster.Builder.create(this, "hello-eks")
 *         .version(KubernetesVersion.V1_34)
 *         .vpc(vpc)
 *         .ipFamily(IpFamily.IP_V6)
 *         .vpcSubnets(List.of(SubnetSelection.builder().subnets(vpc.getPublicSubnets()).build()))
 *         .kubectlLayer(new KubectlV34Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:51.374Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.IpFamily")
public enum IpFamily {
    /**
     * Use IPv4 for pods and services in your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IP_V4,
    /**
     * Use IPv6 for pods and services in your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IP_V6,
}
