package software.amazon.awscdk.services.elasticache;

/**
 * The AWS::ElastiCache::SecurityGroupIngress type authorizes ingress to a cache security group from hosts in specified Amazon EC2 security groups.
 * <p>
 * For more information about ElastiCache security group ingress, go to <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_AuthorizeCacheSecurityGroupIngress.html">AuthorizeCacheSecurityGroupIngress</a> in the <em>Amazon ElastiCache API Reference Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * Updates are not supported.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnSecurityGroupIngress cfnSecurityGroupIngress = CfnSecurityGroupIngress.Builder.create(this, "MyCfnSecurityGroupIngress")
 *         .cacheSecurityGroupName("cacheSecurityGroupName")
 *         .ec2SecurityGroupName("ec2SecurityGroupName")
 *         // the properties below are optional
 *         .ec2SecurityGroupOwnerId("ec2SecurityGroupOwnerId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:51.574Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnSecurityGroupIngress")
public class CfnSecurityGroupIngress extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.elasticache.ISecurityGroupIngressRef {

    protected CfnSecurityGroupIngress(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityGroupIngress(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ElastiCache::SecurityGroupIngress</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecurityGroupIngress(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngressProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a SecurityGroupIngress resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.elasticache.SecurityGroupIngressReference getSecurityGroupIngressRef() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupIngressRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.elasticache.SecurityGroupIngressReference.class));
    }

    /**
     * The name of the Cache Security Group to authorize.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCacheSecurityGroupName() {
        return software.amazon.jsii.Kernel.get(this, "cacheSecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Cache Security Group to authorize.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheSecurityGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheSecurityGroupName", java.util.Objects.requireNonNull(value, "cacheSecurityGroupName is required"));
    }

    /**
     * Name of the EC2 Security Group to include in the authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEc2SecurityGroupName() {
        return software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the EC2 Security Group to include in the authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2SecurityGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ec2SecurityGroupName", java.util.Objects.requireNonNull(value, "ec2SecurityGroupName is required"));
    }

    /**
     * Specifies the Amazon Account ID of the owner of the EC2 security group specified in the EC2SecurityGroupName property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupOwnerId() {
        return software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Amazon Account ID of the owner of the EC2 security group specified in the EC2SecurityGroupName property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2SecurityGroupOwnerId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ec2SecurityGroupOwnerId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngressProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngressProps.Builder();
        }

        /**
         * The name of the Cache Security Group to authorize.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html#cfn-elasticache-securitygroupingress-cachesecuritygroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html#cfn-elasticache-securitygroupingress-cachesecuritygroupname</a>
         * @param cacheSecurityGroupName The name of the Cache Security Group to authorize. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSecurityGroupName(final java.lang.String cacheSecurityGroupName) {
            this.props.cacheSecurityGroupName(cacheSecurityGroupName);
            return this;
        }

        /**
         * Name of the EC2 Security Group to include in the authorization.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupname</a>
         * @param ec2SecurityGroupName Name of the EC2 Security Group to include in the authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupName(final java.lang.String ec2SecurityGroupName) {
            this.props.ec2SecurityGroupName(ec2SecurityGroupName);
            return this;
        }

        /**
         * Specifies the Amazon Account ID of the owner of the EC2 security group specified in the EC2SecurityGroupName property.
         * <p>
         * The Amazon access key ID is not an acceptable value.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupownerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-securitygroupingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupownerid</a>
         * @param ec2SecurityGroupOwnerId Specifies the Amazon Account ID of the owner of the EC2 security group specified in the EC2SecurityGroupName property. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupOwnerId(final java.lang.String ec2SecurityGroupOwnerId) {
            this.props.ec2SecurityGroupOwnerId(ec2SecurityGroupOwnerId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress build() {
            return new software.amazon.awscdk.services.elasticache.CfnSecurityGroupIngress(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
